<?php
class OTW_Shortcode_Social_Linkedin_Share extends OTW_Shortcodes{
	
	public function __construct(){
		
		$this->has_custom_options = true;
		
		$this->preview = 'div';
		
		parent::__construct();
	}
	/**
	 * register external libs
	 */
	public function register_external_libs(){
	
		$this->add_external_lib( 'css', 'otw-shortcode', $this->component_url.'css/otw_shortcode.css', 'all', 100 );
		
		$this->add_external_lib( 'js', 'otw-shortcode-linkedin_share', 'https://platform.linkedin.com/in.js', 'all', 300 );
	}
	/**
	 * apply settings
	 */
	public function apply_settings(){
		
		$this->settings = array(
			
			'counter' => array(
					''   => $this->get_label( 'no counter(default)' ),
					'top'   => $this->get_label( 'top' ),
					'right'   => $this->get_label( 'right' )
				),
			'default_counter' => '',
			
			'float' => array(
					''          => $this->get_label( 'none(default)' ),
					'left'    => $this->get_label( 'Left' ),
					'right'   => $this->get_label( 'Right' )
				),
			'default_float' => ''
		);
	}
	
	/**
	 * Shortcode admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-url', 'label' => $this->get_label( 'Optional URL to Share' ), 'description' => $this->get_label( 'Optionally place the URL you want viewers to \'Share\' here. Defaults to the page/post URL.<br />Don\'t forget the http://.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-counter', 'label' => $this->get_label( 'Counter Style' ), 'description' => $this->get_label( 'Values: top, right, nine (default: none).Note: Depending on how fast the Facebook API is today, the preview could take a few moments to load.' ), 'parse' => $source, 'options' => $this->settings['counter'], 'value' => $this->settings['default_counter'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-float', 'label' => $this->get_label( 'Float' ), 'description' => $this->get_label( 'Optionally float your icon to the left or right.' ), 'parse' => $source, 'options' => $this->settings['float'], 'value' => $this->settings['default_float'] ) );
		
		return $html;
	}
	
	/**
	 * Shortcode admin interface custom options
	 */
	public function build_shortcode_editor_custom_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-css_class', 'label' => $this->get_label( 'CSS Class' ), 'description' => $this->get_label( 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/** build shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_social_linkedin_share';
			
			$code .= $this->format_attribute( 'url', 'url', $attributes, false, '', true );
			$code .= $this->format_attribute( 'counter', 'counter', $attributes, false, '', true );
			$code .= $this->format_attribute( 'float', 'float', $attributes, false, '', true );
			$code .= $this->format_attribute( 'css_class', 'css_class', $attributes, false, '', true  );
			
			$code .= ']';
			
			$code .= '[/otw_shortcode_social_linkedin_share]';
		}
		
		return $code;

	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode( $attributes, $content ){
		
		$html = '<div';
		
		/*class attributes*/
		$class = 'shortcode-linkedin_share';
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		if( strlen( $class ) ){
			$html .= ' class="'.$class.'"';
		}
		/*end class attributes*/
		
		/*style attribute*/
		$style = '';
		
		if( $float = $this->format_attribute( '', 'float', $attributes, false, '' ) ){
			$style = $this->append_attribute( $style, 'float: '.$float.';' );
		}
		
		if( strlen( $style ) ){
			$html .= ' style="'.$style.'"';
		}
		
		$html .= '>';
		
		$html .= '<script type="IN/Share"';
		
		if( $attr_value = $this->format_attribute( '', 'url', $attributes, false, '' ) ){
			$html .= ' data-url="'.$attr_value.'"';
		}else{
			global $post;
			
			if( isset( $post->ID ) ){
				$html .= ' data-url="'.get_permalink( $post->ID ).'"';
			}
		}
		
		if( $attr_value = $this->format_attribute( '', 'counter', $attributes, false, '' ) ){
			$html .= ' data-counter="'.$attr_value.'"';
		}
		
		$html .= '></script>';
		
		if( $this->is_live_preview ){
			$html .= '<script type="text/javascript">
				IN = false;
				jQuery.getScript("https://platform.linkedin.com/in.js"); 
			</script>';
		}
		
		$html .= '</div>';
		
		return $this->format_shortcode_output( $html );
	}
}
