<?php
class OTW_Shortcode_Social_Google_Plus extends OTW_Shortcodes{
	
	public function __construct(){
		
		$this->has_custom_options = true;
		
		$this->preview = 'div';
		
		parent::__construct();
	}
	/**
	 * register external libs
	 */
	public function register_external_libs(){
	
		$this->add_external_lib( 'css', 'otw-shortcode', $this->component_url.'css/otw_shortcode.css', 'all', 100 );
	}
	/**
	 * apply settings
	 */
	public function apply_settings(){
		
		$this->settings = array(
			
			'size' => array(
					'standard'   => $this->get_label( 'standard(default)' ),
					'small'   => $this->get_label( 'small' ),
					'medium'   => $this->get_label( 'medium' ),
					'tall'   => $this->get_label( 'tall' )
				),
			'default_size' => 'standard',
			
			'float' => array(
					''          => $this->get_label( 'none(default)' ),
					'left'    => $this->get_label( 'Left' ),
					'right'   => $this->get_label( 'Right' )
				),
			'default_float' => '',
			
			'counter' => array(
					'false'   => $this->get_label( 'false' ),
					'true'    => $this->get_label( 'true(default)' )
				),
			'default_counter' => 'true'
		);
	}
	
	/**
	 * Shortcode admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-url', 'label' => $this->get_label( 'Optional URL to +1' ), 'description' => $this->get_label( 'Optionally place the URL you want viewers to \'+1\' here. Defaults to the page/post URL.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-size', 'label' => $this->get_label( 'Type' ), 'description' => $this->get_label( 'Values: button, icon_link, icon (default: button).Note: Depending on how fast the Facebook API is today, the preview could take a few moments to load.' ), 'parse' => $source, 'options' => $this->settings['size'], 'value' => $this->settings['default_size'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-counter', 'label' => $this->get_label( 'Include Counter' ), 'description' => $this->get_label( 'Show the counter of users who \'+1\' your URL.' ), 'parse' => $source, 'options' => $this->settings['counter'], 'value' => $this->settings['default_counter'] ) );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-callback', 'label' => $this->get_label( 'JavaScript Callback Function' ), 'description' => $this->get_label( 'Optionally include a JavaScript callback function to run when the +1 button is clicked.<br /><strong>For Advanced Users Only.</strong>' ), 'parse' => $source )  );
		
		
		return $html;
	}
	
	/**
	 * Shortcode admin interface custom options
	 */
	public function build_shortcode_editor_custom_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-css_class', 'label' => $this->get_label( 'CSS Class' ), 'description' => $this->get_label( 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/** build shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_social_google_plus';
			
			$code .= $this->format_attribute( 'url', 'url', $attributes, false, '', true );
			$code .= $this->format_attribute( 'size', 'size', $attributes, false, '', true );
			$code .= $this->format_attribute( 'float', 'float', $attributes, false, '', true );
			$code .= $this->format_attribute( 'counter', 'counter', $attributes, false, '', true );
			$code .= $this->format_attribute( 'callback', 'callback', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'css_class', 'css_class', $attributes, false, '', true  );
			
			$code .= ']';
			
			$code .= '[/otw_shortcode_social_google_plus]';
		}
		
		return $code;

	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode( $attributes, $content ){
		
		$html = '<div';
		
		/*class attributes*/
		$class = 'shortcode-google-plusone';
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		if( strlen( $class ) ){
			$html .= ' class="'.$class.'"';
		}
		/*end class attributes*/
		
		/*style attribute*/
		$style = '';
		
		if( $float = $this->format_attribute( '', 'float', $attributes, false, '' ) ){
			$style = $this->append_attribute( $style, 'float: '.$float.';' );
		}
		
		if( strlen( $style ) ){
			$html .= ' style="'.$style.'"';
		}
		
		$html .= '>';
		
		$html .= '<g:plusone';
		
		if( $attr_value = $this->format_attribute( '', 'url', $attributes, false, '' ) ){
			$html .= ' href="'.$attr_value.'"';
		}else{
			global $post;
			
			if( isset( $post->ID ) ){
				$html .= ' href="'.get_permalink( $post->ID ).'"';
			}
		}
		
		if( $attr_value = $this->format_attribute( '', 'size', $attributes, false, '' ) ){
			$html .= ' size="'.$attr_value.'"';
		}
		
		if( $attr_value = $this->format_attribute( '', 'counter', $attributes, false, '' ) ){
			$html .= ' count="'.$attr_value.'"';
		}
		
		if( $attr_value = $this->format_attribute( '', 'callback', $attributes, false, '' ) ){
			$html .= ' callback="'.$attr_value.'"';
		}
		
		$html .= '></g:plusone>';
		
		
		$html .= '</div>';
		
		if( $this->is_live_preview ){
			$html .= '<script type="text/javascript">';
			$html .= "jQuery.getScript('https://apis.google.com/js/plusone.js');";
			$html .= '</script>';
		}else{
			add_action( 'wp_footer', array( $this, 'otw_shortcode_google_plusone_js' ) );
		}
		
		return $this->format_shortcode_output( $html );
	}
	
	function otw_shortcode_google_plusone_js(){
		
		echo '<script src="https://apis.google.com/js/plusone.js" type="text/javascript"></script>' . "\n";
		echo '<script type="text/javascript">gapi.plusone.go();</script>' . "\n";
	}
}
