<?php
class OTW_Shortcode_Social_Facebook_Share extends OTW_Shortcodes{
	
	public function __construct(){
		
		$this->has_custom_options = true;
		
		$this->preview = 'div';
		
		parent::__construct();
	}
	/**
	 * register external libs
	 */
	public function register_external_libs(){
	
		$this->add_external_lib( 'css', 'otw-shortcode', $this->component_url.'css/otw_shortcode.css', 'all', 100 );
	}
	/**
	 * apply settings
	 */
	public function apply_settings(){
		
		$this->settings = array(
			
			'type' => array(
					'box_count'   => $this->get_label( 'box_count' ),
					'button_count'   => $this->get_label( 'button_count' ),
					'button'   => $this->get_label( 'button(default)' ),
					'icon_link'   => $this->get_label( 'icon_link' ),
					'icon'   => $this->get_label( 'icon' ),
					'link'   => $this->get_label( 'link' )
				),
			'default_type' => 'button',
			
			'float' => array(
					''          => $this->get_label( 'none(default)' ),
					'left'    => $this->get_label( 'Left' ),
					'right'   => $this->get_label( 'Right' )
				),
			'default_float' => ''
		);
	}
	
	/**
	 * Shortcode admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-url', 'label' => $this->get_label( 'Optional URL to Share' ), 'description' => $this->get_label( 'Optionally place the URL you want viewers to \'Share\' here. Defaults to the page/post URL.<br />Don\'t forget the http://.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-type', 'label' => $this->get_label( 'Layout' ), 'description' => $this->get_label( 'Choose the layout.' ), 'parse' => $source, 'options' => $this->settings['type'], 'value' => $this->settings['default_type'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-float', 'label' => $this->get_label( 'Float' ), 'description' => $this->get_label( 'Optionally float your icon to the left or right.' ), 'parse' => $source, 'options' => $this->settings['float'], 'value' => $this->settings['default_float'] ) );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-width', 'label' => $this->get_label( 'Width' ), 'description' => $this->get_label( 'The width in pixels.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-height', 'label' => $this->get_label( 'Height' ), 'description' => $this->get_label( 'The height in pixels.' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/**
	 * Shortcode admin interface custom options
	 */
	public function build_shortcode_editor_custom_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-css_class', 'label' => $this->get_label( 'CSS Class' ), 'description' => $this->get_label( 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/** build shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_social_facebook_share';
			
			$code .= $this->format_attribute( 'url', 'url', $attributes, false, '', true );
			$code .= $this->format_attribute( 'type', 'type', $attributes, false, '', true );
			$code .= $this->format_attribute( 'float', 'float', $attributes, false, '', true );
			$code .= $this->format_attribute( 'css_class', 'css_class', $attributes, false, '', true  );
			$code .= $this->format_attribute( 'width', 'width', $attributes, false, '', true  );
			$code .= $this->format_attribute( 'height', 'height', $attributes, false, '', true  );
			
			$code .= ']';
			
			$code .= '[/otw_shortcode_social_facebook_share]';
		}
		
		return $code;

	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode( $attributes, $content ){
		
		$html = '<div';
		
		/*class attributes*/
		$class = 'otw-fbshare';
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		if( strlen( $class ) ){
			$html .= ' class="'.$class.'"';
		}
		/*end class attributes*/
		
		/*style attribute*/
		$style = '';
		
		if( $float = $this->format_attribute( '', 'float', $attributes, false, '' ) ){
			$style = $this->append_attribute( $style, 'float: '.$float.';' );
		}
		
		if( $att_value = $this->format_attribute( '', 'width', $attributes, false, '' ) ){
			$style = $this->append_attribute( $style, 'width: '.$att_value.'px;' );
		}
		
		if( $att_value = $this->format_attribute( '', 'height', $attributes, false, '' ) ){
			$style = $this->append_attribute( $style, 'height: '.$att_value.'px;' );
		}
		
		
		if( strlen( $style ) ){
			$html .= ' style="'.$style.'"';
		}
		
		$html .= '>';
		
		$html .= '<a name="fb_share"';
		
		$html .= ' type="'.$this->format_attribute( '', 'type', $attributes, false, '' ).'"';
		
		if( $attr_value = $this->format_attribute( '', 'url', $attributes, false, '' ) ){
			$html .= ' share_url="'.$attr_value.'"';
		}else{
			global $post;
			
			if( isset( $post->ID ) ){
				$html .= ' share_url="'.get_permalink( $post->ID ).'"';
			}
		}
		
		if( $attr_value = $this->format_attribute( '', 'width', $attributes, false, '' ) ){
			$html .= ' width="'.$attr_value.'"';
		}
		
		if( $attr_value = $this->format_attribute( '', 'height', $attributes, false, '' ) ){
			$html .= ' height="'.$attr_value.'"';
		}
		
		$html .= ' href="http://www.facebook.com/sharer.php"></a>';
		
		
		if( $this->is_live_preview ){
			$html .= '<script type="text/javascript">';
			$html .= 'FB = false;
				    jQuery.getScript("http://static.ak.fbcdn.net/connect.php/js/FB.Share");';
			$html .= '</script>';
		}else{
			$html .= '<script src="http://static.ak.fbcdn.net/connect.php/js/FB.Share" type="text/javascript"></script>';
		}
		
		$html .= '</div>';
		
		return $this->format_shortcode_output( $html );
	}
}
