<?php
class OTW_Shortcode_Social_Facebook_Likebox extends OTW_Shortcodes{
	
	public function __construct(){
		
		$this->has_custom_options = true;
		
		$this->preview = 'div';
		
		parent::__construct();
	}
	/**
	 * register external libs
	 */
	public function register_external_libs(){
	
		$this->add_external_lib( 'css', 'otw-shortcode', $this->component_url.'css/otw_shortcode.css', 'all', 100 );
	}
	/**
	 * apply settings
	 */
	public function apply_settings(){
		
		$this->settings = array(
			
			'style' => array(
					''   => $this->get_label( 'standart(default)' ),
					'button_count'   => $this->get_label( 'button_count' ),
					'box_count'   => $this->get_label( 'box_count' )
				),
			'default_style' => '',
			
			'faces' => array(
					'true'          => $this->get_label( 'true(default)' ),
					'false'   => $this->get_label( 'false' )
				),
			'default_faces' => 'true',
			
			'header' => array(
					'true'          => $this->get_label( 'true(default)' ),
					'false'   => $this->get_label( 'false' )
				),
			'default_header' => 'true',
			
			'border' => array(
					'true'          => $this->get_label( 'true(default)' ),
					'false'   => $this->get_label( 'false' )
				),
			'default_border' => 'true',
			
			'stream' => array(
					'true'          => $this->get_label( 'true(default)' ),
					'false'   => $this->get_label( 'false' )
				),
			'default_stream' => 'true',
			
			'colorscheme' => array(
					'light'          => $this->get_label( 'light (default)' ),
					'dark'     => $this->get_label( 'dark' )
				),
			'default_colorscheme' => 'light'
		);
	}
	
	/**
	 * Shortcode admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-url', 'label' => $this->get_label( 'Facebook Page URL' ), 'description' => $this->get_label( 'The URL for your page.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-width', 'label' => $this->get_label( 'Width' ), 'description' => $this->get_label( 'The width in pixels.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-height', 'label' => $this->get_label( 'Height' ), 'description' => $this->get_label( 'The height in pixels.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-faces', 'label' => $this->get_label( 'Show Friends\' faces' ), 'description' => $this->get_label( ' Show profile photos when friends like this.' ), 'parse' => $source, 'options' => $this->settings['faces'], 'value' => $this->settings['default_faces'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-colorscheme', 'label' => $this->get_label( 'Color scheme' ), 'description' => $this->get_label( 'The color scheme used by the plugin. Can be "light" or "dark".' ), 'parse' => $source, 'options' => $this->settings['colorscheme'], 'value' => $this->settings['default_colorscheme'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-header', 'label' => $this->get_label( 'Show Header' ), 'description' => $this->get_label( 'Show the header' ), 'parse' => $source, 'options' => $this->settings['header'], 'value' => $this->settings['default_header'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-border', 'label' => $this->get_label( 'Show Border' ), 'description' => $this->get_label( 'Show the border' ), 'parse' => $source, 'options' => $this->settings['border'], 'value' => $this->settings['default_border'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-stream', 'label' => $this->get_label( 'Show Posts.' ), 'description' => $this->get_label( 'Show posts from the Page\'s timeline.' ), 'parse' => $source, 'options' => $this->settings['stream'], 'value' => $this->settings['default_stream'] ) );
		
		return $html;
	}
	
	/**
	 * Shortcode admin interface custom options
	 */
	public function build_shortcode_editor_custom_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-css_class', 'label' => $this->get_label( 'CSS Class' ), 'description' => $this->get_label( 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/** build shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !isset( $attributes['url'] ) || !strlen( trim( $attributes['url'] ) ) ){
			$this->add_error( $this->get_label( 'URL is required field' ) );
		}
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_social_facebook_likebox';
			
			$code .= $this->format_attribute( 'url', 'url', $attributes, false, '', true );
			$code .= $this->format_attribute( 'faces', 'faces', $attributes, false, '', true );
			$code .= $this->format_attribute( 'width', 'width', $attributes, false, '', true );
			$code .= $this->format_attribute( 'height', 'height', $attributes, false, '', true );
			$code .= $this->format_attribute( 'colorscheme', 'colorscheme', $attributes, false, '', true );
			$code .= $this->format_attribute( 'header', 'header', $attributes, false, '', true );
			$code .= $this->format_attribute( 'border', 'border', $attributes, false, '', true );
			$code .= $this->format_attribute( 'stream', 'stream', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'css_class', 'css_class', $attributes, false, '', true  );
			
			$code .= ']';
			
			$code .= '[/otw_shortcode_social_facebook_likebox]';
		}
		
		return $code;

	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode( $attributes, $content ){
		
		$html = '<div';
		
		/*class attributes*/
		$class = 'otw-fblikebox';
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		if( strlen( $class ) ){
			$html .= ' class="'.$class.'"';
		}
		/*end class attributes*/
		
		/*style attribute*/
		$style = '';
		
		if( strlen( $style ) ){
			$html .= ' style="'.$style.'"';
		}
		
		$html .= '>';
		
		$width = 450;
		
		if( $attr_value = $this->format_attribute( '', 'width', $attributes, false, '' ) ){
			$width = $attr_value;
		}
		
		$height = 400;
		
		if( $attr_value = $this->format_attribute( '', 'height', $attributes, false, '' ) ){
			$height = $attr_value;
		}
		
		$html .= '<iframe src="http://www.facebook.com/plugins/likebox.php?href=';
		
		if( $attr_value = $this->format_attribute( '', 'url', $attributes, false, '' ) ){
			$html .= urlencode( $attr_value );
		}else{
			global $post;
			
			if( isset( $post->ID ) ){
				$html .= urlencode( get_permalink( $post->ID ) );
			}
		}
		$html .= '&amp;show_faces='.$this->format_attribute( '', 'faces', $attributes, false, '' );
		
		$html .= '&amp;width='.$width;
		
		$html .= '&amp;height='.$height;
		
		$html .= '&amp;colorscheme='.$this->format_attribute( '', 'colorscheme', $attributes, false, '' );
		
		$html .= '&amp;header='.$this->format_attribute( '', 'header', $attributes, false, '' );
		
		$html .= '&amp;show_border='.$this->format_attribute( '', 'border', $attributes, false, '' );
		
		$html .= '&amp;stream='.$this->format_attribute( '', 'stream', $attributes, false, '' );
		
		$html .= '"';//end of src
		
		$html .= ' scrolling="no" frameborder="0" allowTransparency="true"';
		
		$html .= ' style="border:none; overflow:hidden; width:'.$width.'px; height:'.$height.'px"';
		
		$html .= '></iframe>';
		
		$html .= '</div>';
		
		return $this->format_shortcode_output( $html );
	}
}
