<?php
class OTW_Shortcode_Social_Facebook_Like extends OTW_Shortcodes{
	
	public function __construct(){
		
		$this->has_custom_options = true;
		
		$this->preview = 'div';
		
		parent::__construct();
	}
	/**
	 * register external libs
	 */
	public function register_external_libs(){
	
		$this->add_external_lib( 'css', 'otw-shortcode', $this->component_url.'css/otw_shortcode.css', 'all', 100 );
	}
	/**
	 * apply settings
	 */
	public function apply_settings(){
		
		$this->settings = array(
			
			'style' => array(
					''   => $this->get_label( 'standart(default)' ),
					'button_count'   => $this->get_label( 'button_count' ),
					'box_count'   => $this->get_label( 'box_count' )
				),
			'default_style' => '',
			
			'float' => array(
					''          => $this->get_label( 'none(default)' ),
					'left'    => $this->get_label( 'Left' ),
					'right'   => $this->get_label( 'Right' )
				),
			'default_float' => '',
			
			'faces' => array(
					'false'          => $this->get_label( 'false(default)' ),
					'true'   => $this->get_label( 'true' )
				),
			'default_faces' => 'false',
			
			'share' => array(
					'false'          => $this->get_label( 'false(default)' ),
					'true'   => $this->get_label( 'true' )
				),
			'default_share' => 'false',
			
			'verb' => array(
					'like'          => $this->get_label( 'like (default)' ),
					'recommend'     => $this->get_label( 'recommend' )
				),
			'default_verb' => 'like',
			
			'colorscheme' => array(
					'light'          => $this->get_label( 'light (default)' ),
					'dark'     => $this->get_label( 'dark' )
				),
			'default_colorscheme' => 'light',
			
			'font' => array(
					'arial'          => $this->get_label( 'arial (default)' ),
					'lucida grande'  => $this->get_label( 'lucida grande' ),
					'segoe ui'  => $this->get_label( 'segoe ui' ),
					'tahoma'  => $this->get_label( 'tahoma' ),
					'trebuchet ms'  => $this->get_label( 'trebuchet ms' ),
					'verdana'  => $this->get_label( 'verdana' )
				),
			'default_font' => 'arial'
		);
	}
	
	/**
	 * Shortcode admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-url', 'label' => $this->get_label( 'Optional URL to Like' ), 'description' => $this->get_label( 'Optionally place the URL you want viewers to \'Like\' here. Defaults to the page/post URL.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-style', 'label' => $this->get_label( 'Style' ), 'description' => $this->get_label( 'Values: standard, button_count, box_count (default: standard).<br /><br />Note: Depending on how fast the Facebook API is today, the preview could take a few moments to load.' ), 'parse' => $source, 'options' => $this->settings['style'], 'value' => $this->settings['default_style'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-colorscheme', 'label' => $this->get_label( 'Color scheme' ), 'description' => $this->get_label( 'The color scheme used by the plugin. Can be "light" or "dark".' ), 'parse' => $source, 'options' => $this->settings['colorscheme'], 'value' => $this->settings['default_colorscheme'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-float', 'label' => $this->get_label( 'Float' ), 'description' => $this->get_label( 'Optionally float your icon to the left or right.' ), 'parse' => $source, 'options' => $this->settings['float'], 'value' => $this->settings['default_float'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-faces', 'label' => $this->get_label( 'Show Faces' ), 'description' => $this->get_label( 'Show the faces of Facebook users who \'like\' your URL.' ), 'parse' => $source, 'options' => $this->settings['faces'], 'value' => $this->settings['default_faces'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-share', 'label' => $this->get_label( 'Include Share Button' ), 'description' => $this->get_label( 'Specifies whether to include a share button beside the Like button.' ), 'parse' => $source, 'options' => $this->settings['share'], 'value' => $this->settings['default_share'] ) );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-width', 'label' => $this->get_label( 'Width' ), 'description' => $this->get_label( 'Set the width of this button.' ), 'parse' => $source, 'value' => '150'  )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-height', 'label' => $this->get_label( 'Height' ), 'description' => $this->get_label( 'Set the height of this button.' ), 'parse' => $source, 'value' => '30' )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-verb', 'label' => $this->get_label( 'Verb to display' ), 'description' => $this->get_label( 'The verb to display with this button.' ), 'parse' => $source, 'options' => $this->settings['verb'], 'value' => $this->settings['default_verb'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-font', 'label' => $this->get_label( 'Font' ), 'description' => $this->get_label( 'The font to use when displaying this button.' ), 'parse' => $source, 'options' => $this->settings['font'], 'value' => $this->settings['default_font'] ) );
		
		return $html;
	}
	
	/**
	 * Shortcode admin interface custom options
	 */
	public function build_shortcode_editor_custom_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-css_class', 'label' => $this->get_label( 'CSS Class' ), 'description' => $this->get_label( 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/** build shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_social_facebook_like';
			
			$code .= $this->format_attribute( 'url', 'url', $attributes, false, '', true );
			$code .= $this->format_attribute( 'style', 'style', $attributes, false, '', true );
			$code .= $this->format_attribute( 'float', 'float', $attributes, false, '', true );
			$code .= $this->format_attribute( 'faces', 'faces', $attributes, false, '', true );
			$code .= $this->format_attribute( 'width', 'width', $attributes, false, '', true );
			$code .= $this->format_attribute( 'height', 'height', $attributes, false, '', true );
			$code .= $this->format_attribute( 'verb', 'verb', $attributes, false, '', true );
			$code .= $this->format_attribute( 'font', 'font', $attributes, false, '', true );
			$code .= $this->format_attribute( 'share', 'share', $attributes, false, '', true );
			$code .= $this->format_attribute( 'colorscheme', 'colorscheme', $attributes, false, '', true );
			$code .= $this->format_attribute( 'css_class', 'css_class', $attributes, false, '', true  );
			
			$code .= ']';
			
			$code .= '[/otw_shortcode_social_facebook_like]';
		}
		
		return $code;

	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode( $attributes, $content ){
		
		$html = '<div';
		
		/*class attributes*/
		$class = 'otw-fblike';
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		if( strlen( $class ) ){
			$html .= ' class="'.$class.'"';
		}
		/*end class attributes*/
		
		/*style attribute*/
		$style = '';
		
		if( $float = $this->format_attribute( '', 'float', $attributes, false, '' ) ){
			$style = $this->append_attribute( $style, 'float: '.$float.';' );
		}
		
		if( strlen( $style ) ){
			$html .= ' style="'.$style.'"';
		}
		
		$html .= '>';
		
		
		$html .= '<iframe src="http://www.facebook.com/plugins/like.php?href=';
		
		if( $attr_value = $this->format_attribute( '', 'url', $attributes, false, '' ) ){
			$html .= urlencode( $attr_value );
		}else{
			global $post;
			
			if( isset( $post->ID ) ){
				$html .= urlencode( get_permalink( $post->ID ) );
			}
		}
		
		if( $this->format_attribute( '', 'style', $attributes, false, '' ) ){
			$html .= '&amp;layout='.$this->format_attribute( '', 'style', $attributes, false, '' );
		}
		$html .= '&amp;show_faces='.$this->format_attribute( '', 'faces', $attributes, false, '' );
		
		if( $attr_value = $this->format_attribute( '', 'width', $attributes, false, '' ) ){
			$html .= '&amp;width='.$attr_value;
		}
		
		if( $attr_value = $this->format_attribute( '', 'height', $attributes, false, '' ) ){
			$html .= '&amp;height='.$attr_value;
		}
		
		$html .= '&amp;action='.$this->format_attribute( '', 'verb', $attributes, false, '' );
		
		$html .= '&amp;colorscheme=light';
		
		$html .= '&amp;font='.$this->format_attribute( '', 'font', $attributes, false, '' );
		
		$html .= '&amp;share='.$this->format_attribute( '', 'share', $attributes, false, '' );
		
		$html .= '&amp;colorscheme='.$this->format_attribute( '', 'colorscheme', $attributes, false, '' );
		
		$html .= '"';//end of src
		
		$html .= ' scrolling="no" frameborder="0" allowTransparency="true"';
		
		$html .= ' style="border:none; overflow:hidden;';
		
		if( $attr_value = $this->format_attribute( '', 'width', $attributes, false, '' ) ){
			$html .= ' width:'.$attr_value.'px;';
		}
		if( $attr_value = $this->format_attribute( '', 'height', $attributes, false, '' ) ){
			$html .= ' height:'.$attr_value.'px;';
		}
		
		$html .= '"';
		
		$html .= '></iframe>';
		
		$html .= '</div>';
		
		return $this->format_shortcode_output( $html );
	}
}
