<?php
class OTW_Shortcode_Social_Digg extends OTW_Shortcodes{
	
	public function __construct(){
		
		$this->has_custom_options = true;
		
		$this->preview = 'div';
		
		parent::__construct();
	}
	/**
	 * register external libs
	 */
	public function register_external_libs(){
	
		$this->add_external_lib( 'css', 'otw-shortcode', $this->component_url.'css/otw_shortcode.css', 'all', 100 );
	}
	/**
	 * apply settings
	 */
	public function apply_settings(){
		
		$this->settings = array(
			
			
			'style' => array(
					'Medium'   => $this->get_label( 'medium (Default)' ),
					'Large'   => $this->get_label( 'large' ),
					'Compact'   => $this->get_label( 'compact' ),
					'Icon'   => $this->get_label( 'icon' )
				),
			'default_style' => 'medium',
			
			'float' => array(
					''          => $this->get_label( 'none(default)' ),
					'left'    => $this->get_label( 'Left' ),
					'right'   => $this->get_label( 'Right' )
				),
			'default_float' => ''
		);
	}
	
	/**
	 * Shortcode admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-style', 'label' => $this->get_label( 'Style' ), 'description' => $this->get_label( 'Values: medium, large, compact, icon (default: medium).' ), 'parse' => $source, 'options' => $this->settings['style'], 'value' => $this->settings['default_style'] ) );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-title', 'label' => $this->get_label( 'Title' ), 'description' => $this->get_label( 'Optional. Specify title directly (must add link also).' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-link', 'label' => $this->get_label( 'Link' ), 'description' => $this->get_label( 'Optional. Specify link directly.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-float', 'label' => $this->get_label( 'Float' ), 'description' => $this->get_label( 'Values: none, left, right (default: left).' ), 'parse' => $source, 'options' => $this->settings['float'], 'value' => $this->settings['default_float'] ) );
		
		return $html;
	}
	
	/**
	 * Shortcode admin interface custom options
	 */
	public function build_shortcode_editor_custom_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-css_class', 'label' => $this->get_label( 'CSS Class' ), 'description' => $this->get_label( 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/** build shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_social_digg';
			
			$code .= $this->format_attribute( 'style', 'style', $attributes, false, '', true );
			$code .= $this->format_attribute( 'title', 'title', $attributes, false, '', true );
			$code .= $this->format_attribute( 'link', 'link', $attributes, false, '', true );
			$code .= $this->format_attribute( 'float', 'float', $attributes, false, '', true );
			$code .= $this->format_attribute( 'css_class', 'css_class', $attributes, false, '', true  );
			
			$code .= ']';
			
			$code .= '[/otw_shortcode_social_digg]';
		}
		
		return $code;

	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode( $attributes, $content ){
		
		$html = "<script type=\"text/javascript\">
				jQuery.getScript('http://widgets.digg.com/buttons.js');
			</script>";
		
		$html .= '<div';
		
		/*class attributes*/
		$class = 'otw-digg';
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		if( strlen( $class ) ){
			$html .= ' class="'.$class.'"';
		}
		/*end class attributes*/
		
		/*style attribute*/
		$style = '';
		
		if( $float = $this->format_attribute( '', 'float', $attributes, false, '' ) ){
			$style = $this->append_attribute( $style, 'float: '.$float.';' );
		}
		
		if( strlen( $style ) ){
			$html .= ' style="'.$style.'"';
		}
		
		$html .= '>';
		
		$html .= '<a class="DiggThisButton Digg'.$this->format_attribute( '', 'style', $attributes, false, '' ).'"';
		
		$href = '';
		
		if( $attr_value = $this->format_attribute( '', 'link', $attributes, false, '' ) ){
			$href = $attr_value;
		}
		else{
			global $post;
			
			if( $post->ID ){
				$href = get_permalink( $post->ID );
			}
		}
		
		if( $href ){
			
			$html .= ' href="http://digg.com/submit?url='.urlencode( $href );
			
			if( $attr_value = $this->format_attribute( '', 'title', $attributes, false, '' ) ){
				$html .= '&amp;title='.urlencode( $attr_value );
			}
			$html .= '"';
		}
		
		$html .= '>';
		
		$html .= '</a>';
		
		$html .= '</div>';
		
		return $this->format_shortcode_output( $html );
	}
}