<?php
class OTW_Shortcode_Services extends OTW_Shortcodes{
	
	public function __construct(){
		
		$this->has_custom_options = true;
		
		parent::__construct();
	}
	
	
	/**
	 * register external libs
	 */
	public function register_external_libs(){
		
		$this->add_external_lib( 'css', 'otw-shortcode-general_foundicons', $this->component_url.'css/general_foundicons.css', 'all', 10 );
		$this->add_external_lib( 'css', 'otw-shortcode-social_foundicons', $this->component_url.'css/social_foundicons.css', 'all', 20 );
		$this->add_external_lib( 'css', 'otw-shortcode', $this->component_url.'css/otw_shortcode.css', 'all', 100 );
	
	}
	
	/**
	 * apply settings
	 */
	public function apply_settings(){
		
		$this->settings = array(
			
			'image_styles' => array(
				''          => $this->get_label( 'none(default)' ),
				'otw-sc-image-style border'    => $this->get_label( 'border' ),
				'otw-sc-image-style rounded'   => $this->get_label( 'rounded' )
			),
			'default_image_style' => '',
			
			'title_separator' => array(
				'titleseparator'   => $this->get_label( 'yes' ),
				''                 => $this->get_label( 'no(default)' )
			),
			'default_title_separator' => '',
			
			'title_center' => array(
				'center'   => $this->get_label( 'yes' ),
				''         => $this->get_label( 'no(default)' )
			),
			'default_title_center' => '',
			
			'read_more' => array(
				'yes'   => $this->get_label( 'yes' ),
				''      => $this->get_label( 'no(default)' )
			),
			'default_read_more' => '',
			
			'icon_types' => array(
				
				''                      => $this->get_label( 'none (Default)' ),
				'general foundicon-settings'      => $this->get_label( 'Settings' ),
				'general foundicon-heart'         => $this->get_label( 'Heart' ),
				'general foundicon-star'          => $this->get_label( 'Star' ),
				'general foundicon-plus'          => $this->get_label( 'Plus' ),
				'general foundicon-minus'         => $this->get_label( 'Minus' ),
				'general foundicon-checkmark'     => $this->get_label( 'Checkmark' ),
				'general foundicon-remove'        => $this->get_label( 'Remove' ),
				'general foundicon-mail'          => $this->get_label( 'Mail' ),
				'general foundicon-calendar'      => $this->get_label( 'Calendar' ),
				'general foundicon-page'          => $this->get_label( 'Page' ),
				'general foundicon-tools'         => $this->get_label( 'Tools' ),
				'general foundicon-globe'         => $this->get_label( 'Globe' ),
				'general foundicon-cloud'         => $this->get_label( 'Cloud' ),
				'general foundicon-error'         => $this->get_label( 'Error' ),
				'general foundicon-right-arrow'   => $this->get_label( 'Right arrow' ),
				'general foundicon-left-arrow'    => $this->get_label( 'Left arrow' ),
				'general foundicon-up-arrow'      => $this->get_label( 'Up arrow' ),
				'general foundicon-down-arrow'    => $this->get_label( 'Down arrow' ),
				'general foundicon-trash'         => $this->get_label( 'Trash' ),
				'general foundicon-add-doc'       => $this->get_label( 'Add Doc' ),
				'general foundicon-edit'          => $this->get_label( 'Edit' ),
				'general foundicon-lock'          => $this->get_label( 'Lock' ),
				'general foundicon-unlock'        => $this->get_label( 'Unlock' ),
				'general foundicon-refresh'       => $this->get_label( 'Refresh' ),
				'general foundicon-paper-clip'    => $this->get_label( 'Paper clip' ),
				'general foundicon-video'         => $this->get_label( 'Video' ),
				'general foundicon-photo'         => $this->get_label( 'Photo' ),
				'general foundicon-graph'         => $this->get_label( 'Graph' ),
				'general foundicon-idea'          => $this->get_label( 'Idea' ),
				'general foundicon-mic'           => $this->get_label( 'Mic' ),
				'general foundicon-cart'          => $this->get_label( 'Cart' ),
				'general foundicon-address-book'  => $this->get_label( 'Address book' ),
				'general foundicon-compass'       => $this->get_label( 'Compass' ),
				'general foundicon-flag'          => $this->get_label( 'Flag' ),
				'general foundicon-location'      => $this->get_label( 'Location' ),
				'general foundicon-clock'         => $this->get_label( 'Clock' ),
				'general foundicon-folder'        => $this->get_label( 'Folder' ),
				'general foundicon-inbox'         => $this->get_label( 'Inbox' ),
				'general foundicon-website'       => $this->get_label( 'Website' ),
				'general foundicon-smiley'        => $this->get_label( 'Smiley' ),
				'general foundicon-search'        => $this->get_label( 'Search' ),
				'general foundicon-phone'         => $this->get_label( 'Phone' ),
				
				'social foundicon-thumb-up'       => $this->get_label( 'Thumb up' ),
				'social foundicon-thumb-down'     => $this->get_label( 'Thumb down' ),
				'social foundicon-rss'            => $this->get_label( 'Rss' ),
				'social foundicon-facebook'       => $this->get_label( 'Facebook' ),
				'social foundicon-twitter'        => $this->get_label( 'Twitter' ),
				'social foundicon-pinterest'      => $this->get_label( 'Pinterest' ),
				'social foundicon-github'         => $this->get_label( 'Github' ),
				'social foundicon-path'           => $this->get_label( 'Path' ),
				'social foundicon-linkedin'       => $this->get_label( 'LinkedIn' ),
				'social foundicon-dribbble'       => $this->get_label( 'Dribbble' ),
				'social foundicon-stumble-upon'   => $this->get_label( 'Stumble upon' ),
				'social foundicon-behance'        => $this->get_label( 'Behance' ),
				'social foundicon-reddit'         => $this->get_label( 'Reddit' ),
				'social foundicon-google-plus'    => $this->get_label( 'Google plus' ),
				'social foundicon-youtube'        => $this->get_label( 'Youtube' ),
				'social foundicon-vimeo'          => $this->get_label( 'Vimeo' ),
				'social foundicon-clickr'         => $this->get_label( 'Clickr' ),
				'social foundicon-slideshare'     => $this->get_label( 'Slideshare' ),
				'social foundicon-picassa'        => $this->get_label( 'Picassa' ),
				'social foundicon-skype'          => $this->get_label( 'Skype' ),
				'social foundicon-instagram'      => $this->get_label( 'instagram' ),
				'social foundicon-foursquare'     => $this->get_label( 'Foursquare' ),
				'social foundicon-delicious'      => $this->get_label( 'Delicious' ),
				'social foundicon-chat'           => $this->get_label( 'Chat' ),
				'social foundicon-torso'          => $this->get_label( 'Torso' ),
				'social foundicon-tumblr'         => $this->get_label( 'Tumblr' ),
				'social foundicon-video-chat'     => $this->get_label( 'Video chat' ),
				'social foundicon-digg'           => $this->get_label( 'Digg' ),
				'social foundicon-wordpress'      => $this->get_label( 'Wordpress' )
			),
			'default_icon_type' => '',
			
			'icon_positions' => array(
				'with-left-icon'   => $this->get_label( 'left(default)' ),
				'with-center-icon'      => $this->get_label( 'center' )
			),
			'default_icon_position' => 'left',
			
			'icon_sizes' => array(
				'small'       => $this->get_label( 'Small' ),
				'medium' => $this->get_label( 'Medium' ),
				'large'  => $this->get_label( 'Large' )
			),
			'default_icon_size' => 'small',
			
			'icon_color_classes' => array(
				''                      => $this->get_label( 'none (Default)' ),
				'otw-red-text'                   => $this->get_label( 'Red' ),
				'otw-orange-text'                => $this->get_label( 'Orange' ),
				'otw-green-text'                 => $this->get_label( 'Green' ),
				'otw-greenish-text'              => $this->get_label( 'Greenish' ),
				'otw-aqua-text'                  => $this->get_label( 'Aqua' ),
				'otw-blue-text'                  => $this->get_label( 'Blue' ),
				'otw-pink-text'                  => $this->get_label( 'Pink' ),
				'otw-silver-text'                => $this->get_label( 'Silver' ),
				'otw-brown-text'                 => $this->get_label( 'Brown' ),
				'otw-black-text'                 => $this->get_label( 'Black' )
			),
			'default_icon_color_class' => ''
		);
		
	}
	
	/**
	 * Shortcode admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::uploader( array( 'id' => 'otw-shortcode-element-image_url', 'label' => $this->get_label( 'Upload image' ), 'description' => $this->get_label( 'Upload an image.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-image_style', 'label' => $this->get_label( 'Image style' ), 'description' => $this->get_label( 'No style, border or rounded image corners.' ), 'parse' => $source, 'options' => $this->settings['image_styles'], 'value' => $this->settings['default_image_style'] ) );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-url', 'label' => $this->get_label( 'URL' ), 'description' => $this->get_label( 'The onclick URL for the image, title and read more.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-title', 'label' => $this->get_label( 'Title' ), 'description' => $this->get_label( 'The title.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-title_separator', 'label' => $this->get_label( 'Title separator' ), 'description' => $this->get_label( 'Enables separator after the title.' ), 'parse' => $source, 'options' => $this->settings['title_separator'], 'value' => $this->settings['default_title_separator'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-title_center', 'label' => $this->get_label( 'Center image, top icon and title' ), 'description' => $this->get_label( 'Centers the image or the top icon and the title.' ), 'parse' => $source, 'options' => $this->settings['title_center'], 'value' => $this->settings['default_title_center'] ) );
		
		$html .= OTW_Form::text_area( array( 'id' => 'otw-shortcode-element-content', 'label' => $this->get_label( 'Content' ), 'description' => $this->get_label( 'The text content. HTML is allowed.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-read_more', 'label' => $this->get_label( 'Read more' ), 'description' => $this->get_label( 'Enables read more link at the bottom.' ), 'parse' => $source, 'options' => $this->settings['read_more'], 'value' => $this->settings['default_read_more'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-icon_type', 'label' => $this->get_label( 'Icon type' ), 'description' => $this->get_label( 'The icons here are based on foundation icon fonts.' ), 'parse' => $source, 'options' => $this->settings['icon_types'], 'value' => $this->settings['default_icon_type'] )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-icon_position', 'label' => $this->get_label( 'Icon position' ), 'description' => $this->get_label( 'Icons can be positioned left or right.' ), 'parse' => $source, 'options' => $this->settings['icon_positions'], 'value' => $this->settings['default_icon_position'] )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-icon_size', 'label' => $this->get_label( 'Icon size' ), 'description' => $this->get_label( 'The size of the icon.' ), 'parse' => $source, 'options' => $this->settings['icon_sizes'], 'value' => $this->settings['default_icon_size'] )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-icon_color_class', 'label' => $this->get_label( 'Icon color' ), 'description' => $this->get_label( 'The color for the icon.' ), 'parse' => $source, 'options' => $this->settings['icon_color_classes'], 'value' => $this->settings['default_icon_color_class'] )  );
		
		return $html;
	}
	
	/**
	 * Shortcode admin interface custom options
	 */
	public function build_shortcode_editor_custom_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::uploader( array( 'id' => 'otw-shortcode-element-icon_url', 'label' => $this->get_label( 'Icon URL' ), 'description' => $this->get_label( 'Url to a custom icon.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::color_picker( array( 'id' => 'otw-shortcode-element-icon_color', 'label' => $this->get_label( 'Icon color custom' ), 'description' => $this->get_label( 'Applies on foundation icons only.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-css_class', 'label' => $this->get_label( 'CSS Class' ), 'description' => $this->get_label( 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/** build shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_services';
			
			$code .= $this->format_attribute( 'image_url', 'image_url', $attributes );
			
			$code .= $this->format_attribute( 'image_style', 'image_style', $attributes );
			
			$code .= $this->format_attribute( 'url', 'url', $attributes );
			
			$code .= $this->format_attribute( 'title', 'title', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'title_separator', 'title_separator', $attributes );
			
			$code .= $this->format_attribute( 'title_center', 'title_center', $attributes );
			
			$code .= $this->format_attribute( 'read_more', 'read_more', $attributes );
			
			$code .= $this->format_attribute( 'icon_type', 'icon_type', $attributes );
			
			$code .= $this->format_attribute( 'icon_position', 'icon_position', $attributes );
			
			$code .= $this->format_attribute( 'icon_size', 'icon_size', $attributes );
			
			$code .= $this->format_attribute( 'icon_color_class', 'icon_color_class', $attributes );
			
			$code .= $this->format_attribute( 'icon_url', 'icon_url', $attributes );
			
			$code .= $this->format_attribute( 'icon_color', 'icon_color', $attributes );
			
			$code .= $this->format_attribute( 'css_class', 'css_class', $attributes, false, '', true  );
			
			$code .= ']';
			
			$code .= $attributes['content'];
			
			$code .= '[/otw_shortcode_services]';
		}
		
		return $code;

	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode( $attributes, $content ){
		
		$html = '<div';
		
		/*class attributes*/
		$class = 'otw-sc-services';
		
		if( $image_url = $this->format_attribute( '', 'image_url', $attributes, false, '' ) ){
			$class .= $this->format_attribute( '', 'image_style', $attributes, false, $class );
		}
		if( $icon_type = $this->format_attribute( '', 'icon_type', $attributes, false, '' ) ){
			
			$class .= $this->format_attribute( '', 'icon_position', $attributes, false, $class );
			
			$class .= $this->format_attribute( '', 'icon_size', $attributes, false, $class );
		}
		
		$class .= $this->format_attribute( '', 'title_center', $attributes, false, $class );
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		if( strlen( $class ) ){
			$html .= ' class="'.$class.'"';
		}
		/*end class attributes*/
		
		/*style attribute*/
		$style = '';
		
		if( strlen( $style ) ){
			$html .= ' style="'.$style.'"';
		}
		
		$html .= '>';
		
		if( $image_url = $this->format_attribute( '', 'image_url', $attributes, false, '' ) ){
			
			if( $url = $this->format_attribute( '', 'url', $attributes, false, '' ) ){
				$html .= '<a href="'.$this->format_attribute( '', 'url', $attributes, false, '' ).'">';
			}
			$html .= '<img src="'.$image_url.'" alt="'.$this->format_attribute( '', 'title', $attributes, false, '' ).'" title="'.$this->format_attribute( '', 'title', $attributes, false, '' ).'" />';
			
			if( $url = $this->format_attribute( '', 'url', $attributes, false, '' ) ){
				$html .= '</a>';
			}
		}
		
		if( $icon_url = $this->format_attribute( '', 'icon_url', $attributes, false, '' ) ){
			$html .= '<a href="'.$this->format_attribute( '', 'url', $attributes, false, '' ).'">';
				$html .= '<img src="'.$icon_url.'" alt="icon" title="icon" />';
			$html .= '</a>';
		}
		
		if( $icon_type = $this->format_attribute( '', 'icon_type', $attributes, false, '' ) ){
			
			$icon_class = $icon_type;
			
			$icon_class .= $this->format_attribute( '', 'icon_color_class', $attributes, false, $icon_class );
			
			$icon_style = '';
			
			if( $icon_color = $this->format_attribute( '', 'icon_color', $attributes, false, '' ) ){
				$icon_style = $this->append_attribute( $icon_style, 'color: '.$icon_color.' !important;' );
			}
			
			if( strlen( $icon_style ) ){
				$icon_style .= ' style="'.$icon_style.'"';
			}
			
			$html .= '<i class="'.$icon_class.'"'.$icon_style.'></i>';
		}
		
		$html .= '<h3 class="widget-title">';
		
		if( $this->format_attribute( '', 'url', $attributes, false, '' ) ){
			$html .= '<a title="'.$this->get_label( 'Read more' ).'" href="'.$this->format_attribute( '', 'url', $attributes, false, '' ).'">';
		}
		$html .= $this->format_attribute( '', 'title', $attributes, false, '' );
		
		if( $this->format_attribute( '', 'url', $attributes, false, '' ) ){
			$html .= '</a>';
		}
		
		$html .= '</h3>';
		
		$html .= '<div';
		
		$content_class = 'image-content-text';
		
		$content_class .= $this->format_attribute( '', 'title_separator', $attributes, false, $content_class );
		
		if( strlen( $content_class ) ){
			$html .= ' class="'.$content_class.'"';
		}
		$html .= '>';
		
		$html .= '<p>'.nl2br( $content ).'</p>';
		
		$html .= '</div>';
		
		if( $this->format_attribute( '', 'read_more', $attributes, false, '' ) == 'yes' ){
			$html .= '<div class="read-more"><a title="'.$this->get_label( 'Read more' ).'" href="'.$this->format_attribute( '', 'url', $attributes, false, '' ).'">'.$this->get_label( 'Read more' ).'</a></div>';
		}
		
		$html .= '</div>';
		
		return $this->format_shortcode_output( $html );
	}
}