<?php

/**
 * General Workflow for Otw_Shortcode_Progressbar
 *
 * @author Станимир | OTW Design
 * @ver 1.0
 */
class Otw_Shortcode_Progressbar extends OTW_Shortcodes {

    function __construct() {
        parent::__construct();
        $this->has_custom_options = true;
    }

    /**
     * Register externel lybs 
     */
    function register_external_libs() {
        $this->add_external_lib('css', 'otw-shortcode-general_foundicons', $this->component_url . 'css/general_foundicons.css', 'all', 10);
        $this->add_external_lib('css', 'otw-shortcode-social_foundicons', $this->component_url . 'css/social_foundicons.css', 'all', 20);
        $this->add_external_lib('css', 'otw-grid', $this->component_url . '../' . 'otw_grid_manager/' . 'css/otw-grid.css', 'all', 100);
        $this->add_external_lib('css', 'otw-shortcode', $this->component_url . 'css/otw_shortcode.css', 'all', 120);
        $this->add_external_lib('js', 'otw-shortcode-core', $this->component_url . 'js/otw_shortcode_core.js', 'all', 99, array('jquery'));
        $this->add_external_lib('js', 'otw-shortcode', $this->component_url . 'js/otw_shortcode.js', 'all', 130);
        $this->add_external_lib('js', 'otw-shortcode_live_preview', $this->component_url . 'js/otw_shortcode_live_preview.js', 'live_preview', 200);


        return $this;
    }

    /**
     * Applay all settings to shortcode
     */
    public function apply_settings() {
        $this->_applyBackgrounds();
        $this->_applyHolderStyle();
    }

    /**
     * Get Backgrounds
     * @return array
     */
    public function getBackgrounds() {
        return array(
            '' => $this->get_label('Default'),
            'otw-b-meter-white-bgr' => $this->get_label('White Flat'),
            'otw-b-meter-blue-flat-bgr' => $this->get_label('Blue Flat'),
            'otw-b-meter-bluesky-flat-bgr' => $this->get_label('Bluesky Flat'),
            'otw-b-meter-darkblue-flat-bgr' => $this->get_label('Darkblue Flat'),
            'otw-b-meter-purple-flat-bgr' => $this->get_label('Purple Flat'),
            'otw-b-meter-magenta-flat-bgr' => $this->get_label('Magenta Flat'),
            'otw-b-meter-pink-flat-bgr' => $this->get_label('Pink Flat'),
            'otw-b-meter-yellow-flat-bgr' => $this->get_label('Yellow Flat'),
            'otw-b-meter-green-flat-bgr' => $this->get_label('Green Flat'),
            'otw-b-meter-greenyellow-flat-bgr' => $this->get_label('Greenyellow Flat'),
            'otw-b-meter-orange-flat-bgr' => $this->get_label('Orange Flat'),
            'otw-b-meter-red-flat-bgr' => $this->get_label('Red Flat')
        );
    }

    /**
     * get Holder styles
     * @return  \Otw_Shortcode_progressbar
     */
    private function getHolderStyle() {
        return array(
            '' => $this->get_label('Light (Default)'),
            'otw-b-meter-dark' => $this->get_label('Dark'),
        );
    }

    /**
     * apply all settings for backgrounds
     * @return \Otw_Shortcode_progressbar
     */
    protected function _applyBackgrounds() {
        $this->settings['content_meter_background'] = $this->getBackgrounds();
        $this->settings['default_content_meter_background'] = '';
        return $this;
    }

    /**
     * apply holder style for all 
     * @return \Otw_Shortcode_progressbar
     */
    protected function _applyHolderStyle() {
        $this->settings['content_meter_holder'] = $this->getHolderStyle();
        $this->settings['default_content_meter_holder'] = '';
        return $this;
    }

    /**
     * 
     * @param type $attributes
     * @return string
     */
    public function build_shortcode_code($attributes) {
        $code = '';

        if (!empty($attributes['content_meter_width'])) {
            if (!is_numeric($attributes['content_meter_width'])) {
                $this->add_error($this->get_label('Width value must be numeber format '));
            } else if (is_numeric($attributes['content_meter_width']) && ($attributes['content_meter_width'] < 0 || $attributes['content_meter_width'] > 100)) {
                $this->add_error($this->get_label('Valide value for progress width is point from 0 to 100'));
            }
        }

        if (!$this->has_error) {
            $code .= '[otw_shortcode_progressbar';
            $code .= $this->format_attribute('content_meter_label', 'content_meter_label', $attributes);
            $code .= $this->format_attribute('content_meter_width', 'content_meter_width', $attributes);
            $code .= $this->format_attribute('content_meter_background', 'content_meter_background', $attributes);
            $code .= $this->format_attribute('content_meter_holder', 'content_meter_holder', $attributes);
            $code .= $this->format_attribute('custom_color', 'custom_color', $attributes);
            $code .= $this->format_attribute('custom_class', 'custom_class', $attributes);
            $code .= ']';
            $code .= '[/otw_shortcode_progressbar]';

            return $code;
        }
    }

    /**
     * Set the additional settings
     * @return string
     */
    public function build_shortcode_editor_custom_options() {
        $html = '';

        $source = array();
        if (isset($_POST['shortcode_object'])) {
            $source = $_POST['shortcode_object'];
        }
        $html .= $this->_generatePicker('custom_color', 'Custom color', 'Enter your favorite color ', $source);
        $html .= $this->_generateText('custom_class', 'Custom CSS Class ', 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..', $source);
        return $html;
    }

    /**
     * Generate options as HTML string 
     * @return string
     */
    public function build_shortcode_editor_options() {
        $html = '';

        $source = array();
        if (isset($_POST['shortcode_object'])) {
            $source = $_POST['shortcode_object'];
        }

        $html .= $this->_generateText('content_meter_label', 'Text label ', 'Enter the text label. None is also an option. ', $source);
        $html .= $this->_generateText('content_meter_width', 'Meter width', 'Enter the start position for meter in percents', $source);
        $html .= $this->_generateSelect('content_meter_background', 'Meter Color ', 'Choose meter color. ', $source, 'content_meter_background', 'default_content_meter_background');
        $html .= $this->_generateSelect('content_meter_holder', 'Background', 'Choose from light or dark background. ', $source, 'content_meter_holder', 'default_content_meter_holder');

        return $html;
    }

    /**
     * Export end shortcode
     * @param array $attributes
     * @param string $content
     * @return string
     */
    public function display_shortcode($attributes, $content) {
        $html = '<div class="otw-row">';
        $style = '';
        $style = $this->append_attribute($style, 'background-color: ' . $this->format_attribute('', 'custom_color', $attributes) . '!important;');

        $html .= '<div class="otw-b-meter ' . $this->format_attribute('', 'custom_class', $attributes) . ' ' . $this->format_attribute('', 'content_meter_holder', $attributes) . ' ' . $this->format_attribute('', 'content_meter_background', $attributes) . '">';
        $html .= '<span style="' . $style . ' width: ' . $this->format_attribute('', 'content_meter_width', $attributes) . '%">';
        $text = $this->format_attribute('', 'content_meter_label', $attributes);
        if (!empty($text)) {
            $html .= '<span class="otw-b-meter-text">' . $text . '</span>';
        }
        $html .= '<span>';

        $html .= '</span>';
        $html .= '</span>';
        $html .= '</div>';
        $html .= '</div>';
        return $this->format_shortcode_output($html);
    }

}
