<?php
class OTW_Shortcode_Price_Table extends OTW_Shortcodes{
	
	/**
	 *  Numbers
	 *
	 *  @var array
	 */
	
	public $number_names = array( 'zero', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'ten', 'eleven', 'twelve', 'thirteen', 'fourteen', 'fifteen', 'sixteen', 'seventeen', 'eighteen', 'nineteen', 'twenty', 'twentyone', 'twentytwo', 'twentythree', 'twentyfour');
	
	public function __construct(){
		
		$this->has_custom_options = true;
		
		parent::__construct();
	}
	/**
	 * register external libs
	 */
	public function register_external_libs(){
	
		$this->add_external_lib( 'css', 'otw-shortcode', $this->component_url.'css/otw_shortcode.css', 'all', 100 );
	}
	
	/**
	 * apply settings
	 */
	public function apply_settings(){
		
		$this->settings = array(
			
			'cols' => array(
				'1'           => $this->get_label( '1' ),
				'2'           => $this->get_label( '2 (default)' ),
				'3'           => $this->get_label( '3' ),
				'4'           => $this->get_label( '4' ),
				'5'           => $this->get_label( '5' ),
				'6'           => $this->get_label( '6' ),
				'7'           => $this->get_label( '7' ),
				'8'           => $this->get_label( '8' ),
				'9'           => $this->get_label( '9' ),
				'10'          => $this->get_label( '10' )
			),
			'default_cols' => 2,
			
			'rows' => array(
				'1'           => $this->get_label( '1' ),
				'2'           => $this->get_label( '2 (default)' ),
				'3'           => $this->get_label( '3' ),
				'4'           => $this->get_label( '4' ),
				'5'           => $this->get_label( '5' ),
				'6'           => $this->get_label( '6' ),
				'7'           => $this->get_label( '7' ),
				'8'           => $this->get_label( '8' ),
				'9'           => $this->get_label( '9' ),
				'10'          => $this->get_label( '10' )
			),
			'default_rows' => 2,
			
			'enable_button_options' => array(
				'1'                   => $this->get_label( 'Yes (default)' ),
				''                   => $this->get_label( 'No' )
			),
			'default_enable_button' => 1,
			
			'special_options' => array(
				'special'            => $this->get_label( 'Yes' ),
				''                   => $this->get_label( 'No (default)' )
			),
			'default_special' => '',
			
			'column_title_color_classes' => array(
				
				''                      => $this->get_label( 'none (Default)' ),
				'otw-red-text'                   => $this->get_label( 'Red' ),
				'otw-orange-text'                => $this->get_label( 'Orange' ),
				'otw-green-text'                 => $this->get_label( 'Green' ),
				'otw-greenish-text'              => $this->get_label( 'Greenish' ),
				'otw-aqua-text'                  => $this->get_label( 'Aqua' ),
				'otw-blue-text'                  => $this->get_label( 'Blue' ),
				'otw-pink-text'                  => $this->get_label( 'Pink' ),
				'otw-silver-text'                => $this->get_label( 'Silver' ),
				'otw-brown-text'                 => $this->get_label( 'Brown' ),
				'otw-black-text'                 => $this->get_label( 'Black' )
			),
			'default_column_title_color_class' => '',
			
			'column_price_color_classes' => array(
				
				''                      => $this->get_label( 'none (Default)' ),
				'otw-red-text'                   => $this->get_label( 'Red' ),
				'otw-orange-text'                => $this->get_label( 'Orange' ),
				'otw-green-text'                 => $this->get_label( 'Green' ),
				'otw-greenish-text'              => $this->get_label( 'Greenish' ),
				'otw-aqua-text'                  => $this->get_label( 'Aqua' ),
				'otw-blue-text'                  => $this->get_label( 'Blue' ),
				'otw-pink-text'                  => $this->get_label( 'Pink' ),
				'otw-silver-text'                => $this->get_label( 'Silver' ),
				'otw-brown-text'                 => $this->get_label( 'Brown' ),
				'otw-black-text'                 => $this->get_label( 'Black' )
			),
			'default_column_price_color_class' => '',
			
			'button_bgcolor_classes' => array(
				
				''                      => $this->get_label( 'none (Default)' ),
				'otw-red'                   => $this->get_label( 'Red' ),
				'otw-orange'                => $this->get_label( 'Orange' ),
				'otw-green'                 => $this->get_label( 'Green' ),
				'otw-greenish'              => $this->get_label( 'Greenish' ),
				'otw-aqua'                  => $this->get_label( 'Aqua' ),
				'otw-blue'                  => $this->get_label( 'Blue' ),
				'otw-pink'                  => $this->get_label( 'Pink' ),
				'otw-silver'                => $this->get_label( 'Silver' ),
				'otw-brown'                 => $this->get_label( 'Brown' ),
				'otw-black'                 => $this->get_label( 'Black' )
			),
			'default_button_bgcolor_class' => '',
			
			'button_text_color_classes' => array(
				
				''                      => $this->get_label( 'none (Default)' ),
				'otw-red-text'                   => $this->get_label( 'Red' ),
				'otw-orange-text'                => $this->get_label( 'Orange' ),
				'otw-green-text'                 => $this->get_label( 'Green' ),
				'otw-greenish-text'              => $this->get_label( 'Greenish' ),
				'otw-aqua-text'                  => $this->get_label( 'Aqua' ),
				'otw-blue-text'                  => $this->get_label( 'Blue' ),
				'otw-pink-text'                  => $this->get_label( 'Pink' ),
				'otw-silver-text'                => $this->get_label( 'Silver' ),
				'otw-brown-text'                 => $this->get_label( 'Brown' ),
				'otw-black-text'                 => $this->get_label( 'Black' )
			),
			'default_button_text_color_class' => '',
			
			'special_bgcolor_classes' => array(
				
				''                      => $this->get_label( 'none (Default)' ),
				'otw-red'                   => $this->get_label( 'Red' ),
				'otw-orange'                => $this->get_label( 'Orange' ),
				'otw-green'                 => $this->get_label( 'Green' ),
				'otw-greenish'              => $this->get_label( 'Greenish' ),
				'otw-aqua'                  => $this->get_label( 'Aqua' ),
				'otw-blue'                  => $this->get_label( 'Blue' ),
				'otw-pink'                  => $this->get_label( 'Pink' ),
				'otw-silver'                => $this->get_label( 'Silver' ),
				'otw-brown'                 => $this->get_label( 'Brown' ),
				'otw-black'                 => $this->get_label( 'Black' )
			),
			'default_special_bgcolor_class' => ''
		);
		
	}
	
	/**
	 * Shortcode admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-cols', 'label' => $this->get_label( 'Number of Columns' ), 'description' => $this->get_label( 'Choose the number of columns.' ), 'parse' => $source, 'options' => $this->settings['cols'], 'value' => $this->settings['default_cols'], 'data-reload' => '1' ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-rows', 'label' => $this->get_label( 'Number of Rows' ), 'description' => $this->get_label( 'Choose the number of rows.' ), 'parse' => $source, 'options' => $this->settings['rows'], 'value' => $this->settings['default_rows'], 'data-reload' => '1' ) );
		
		$total_rows = $this->settings['default_rows'];
		
		if( isset( $source['otw-shortcode-element-rows'] ) ){
			$total_rows = $source['otw-shortcode-element-rows'];
		}
		
		for( $cR = 1; $cR <= $total_rows; $cR++ ){
			
			if( $cR == 1 ){
				$description = $this->get_label( 'Enter row titles. If all row titles are left empty the whole row titles column will not be displayed.');
			}else{
				$description = $this->get_label( 'Enter row '.$cR.' title' );
			}
			$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-row_'.$cR.'_title', 'label' => $this->get_label( 'Row '.$cR.' Title' ), 'description' => $description, 'parse' => $source )  );
		}
		
		$total_cols = $this->settings['default_cols'];
		
		if( isset( $source['otw-shortcode-element-cols'] ) ){
			$total_cols = $source['otw-shortcode-element-cols'];
		}
		
		for( $cC = 1; $cC <= $total_cols; $cC++ ){
			
			$html .= '<div class="otw_separator"> </div>';
			
			$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-col_'.$cC.'_title', 'label' => $this->get_label( 'Column '.$cC.' Title' ), 'description' => $this->get_label( 'Enter title.' ), 'parse' => $source )  );
			$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-col_'.$cC.'_price', 'label' => $this->get_label( 'Column '.$cC.' Price' ), 'description' => $this->get_label( 'Enter price.' ), 'parse' => $source )  );
			
			for( $cR = 1; $cR <= $total_rows; $cR++ ){
			
				$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-row_'.$cR.'_col_'.$cC.'_text', 'label' => $this->get_label( 'Column '.$cC.' Row '.$cR.' Text' ), 'description' => $this->get_label( 'Enter the texts for this column.' ), 'parse' => $source )  );
			}
			
			$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-col_'.$cC.'_button', 'label' => $this->get_label( 'Enable Column '.$cC.' Button' ), 'description' => $this->get_label( 'Enables the button for this column.' ), 'parse' => $source, 'options' => $this->settings['enable_button_options'], 'value' => $this->settings['default_enable_button'] )  );
			
			$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-col_'.$cC.'_button_text', 'label' => $this->get_label( 'Column '.$cC.' Button Text' ), 'description' => $this->get_label( 'The text for the button. Default is \'Sign Up\'.' ), 'parse' => $source ) );
			
			$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-col_'.$cC.'_button_link', 'label' => $this->get_label( 'Column '.$cC.' Button Link' ), 'description' => $this->get_label( 'The link for the button.' ), 'parse' => $source ) );
			
			$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-col_'.$cC.'_special', 'label' => $this->get_label( 'Make Column '.$cC.' Special' ), 'description' => $this->get_label( 'Makes this column special.' ), 'parse' => $source, 'options' => $this->settings['special_options'], 'value' => $this->settings['default_special'] )  );
			
		}
		$html .= '<div class="otw_separator"> </div>';
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-column_title_color_class', 'label' => $this->get_label( 'Columns Titles Color' ), 'description' => $this->get_label( 'Choose a color for the columns titles.' ), 'parse' => $source, 'options' => $this->settings['column_title_color_classes'], 'value' => $this->settings['default_column_title_color_class'] )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-column_price_color_class', 'label' => $this->get_label( 'Prices Color' ), 'description' => $this->get_label( 'Choose a color for the prices.' ), 'parse' => $source, 'options' => $this->settings['column_price_color_classes'], 'value' => $this->settings['default_column_price_color_class'] )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-button_bgcolor_class', 'label' => $this->get_label( 'Buttons Color' ), 'description' => $this->get_label( 'Choose a color for the buttons.' ), 'parse' => $source, 'options' => $this->settings['button_bgcolor_classes'], 'value' => $this->settings['default_button_bgcolor_class'] )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-button_text_color_class', 'label' => $this->get_label( 'Buttons Text Color' ), 'description' => $this->get_label( 'Choose a color for the buttons text.' ), 'parse' => $source, 'options' => $this->settings['button_text_color_classes'], 'value' => $this->settings['default_button_text_color_class'] )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-special_bgcolor_class', 'label' => $this->get_label( 'Special Columns Background Color' ), 'description' => $this->get_label( 'Choose background color for special columns.' ), 'parse' => $source, 'options' => $this->settings['special_bgcolor_classes'], 'value' => $this->settings['default_special_bgcolor_class'] )  );
		
		return $html;
	}
	
	/**
	 * Shortcode admin interface custom options
	 */
	public function build_shortcode_editor_custom_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::color_picker( array( 'id' => 'otw-shortcode-element-column_title_color', 'label' => $this->get_label( 'Column Titles Color Custom' ), 'description' => $this->get_label( 'Choose a custom titles color.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::color_picker( array( 'id' => 'otw-shortcode-element-column_price_color', 'label' => $this->get_label( 'Prices Color Custom' ), 'description' => $this->get_label( 'Choose a custom prices color.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::color_picker( array( 'id' => 'otw-shortcode-element-button_bgcolor', 'label' => $this->get_label( 'Buttons Color Custom' ), 'description' => $this->get_label( 'Choose a custom buttons color.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::color_picker( array( 'id' => 'otw-shortcode-element-button_text_color', 'label' => $this->get_label( 'Buttons Text Color Custom' ), 'description' => $this->get_label( 'Choose a custom buttons text color.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::color_picker( array( 'id' => 'otw-shortcode-element-column_title_bgcolor', 'label' => $this->get_label( 'Column Titles Background Color Custom' ), 'description' => $this->get_label( 'Choose a custom column titles background color.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::uploader( array( 'id' => 'otw-shortcode-element-column_title_pattern', 'label' => $this->get_label( 'Column Titles Background Pattern Custom' ), 'description' => $this->get_label( 'Choose a custom column titles background pattern.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::color_picker( array( 'id' => 'otw-shortcode-element-special_bgcolor', 'label' => $this->get_label( 'Special Columns Background Color Custom' ), 'description' => $this->get_label( 'Choose a custom special columns background color.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-css_class', 'label' => $this->get_label( 'CSS Class' ), 'description' => $this->get_label( 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/** build shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_price_table';
			
			$code .= $this->format_attribute( 'cols', 'cols', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'rows', 'rows', $attributes, false, '', true );
			
			if( $rows = $this->format_attribute( '', 'rows', $attributes ) ){
				
				for( $cR = 1; $cR <= $rows; $cR++ ){
					
					$code .= $this->format_attribute( 'row_'.$cR.'_title', 'row_'.$cR.'_title', $attributes, false, '', true );
				}
			}
			
			if( $cols = $this->format_attribute( '', 'cols', $attributes ) ){
				
				for( $cC = 1; $cC <= $cols; $cC++ ){
					
					$code .= $this->format_attribute( 'col_'.$cC.'_title', 'col_'.$cC.'_title', $attributes, false, '', true );
					
					$code .= $this->format_attribute( 'col_'.$cC.'_price', 'col_'.$cC.'_price', $attributes, false, '', true );
					
					for( $cR = 1; $cR <= $rows; $cR++ ){
						$code .= $this->format_attribute( 'row_'.$cR.'_col_'.$cC.'_text', 'row_'.$cR.'_col_'.$cC.'_text', $attributes, false, '', true );
					}
					
					$code .= $this->format_attribute( 'col_'.$cC.'_button', 'col_'.$cC.'_button', $attributes, false, '', true );
					
					$code .= $this->format_attribute( 'col_'.$cC.'_button_text', 'col_'.$cC.'_button_text', $attributes, false, '', true );
					
					$code .= $this->format_attribute( 'col_'.$cC.'_button_link', 'col_'.$cC.'_button_link', $attributes, false, '', true );
					
					$code .= $this->format_attribute( 'col_'.$cC.'_special', 'col_'.$cC.'_special', $attributes, false, '', true );
				}
			}
			
			$code .= $this->format_attribute( 'column_title_color_class', 'column_title_color_class', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'column_price_color_class', 'column_price_color_class', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'button_bgcolor_class', 'button_bgcolor_class', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'button_text_color_class', 'button_text_color_class', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'special_bgcolor_class', 'special_bgcolor_class', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'column_title_color', 'column_title_color', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'column_price_color', 'column_price_color', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'button_bgcolor', 'button_bgcolor', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'button_text_color', 'button_text_color', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'column_title_bgcolor', 'column_title_bgcolor', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'column_title_pattern', 'column_title_pattern', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'special_bgcolor', 'special_bgcolor', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'css_class', 'css_class', $attributes, false, '', true  );
			
			$code .= ']';
			
			$code .= '[/otw_shortcode_price_table]';
		
		}
		
		return $code;

	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode( $attributes, $content ){
		
		$html = '<div';
		
		/*class attributes*/
		$class = 'otw-cs-pricetable';
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		if( strlen( $class ) ){
			$html .= ' class="'.$class.'"';
		}
		/*end class attributes*/
		
		/*style attribute*/
		$style = '';
		
		if( strlen( $style ) ){
			$html .= ' style="'.$style.'"';
		}
		
		$html .= '>';
		
		$rows = intval( $this->format_attribute( '', 'rows', $attributes, false, '' ) );
		$cols = intval( $this->format_attribute( '', 'cols', $attributes, false, '' ) );
		
		$total_cols  = $cols;
		
		$otw_row_class = '';
		
		$has_row_titles = false;
		
		if( $rows ){
			
			for( $cR = 1; $cR <= $rows;  $cR++ ){
				if( strlen( trim( $this->format_attribute( '', 'row_'.$cR.'_title', $attributes, false, '' ) ) ) ){
					$has_row_titles = true;
					break;
				}
			}
		}
		
		$has_foot = false;
		
		for( $cC = 1; $cC <= $cols; $cC++ ){
		
			if( $this->format_attribute( '', 'col_'.$cC.'_button', $attributes, false, '' ) == '1' ){
				$has_foot = true;
				break;
			}
		}
		
		if( $has_row_titles ){
			$total_cols++;
		}
		
		if( $total_cols > 0 ){
			
			if( isset( $this->number_names[ 24 / $total_cols ] ) ){
				$otw_row_class = 'otw-'.$this->number_names[ 24 / $total_cols ];
			}
		}
		
		if( $has_row_titles ){
			
			$html .= '<ul class="price-section column-header '.$otw_row_class.' otw-columns">';
			
				$li_classes = '';
				
				$li_styles = '';
				
				if( $value = $this->format_attribute( '', 'column_title_bgcolor', $attributes, false, '' ) ){
					$li_styles = $this->append_attribute( $li_styles, 'background-color: '.$value.';' );
				}
				
				if( $value = $this->format_attribute( '', 'column_title_pattern', $attributes, false, '' ) ){
					$li_styles = $this->append_attribute( $li_styles, 'background-image: url(\''.$value.'\');' );
				}
				
				if( strlen( $li_classes ) ){
					$li_classes = ' '.$li_classes;
				}
				
				if( strlen( $li_styles ) ){
					$li_styles = ' style="'.$li_styles.'" ';
				}
			
				$html .= '<li class="column-title'.$li_classes.'"'.$li_styles.'>&nbsp;</li>';
				$html .= '<li class="column-price">&nbsp;</li>';
				
				for( $cR = 1; $cR <= $rows;  $cR++ ){
					
					$html .= '<li>'.$this->format_attribute( '', 'row_'.$cR.'_title', $attributes, false, '' ).'</li>';
				}
				
				if( $has_foot ){
					$html .= '<li class="column-foot">&nbsp;</li>';
				}
				
			$html .=  '</ul>';
		}
		
		for( $cC = 1; $cC <= $cols; $cC++ ){
		
			$ul_class = 'price-section '.$otw_row_class.' otw-columns';
			
			$ul_class .= $this->format_attribute( '', 'col_'.$cC.'_special', $attributes, false, $ul_class );
			
			$ul_style = '';
			
			
			if( $this->format_attribute( '', 'col_'.$cC.'_special', $attributes, false ) == 'special' ){
				
				$ul_class .= $this->format_attribute( '', 'special_bgcolor_class', $attributes, false, $ul_class );
				
				if( $value = $this->format_attribute( '', 'special_bgcolor', $attributes, false, '' ) ){
					$ul_style = $this->append_attribute( $ul_style, 'background-color: '.$value.';' );
				}
			}
			
			if( strlen( $ul_style ) ){
				$ul_style = ' style="'.$ul_style.'"';
			}
			
			$html .= '<ul class="'.$ul_class.'"'.$ul_style.'>';
			
			$li_title_class = 'column-title';
			
			$li_title_class .= $this->format_attribute( '', 'column_title_color_class', $attributes, false, $li_title_class );
			
			$li_title_style = '';
			
			if( $value = $this->format_attribute( '', 'column_title_color', $attributes, false, '' ) ){
				$li_title_style = $this->append_attribute( $li_title_style, 'color: '.$value.';' );
			}
			
			if( $value = $this->format_attribute( '', 'column_title_bgcolor', $attributes, false, '' ) ){
				$li_title_style = $this->append_attribute( $li_title_style, 'background-color: '.$value.';' );
			}
			
			if( $value = $this->format_attribute( '', 'column_title_pattern', $attributes, false, '' ) ){
				$li_title_style = $this->append_attribute( $li_title_style, 'background-image: url(\''.$value.'\');' );
			}
			
			if( strlen( $li_title_style ) ){
				$li_title_style = ' style="'.$li_title_style.'"';
			}
			
			$html .= '<li class="'.$li_title_class.'"'.$li_title_style.'>'.$this->format_attribute( '', 'col_'.$cC.'_title', $attributes, false, '' ).'</li>';
			
			$li_price_class = 'column-price';
			
			$li_price_class .= $this->format_attribute( '', 'column_price_color_class', $attributes, false, $li_price_class );
			
			$li_price_style = '';
			
			if( $value = $this->format_attribute( '', 'column_price_color', $attributes, false, '' ) ){
				$li_price_style = $this->append_attribute( $li_price_style, 'color: '.$value.';' );
			}
			
			if( strlen( $li_price_style ) ){
				$li_price_style = ' style="'.$li_price_style.'"';
			}
			
			$html .= '<li class="'.$li_price_class.'"'.$li_price_style.'>'.$this->format_attribute( '', 'col_'.$cC.'_price', $attributes, false, '' ).'</li>';
			
			for( $cR = 1; $cR <= $rows;  $cR++ ){
				$html .= '<li>'.$this->format_attribute( '', 'row_'.$cR.'_col_'.$cC.'_text', $attributes, false, '' ).'</li>';
			}
			
			if( $has_foot ){
				$html .= '<li class="column-foot">';
				
				if( $this->format_attribute( '', 'col_'.$cC.'_button', $attributes, false, '' ) ){
					
					$button_text = $this->get_label( 'Sign up' );
					
					if( $value = $this->format_attribute( '', 'col_'.$cC.'_button_text', $attributes, false, '' ) ){
						$button_text = $value;
					}
					
					$button_link = '#';
					
					if( $value = $this->format_attribute( '', 'col_'.$cC.'_button_link', $attributes, false, '' ) ){
						$button_link = $value;
					}
					
					$button_class = 'button';
					
					$button_class .= $this->format_attribute( '', 'button_bgcolor_class', $attributes, false, $button_class );
					
					$button_class .= $this->format_attribute( '', 'button_text_color_class', $attributes, false, $button_class );
					
					$button_style = '';
					
					if( $value = $this->format_attribute( '', 'button_bgcolor', $attributes, false, '' ) ){
						$button_style = $this->append_attribute( $button_style, 'background-color: '.$value.';' );
					}
					
					if( $value = $this->format_attribute( '', 'button_text_color', $attributes, false, '' ) ){
						$button_style = $this->append_attribute( $button_style, 'color: '.$value.';' );
					}
					
					if( strlen( $button_style ) ){
						$button_style = ' style="'.$button_style.'"';
					}
					
					$html .= '<a class="'.$button_class.'"'.$button_style.' href="'.$button_link.'">'.$button_text.'</a>';
				}
				
				$html .= '</li>';
			}
			
			$html .=  '</ul>';
		}
		
		$html .= '</div>';
		
		return $this->format_shortcode_output( $html );
	}
}
?>
