<?php
class OTW_Shortcode_Price_Box extends OTW_Shortcodes{
	
	public function __construct(){
		
		$this->has_custom_options = true;
		
		parent::__construct();
	}
	/**
	 * register external libs
	 */
	public function register_external_libs(){
	
		$this->add_external_lib( 'css', 'otw-shortcode', $this->component_url.'css/otw_shortcode.css', 'all', 100 );
	}
	
	/**
	 * apply settings
	 */
	public function apply_settings(){
		
		$this->settings = array(
			
			'title_color_classes' => array(
				
				''                      => $this->get_label( 'none (Default)' ),
				'otw-red-text'                   => $this->get_label( 'Red' ),
				'otw-orange-text'                => $this->get_label( 'Orange' ),
				'otw-green-text'                 => $this->get_label( 'Green' ),
				'otw-greenish-text'              => $this->get_label( 'Greenish' ),
				'otw-aqua-text'                  => $this->get_label( 'Aqua' ),
				'otw-blue-text'                  => $this->get_label( 'Blue' ),
				'otw-pink-text'                  => $this->get_label( 'Pink' ),
				'otw-silver-text'                => $this->get_label( 'Silver' ),
				'otw-brown-text'                 => $this->get_label( 'Brown' ),
				'otw-black-text'                 => $this->get_label( 'Black' )
			),
			'default_title_color_class' => '',
			
			'price_color_classes' => array(
				
				''                      => $this->get_label( 'none' ),
				'otw-red-text'                   => $this->get_label( 'Red' ),
				'otw-orange-text'                => $this->get_label( 'Orange' ),
				'otw-green-text'                 => $this->get_label( 'Green' ),
				'otw-greenish-text'              => $this->get_label( 'Greenish' ),
				'otw-aqua-text'                  => $this->get_label( 'Aqua (Default)' ),
				'otw-blue-text'                  => $this->get_label( 'Blue' ),
				'otw-pink-text'                  => $this->get_label( 'Pink' ),
				'otw-silver-text'                => $this->get_label( 'Silver' ),
				'otw-brown-text'                 => $this->get_label( 'Brown' ),
				'otw-black-text'                 => $this->get_label( 'Black' )
			),
			'default_price_color_class' => 'otw-aqua-text',
			
			'price_text_color_classes' => array(
				
				''                      => $this->get_label( 'none (Default)' ),
				'otw-red-text'                   => $this->get_label( 'Red' ),
				'otw-orange-text'                => $this->get_label( 'Orange' ),
				'otw-green-text'                 => $this->get_label( 'Green' ),
				'otw-greenish-text'              => $this->get_label( 'Greenish' ),
				'otw-aqua-text'                  => $this->get_label( 'Aqua' ),
				'otw-blue-text'                  => $this->get_label( 'Blue' ),
				'otw-pink-text'                  => $this->get_label( 'Pink' ),
				'otw-silver-text'                => $this->get_label( 'Silver' ),
				'otw-brown-text'                 => $this->get_label( 'Brown' ),
				'otw-black-text'                 => $this->get_label( 'Black' )
			),
			'default_price_text_color_class' => '',
			
			'background_color_classes' => array(
				
				''                      => $this->get_label( 'none (Default)' ),
				'otw-red'                   => $this->get_label( 'Red' ),
				'otw-orange'                => $this->get_label( 'Orange' ),
				'otw-green'                 => $this->get_label( 'Green' ),
				'otw-greenish'              => $this->get_label( 'Greenish' ),
				'otw-aqua'                  => $this->get_label( 'Aqua' ),
				'otw-blue'                  => $this->get_label( 'Blue' ),
				'otw-pink'                  => $this->get_label( 'Pink' ),
				'otw-silver'                => $this->get_label( 'Silver' ),
				'otw-brown'                 => $this->get_label( 'Brown' ),
				'otw-black'                 => $this->get_label( 'Black' )
			),
			'default_background_color_class' => '',
			
			'price_background_color_classes' => array(
				
				''                      => $this->get_label( 'none (Default)' ),
				'otw-red'                   => $this->get_label( 'Red' ),
				'otw-orange'                => $this->get_label( 'Orange' ),
				'otw-green'                 => $this->get_label( 'Green' ),
				'otw-greenish'              => $this->get_label( 'Greenish' ),
				'otw-aqua'                  => $this->get_label( 'Aqua' ),
				'otw-blue'                  => $this->get_label( 'Blue' ),
				'otw-pink'                  => $this->get_label( 'Pink' ),
				'otw-silver'                => $this->get_label( 'Silver' ),
				'otw-brown'                 => $this->get_label( 'Brown' ),
				'otw-black'                 => $this->get_label( 'Black' )
			),
			'default_price_background_color_class' => '',
			
			'price_background_patterns' => array(
				''               => $this->get_label( 'none' ),
				'otw-pattern-1'      => $this->get_label( 'pattern 1 (default)' ),
				'otw-pattern-2'      => $this->get_label( 'pattern 2' ),
				'otw-pattern-3'      => $this->get_label( 'pattern 3' ),
				'otw-pattern-4'      => $this->get_label( 'pattern 4' ),
				'otw-pattern-5'      => $this->get_label( 'pattern 5' )
			),
			'default_price_background_pattern' => 'otw-pattern-1',
			
			'enable_button_options' => array(
				'1'                   => $this->get_label( 'Yes (default)' ),
				''                   => $this->get_label( 'No' )
			),
			'default_enable_button' => 1,
			
			'button_bgcolor_classes' => array(
				
				''                      => $this->get_label( 'none (Default)' ),
				'otw-red'                   => $this->get_label( 'Red' ),
				'otw-orange'                => $this->get_label( 'Orange' ),
				'otw-green'                 => $this->get_label( 'Green' ),
				'otw-greenish'              => $this->get_label( 'Greenish' ),
				'otw-aqua'                  => $this->get_label( 'Aqua' ),
				'otw-blue'                  => $this->get_label( 'Blue' ),
				'otw-pink'                  => $this->get_label( 'Pink' ),
				'otw-silver'                => $this->get_label( 'Silver' ),
				'otw-brown'                 => $this->get_label( 'Brown' ),
				'otw-black'                 => $this->get_label( 'Black' )
			),
			'default_button_bgcolor_class' => '',
			
			'button_text_color_classes' => array(
				
				''                      => $this->get_label( 'none (Default)' ),
				'otw-red-text'                   => $this->get_label( 'Red' ),
				'otw-orange-text'                => $this->get_label( 'Orange' ),
				'otw-green-text'                 => $this->get_label( 'Green' ),
				'otw-greenish-text'              => $this->get_label( 'Greenish' ),
				'otw-aqua-text'                  => $this->get_label( 'Aqua' ),
				'otw-blue-text'                  => $this->get_label( 'Blue' ),
				'otw-pink-text'                  => $this->get_label( 'Pink' ),
				'otw-silver-text'                => $this->get_label( 'Silver' ),
				'otw-brown-text'                 => $this->get_label( 'Brown' ),
				'otw-black-text'                 => $this->get_label( 'Black' )
			),
			'default_button_text_color_class' => ''
		);
		
	}
	
	/**
	 * Shortcode admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-title', 'label' => $this->get_label( 'Title' ), 'description' => $this->get_label( 'The title for the price box.' ), 'parse' => $source ) );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-price', 'label' => $this->get_label( 'Price' ), 'description' => $this->get_label( 'The price.' ), 'parse' => $source ) );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-price_text', 'label' => $this->get_label( 'Price Text' ), 'description' => $this->get_label( 'The text after the price in the same price area. Example / month.' ), 'parse' => $source ) );
		
		$html .= OTW_Form::text_area( array( 'id' => 'otw-shortcode-element-content', 'label' => $this->get_label( 'Text' ), 'description' => $this->get_label( 'The text bellow the price area. HTML is allowed.' ), 'parse' => $source ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-button', 'label' => $this->get_label( 'Enable Button' ), 'description' => $this->get_label( 'Enables the button.' ), 'parse' => $source, 'options' => $this->settings['enable_button_options'], 'value' => $this->settings['default_enable_button'] )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-button_text', 'label' => $this->get_label( 'Button Text' ), 'description' => $this->get_label( 'The text for the button. Default is \'Sign Up\'.' ), 'parse' => $source ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-button_bgcolor_class', 'label' => $this->get_label( 'Button Color' ), 'description' => $this->get_label( 'Choose a color for the button.' ), 'parse' => $source, 'options' => $this->settings['button_bgcolor_classes'], 'value' => $this->settings['default_button_bgcolor_class'] )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-button_text_color_class', 'label' => $this->get_label( 'Button Text Color' ), 'description' => $this->get_label( 'Choose a color for the button text.' ), 'parse' => $source, 'options' => $this->settings['button_text_color_classes'], 'value' => $this->settings['default_button_text_color_class'] )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-button_link', 'label' => $this->get_label( 'Button Link' ), 'description' => $this->get_label( 'The link for the button.' ), 'parse' => $source ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-title_color_class', 'label' => $this->get_label( 'Title Color' ), 'description' => $this->get_label( 'Choose a color for the title.' ), 'parse' => $source, 'options' => $this->settings['title_color_classes'], 'value' => $this->settings['default_title_color_class'] )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-price_color_class', 'label' => $this->get_label( 'Price Color' ), 'description' => $this->get_label( 'Choose a color for the price.' ), 'parse' => $source, 'options' => $this->settings['price_color_classes'], 'value' => $this->settings['default_price_color_class'] )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-price_text_color_class', 'label' => $this->get_label( 'Price Text Color' ), 'description' => $this->get_label( 'Choose a color for the price text.' ), 'parse' => $source, 'options' => $this->settings['price_text_color_classes'], 'value' => $this->settings['default_price_text_color_class'] )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-background_color_class', 'label' => $this->get_label( 'Price Box Background Color' ), 'description' => $this->get_label( 'Choose a background for the whole price box.' ), 'parse' => $source, 'options' => $this->settings['background_color_classes'], 'value' => $this->settings['default_background_color_class'] )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-price_background_color_class', 'label' => $this->get_label( 'Price Area Background Color' ), 'description' => $this->get_label( 'This is the background color for the price area that includes the Price and the Price Text.' ), 'parse' => $source, 'options' => $this->settings['price_background_color_classes'], 'value' => $this->settings['default_price_background_color_class'] )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-price_background_pattern', 'label' => $this->get_label( 'Price Area Background Pattern' ), 'description' => $this->get_label( 'This is the pattern color for your price area that includes the Price and the Price Text.' ), 'parse' => $source, 'options' => $this->settings['price_background_patterns'], 'value' => $this->settings['default_price_background_pattern'] )  );
		
		return $html;
	}
	
	/**
	 * Shortcode admin interface custom options
	 */
	public function build_shortcode_editor_custom_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		
		$html .= OTW_Form::color_picker( array( 'id' => 'otw-shortcode-element-title_color', 'label' => $this->get_label( 'Title Color Custom' ), 'description' => $this->get_label( 'Choose a custom title color.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::color_picker( array( 'id' => 'otw-shortcode-element-button_bgcolor', 'label' => $this->get_label( 'Button Color Custom' ), 'description' => $this->get_label( 'Choose a custom button color.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::color_picker( array( 'id' => 'otw-shortcode-element-button_text_color', 'label' => $this->get_label( 'Button Text Color Custom' ), 'description' => $this->get_label( 'Choose a custom button text color.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::color_picker( array( 'id' => 'otw-shortcode-element-price_color', 'label' => $this->get_label( 'Price Color Custom' ), 'description' => $this->get_label( 'Choose a custom price color.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::color_picker( array( 'id' => 'otw-shortcode-element-price_text_color', 'label' => $this->get_label( 'Price Text Color Custom' ), 'description' => $this->get_label( 'Choose a custom price text color.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::color_picker( array( 'id' => 'otw-shortcode-element-background_color', 'label' => $this->get_label( 'Price Box Background Color Custom' ), 'description' => $this->get_label( 'Choose a custom box background color.' ), 'parse' => $source ) );
		
		$html .= OTW_Form::color_picker( array( 'id' => 'otw-shortcode-element-price_background_color', 'label' => $this->get_label( 'Price Area Background Color Custom' ), 'description' => $this->get_label( 'Choose a custom price area background.' ), 'parse' => $source ) );
		
		$html .= OTW_Form::uploader( array( 'id' => 'otw-shortcode-element-price_background_pattern_url', 'label' => $this->get_label( 'Price Area Background Pattern URL' ), 'description' => $this->get_label( 'URL to a custom price area background.' ), 'parse' => $source ) );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-css_class', 'label' => $this->get_label( 'CSS Class' ), 'description' => $this->get_label( 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..' ), 'parse' => $source )  );
		
		
		return $html;
	}
	
	/** build shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_price_box';
			
			$code .= $this->format_attribute( 'title', 'title', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'price', 'price', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'price_text', 'price_text', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'button', 'button', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'button_text', 'button_text', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'button_link', 'button_link', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'button_bgcolor_class', 'button_bgcolor_class', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'button_text_color_class', 'button_text_color_class', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'title_color_class', 'title_color_class', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'price_color_class', 'price_color_class', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'price_text_color_class', 'price_text_color_class', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'background_color_class', 'background_color_class', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'price_background_color_class', 'price_background_color_class', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'price_background_pattern', 'price_background_pattern', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'title_color', 'title_color', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'button_bgcolor', 'button_bgcolor', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'button_text_color', 'button_text_color', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'price_color', 'price_color', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'price_text_color', 'price_text_color', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'css_class', 'css_class', $attributes, false, '', true  );
			
			$code .= $this->format_attribute( 'background_color', 'background_color', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'price_background_color', 'price_background_color', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'price_background_pattern_url', 'price_background_pattern_url', $attributes, false, '', true );
			
			$code .= ']';
			
			$code .= $attributes['content'];
			
			$code .= '[/otw_shortcode_price_box]';
		
		}
		
		return $code;

	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode( $attributes, $content ){
		
		$html = '<div';
		
		/*class attributes*/
		$class = 'otw-cs-pricebox';
		
		$class .= $this->format_attribute( '', 'background_color_class', $attributes, false, $class );
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		if( strlen( $class ) ){
			$html .= ' class="'.$class.'"';
		}
		/*end class attributes*/
		
		/*style attribute*/
		$style = '';
		
		if( $bgcolor = $this->format_attribute( '', 'background_color', $attributes, false, '' ) ){
			$style = $this->append_attribute( $style, 'background-color: '.$bgcolor.';' );
		}
		
		if( strlen( $style ) ){
			$html .= ' style="'.$style.'"';
		}
		
		$html .= '>';
		
		$title_class = 'price-head';
		
		$title_class .= $this->format_attribute( '', 'title_color_class', $attributes, false, $title_class );
		
		$title_style = '';
		
		if( $color = $this->format_attribute( '', 'title_color', $attributes, false, '' ) ){
			$title_style = $this->append_attribute( $title_style, 'color: '.$color.';' );
		}
		
		if( strlen( $title_style ) ){
			$title_style = ' style="'.$title_style.'"';
		}
		
		if( $title = $this->format_attribute( '', 'title', $attributes, false, '' ) ){
			$html .= '<h3 class="'.$title_class.'"'.$title_style.'>'.$title.'</h3>';
		}
		
		if( $price = $this->format_attribute( '', 'price', $attributes, false, '' ) ){
		
			$price_area_class = 'price';
			
			$price_area_class .= $this->format_attribute( '', 'price_background_color_class', $attributes, false, $price_area_class );
			
			$price_area_class .= $this->format_attribute( '', 'price_background_pattern', $attributes, false, $price_area_class );
			
			$price_area_style  = '';
			
			if( $pattern = $this->format_attribute( '', 'price_background_pattern_url', $attributes, false, '' ) ){
				$price_area_style = $this->append_attribute( $price_area_style, 'background-image: url(\''.$pattern.'\');' );
			}
			
			if( $bgcolor = $this->format_attribute( '', 'price_background_color', $attributes, false, '' ) ){
				$price_area_style = $this->append_attribute( $price_area_style, 'background-color: '.$bgcolor.';' );
			}
			
			if( strlen( $price_area_style ) ){
				$price_area_style = ' style="'.$price_area_style.'"';
			}
			
			$html .= '<div class="'.$price_area_class.'"'.$price_area_style.'>';
				
				$price_class = '';
				
				$price_class .= $this->format_attribute( '', 'price_color_class', $attributes, false, $price_class );
				
				$price_style = '';
				
				if( $color = $this->format_attribute( '', 'price_color', $attributes, false, '' ) ){
					$price_style = $this->append_attribute( $price_style, 'color: '.$color.';' );
				}
				
				if( strlen( $price_class ) ){
					$price_class = ' class="'.$price_class.'"';
				}
				
				if( strlen( $price_style ) ){
					$price_style = ' style="'.$price_style.'"';
				}
				
				$html .= '<strong'.$price_class.''.$price_style.'>'.$price.'</strong>';
				
				if( $price_text = $this->format_attribute( '', 'price_text', $attributes, false, '' ) ){
				
					$price_text_class = '';
					
					$price_text_style = '';
					
					$price_text_class .= $this->format_attribute( '', 'price_text_color_class', $attributes, false, $price_text_class );
					
					if( $color = $this->format_attribute( '', 'price_text_color', $attributes, false, '' ) ){
						$price_text_style = $this->append_attribute( $price_text_style, 'color: '.$color.';' );
					}
					
					if( strlen( $price_text_class ) ){
						$price_text_class = ' class="'.$price_text_class.'"';
					}
					
					if( strlen( $price_text_style ) ){
						$price_text_style = ' style="'.$price_text_style.'"';
					}
					
					$html .= '<span'.$price_text_class.''.$price_text_style.'>'.$price_text.'</span>';
					
				}
				
			$html .= '</div>';
		}
		
		$html .= '<div class="pricebox_text">'.$content.'</div>';
		
		if( $this->format_attribute( '', 'button', $attributes, false, '' ) ){
			
			$button_class = 'button';
			$button_style = '';
			$button_link  = '#';
			$button_text  = $this->get_label( 'Sign up' );
			
			if( $value = $this->format_attribute( '', 'button_text', $attributes, false, '' ) ){
				$button_text = $value;
			}
			
			if( $value = $this->format_attribute( '', 'button_link', $attributes, false, '' ) ){
				$button_link = $value;
			}
			
			$button_class .= $this->format_attribute( '', 'button_bgcolor_class', $attributes, false, $button_class );
			
			$button_class .= $this->format_attribute( '', 'button_text_color_class', $attributes, false, $button_class );
			
			if( $value = $this->format_attribute( '', 'button_bgcolor', $attributes, false, '' ) ){
				$button_style = $this->append_attribute( $button_style, 'background-color: '.$value.';' );
			}
			
			if( $value = $this->format_attribute( '', 'button_text_color', $attributes, false, '' ) ){
				$button_style = $this->append_attribute( $button_style, 'color: '.$value.';' );
			}
			
			if( strlen( $button_style ) ){
				$button_style = ' style="'.$button_style.'"';
			}
			
			$html .= '<div class="otw_price_button"><a class="'.$button_class.'"'.$button_style.' href="'.$button_link.'">'.$button_text.'</a></div>';
			
		}
		
		$html .= '</div>';
		
		return $this->format_shortcode_output( $html );
	}
}
?>
