<?php
class OTW_Shortcode_Post_Tabs extends OTW_Shortcodes{
	
	public function __construct(){
		
		$this->has_custom_options = true;
		
		parent::__construct();
	}
	/**
	 * register external libs
	 */
	public function register_external_libs(){
	
		$this->add_external_lib( 'css', 'otw-shortcode-jquery-ui', $this->component_url.'css/jquery-ui-1.9.1.css', 'all', 30 );
		
		$this->add_external_lib( 'css', 'otw-shortcode', $this->component_url.'css/otw_shortcode.css', 'all', 100 );
		
		
		$this->add_external_lib( 'js', 'otw-shortcode-core', $this->component_url.'js/otw_shortcode_core.js', 'all', 99, array( 'jquery' ) );
		$this->add_external_lib( 'js', 'otw-shortcode', $this->component_url.'js/otw_shortcode.js', 'front', 100 );
		$this->add_external_lib( 'js', 'otw-shortcode_live_preview', $this->component_url.'js/otw_shortcode_live_preview.js', 'live_preview', 200 );
	}
	/**
	 * apply settings
	 */
	public function apply_settings(){
		
		$this->settings = array(
			
			'number' => array(
					'1'    => $this->get_label( '1' ),
					'2'    => $this->get_label( '2' ),
					'3'    => $this->get_label( '3' ),
					'4'    => $this->get_label( '4' ),
					'5'    => $this->get_label( '5' ),
					'6'    => $this->get_label( '6' ),
					'7'    => $this->get_label( '7' ),
					'8'    => $this->get_label( '8' ),
					'9'    => $this->get_label( '9' ),
					'10'   => $this->get_label( '10' )
				),
			'default_number' => '5',
			
			'types' => array(
					'pop'   => $this->get_label( 'Popular' ),
					'latest'   => $this->get_label( 'Latest' ),
					'comments'   => $this->get_label( 'Comments' ),
					'tags'   => $this->get_label( 'Tags' )
				),
			'default_type' => 'pop'
		);
	}
	
	/**
	 * Shortcode admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-number', 'label' => $this->get_label( 'Number of posts' ), 'description' => $this->get_label( 'Number of posts to show.' ), 'parse' => $source, 'options' => $this->settings['number'], 'value' => $this->settings['default_number'] )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-thumb_size', 'label' => $this->get_label( 'Thumbnail width' ), 'description' => $this->get_label( 'Thumbnail width. (0=disable)' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-pop_limit', 'label' => $this->get_label( 'Popular limit' ), 'description' => $this->get_label( 'Popular posts tab limit in days.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-active', 'label' => $this->get_label( 'First Visible Tab' ), 'description' => $this->get_label( 'Select the first visible tab.' ), 'parse' => $source, 'options' => $this->settings['types'], 'value' => $this->settings['default_type'] )  );
		
		$html .= '<div class="otw-form-control"><label>'.$this->get_label( 'Hide Tabs' ).'</label></div>';
		
		foreach( $this->settings['types'] as $type_code => $type_name ){
			
			$html .=  OTW_Form::checkbox( array( 'id' => 'otw-shortcode-element-hide_'.$type_code, 'label' => $type_name, 'description' => $this->get_label( '' ), 'parse' => $source, 'value' => 1 )  );
		}
		$html .= '<div class="otw-form-control"><span class="otw-form-hint">'.$this->get_label( 'Select what tabs to hide.').'</span></div>';
		
		return $html;
	}
	
	/**
	 * Shortcode admin interface custom options
	 */
	public function build_shortcode_editor_custom_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-css_class', 'label' => $this->get_label( 'CSS Class' ), 'description' => $this->get_label( 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/** build shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_post_tabs';
			
			$code .= $this->format_attribute( 'number', 'number', $attributes, false, '', true );
			$code .= $this->format_attribute( 'thumb_size', 'thumb_size', $attributes, false, '', true );
			$code .= $this->format_attribute( 'pop_limit', 'pop_limit', $attributes, false, '', true );
			$code .= $this->format_attribute( 'active', 'active', $attributes, false, '', true );
			
			foreach( $this->settings['types'] as $type_code => $type_name ){
				$code .= $this->format_attribute( 'hide_'.$type_code, 'hide_'.$type_code, $attributes, false, '', true );
			}
			
			$code .= $this->format_attribute( 'css_class', 'css_class', $attributes, false, '', true  );
			
			$code .= ']';
			
			$code .= '[/otw_shortcode_post_tabs]';
		}
		
		return $code;

	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode( $attributes, $content ){
		
		$html = '<div';
		
		/*class attributes*/
		$class = 'otw-sc-tabs otw-post-tabs ui-tabs ui-widget ui-widget-content ui-corner-all';
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		if( strlen( $class ) ){
			$html .= ' class="'.$class.'"';
		}
		/*end class attributes*/
		
		/*style attribute*/
		$style = '';
		
		if( $float = $this->format_attribute( '', 'float', $attributes, false, '' ) ){
			$style = $this->append_attribute( $style, 'float: '.$float.';' );
		}
		
		if( strlen( $style ) ){
			$html .= ' style="'.$style.'"';
		}
		
		$html .= '>';
		
		$html .= '<ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">';
		
		foreach( $this->settings['types'] as $type_code => $type_name ){
			
			if( $this->format_attribute( '', 'hide_'.$type_code, $attributes, false, '' ) != 1 ){
				
				$li_class = 'ui-state-default ui-corner-top';
				
				if( $this->format_attribute( '', 'active', $attributes, false, '' ) == $type_code ){
				
					$li_class .= ' ui-tabs-active ui-state-active';
				}
				
				$html .= '<li class="'.$li_class.'">';
				
				$html .= '<a href="#tabs-'.$type_code.'">';
				
				$html .= $type_name;
				
				$html .= '</a>';
				
				$html .= '</li>';
			}
		}
		$html .= '</ul>';
		
		foreach( $this->settings['types'] as $type_code => $type_name ){
			
			if( $this->format_attribute( '', 'hide_'.$type_code, $attributes, false, '' ) != 1 ){
				$html .= '<div id="tabs-'.$type_code.'" class="ui-tabs-panel ui-widget-content ui-corner-bottom">';
				
				switch( $type_code ){
					
					case 'pop':
							if( $pop_limit = $this->format_attribute( '', 'pop_limit', $attributes, false, '' ) ){
								global $popular_days;
								
								$popular_days = $pop_limit;
								
								add_filter('posts_where', array( $this, 'popular_filter_where' ) );
							}
							$popular = get_posts( array( 'suppress_filters' => false, 'ignore_sticky_posts' => 1, 'orderby' => 'comment_count', 'numberposts' => $this->format_attribute( '', 'number', $attributes, false, '' )) );
							
							if( $pop_limit = $this->format_attribute( '', 'pop_limit', $attributes, false, '' ) ){
								remove_filter('posts_where', array( $this, 'popular_filter_where' ) );
							}
							
							foreach( $popular as $post ){
							
								$html .= '<div class="widget-row animate-on-hover otw-post-tabs-content-wrapper">';
								
								if( $this->format_attribute( '', 'thumb_size', $attributes, false, '' ) ){
									if( $img_link = get_the_post_thumbnail($post->ID, array($this->format_attribute( '', 'thumb_size', $attributes, false, '' ),$this->format_attribute( '', 'thumb_size', $attributes, false, '' )),array( ) ) ){
										$html .= '<a href="'.get_permalink().'" class="image">';
										$html .= $img_link;
										$html .= '<span class="shadow-overlay hide-for-small"></span>';
										$html .= '</a>';
									}
								}
								
								$html .= '<div class="otw-post-tabs-content">';
								
								$html .= '<h4><a href="'.get_permalink().'">'.the_title('','',false).'</a></h4>';
								
								$html .= '<p>'.get_the_time( get_option( 'date_format' ), $post ).'</p>';
								
								$html .= '</div>';
								
								$html .= '</div>';
								
							}
						break;
					case 'latest':
							$latest = get_posts( 'ignore_sticky_posts=1&numberposts='. $this->format_attribute( '', 'number', $attributes, false, '' ) .'&orderby=post_date&order=desc' );
							
							foreach( $latest as $post ){
							
								$html .= '<div class="widget-row animate-on-hover otw-post-tabs-content-wrapper">';
							
								if( $this->format_attribute( '', 'thumb_size', $attributes, false, '' ) ){
									
									if( $img_link = get_the_post_thumbnail($post->ID, array($this->format_attribute( '', 'thumb_size', $attributes, false, '' ),$this->format_attribute( '', 'thumb_size', $attributes, false, '' )),array( ) ) ){
										$html .= '<a href="'.get_permalink().'" class="image">';
										$html .= $img_link;
										$html .= '<span class="shadow-overlay hide-for-small"></span>';
										$html .= '</a>';
									}
								}
								$html .= '<div class="otw-post-tabs-content">';
								
								$html .= '<h4><a href="'.get_permalink().'">'.the_title('','',false).'</a></h4>';
								
								$html .= '<p>'.get_the_time( get_option( 'date_format' ), $post ).'</p>';
								
								$html .= '</div>';
								
								$html .= '</div>';
								
							}
						break;
					case 'comments':
							$html .= '<div class="otw-sc-recent-comments otw-widget-list">';
							
							$html .= '<h3 class="widget-title">'.$this->get_label( 'Recent comments' ).'</h3>';
							$comments = get_comments( array( 'number' => $this->format_attribute( '', 'number', $attributes, false, '' ), 'status' => 'approve' ) );
							
							if ( $comments ){
								
								$html .= '<ul class="otw-list">';
								foreach ( (array) $comments as $comment) {
									$post = get_post( $comment->comment_post_ID );
									
									$html .= '<li><a href="'.get_comment_link($comment->comment_ID).'">';
									
									$html .= wp_filter_nohtml_kses($comment->comment_author).' '.stripslashes( substr( wp_filter_nohtml_kses( $comment->comment_content ), 0, 50 ) ).'...';
									
									$html .= '</a></li>';
								}
								$html .= '</ul>';
							}
							$html .= '</div>';
						break;
					case 'tags':
							$html .= '<p>'.wp_tag_cloud( array( 'smallest'=>12, 'largest' => 20, 'echo' => false ) ).'</p>';
						break;
				}
				$html .= '</div>';
			}
		}
		$html .= '</div>';
		
		return $this->format_shortcode_output( $html );
	}
	
	public function popular_filter_where( $where ){
		
		global $popular_days;
		//posts in the last X days
		$where .= " AND post_date > '" . date('Y-m-d', strtotime('-'.$popular_days.' days')) . "'";
		return $where;
	}
}
