<?php
class OTW_Shortcode_Portfolio_Lists extends OTW_Shortcodes{
	
	/**
	 * shortcode counter
	 */
	public static $shortcode_counter = 0;
	
	/**
	 * pager var name
	 */
	private $pager_var_name = '';
	
	/**
	 *  Numbers
	 *
	 *  @var array
	 */
	public function __construct(){
		
		$this->has_custom_options = true;
		
		parent::__construct();
		
		add_action( 'wp_ajax_otw_item_options_otw_shortcode-element-otw_cm_portfolio_categories', array( $this, '_get_otw_cm_portfolio_category_options' ) );
	}
	/**
	 * register external libs
	 */
	public function register_external_libs(){
		
		$this->add_external_lib( 'css', 'otw-shortcode', $this->component_url.'css/otw_shortcode.css', 'all', 100 );
		$this->add_external_lib( 'css', 'otw-shortcode-jquery-ui', $this->component_url.'css/jquery-ui-1.9.1.css', 'all', 30 );
		$this->add_external_lib( 'css', 'otw-shortcode-block-grid', $this->component_url.'css/otw_block_grid.css', 'live_preview', 130 );
		
		$this->add_external_lib( 'js', 'otw-shortcode-core', $this->component_url.'js/otw_shortcode_core.js', 'all', 99, array( 'jquery' ) );
		$this->add_external_lib( 'js', 'otw-shortcode', $this->component_url.'js/otw_shortcode.js', 'front', 100 );
		$this->add_external_lib( 'js', 'otw-shortcode_live_preview', $this->component_url.'js/otw_shortcode_live_preview.js', 'live_preview', 200 );
	}
	
	/**
	 * apply settings
	 */
	public function apply_settings(){
		
		$this->settings = array(
			
			'templates' => array(
				'p1c'          => $this->get_label( 'Portfolio 1 Column' ),
				'p2c'          => $this->get_label( 'Portfolio 2 Column' ),
				'p3c'          => $this->get_label( 'Portfolio 3 Column' ),
				'p4c'          => $this->get_label( 'Portfolio 4 Column' ),
				'pws'          => $this->get_label( 'Portfolio Widget Style' ),
				'pa'           => $this->get_label( 'Portfolio Archive' )
			),
			'default_template' => 1,
			'default_per_page' => 10,
			'pager' => array(
				'yes'          => $this->get_label( 'yes' ),
				'no'          => $this->get_label( 'no' )
			),
			'default_pager' => 'no',
			
			'yes_no' => array(
				'yes'          => $this->get_label( 'yes' ),
				'no'          => $this->get_label( 'no' )
			),
			'default_yes_no' => 'yes',
			
			'targets' => array( 
				'_self' => $this->get_label( 'Same Window / Tab (default)' ),
				'_blank' => $this->get_label( 'New Window / Tab' )
			),
			'default_target' => '_self',
			
			'default_excerpt_words' => 20
		);
		
	}
	
	/**
	 * Shortcode admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-template', 'label' => $this->get_label( 'Choose template' ), 'description' => $this->get_label( 'Choose the template.' ), 'parse' => $source, 'options' => $this->settings['templates'], 'value' => $this->settings['default_template'] ) );
		
		$html .= OTW_Form::dynamic_select( array( 'id' => 'otw-shortcode-element-otw_cm_portfolio_categories', 'label' => $this->get_label( 'Choose Categories' ), 'description' => $this->get_label( 'Choose categories to include posts from those categories in your list or use the Select all checkbox to include posts from all categories.' ), 'parse' => $source ) );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-number', 'label' => $this->get_label( 'Number of Posts in the list' ), 'description' => $this->get_label( 'Please leave empty for all posts.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-per_page', 'label' => $this->get_label( 'Number of Posts per Page' ), 'description' => $this->get_label( 'Show pagination should be ebabled in the section above in order for this option to work.' ), 'parse' => $source, 'value' => $this->settings['default_per_page'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-pager', 'label' => $this->get_label( 'Show Pagination' ), 'description' => $this->get_label( 'Enable pager.' ), 'parse' => $source, 'options' => $this->settings['pager'], 'value' => $this->settings['default_pager'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-show_category_filters', 'label' => $this->get_label( 'Enable Category Filters' ), 'description' => $this->get_label( 'Enable Category Filters' ), 'parse' => $source, 'options' => $this->settings['pager'], 'value' => $this->settings['default_yes_no'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-show_title', 'label' => $this->get_label( 'Show Title' ), 'description' => $this->get_label( '' ), 'parse' => $source, 'options' => $this->settings['yes_no'], 'value' => $this->settings['default_yes_no'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-show_meta', 'label' => $this->get_label( 'Show Category' ), 'description' => $this->get_label( '' ), 'parse' => $source, 'options' => $this->settings['yes_no'], 'value' => $this->settings['default_yes_no'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-show_excerpt', 'label' => $this->get_label( 'Show Excerpt' ), 'description' => $this->get_label( '' ), 'parse' => $source, 'options' => $this->settings['yes_no'], 'value' => $this->settings['default_yes_no'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-show_read_more', 'label' => $this->get_label( 'Show Read More' ), 'description' => $this->get_label( '' ), 'parse' => $source, 'options' => $this->settings['yes_no'], 'value' => $this->settings['default_yes_no'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-show_image', 'label' => $this->get_label( 'Show Image' ), 'description' => $this->get_label( '' ), 'parse' => $source, 'options' => $this->settings['yes_no'], 'value' => $this->settings['default_yes_no'] ) );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-excerpt_words', 'label' => $this->get_label( 'Excerpt length in words' ), 'description' => $this->get_label( 'Excerpt is pulled from excerpt field for each post. If excerpt fields is empty excerpt is pulled from the text area (the post editor). If Excerpt length is empty or 0 this means pull the entire text.' ), 'parse' => $source, 'value' => $this->settings['default_excerpt_words'] )  );
		
		return $html;
	}
	
	/**
	 * Shortcode admin interface custom options
	 */
	public function build_shortcode_editor_custom_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-css_class', 'label' => $this->get_label( 'CSS Class' ), 'description' => $this->get_label( 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/** build shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_portfolio_lists';
			
			$code .= $this->format_attribute( 'template', 'template', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'otw_cm_portfolio_categories', 'otw_cm_portfolio_categories', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'otw_cm_portfolio_categories_allitems', 'otw_cm_portfolio_categories_allitems', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'number', 'number', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'per_page', 'per_page', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'pager', 'pager', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'show_category_filters', 'show_category_filters', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'show_title', 'show_title', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'show_meta', 'show_meta', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'show_excerpt', 'show_excerpt', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'show_read_more', 'show_read_more', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'show_image', 'show_image', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'excerpt_words', 'excerpt_words', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'css_class', 'css_class', $attributes, false, '', true  );
			
			$code .= ']';
			
			$code .= '[/otw_shortcode_portfolio_lists]';
		
		}
		
		return $code;

	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode( $attributes, $content ){
		
		$html = '';
		
		if( isset( $attributes['template'] ) ){
			
			self::$shortcode_counter++;
			
			$this->pager_var_name = 'otwpl'.self::$shortcode_counter.'page';
			
			$query = array();
			$query['post_status'] = 'publish';
			$query['post_type']   = 'otw_cm_portfolio';
			
			$has_search = false;
			
			if( $this->format_attribute( '', 'otw_cm_portfolio_categories_allitems', $attributes, false, '' ) != 1 ){
				
				if( $param_value = $this->format_attribute( '', 'otw_cm_portfolio_categories', $attributes, false, '' ) ){
					
					$has_search = true;
					
					$query['tax_query'] = array(
						array(
							'taxonomy' => 'otw_cm_portfolio_category',
							'field'    => 'id',
							'terms'    => explode( ',', $this->format_attribute( '', 'otw_cm_portfolio_categories', $attributes, false, '' )  ),
							'operator' => 'IN'
						)
					);
				}
			}elseif( $this->format_attribute( '', 'otw_cm_portfolio_categories_allitems', $attributes, false, '' ) == 1 ){
				$has_search = true;
			}
			
			if( $has_search ){
				
				//this should be the last query params
				if( $this->format_attribute( '', 'pager', $attributes, false, '' ) == 'yes' ){
					
					if( $param_value = $this->format_attribute( '', 'per_page', $attributes, false, '' ) ){
						
						if( $number = $this->format_attribute( '', 'number', $attributes, false, '' ) ){
							//pull only limited number of posts
							$query['posts_per_page'] = $number;
							
							//limited posts
							wp_reset_query();
							$otw_limited_posts = new WP_Query( $query );
							
							if( isset( $otw_limited_posts->posts ) ){
								
								$post_ids = array();
								foreach( $otw_limited_posts->posts as $limited_post ){
									$post_ids[ $limited_post->ID ] = $limited_post->ID;
								}
								$query['post__in'] = $post_ids;
							}
							unset( $query['posts_per_page'] );
						}
						
						$query['posts_per_page'] = $param_value;
						$query['paged'] = 1;
						
						if( isset( $_GET[ $this->pager_var_name ] ) && intval( $_GET[ $this->pager_var_name ] ) ){
							$query['paged'] = max( 1, intval( $_GET[ $this->pager_var_name ] ) );
						}else{
							$query['paged'] = 1;
						}
					}
					
					
				}elseif( $param_value = $this->format_attribute( '', 'number', $attributes, false, '' ) ){
					$query['posts_per_page'] = $param_value;
				}
				
				wp_reset_query();
				
				$otw_posts = new WP_Query( $query );
				
				switch( $attributes['template'] ){
					
					case 'p1c':
							$html .= $this->renderP1CTemplate( $attributes, $otw_posts );
						break;
					case 'p2c':
							$html .= $this->renderP2CTemplate( $attributes, $otw_posts );
						break;
					case 'p3c':
							$html .= $this->renderP3CTemplate( $attributes, $otw_posts );
						break;
					case 'p4c':
							$html .= $this->renderP4CTemplate( $attributes, $otw_posts );
						break;
					case 'pa':
							$html .= $this->renderPATemplate( $attributes, $otw_posts );
						break;
					case 'pws':
							$html .= $this->renderPWSTemplate( $attributes, $otw_posts );
						break;
					default:
							echo $attributes['template'];
						break;
				}
			}
		}
		
		return $this->format_shortcode_output( $html );
	}
	
	private function renderPWSTemplate( $attributes, $items ){
		
		$html = '';
		
		$class = 'otw-widget-portfolio-latest animate-on-hover latest-portfolio-items';
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		$html = '';
		
		if( isset( $items->posts ) && is_array( $items->posts ) && count( $items->posts ) ){
			
			$html .= '<div class="otw-row">';
			$html .=	'<div class="'.$class.'">';
			$html .=		'<h3 class="widget-title">'.$this->get_label( 'Latest Portfolio Items').'</h3>';
			foreach( $items->posts as $item ){
				
				$html .= '<div class="widget-row">';
				$html .=	$this->renderPost( $item, $attributes );
				$html .= '</div>';
			}
			$html .=	'</div>';
			$html .= '</div>';
			$html .= $this->renderPager( $items, $attributes );
		}
		
		return $html;
	}
	
	private function renderPATemplate( $attributes, $items ){
		
		$html = '';
		
		$class = 'otw-twentyfour otw-columns';
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		$html = '';
		
		if( isset( $items->posts ) && is_array( $items->posts ) && count( $items->posts ) ){
			
			foreach( $items->posts as $item ){
				
				$html .= '<div class="otw-row">';
				
				$html .= 	'<div class="'.$class.'">';
				$html .=		$this->renderPost( $item, $attributes );
				$html .= 	'</div>';
				
				$html .= '</div>';
			}
			$html .= $this->renderPager( $items, $attributes );
		}
		
		return $html;
	}
	
	private function renderP4CTemplate( $attributes, $items ){
		
		$html = '';
		
		$class = 'otw-row otw-sc-portfolio';
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		$html = '<div class="'.$class.'">';
		
		$html .=	'<div class="otw-twentyfour otw-columns">';
		$html .=		$this->renderCategoryFilters( $attributes, $items );
		if( isset( $items->posts ) && is_array( $items->posts ) && count( $items->posts ) ){
			
			$html .= '<ul class="otw-portfolio otw-portfolio-working block-grid four-up mobile">';
			
			foreach( $items->posts as $item ){
				
				$html .= $this->renderPost( $item, $attributes );
			}
			
			$html .= '</ul>';
			
		}
		$html .=	'</div>';
		
		$html .= '</div>';
		
		$html .= $this->renderPager( $items, $attributes );
		
		return $html;
	}
	
	private function renderP3CTemplate( $attributes, $items ){
		
		$html = '';
		
		$class = 'otw-row otw-sc-portfolio';
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		$html = '<div class="'.$class.'">';
		
		$html .=	'<div class="otw-twentyfour otw-columns">';
		$html .=		$this->renderCategoryFilters( $attributes, $items );
		if( isset( $items->posts ) && is_array( $items->posts ) && count( $items->posts ) ){
			
			$html .= '<ul class="otw-portfolio block-grid three-up mobile">';
			
			foreach( $items->posts as $item ){
				
				$html .= $this->renderPost( $item, $attributes );
			}
			
			$html .= '</ul>';
			
		}
		$html .=	'</div>';
		
		$html .= '</div>';
		
		$html .= $this->renderPager( $items, $attributes );
		
		return $html;
	}
	
	private function renderP2CTemplate( $attributes, $items ){
		
		$html = '';
		
		$class = 'otw-row otw-sc-portfolio';
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		$html = '<div class="'.$class.'">';
		
		$html .=	'<div class="otw-twentyfour otw-columns">';
		$html .=		$this->renderCategoryFilters( $attributes, $items );
		if( isset( $items->posts ) && is_array( $items->posts ) && count( $items->posts ) ){
			
			$html .= '<ul class="otw-portfolio block-grid two-up mobile">';
			
			foreach( $items->posts as $item ){
				
				$html .= $this->renderPost( $item, $attributes );
			}
			
			$html .= '</ul>';
			
		}
		$html .=	'</div>';
		
		$html .= '</div>';
		
		$html .= $this->renderPager( $items, $attributes );
		
		return $html;
	}
	
	private function renderP1CTemplate( $attributes, $items ){
		
		$class = 'otw-row otw-sc-portfolio';
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		$html = '<div class="'.$class.'">';
		$html .= 	'<div class="otw-sc-portfolio">';
		$html .= 		'<div class="otw-twentyfour otw-columns">';
		
		$html .= $this->renderCategoryFilters( $attributes, $items );
		
		if( isset( $items->posts ) && is_array( $items->posts ) && count( $items->posts ) ){
			
			$html .= '<ul class="otw-portfolio block-grid one-up">';
		
			foreach( $items->posts as $item ){
				
				$html .= $this->renderPost( $item, $attributes );
			}
			
			$html .= '</ul>';
			
		}
		$html .= 		'</div>';
		$html .= 	'</div>';
		$html .= '</div>';
		
		$html .= $this->renderPager( $items, $attributes );
		
		return $html;
	}
	
	private function excerptLength($content, $count){
		$content = strip_tags($content);
		
		$content = str_replace('&nbsp;', ' ', $content);
		
		$content = explode(" ", $content);
		
		if( $count == 0 ){
			$count = 1;
		}
		
		if ($count < count($content) ){
			$content = array_slice($content, 0, $count);
		}
		$content = join(" ", $content);
		
		return $content;
	}
	
	private function resize_media( $type, $path, $width, $height, $crop ){
	
		$params = array();
		$params['type']   = $type;
		$params['path']   = $path;
		$params['width']  = $width;
		$params['height'] = $height;
		$params['crop']   = $crop;
		
		return otw_resize_media( $params );
	}
	
	private function renderCategoryFilters( $attributes, $items ){
		
		$html = '';
		
		if( $this->format_attribute( '', 'show_category_filters', $attributes, false, '' ) == 'yes'  ){
		
			$categories = array();
			//collect categories
			if( isset( $items->posts ) && is_array( $items->posts ) && count( $items->posts ) ){
				
				foreach( $items->posts as $item ){
					
					$catArray = wp_get_post_terms( $item->ID, 'otw_cm_portfolio_category' );
					
					if( is_array( $catArray ) && count( $catArray ) ){
						
						foreach( $catArray as $cat ){
							$categories[ $cat->term_id ] = $cat;
						}
					}
				}
			}
			
			if( count( $categories ) ){
				
				$html .= '<ul class="otw-portfolio-filter">';
				$html .= 		'<li class="current all"><a href="#">'.$this->get_label( 'All' ).'</a></li>';
				
				foreach( $categories as $cat ){
					$html .= '<li class="catf_'.self::$shortcode_counter.'_'.$cat->term_id.'" ><span class="separator">/</span><a href="#">'.$cat->name.'</a></li>';
				}
				
				$html .= '</ul>';
			}
		}
		
		return $html;
	}
	
	private function renderPost( $item, $attributes ){
		
		$html = '';
		$postLink = get_permalink( $item->ID );
		
		$data_type = '';
		
		$catArray = wp_get_post_terms( $item->ID, 'otw_cm_portfolio_category' );
					
		if( is_array( $catArray ) && count( $catArray ) ){
			foreach( $catArray as $cat ){
				$data_type .= ' catf_'.self::$shortcode_counter.'_'.$cat->term_id;
			}
			$data_type = trim( $data_type );
		}
		
		switch( $attributes['template'] ){
		
			case 'p1c':
					$html .= '<li data-id="id-'.$item->ID.'" data-type="'.$data_type.'">';
					$html .= 	'<div class="otw-sixteen otw-columns">';
					$html .= 		'<article class="otw-portfolio-item">';
					$html .=			'<a class="otw-portfolio-item-link" href="'.$postLink.'">';
					$html .=				$this->renderPostImage( $item, $attributes, $postLink );
					$html .=				'<span class="shadow-overlay hide-for-small" style="box-shadow: 0px 0px 0px 0px rgba(0, 0, 0, 0.698) inset;"></span>';
					$html .=			'</a>';
					$html .= 		'</article>';
					$html .= 	'</div>';
					$html .= 	'<div class="otw-eight otw-columns">';
					$html .= 		'<article class="otw-portfolio-item-text-column">';
					$html .= 			$this->renderPostTitle( $item, $attributes, $postLink );
					$html .= 			$this->renderPostMeta( $item, $attributes, $postLink );
					$html .= 			$this->renderPostContent( $item, $attributes, $postLink );
					$html .= 			$this->renderPostReadMore( $item, $attributes, $postLink );
					$html .= 		'</article>';
					$html .= 	'</div>';
					$html .= '</li>';
				break;
			case 'pws':
					$html .= $this->renderPostImage( $item, $attributes, $postLink );
					
					//title
					$html .= $this->renderPostTitle( $item, $attributes, $postLink );
					
					//meta
					$html .= $this->renderPostMeta( $item, $attributes, $postLink );
					
					//content
					$html .= $this->renderPostContent( $item, $attributes, $postLink );
					
					//read more
					$html .= $this->renderPostReadMore( $item, $attributes, $postLink );
				break;
			case 'pa':
					$article_class = 'otw-post-archive';
					
					if( $this->format_attribute( '', 'show_image', $attributes ) != 'yes' ){
						$article_class .= ' otw-no-image';
					}
					$html .= '<article class="'.$article_class.'">';
					
					$html .= $this->renderPostImage( $item, $attributes, $postLink );
					
					$html .= '<div class="post-body">';
					
					//title
					$html .= $this->renderPostTitle( $item, $attributes, $postLink );
					
					//meta
					$html .= $this->renderPostMeta( $item, $attributes, $postLink );
					
					//content
					$html .= $this->renderPostContent( $item, $attributes, $postLink );
					
					//read more
					$html .= $this->renderPostReadMore( $item, $attributes, $postLink );
					
					$html .= '</div>';
					
					$html .= '</article>';
				break;
			default:
					$html .= '<li data-id="id-'.$item->ID.'" data-type="'.$data_type.'">';
					$html .= 	'<article class="otw-portfolio-item">';
					$html .=		'<a class="otw-portfolio-item-link" href="'.$postLink.'">';
					$html .=				$this->renderPostImage( $item, $attributes, $postLink );
					$html .=				$this->renderImageTitle( $item, $attributes, $postLink );
					$html .=				$this->renderImageText( $item, $attributes, $postLink );
					$html .=				'<span class="shadow-overlay hide-for-small" style="box-shadow: 0px 0px 0px 0px rgba(0, 0, 0, 0.698) inset;"></span>';
					$html .=		'</a>';
					$html .= 	'</article>';
					$html .= '</li>';
				break;
		}
		
		return $html;
	}
	
	private function renderPager( $items, $attributes ){
		
		$html = '';
		
		if( $this->format_attribute( '', 'pager', $attributes, false, '' ) == 'yes' && isset( $items->query['paged'] ) && $items->query['paged'] ){
			
			$html .= '<div class="otw-row">';
			$html .= 	'<div class="otw-twentyfour otw-columns">';
			$html .= '<ul class="pagination">';
			
			if( $items->query['paged'] > 1 ){
				$html .= '<li class="prev">';
				$html .= 		'<a href="'.esc_url( add_query_arg( $this->pager_var_name, ( $items->query['paged'] - 1 ) ) ).'">&laquo '.$this->get_label('Previous').'</a>';
				$html .= '</li>';
			}
			
			if( isset( $items->max_num_pages ) && $items->max_num_pages > 1 ){
				for( $cP = 1; $cP <= $items->max_num_pages; $cP ++){
					
					$current_page = '';
					
					if( $cP == $items->query['paged'] ){
						$current_page = ' class="current"';
					}
					
					$html .= '<li'.$current_page.'>';
					$html .= 	'<a href="'.esc_url( add_query_arg( $this->pager_var_name, ( $cP ) ) ).'">'.$cP.'</a>';
					$html .= '</li>';
				}
				
				if( $items->query['paged'] < $items->max_num_pages ){
					$html .= '<li class="next">';
					$html .= 	'<a href="'.esc_url( add_query_arg( $this->pager_var_name, ( $items->query['paged'] + 1 ) ) ).'">'.$this->get_label('Next').' &raquo</a>';
					$html .= '</li>';
				}
			}
			$html .= '</ul>';
			
			$html .= 	'</div>';
			$html .= '</div>';
		}
		
		return $html;
	}
	
	public function renderPostTitle( $item, $attributes, $postLink, $wrap = true ){
		$html = '';
		
		if( $this->format_attribute( '', 'show_title', $attributes ) == 'yes' ){
		
			switch( $attributes['template'] ){
				case 'pws':
						$html .= '<h4>';
								
								if( !empty($postLink) ){
									$html .= '<a href="'.$postLink.'" title="'.$item->post_title.'">'.$item->post_title.'</a>';
								}else{
									$html .= $item->post_title;
								}
						$html .= '</h4>';
					break;
					
				default:
						$html .= '<h3 class="post-title">';
								if( !empty($postLink) ){
									$html .= '<a href="'.$postLink.'" title="'.$item->post_title.'">'.$item->post_title.'</a>';
								}else{
									$html .= $item->post_title;
								}
						$html .= '</h3>';
					break;
					
			}
		}
		
		return $html;
	}
	
	public function renderImageTitle( $item, $attributes, $postLink ){
		$html = '';
		
		switch( $attributes['template'] ){
			default:
					$html .= '<div class="title">';
								$html .= '<h3>'.$item->post_title.'</h3>';
					$html .= '</div>';
				break;
				
		}
		
		return $html;
	}
	
	public function renderImageText( $item, $attributes, $postLink ){
	
		$html = '';
		
		if( $this->format_attribute( '', 'show_excerpt', $attributes ) == 'yes' ){
		
			switch( $attributes['template'] ){
				default:
						$html .= '<div class="text">';
							$html .= '<p>';
							
							if( !empty( $item->post_excerpt ) ){
								$postContent = $item->post_excerpt;
							}else{
								$postContent = $item->post_content;
							}
							
							if( $param_value =  $this->format_attribute( '', 'excerpt_words', $attributes ) ){
								if( intval( $param_value ) > 0 ){
									$postContent = $this->excerptLength( $postContent, $param_value );
								}
							}
							
							$html .= strip_tags($postContent);
							$html .= '</p>';
						$html .= '</div>';
					break;
			}
		}
		
		return $html;
	}
	
	public function renderPostMeta( $item, $attributes, $postLink ){
		
		$html = '';
		
		if( $this->format_attribute( '', 'show_meta', $attributes ) == 'yes' ){
			
			$html .= '<div class="post-meta">';
			
			$catArray = wp_get_post_terms( $item->ID, 'otw_cm_portfolio_category' );
			
			if( is_array( $catArray ) && count( $catArray ) ){
				
				$html .= '<div class="categories">'.$this->get_label( 'Categories' ).': ';
				
				foreach( $catArray as $index => $cat ){
					
					$category = get_term( $cat, 'otw_cm_portfolio_category' );
					
					$catUrl = get_term_link( $category->term_id, 'otw_cm_portfolio_category' );
					
					$html .= '<a href="'.esc_url($catUrl).'" title="'.$this->get_label( 'View all posts in ' ).$category->name.'">'.$category->name.'</a>';
					
					if( $index < count( $catArray ) - 1 ){
						$html .= ', ';
					}
				}
				
				$html .= '</div>';
			}
			
			$html .= '</div>';
		}
		
		return $html;
	}
	
	public function renderPostContent( $item, $attributes, $postLink ){
		
		$html = '';
		
		if( $this->format_attribute( '', 'show_excerpt', $attributes ) == 'yes' ){
		
			switch( $attributes['template'] ){
				case 'pws':
						$html .= '<p>';
						
						if( !empty( $item->post_excerpt ) ){
							$postContent = $item->post_excerpt;
						}else{
							$postContent = $item->post_content;
						}
						
						if( $param_value =  $this->format_attribute( '', 'excerpt_words', $attributes ) ){
							if( intval( $param_value ) > 0 ){
								$postContent = $this->excerptLength( $postContent, $param_value );
							}
						}
						
						$html .= strip_tags($postContent);
						$html .= '</p>';
					break;
				default:
						$html .= '<div class="text">';
							$html .= '<p>';
							
							if( !empty( $item->post_excerpt ) ){
								$postContent = $item->post_excerpt;
							}else{
								$postContent = $item->post_content;
							}
							
							if( $param_value =  $this->format_attribute( '', 'excerpt_words', $attributes ) ){
								if( intval( $param_value ) > 0 ){
									$postContent = $this->excerptLength( $postContent, $param_value );
								}
							}
							
							$html .= strip_tags($postContent);
							$html .= '</p>';
						$html .= '</div>';
					break;
			}
		}
		
		return $html;
	}
	
	public function renderPostReadMore( $item, $attributes, $postLink ){
		
		$html = '';
		
		if( $this->format_attribute( '', 'show_read_more', $attributes ) == 'yes' ){
			$html .= '<div class="post-more">';
			
			if( !empty($postLink) ){
				$html .=	'<span class="read-more">';
				$html .=		'<a href="'.$postLink.'" title="'.$this->get_label( 'Read more' ).'">'.$this->get_label( 'Read more' ).'</a>';
				$html .=	'</span>';
			}
			
			$html .= '</div>';
		}
		
		return $html;
	}
	
	public function renderPostImage( $item, $attributes, $postLink ){
		
		$html = '';
		
		if( $this->format_attribute( '', 'show_image', $attributes ) == 'yes' ){
			
			$imagePath = false;
			
			if( $thumb = get_post_thumbnail_id( $item->ID ) ){
				
				$postAsset = parse_url( wp_get_attachment_url( get_post_thumbnail_id( $item->ID ) ) );
				
				if( is_array( $postAsset ) && isset( $postAsset['path'] ) && strlen( $postAsset['path'] ) ){
					
					$imagePath = $postAsset['path'];
				}
			}else{
				$otw_portfolio_meta_data = get_post_meta( $item->ID, 'otw_cm_portfolio_meta_data', true );
				
				$otw_portfolio_slider_images = array();
				
				if( isset( $otw_portfolio_meta_data['slider_url'] ) && strlen( trim( $otw_portfolio_meta_data['slider_url'] ) ) ){
					$otw_portfolio_slider_images = explode( ',', $otw_portfolio_meta_data['slider_url'] );
				}
				
				if( count( $otw_portfolio_slider_images ) ){
					$image_data = parse_url( $otw_portfolio_slider_images[0] );
					
					if( isset( $image_data['path'] ) ){
						$imagePath = $image_data['path'];
					}
				}
			}
			
			if( $imagePath ){
					
				$resized_image = '';
				
				switch( $attributes['template'] ){
					
					case 'p1c':
							$resized_image = $this->resize_media( 'img', $imagePath, 647, 350, 'center_center' );
						break;
					case 'p2c':
							$resized_image = $this->resize_media( 'img', $imagePath, 480, 215, 'center_center' );
						break;
					case 'p3c':
							$resized_image = $this->resize_media( 'img', $imagePath, 313, 210, 'center_center' );
						break;
					case 'p4c':
							$resized_image = $this->resize_media( 'img', $imagePath, 230, 152, 'center_center' );
						break;
					case 'pa':
							$resized_image = $this->resize_media( 'img', $imagePath, 220, 170, 'center_center' );
						break;
					case 'pws':
							$resized_image = $this->resize_media( 'img', $imagePath, 60, 60, 'center_center' );
						break;
				}
				
				if( $resized_image && strlen( $resized_image ) ){
					
					switch( $attributes['template'] ){
						case 'pws':
								$html .= '<a class="image" href="'.$postLink.'" title="">';
								$html .=	'<img src="'.$resized_image.'" alt="">';
								$html .=	'<span class="shadow-overlay hide-for-small"> </span>';
								$html .= '</a>';
							break;
						case 'pa':
								$html .= '<a class="animate-on-hover" href="'.$postLink.'" title="">';
								$html .= 	'<div class="image">';
								$html .=		'<img src="'.$resized_image.'" alt="">';
								$html .=		'<span class="shadow-overlay hide-for-small"></span>';
								$html .= 	'</div>';
								$html .= '</a>';
							break;
						default:
								$html .= '<div class="image">';
								$html .=	'<img src="'.$resized_image.'" alt="">';
								$html .= '</div>';
							break;
					}
				}
			}
		}
		return $html;
	}
	
	public function _get_otw_cm_portfolio_category_options(){
		
		$args = array();
		$args['hide_empty']      = 0;
		$args['number']          = 0;
		
		if( isset( $_GET['otw_options_ids'] ) && strlen( $_GET['otw_options_ids'] ) && preg_match( "/^([0-9]+,)*[0-9]+\$|^\$/i", $_GET['otw_options_ids'] ) ){
			$args['include'] = explode( ',', $_GET['otw_options_ids'] );
		}
		if( isset( $_GET['otw_search_term'] ) && strlen( $_GET['otw_search_term'] ) ){
			$args['search'] = urldecode( $_GET['otw_search_term'] );
		}
		if( isset( $_GET['otw_options_limit'] ) && strlen( $_GET['otw_options_limit'] ) && preg_match( "/^([0-9]+)$/i", $_GET['otw_options_limit'] ) ){
			$args['number'] = $_GET['otw_options_limit'];
		}
		$all_items = get_terms( 'otw_cm_portfolio_category', $args );
		
		$options  = array();
		$options['results'] = array();
		
		if( is_array( $all_items ) && count( $all_items ) ){
			foreach( $all_items as $item ){
				$o_key = count( $options['results'] );
				$options['results'][ $o_key ] = array();
				$options['results'][ $o_key ]['id'] = $item->term_id;
				$options['results'][ $o_key ]['text'] = $item->name;
			}
		}
		echo json_encode( $options );
		die;
	}

}
?>
