<?php

session_start();

/**
 * General Workflow for Otw_Shortcode_Progressbar
 *
 * @author Станимир | OTW Design
 * @ver 1.0
 */
class Otw_Shortcode_Login extends OTW_Shortcodes {

    private $_error = array();

    function __construct() {
        parent::__construct();
        $this->has_custom_options = true;
        //   add_action('after_setup_theme', array($this, '_otwLogin'));
        add_action('wp_login_failed', array($this, '_login_failed'));
        add_action('authenticate', array($this, '_blank_login'));
        if (isset($_POST['otw-login-submit'])) {
            $this->_otwLogin($_POST['user'], $_POST['pass'], $_POST['remember']);
        }
    }

    /**
     * Register externel lybs 
     */
    function register_external_libs() {
        $this->add_external_lib('css', 'otw-shortcode-general_foundicons', $this->component_url . 'css/general_foundicons.css', 'all', 10);
        $this->add_external_lib('css', 'otw-shortcode-social_foundicons', $this->component_url . 'css/social_foundicons.css', 'all', 20);
        $this->add_external_lib('css', 'otw-shortcode', $this->component_url . 'css/otw_shortcode.css', 'all', 30);
        $this->add_external_lib('css', 'otw-grid', $this->component_url . '../' . 'otw_grid_manager/' . 'css/otw-grid.css', 'all', 100);
        return $this;
    }

    /**
     * Applay all settings to shortcode
     */
    public function apply_settings() {
        $this->_applyBoxBackgroundPattern();
        $this->_applyBoxBackgrounds();
        $this->_applyBoxBorderColors();
        $this->_applyBoxBorderStyle();
        $this->_applyBoxBorderType();
        $this->_applyBoxBorderWidth();
        $this->_applyBoxRoundedCourners();
        $this->_applyBoxShadow();
        $this->_applyBoxType();
        $this->_applyLabelColors();
        $this->_applyCheckBoxColors();
        $this->_applyCheckFloat();
        $this->_applySubmitFloat();
        $this->_applyButtonBackgrounds();
    }

    function _applyLabelColors() {
        $this->settings['label_colors'] = $this->getPatterns();
        $this->settings['default_label_colors'] = '';
        return $this;
    }

    function _applyCheckBoxColors() {
        $this->settings['check_colors'] = $this->getPatterns();
        $this->settings['default_check_colors'] = '';
        return $this;
    }

    function _applyCheckFloat() {
        $this->settings['check_float'] = $this->getFloats();
        $this->settings['default_check_float'] = '';
        return $this;
    }

    function _applySubmitFloat() {
        $this->settings['submit_float'] = $this->getFloats();
        $this->settings['default_submit_float'] = '';
        return $this;
    }

    /**
     * 
     * @param type $attributes
     * @return string
     */
    public function build_shortcode_code($attributes) {
        $code = '';

        if (!$this->has_error) {
            $code .= '[otw_shortcode_login';
            $code .= $this->format_attribute('label_color', 'label_color', $attributes);
            $code .= $this->format_attribute('check_colors', 'check_colors', $attributes);
            $code .= $this->format_attribute('check_float', 'check_float', $attributes);
            $code .= $this->format_attribute('submit_float', 'submit_float', $attributes);
            $code .= $this->format_attribute('content_button_background', 'content_button_background', $attributes);
            $code .= $this->format_attribute('box_brd_style', 'box_brd_style', $attributes);
            $code .= $this->format_attribute('box_brd_type', 'box_brd_type', $attributes);
            $code .= $this->format_attribute('box_brd_color', 'box_brd_color', $attributes);
            $code .= $this->format_attribute('box_shadow', 'box_shadow', $attributes);
            $code .= $this->format_attribute('box_rounded_corners', 'box_rounded_corners', $attributes);
            $code .= $this->format_attribute('box_bgr', 'box_bgr', $attributes);
            $code .= $this->format_attribute('box_bgr_pattern', 'box_bgr_pattern', $attributes);

            $code .= ']';
            $code .= '[/otw_shortcode_login]';
        }


        return $code;
    }

    /**
     * Set the additional settings
     * @return string
     */
    public function build_shortcode_editor_custom_options() {
        $html = '';

        $source = array();
        if (isset($_POST['shortcode_object'])) {
            $source = $_POST['shortcode_object'];
        }

        $html .= $this->_generatePicker('box_custom_border_color', 'Border Color Custom', 'Choose a custom box border color.', $source);
        $html .= $this->_generatePicker('box_custom_bgr_color', 'Background Color Custom', 'Choose a custom box background color.', $source);
        $html .= $this->_generateUploader('box_custom_bgr_pattern', 'Background Pattern URL', 'URL to a custom box background pattern. ', $source);
        $html .= $this->_generateText('custom_class', 'CSS Class', 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..', $source);

        return $html;
    }

    /**
     * Generate options as HTML string 
     * @return string
     */
    public function build_shortcode_editor_options() {
        $html = '';

        $source = array();
        if (isset($_POST['shortcode_object'])) {
            $source = $_POST['shortcode_object'];
        }

        $html .= $this->_generateSelect('box_brd_style', 'Box Border Style', 'Choose box border style.', $source, 'box_brd_style', 'default_box_brd_style');
        $html .= $this->_generateSelect('box_brd_type', 'Box Border Type', 'Choose box border type.', $source, 'box_brd_type', 'default_box_brd_type');
        $html .= $this->_generateSelect('box_brd_color', 'Box Border Color', 'Choose box border color.', $source, 'box_brd_color', 'default_box_brd_color');
        $html .= $this->_generateSelect('box_shadow', 'Box Shadow', 'Choose box shadow.', $source, 'box_shadow', 'default_box_shadow');
        $html .= $this->_generateSelect('box_rounded_corners', 'Box Rounded Corners', 'Choose box rounded corners.', $source, 'box_rounded_corners', 'default_box_rounded_corners');
        $html .= $this->_generateSelect('box_bgr', 'Box Background Color', 'Choose box background color.', $source, 'box_bgr', 'default_box_bgr');
        $html .= $this->_generateSelect('box_bgr_pattern', 'Box Background Pattern', 'Choose box background pattern.', $source, 'box_bgr_pattern', 'default_box_bgr_pattern');
        return $html;
    }

    /**
     * Export end shortcode
     * @param array $attributes
     * @param string $content
     * @return string
     */
    public function display_shortcode($attributes, $content) {
        $html = $this->_otwBuild($attributes, $content);
        return $this->format_shortcode_output($html);
    }

    private function _otwLogin($username, $password, $remember = false) {
        global $user;
        $data = array();
        $data['user_login'] = $username;
        $data['user_password'] = $password;
        $data['remember'] = $remember;
        $user = wp_signon($data, false);
        if (is_wp_error($user)) {
           return false;
        }
        if (!is_wp_error($user)) {
            header('Location: ' . home_url('wp-admin'));
        }
    }

    function _otwBuild($attributes, $content) {
        return $this->_generateForm($attributes, $content);
    }

    function _generateForm($attributes, $content) {
        $html = '';
        if (!empty($_GET['login']) && $_GET['login'] == 'failed') {
            $html .= '<div class="otw-row">';
            $html .= otw_form::message('error', $this->get_label('Error!'), $this->get_label('Wrong username or password'));
            $html .= '</div>';
        }
        $html .= '';
        $master_class = 'otw-b-login otw-b-login-padding';
        if (strlen($this->format_attribute('', 'box_brd_style', $attributes)) > 0 && strlen($this->format_attribute('', 'box_brd_type', $attributes)) > 0) {
            $master_class = $this->append_attribute($master_class, $this->format_attribute('', 'box_brd_style', $attributes));
            $master_class = $this->append_attribute($master_class, $this->format_attribute('', 'box_brd_type', $attributes));
        }
        $master_class = $this->append_attribute($master_class, $this->format_attribute('', 'box_brd_color', $attributes));
        $master_class = $this->append_attribute($master_class, $this->format_attribute('', 'box_shadow', $attributes));
        $master_class = $this->append_attribute($master_class, $this->format_attribute('', 'box_rounded_corners', $attributes));
        $master_class = $this->append_attribute($master_class, $this->format_attribute('', 'box_bgr', $attributes));
        $master_class = $this->append_attribute($master_class, $this->format_attribute('', 'box_bgr_pattern', $attributes));

        $html .= '<div class="' . $master_class . '">';
        $html .= '<form action="' . home_url('wp-login.php?') . '" method="POST">';

        $forms_class = $this->append_attribute($forms_class, 'otw-b-form-group');
        $forms_class = $this->append_attribute($forms_class, $this->format_attribute('', 'label_color', $attributes));


        $html .= '<div class="' . $forms_class . '">';
        $html .= '<label for="user">Username</label>';
        $html .= '<input type="text" name="user" id="user">';
        $html .= '</div>';

        $html .= '<div class="' . $forms_class . 't">';
        $html .= '<label for="pass">Password</label>';
        $html .= '<input type="password" name="pass" id="pass">';
        $html .= '</div>';

        $html .= '<div class="otw-b-submit-group otw-b-clearfix">';
        $checkBoxClass = 'otw-b-checkbox-line';
        $checkBoxClass = $this->append_attribute($checkBoxClass, $this->format_attribute('', 'check_colors', $attributes));
        $checkBoxClass = $this->append_attribute($checkBoxClass, $this->format_attribute('', 'check_float', $attributes));

        $html .= '<label class="' . $checkBoxClass . '">';
        $html .= '<input type="checkbox" name="remember" value="1"> Remember Me</label>';
        $submitClass = 'button otw-button round';
        $submitClass = $this->append_attribute($submitClass, $this->format_attribute('', 'submit_float', $attributes));
        if (strlen($this->format_attribute('', 'content_button_background', $attributes)) > 0) {
            $submitClass = $this->append_attribute($submitClass, $this->format_attribute('', 'content_button_background', $attributes));
        } else {
            $submitClass = $this->append_attribute($submitClass, ' silver-background');
        }
        $html .= '<button class="' . $submitClass . '" name="otw-login-submit" type="submit">Log In</button>';
        $html .= '</div>';

        /// $html .= '<a href="#" class="otw-b-lostpass otw-b-white-text">Lost your password?</a>';
        $html .= '</form>';
        $html .= '</div>';
        return $html;
    }

    /**
     * Change native redirect
     * @param \WP_User $user
     */
    function _login_failed($user) {
        $referrer = $_SERVER['HTTP_REFERER'];
        if (!empty($referrer) && !strstr($referrer, 'wp-login') && !strstr($referrer, 'wp-admin') && $user != null) {
            if (!strstr($referrer, '?login=failed')) {
                if (strpos($referrer, '?') != 0) {
                    wp_redirect($referrer . '&login=failed');
                } else {
                    wp_redirect($referrer . '?login=failed');
                }
            } else {
                wp_redirect($referrer);
            }
            exit;
        }
    }

    /**
     * Change blank logins
     * @param \WP_User $user
     */
    function _blank_login($user) {
        $referrer = $_SERVER['HTTP_REFERER'];
        $error = false;

        if ($_POST['user'] == '' || $_POST['pass'] == '') {
            $error = true;
        }
        // check that were not on the default login page
        if (!empty($referrer) && !strstr($referrer, 'wp-login') && !strstr($referrer, 'wp-admin') && $error) {
            // make sure we don't already have a failed login attempt
            if (!strstr($referrer, '?login=failed')) {
                // Redirect to the login page and append a querystring of login failed
                if (strpos($referrer, '?') != 0) {
                    wp_redirect($referrer . '&login=failed');
                } else {
                    wp_redirect($referrer . '?login=failed');
                }
            } else {
                wp_redirect($referrer);
            }

            exit;
        }
    }

}
