<?php

/**
 * General Workflow for otw_shortcode_Info_List
 *
 * @author Станимир | OTW Design
 * @ver 1.0
 */
class Otw_Shortcode_Info_List extends OTW_Shortcodes {

    function __construct() {
        parent::__construct();
        $this->has_custom_options = true;
    }

    /**
     * register external libs
     */
    public function register_external_libs() {

        $this->add_external_lib('css', 'otw-shortcode-general_foundicons', $this->component_url . 'css/general_foundicons.css', 'all', 10);
        $this->add_external_lib('css', 'otw-shortcode-social_foundicons', $this->component_url . 'css/social_foundicons.css', 'all', 20);
        $this->add_external_lib('css', 'otw-grid', $this->component_url . '../' . 'otw_grid_manager/' . 'css/otw-grid.css', 'all', 100);
        $this->add_external_lib('css', 'otw-shortcode', $this->component_url . 'css/otw_shortcode.css', 'all', 120);
        $this->add_external_lib('css', 'otw-shortcode_scrolling', $this->component_url . 'css/scroll_for_preview.css?' . md5(time()), 'all', 130);
    }

    /**
     * Applay all settings to shortcode
     * @return \Otw_Shortcode_Info_List
     */
    public function apply_settings() {
        $this->_applyBoxAnimations();
        $this->_applyBoxBackgroundPattern();
        $this->_applyBoxBackgrounds();
        $this->_applyBoxBorderColors();
        $this->_applyBoxBorderStyle();
        $this->_applyBoxBorderType();
        $this->_applyBoxBorderWidth();
        $this->_applyBoxRoundedCourners();
        $this->_applyBoxShadow();
        $this->_applyBoxType();
        $this->_applyButtonBackgrounds();
        $this->_applyCallActions();
        $this->_applyContentLinkColor();
        $this->_applyIconAnimations();
        $this->_applyIconBackgroundColors();
        $this->_applyIconBorderStyle();
        $this->_applyIconBorderWidth();
        $this->_applyIconColorBorders();
        $this->_applyIconColors();
        $this->_applyIconSizes();
        $this->_applyIconTypes();
        $this->_applyIconBoxRounds();

        $this->_applyNumItems();
        $this->_applyAnimationItem();
        $this->_applyHasIcon();
        $this->_applyIconPossition();
        $this->_applyConnector();
        $this->_applyContentColor();
        $this->_applyIconScale();
        return $this;
    }

    /**
     * Apply the settings for num items 
     */
    private function _applyNumItems() {
        $this->settings['num_items'] = $this->_getNumItems();
        $this->settings['default_num_items'] = 2;
    }

    /**
     * Set the annimation item
     */
    private function _applyAnimationItem() {
        $this->settings['box_animations_item'] = $this->getAnimationItems();
        $this->settings['default_box_animations_item'] = '';
    }

    /**
     * Will have icon or not
     */
    private function _applyHasIcon() {
        $this->settings['icon_has'] = $this->_getHasIcon();
        $this->settings['default_icon_has'] = '0';
    }

    /**
     * Apply the settigs for icon possition
     */
    private function _applyIconPossition() {
        $this->settings['icon_possition'] = $this->_getIconPossitions();
        $this->settings['default_icon_possition'] = 'otw-b-info-list-left';
    }

    /**
     * Apply the settings for icon connector btw items
     */
    private function _applyConnector() {
        $this->settings['display_connector'] = $this->_getConnector();
        $this->settings['default_display_connector'] = '0';
    }

    /**
     * Set the settings for content color
     */
    private function _applyContentColor() {
        $this->settings['content_color'] = $this->getColors();
        $this->settings['default_content_color'] = '';
    }

    private function _applyIconScale() {
        $this->settings['icon_scale'] = $this->getGeneralScales();
        $this->settings['default_icon_scale'] = '';
    }

    /**
     * Return settings for connector settings
     * @return void
     */
    private function _getConnector() {
        return array(
            '0' => $this->get_label("No (Default)"),
            '1' => $this->get_label("Yes")
        );
    }

    /**
     * Return settings for having icon
     * @return void
     */
    private function _getHasIcon() {
        return array(
            '0' => $this->get_label('No (Default)'),
            '1' => $this->get_label('Yes '),
        );
    }

    /**
     * Settings for num items 
     * @return void
     */
    private function _getNumItems() {
        return array(
            '1' => $this->get_label('1 Items'),
            '2' => $this->get_label('2 Items(default)'),
            '3' => $this->get_label('3 Items'),
            '4' => $this->get_label('4 Items'),
            '5' => $this->get_label('5 Items'),
            '6' => $this->get_label('6 Items'),
            '7' => $this->get_label('7 Items'),
            '8' => $this->get_label('8 Items'),
            '9' => $this->get_label('9 Items'),
            '10' => $this->get_label('10 Items')
        );
    }

    /**
     * Return all items with access to animation procces 
     * @return void;
     */
    private function getAnimationItems() {
        return array(
            '' => $this->get_label('None'),
            'text' => $this->get_label('Whole text'),
            'title' => $this->get_label('The title'),
            'icon' => $this->get_label('The icon'),
            'box' => $this->get_label('The box'),
        );
    }

    /**
     * Set the icon possitions and return as array
     * @return void;
     */
    private function _getIconPossitions() {
        return array(
            'otw-b-info-list-left' => $this->get_label('Left (Default)'),
            'otw-b-info-list-right' => $this->get_label('Right')
        );
    }

    /**
     * 
     * @param type $attributes
     * @return string
     */
    public function build_shortcode_code($attributes) {
        $code = '';
        if (!$this->has_error) {
            $code = '[otw_shortcode_info_list';
            $total_elements = $this->format_attribute('', 'num_items', $attributes);
            $code .= $this->format_attribute('num_items', 'num_items', $attributes);
            for ($ni = 1; $ni <= $total_elements; $ni++) {
                $code .= $this->format_attribute('item_' . $ni . '_icon_has', 'item_' . $ni . '_icon_has', $attributes);
                $has_icon = $this->format_attribute('', 'item_' . $ni . '_icon_has', $attributes);
                if (!empty($has_icon) && $has_icon == '1') {
                    $code .= $this->format_attribute('item_' . $ni . '_icon_types', 'item_' . $ni . '_icon_types', $attributes);
                    $type = $this->format_attribute('', 'item_' . $ni . '_icon_types', $attributes);
                    if (!empty($type) && $type == 'custom') {
                        $code .= $this->format_attribute('item_' . $ni . '_icon_custom_content', 'item_' . $ni . '_icon_custom_content', $attributes);
                    }
//                    $code .= $this->format_attribute('item_' . $ni . '_icon_colors', 'item_' . $ni . '_icon_colors', $attributes);
                    $code .= $this->format_attribute('item_' . $ni . '_icon_bgr_colors', 'item_' . $ni . '_icon_bgr_colors', $attributes);
                    $code .= $this->format_attribute('item_' . $ni . '_icon_brd_width', 'item_' . $ni . '_icon_brd_width', $attributes);
                    $code .= $this->format_attribute('item_' . $ni . '_icon_brd_style', 'item_' . $ni . '_icon_brd_style', $attributes);
                    $code .= $this->format_attribute('item_' . $ni . '_icon_brd_color', 'item_' . $ni . '_icon_brd_color', $attributes);
                    $code .= $this->format_attribute('item_' . $ni . '_icon_brd_round', 'item_' . $ni . '_icon_brd_round', $attributes);
                }
                $code .= $this->format_attribute('item_' . $ni . '_title', 'item_' . $ni . '_title', $attributes);
                $code .= $this->format_attribute('item_' . $ni . '_title_color', 'item_' . $ni . '_title_color', $attributes);
                $code .= $this->format_attribute('item_' . $ni . '_content', 'item_' . $ni . '_content', $attributes, false, '', true);
                $code .= $this->format_attribute('item_' . $ni . '_content_color', 'item_' . $ni . '_content_color', $attributes);
                $code .= $this->format_attribute('item_' . $ni . '_call_action', 'item_' . $ni . '_call_action', $attributes);
                $code .= $this->format_attribute('item_' . $ni . '_action_text', 'item_' . $ni . '_action_text', $attributes);
                $code .= $this->format_attribute('item_' . $ni . '_href', 'item_' . $ni . '_href', $attributes);
                $code .= $this->format_attribute('item_' . $ni . '_content_link_color', 'item_' . $ni . '_content_link_color', $attributes);
                $code .= $this->format_attribute('item_' . $ni . '_content_button_background', 'item_' . $ni . '_content_button_background', $attributes);
                $code .= $this->format_attribute('item_' . $ni . '_custom_icon_url', 'item_' . $ni . '_custom_icon_url', $attributes);

                $code .= $this->format_attribute('item_' . $ni . '_custom_icon_scale', 'item_' . $ni . '_custom_icon_scale', $attributes);
            }
            $code .= $this->format_attribute('item_custom_pattern_url', 'item_custom_pattern_url', $attributes);
            $code .= $this->format_attribute('item_custom_brd_color', 'item_custom_brd_color', $attributes);
            $code .= $this->format_attribute('item_custom_bgr_color', 'item_custom_bgr_color', $attributes);
            $code .= $this->format_attribute('item_display_connector', 'item_display_connector', $attributes);
            $code .= $this->format_attribute('item_icon_possition', 'item_icon_possition', $attributes);
            $code .= $this->format_attribute('item_icon_sizes', 'item_icon_sizes', $attributes);
            $code .= $this->format_attribute('item_box_animations_item', 'item_box_animations_item', $attributes);
            $ani_item = $this->format_attribute('', 'item_box_animations_item', $attributes);
            if (!empty($ani_item)) {
                $code .= $this->format_attribute('item_box_animations', 'item_box_animations', $attributes);
            }
            $code .= $this->format_attribute('item_box_brd_width', 'item_box_brd_width', $attributes);
            $code .= $this->format_attribute('item_box_brd_style', 'item_box_brd_style', $attributes);
            $code .= $this->format_attribute('item_box_brd_color', 'item_box_brd_color', $attributes);
            $code .= $this->format_attribute('item_box_rounded_corners', 'item_box_rounded_corners', $attributes);
            $code .= $this->format_attribute('item_box_shadow', 'item_box_shadow', $attributes);
            $code .= $this->format_attribute('item_box_bgr', 'item_box_bgr', $attributes);
            $code .= $this->format_attribute('item_box_bgr_pattern', 'item_box_bgr_pattern', $attributes);
            $code .= $this->format_attribute('custom_class', 'custom_class', $attributes);
            $code .= ']';
            
            $code .= '[/otw_shortcode_info_list]';
            return $code;
        }
    }

    /**
     * Set the additional settings
     * @return string
     */
    public function build_shortcode_editor_custom_options() {
        $html = '';

        $source = array();
        if (isset($_POST['shortcode_object'])) {
            $source = $_POST['shortcode_object'];
        }
        //Get default value for items in init time
        $total_elements = $this->settings['default_num_items'];
        //check for set items
        if (isset($source['otw-shortcode-element-num_items'])) {
            $total_elements = $source['otw-shortcode-element-num_items'];
        }
        /* @var $ni int Iterate the lists */
        for ($ni = 1; $ni <= $total_elements; $ni++) {
            $html .= '<div class="otw-form-control" >'
                    . '<h4>Item ' . $ni . ' Custom Options'
                    . '<div class="otw_separator"> </div></div>';
            $html .= parent::_generateUploader('item_' . $ni . '_custom_icon_url', 'Item ' . $ni . ' - Icon URL', 'URL to a custom icon. (Recommended size: 128x128px)', $source);
            $html .= parent::_generateSelect('item_' . $ni . '_custom_icon_scale', 'Item ' . $ni . ' - Icon Scale', 'If you want to resize your custom icon', $source, 'icon_scale', 'default_icon_scale', true);
        }
        $html .= '<div class="otw-form-control" >'
                . '<h4>Gobal Custom Options</h4>'
                . '<div class="otw_separator"> </div>'
                . '</div>';
        $html .= parent::_generatePicker('item_custom_brd_color', 'Custom Border Color', 'Choose your favorite color for border on this item', $source);
        $html .= parent::_generatePicker('item_custom_bgr_color', 'Custom Background Color', 'Choose your color for background on this item', $source);
        $html .= parent::_generateUploader('item_custom_pattern_url', 'Box Background Pattern URL', 'URL to a custom box background pattern.', $source);
        $html .= $this->_generateText('custom_class', 'Custom CSS Class ', 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..', $source);


        return $html;
    }

    /**
     * Generate options as HTML string 
     * @return string
     */
    public function build_shortcode_editor_options() {
        $html = '';
        $source = array();
        if (isset($_POST['shortcode_object'])) {
            $source = $_POST['shortcode_object'];
        }
        $html .= parent::_generateSelect('num_items', 'Number of items', ' Choose the number of items in your list.', $source, 'num_items', 'default_num_items', 1);
        $html .= parent::_generateSelect('item_box_animations_item', 'Box Animation for Item', 'Choose the item for animation', $source, 'box_animations_item', 'default_box_animations_item', 1);
        if (!empty($source['otw-shortcode-element-item_box_animations_item'])) {
            $html .= parent::_generateSelect('item_box_animations', 'Box Animation effect', 'Choose Box Animation effect.', $source, 'box_animations', 'default_box_animations');
        }
        $html .= parent::_generateSelect('item_box_brd_width', 'Box Border Width', 'Choose The Item Border Width.', $source, 'box_brd_width', 'default_box_brd_width');
        $html .= parent::_generateSelect('item_box_brd_style', 'Box Border Style', 'Choose The Item Border Style.', $source, 'box_brd_style', 'default_box_brd_style');
        $html .= parent::_generateSelect('item_box_brd_color', 'Box Border Color', 'Choose Box Border Color.', $source, 'box_brd_color', 'default_box_brd_color');
        $html .= parent::_generateSelect('item_box_rounded_corners', 'Box Rounded Corners', 'Choose Box Rounded Corners.', $source, 'box_rounded_corners', 'default_box_rounded_corners');
        $html .= parent::_generateSelect('item_box_shadow', 'Shadow', 'Choose Box Shadow.', $source, 'box_shadow', 'default_box_shadow');
        $html .= parent::_generateSelect('item_box_bgr', 'Background Color', 'Choose Box Background Color.', $source, 'box_bgr', 'default_box_bgr');
        $html .= parent::_generateSelect('item_box_bgr_pattern', 'Background Pattern', 'Choose Box Background Pattern.', $source, 'box_bgr_pattern', 'default_box_bgr_pattern');
        //Get default value for items in init time
        $total_elements = $this->settings['default_num_items'];
        //check for set items
        if (isset($source['otw-shortcode-element-num_items'])) {
            $total_elements = $source['otw-shortcode-element-num_items'];
        }
        $html .= parent::_generateSelect('item_display_connector', 'Display Connector', 'Display Connector for each items', $source, 'display_connector', 'default_display_connector');
        $html .= parent::_generateSelect('item_icon_possition', 'Icon Position', 'Choose the position of the icon.', $source, 'icon_possition', 'default_icon_possition');
        $html .= parent::_generateSelect('item_icon_sizes', 'Icon Size', 'Choose correct for you icon size.', $source, 'icon_sizes', 'default_icon_has', true);

        /* @var $ni int Iterate the lists */
        for ($ni = 1; $ni <= $total_elements; $ni++) {
            $html .= '<div class="otw-form-control" >'
                    . '<h4>Item ' . $ni . ' Options '
                    . '<div class="otw_separator"> </div>'
                    . '</div>';
            //icon setting
            $html .= parent::_generateSelect('item_' . $ni . '_icon_has', 'Item ' . $ni . ' - Enable Icon', 'If you want icon object into list item', $source, 'icon_has', 'default_icon_has', true);
            if (!empty($source['otw-shortcode-element-item_' . $ni . '_icon_has']) && (bool) $source['otw-shortcode-element-item_' . $ni . '_icon_has']) {
                $html .= parent::_generateSelect('item_' . $ni . '_icon_types', 'Item ' . $ni . ' - Icon Type', 'The icons here are based on foundation icon fonts.', $source, 'icon_types', 'default_icon_types', true);
                if (!empty($source['otw-shortcode-element-item_' . $ni . '_icon_types']) && $source['otw-shortcode-element-item_' . $ni . '_icon_types'] == 'custom') {
                    $html .= parent::_generateText('item_' . $ni . '_icon_custom_content', 'Item ' . $ni . ' - Custom Icon Text', 'Instead of an icon you can enter some text like: A, B, 1, 2, 3, etc.', $source);
                }
                $html .= parent::_generateSelect('item_' . $ni . '_icon_bgr_colors', 'Item ' . $ni . ' - Icon Box Background Color', 'Choose Icon Box Background Color.', $source, 'icon_bgr_colors', 'default_icon_bgr_colors');
                $html .= parent::_generateSelect('item_' . $ni . '_icon_brd_width', 'Item ' . $ni . ' - Icon Box Border Width', 'Choose Icon Box Border Width.', $source, 'icon_brd_width', 'default_icon_brd_width');
                $html .= parent::_generateSelect('item_' . $ni . '_icon_brd_style', 'Item ' . $ni . ' - Icon Box Border Style', 'Choose Icon Box Border Style.', $source, 'icon_brd_style', 'default_icon_brd_style');
                $html .= parent::_generateSelect('item_' . $ni . '_icon_brd_color', 'Item ' . $ni . ' - Icon Box Border Color', 'Choose Icon Box Border Color.', $source, 'icon_brd_color', 'default_icon_brd_color');
                $html .= parent::_generateSelect('item_' . $ni . '_icon_brd_round', 'Item ' . $ni . ' - Icon Box Rounded Corners', 'Choose Icon Box Rounded Corners.', $source, 'icon_brd_round', 'default_icon_brd_round');
            }

            $html .= parent::_generateText('item_' . $ni . '_title', 'Item ' . $ni . ' - Title', 'Title', $source);
            $html .= parent::_generateSelect('item_' . $ni . '_title_color', 'Item ' . $ni . ' - Title color', 'Choose the color fro your title.', $source, 'content_color', 'default_content_color');
            $html .= parent::_generateTextArea('item_' . $ni . '_content', 'Item ' . $ni . ' - Content', 'Set up your content', $source);
            $html .= parent::_generateSelect('item_' . $ni . '_content_color', 'Item ' . $ni . ' - Content color', 'Choose the color fro your content.', $source, 'content_color', 'default_content_color');
            $html .= parent::_generateSelect('item_' . $ni . '_call_action', 'Item ' . $ni . ' - Call to Action Type', 'Choose the type of the call to action.', $source, 'call_action', 'default_call_action');
            $html .= parent::_generateText('item_' . $ni . '_action_text', 'Item ' . $ni . ' - Call to Action Text', 'This is the text in the button or the text link..', $source);
            $html .= parent::_generateText('item_' . $ni . '_href', 'Item ' . $ni . ' - Call to Action Link ', 'The link your call to action leads to.', $source);
            $html .= parent::_generateSelect('item_' . $ni . '_content_link_color', 'Item ' . $ni . ' - Call to Action Text Color ', 'Choose text color.', $source, 'content_link_color', 'default_content_link_color');
            $html .= parent::_generateSelect('item_' . $ni . '_content_button_background', 'Item ' . $ni . ' - Call to Action Button Color', 'Choose button color.', $source, 'content_button_background', 'default_content_button_background');
        }


        return $html;
    }

    public function display_shortcode($attributes, $content) {
	$html = '';
        $total_elements = $this->format_attribute('', 'num_items', $attributes);
        $html .= '<div class="otw-row ' . $this->format_attribute('', 'custom_class', $attributes) . '" style="position: relative;" >';



        for ($ni = 1; $ni <= $total_elements; $ni++) {
            $icon_size = $this->format_attribute('', 'item_icon_sizes', $attributes);

            $animation_item = $this->format_attribute('', 'item_box_animations_item', $attributes);
            $animation_fx = $this->format_attribute('', 'item_box_animations', $attributes);

            $master_dom_class = array();

            $master_dom_class[] = 'otw-b-info-list';
            $master_dom_class[] = 'otw-b-clearfix';
            $master_dom_class[] = $this->format_attribute('', 'item_icon_possition', $attributes);
            $master_dom_class[] = $this->format_attribute('', 'item_box_brd_width', $attributes);
            $master_dom_class[] = $this->format_attribute('', 'item_box_brd_style', $attributes);
            $master_dom_class[] = $this->format_attribute('', 'item_box_brd_color', $attributes);
            $master_dom_class[] = $this->format_attribute('', 'item_box_rounded_corners', $attributes);
            $master_dom_class[] = $this->format_attribute('', 'item_box_shadow', $attributes);
            $master_dom_class[] = $this->format_attribute('', 'item_box_bgr', $attributes);
            $master_dom_class[] = $this->format_attribute('', 'item_box_bgr_pattern', $attributes);

            $container_list_type = str_replace('otw-b-icon-', 'otw-b-info-list-', $icon_size);
            $master_dom_class[] = $container_list_type;
            $master_dom_class[] = 'otw-b-box';

            if (!empty($animation_item) && $animation_item == 'box') {
                $master_dom_class[] = 'animated-b';
                if (!empty($animation_fx)) {
                    $master_dom_class[] = 'animated-b-' . $animation_fx;
                }
            }

            $dom_style = '';
            $bgr_color = $this->format_attribute('', 'item_custom_bgr_color', $attributes);
            if (!empty($bgr_color)) {
                $dom_style = $this->append_attribute($dom_style, 'background-color: ' . $bgr_color . '!important;');
            }
            $bgr_pattern = $this->format_attribute('', 'item_custom_pattern_url', $attributes);
            if (!empty($bgr_pattern)) {
                $dom_style = $this->append_attribute($dom_style, 'background-image: url(' . $bgr_pattern . ')!important; background-repeat: repeat!important;');
            }

            $brd_color = $this->format_attribute('', 'item_custom_brd_color', $attributes);
            if (!empty($brd_color)) {
                $dom_style = $this->append_attribute($dom_style, 'border-color: ' . $brd_color . '!important;');
            }


            $html .= '<div style="' . $dom_style . '" class = "' . implode(' ', $master_dom_class) . '">';



            $has_icon = $this->format_attribute('', 'item_' . $ni . '_icon_has', $attributes);
            if (!empty($has_icon) && (bool) $has_icon) {
                $icon_parent_dom = array();
                $icon_parent_dom[] = 'otw-b-icon';
                // $icon_parent_dom[] = $this->format_attribute('', 'item_icon_sizes', $attributes);

                $html .= '<div class = "' . implode(' ', $icon_parent_dom) . '">';
                $class_for_icon = array();
                $class_for_icon[] = 'otw-b-icon';
                $class_for_icon[] = 'otw-b-scaledown';
                // $class_for_icon[] = 'otw-b-icon-info-list';
                $class_for_icon[] = $icon_size;
                if (!empty($animation_item) && $animation_item == 'icon') {
                    $class_for_icon[] = 'animated-b';
                    if (!empty($animation_fx)) {
                        $class_for_icon[] = 'animated-b-' . $animation_fx;
                    }
                }


                //check for icon background flat color
                $icon_backgorund_images = $this->format_attribute('', 'item_' . $ni . '_icon_bgr_colors', $attributes);
                if (!empty($icon_backgorund_images)) {
                    $class_for_icon[] = $icon_backgorund_images;
                }

                //set the cyrcle class 
                $icon_cyrcle_border = $this->format_attribute('', 'item_' . $ni . '_icon_brd_round', $attributes);
                if (!empty($icon_cyrcle_border)) {
                    $class_for_icon[] = $icon_cyrcle_border;
                }

                //set the border width
                $_icon_brd_width = $this->format_attribute('', 'item_' . $ni . '_icon_brd_width', $attributes);
                if (!empty($_icon_brd_width)) {
                    $class_for_icon[] = $_icon_brd_width;
                }

                //set the border style
                $_icon_brd_style = $this->format_attribute('', 'item_' . $ni . '_icon_brd_style', $attributes);
                if (!empty($_icon_brd_style)) {
                    $class_for_icon[] = $_icon_brd_style;
                }

                //set the border style
                $_icon_brd_color = $this->format_attribute('', 'item_' . $ni . '_icon_brd_color', $attributes);
                if (!empty($_icon_brd_color)) {
                    $class_for_icon[] = $_icon_brd_color;
                }

                $icon_style = '';
                $brd_color = $this->format_attribute('', 'item_custom_brd_color', $attributes);
                if (!empty($brd_color)) {
                    $icon_style = $this->append_attribute($icon_style, 'border-color: ' . $this->format_attribute('', 'item_custom_brd_color', $attributes) . '!important;');
                }
                $class_for_icon[] = $this->format_attribute('', 'item_' . $ni . '_icon_colors', $attributes);
                $html .= '<span style="' . $icon_style . '" class = "' . implode(' ', $class_for_icon) . '">';
                $_icon_types = $this->format_attribute('', 'item_' . $ni . '_icon_types', $attributes);
                //$html .= '<img src = "' . $this->component_url . 'images-shortcodes/icons/flatified/envelope.png" class = "otw-b-scale70" alt = "">';
                $icon_clases = array();
                $custom_icon_image = $this->format_attribute('', 'item_' . $ni . '_custom_icon_url', $attributes);
                if (!empty($custom_icon_image)) {
                    $icon_clases[] = $this->format_attribute('', 'item_' . $ni . '_custom_icon_scale', $attributes);
                    $html .= '<img class="' . implode(' ', $icon_clases) . '" src="' . $custom_icon_image . '" />';
                } else {
                    if (!empty($_icon_types) && $_icon_types != 'custom') {
                        $icon_clases[] = $_icon_types;
                        $html .= '<i class="' . implode(' ', $icon_clases) . '"></i>';
                    } else if (!empty($_icon_types) && $_icon_types == 'custom') {
                        $html .= $this->format_attribute('', 'item_' . $ni . '_icon_custom_content', $attributes);
                    }
                }

                $html .= '</span>';
                $html .= '</div>';
            }
            $content_class = array();
            $content_class[] = 'otw-b-floated-content';
            if ($has_icon) {
                $content_class[] = 'otw-has-has-icon';
            }
            $html .= '<div class = "' . implode(' ', $content_class) . '">';
            $tiem_tile = $this->format_attribute('', 'item_' . $ni . '_title', $attributes);
            if (!empty($tiem_tile)) {
                $h_class = array();
                $h_class[] = $this->format_attribute('', 'item_' . $ni . '_title_color', $attributes);
                if (!empty($animation_item) && trim($animation_item) == 'title') {
                    $h_class[] = 'animated-b';
                    if (!empty($animation_fx)) {
                        $h_class[] = 'animated-b-' . $animation_fx;
                    }
                }
                $html .= '<h3 class="' . implode(' ', $h_class) . '"> ' . $this->format_attribute('', 'item_' . $ni . '_title', $attributes) . '</h3>';
            }
            $p_class = array();
            $p_class[] = $this->format_attribute('', 'item_' . $ni . '_content_color', $attributes);
            if (!empty($animation_item) && trim($animation_item) == 'text') {
                $p_class[] = 'animated-b';
                if (!empty($animation_fx)) {
                    $p_class[] = 'animated-b-' . $animation_fx;
                }
            }
            $html .= '<p class="' . implode(' ', $p_class) . '">' . $this->format_attribute('', 'item_' . $ni . '_content', $attributes) . '</p>';
            $call_to_action_classes = array();
            $call_to_action_type = $this->format_attribute('', 'item_' . $ni . '_call_action', $attributes);

            if ($call_to_action_type != 'none') {
                if (trim($call_to_action_type) == 'otw-button') {
                    $call_to_action_classes[] = $call_to_action_type;
                    $call_to_action_classes[] = $this->format_attribute('', 'item_' . $ni . '_content_button_background', $attributes);
                }
                $call_to_action_classes[] = $this->format_attribute('', 'item_' . $ni . '_content_link_color', $attributes);
                $html .= '<a class="' . implode(' ', $call_to_action_classes) . '" href="' . $this->format_attribute('', 'item_' . $ni . '_href', $attributes) . '">' . $this->format_attribute('', 'item_' . $ni . '_action_text', $attributes) . '</a>';
            }


            $html .= '</div>';
            $has_connector = (boolean) $this->format_attribute('', 'item_display_connector', $attributes);
            if ($has_connector) {

                $pos = $this->format_attribute('', 'item_icon_possition', $attributes);
                if (trim($pos) == 'otw-b-info-list-right') {
                    $devider = '-divider-right';
                } else {
                    $devider = '-divider';
                }

                $html .= '<div class = "otw-b-connector-original ' . $this->format_attribute('', 'item_icon_sizes', $attributes) . $devider . '"></div>';
            }
            $html .= '</div>';
        }
        $html .= '</div>';
        return $this->format_shortcode_output($html);
    }

}
