<?php
class OTW_Shortcode_Image_Style extends OTW_Shortcodes{
	
	public function __construct(){
		
		$this->has_custom_options = true;
		
		parent::__construct();
	}
	
	
	/**
	 * register external libs
	 */
	public function register_external_libs(){
		
		$this->add_external_lib( 'css', 'otw-shortcode', $this->component_url.'css/otw_shortcode.css', 'all', 100 );
	}
	
	/**
	 * apply settings
	 */
	public function apply_settings(){
		
		$this->settings = array(
			
			'image_styles' => array(
				''          => $this->get_label( 'none(default)' ),
				'border'    => $this->get_label( 'border' ),
				'rounded'   => $this->get_label( 'rounded' )
			),
			'default_image_style' => '',
			
			'image_alignment' => array(
				'alignleft'          => $this->get_label( 'left(default)' ),
				'aligncenter'    => $this->get_label( 'center' ),
				'alignright'    => $this->get_label( 'right' ),
				
			),
			'default_image_alignment' => 'alignleft',
			
		);
		
	}
	
	/**
	 * Shortcode admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::uploader( array( 'id' => 'otw-shortcode-element-image_url', 'label' => $this->get_label( 'Image' ), 'description' => $this->get_label( 'Person image.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-image_style', 'label' => $this->get_label( 'Image style' ), 'description' => $this->get_label( 'No style, border or rounded image corners.' ), 'parse' => $source, 'options' => $this->settings['image_styles'], 'value' => $this->settings['default_image_style'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-image_alignment', 'label' => $this->get_label( 'Image alignment' ), 'description' => $this->get_label( 'Image alignment' ), 'parse' => $source, 'options' => $this->settings['image_alignment'], 'value' => $this->settings['default_image_alignment'] ) );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-url', 'label' => $this->get_label( 'URL' ), 'description' => $this->get_label( 'The onclick URL for the image.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_area( array( 'id' => 'otw-shortcode-element-content', 'label' => $this->get_label( 'Text' ), 'description' => $this->get_label( 'Short description. HTML is allowed.' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/**
	 * Shortcode admin interface custom options
	 */
	public function build_shortcode_editor_custom_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-css_class', 'label' => $this->get_label( 'CSS Class' ), 'description' => $this->get_label( 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/** build shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_image_style';
			
			$code .= $this->format_attribute( 'image_url', 'image_url', $attributes );
			
			$code .= $this->format_attribute( 'image_style', 'image_style', $attributes );
			
			$code .= $this->format_attribute( 'image_alignment', 'image_alignment', $attributes );
			
			$code .= $this->format_attribute( 'url', 'url', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'css_class', 'css_class', $attributes, false, '', true  );
			
			$code .= ']';
			
			$code .= $attributes['content'];
			
			$code .= '[/otw_shortcode_image_style]';
		}
		
		return $code;

	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode( $attributes, $content ){
		
		$html = '<div';
		
		/*class attributes*/
		$class = 'otw-sc-image-style';
		
		$class .= $this->format_attribute( '', 'image_style', $attributes, false, $class );
		
		$class .= $this->format_attribute( '', 'image_alignment', $attributes, false, $class );
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		if( strlen( $class ) ){
			$html .= ' class="'.$class.'"';
		}
		/*end class attributes*/
		
		/*style attribute*/
		$style = '';
		
		if( strlen( $style ) ){
			$html .= ' style="'.$style.'"';
		}
		
		$html .= '>';
		
		if( $this->format_attribute( '', 'url', $attributes, false, '' ) ){
			$html .= '<a href="'.$this->format_attribute( '', 'url', $attributes, false, '' ).'">';
		}
		
		if( $image_url = $this->format_attribute( '', 'image_url', $attributes, false, '' ) ){
			
			$html .= '<img src="'.$image_url.'" alt="'.$this->format_attribute( '', 'name', $attributes, false, '' ).'" title="'.$this->format_attribute( '', 'name', $attributes, false, '' ).'" />';
		}
		if( $this->format_attribute( '', 'url', $attributes, false, '' ) ){
			$html .= '</a>';
		}
		
		$html .= '<p>'.nl2br( $content ).'</p>';
		
		$html .= '</div>';
		
		return $this->format_shortcode_output( $html );
	}
}