<?php

/**
 * General Workflow for otw_shortcode_icon_box
 *
 * @author Станимир | OTW Design
 * @ver 1.0
 */
class Otw_Shortcode_Icon_Box extends OTW_Shortcodes {

    function __construct() {
        $this->has_custom_options = true;
        parent::__construct();
    }

    /**
     * register external libs
     */
    public function register_external_libs() {

        $this->add_external_lib('css', 'otw-shortcode-general_foundicons', $this->component_url . 'css/general_foundicons.css', 'all', 10);
        $this->add_external_lib('css', 'otw-shortcode-social_foundicons', $this->component_url . 'css/social_foundicons.css', 'all', 20);
        $this->add_external_lib('css', 'otw-shortcode', $this->component_url . 'css/otw_shortcode.css', 'all', 100);
        $this->add_external_lib('css', 'otw-grid', $this->component_url . '../' . 'otw_grid_manager/' . 'css/otw-grid.css', 'all', 120);
    }

    /**
     * Attach all settings to code
     * @return Void
     */
    public function apply_settings() {
        $this->_applyBoxAnimations();
        $this->_applyBoxBackgroundPattern();
        $this->_applyBoxBackgrounds();
        $this->_applyBoxBorderColors();
        $this->_applyBoxBorderStyle();
        $this->_applyBoxBorderType();
        $this->_applyBoxBorderWidth();
        $this->_applyBoxRoundedCourners();
        $this->_applyBoxShadow();
        $this->_applyBoxType();
        $this->_applyButtonBackgrounds();
        $this->_applyCallActions();
        $this->_applyContentLinkColor();
        $this->_applyIconAnimations();
        $this->_applyIconBackgroundColors();
        $this->_applyIconBorderStyle();
        $this->_applyIconBorderWidth();
        $this->_applyIconColorBorders();
        $this->_applyIconColors();
        $this->_applyIconSizes();
        $this->_applyIconTypes();
        $this->_applyIconBoxRounds();
    }

    /**
     * Shortcode icon_box admin interface
     */
    public function build_shortcode_editor_options() {

        $html = '';

        $source = array();
        if (isset($_POST['shortcode_object'])) {
            $source = $_POST['shortcode_object'];
        }
//Container title input
        $html .= OTW_Form::text_input(
                        array('id' => 'otw-shortcode-element-title',
                            'label' => $this->get_label('Title'),
                            'description' => $this->get_label('The title for the Icon box.'),
                            'parse' => $source)
        );

//General Content input element
        $html .= OTW_Form::text_area(
                        array('id' => 'otw-shortcode-element-content',
                            'label' => $this->get_label('Content'),
                            'description' => $this->get_label('The content text. HTML is allowed.'),
                            'parse' => $source)
        );

//Chose for Call action 
        $html .= OTW_Form::select(
                        array('id' => 'otw-shortcode-element-call_to_action',
                            'label' => $this->get_label('Call to Action'),
                            'description' => $this->get_label('Choose the type of the call to action.'),
                            'parse' => $source, 'options' => $this->settings['call_action'],
                            'value' => $this->settings['default_call_action']
                        )
        );

//Text for choosen action call method
        $html .= OTW_Form::text_input(
                        array('id' => 'otw-shortcode-element-action_text',
                            'label' => $this->get_label('Call to Action Text'),
                            'description' => $this->get_label('This is the text in the button or the text link.'),
                            'parse' => $source
                        )
        );
//Call to action link. Href source
        $html .= OTW_Form::text_input(
                        array('id' => 'otw-shortcode-element-href',
                            'label' => $this->get_label('Call to Action Link'),
                            'description' => $this->get_label('The link your call to action leads to.'),
                            'parse' => $source)
        );
//the color in button or link (only for text)
        $html .= OTW_Form::select(
                        array('id' => 'otw-shortcode-element-content_link_color',
                            'label' => $this->get_label('Call to Action Text Color'),
                            'description' => $this->get_label('Choose text color.'),
                            'parse' => $source, 'options' => $this->settings['content_link_color'],
                            'value' => $this->settings['default_content_link_color'])
        );
//button background
        $html .= OTW_Form::select(
                        array('id' => 'otw-shortcode-element-content_button_background',
                            'label' => $this->get_label('Call to Action Button Color'),
                            'description' => $this->get_label('Choose button color.'),
                            'parse' => $source, 'options' => $this->settings['content_button_background'],
                            'value' => $this->settings['default_content_button_background']
                        )
        );


//The icons here are based on foundation icon fonts.
        $html .= OTW_Form::select(
                        array(
                            'id' => 'otw-shortcode-element-icon_types',
                            'label' => $this->get_label('Icon Type'),
                            'description' => $this->get_label('The icons here are based on foundation icon fonts.'),
                            'parse' => $source, 'options' => $this->settings['icon_types'],
                            'value' => $this->settings['default_icon_type'],
                            'data-reload' => '1'
                        )
        );
        if (!empty($source['otw-shortcode-element-icon_types']) && $source['otw-shortcode-element-icon_types'] == 'custom') {
            $html .= OTW_Form::text_input(
                            array('id' => 'otw-shortcode-element-icon_custom_content',
                                'label' => $this->get_label('Custom Icon Text'),
                                'description' => $this->get_label('Instead of an icon you can enter some text like: A, B, 1, 2, 3, etc.'),
                                'parse' => $source
                            )
            );
        }




//Choose icon color. 
        $html .= OTW_Form::select(
                        array(
                            'id' => 'otw-shortcode-element-icon_colors',
                            'label' => $this->get_label('Icon Color'),
                            'description' => $this->get_label('Choose icon color. '),
                            'parse' => $source, 'options' => $this->settings['icon_colors'],
                            'value' => $this->settings['default_icon_colors']
                        )
        );


        //Choose icon size.
        $html .= OTW_Form::select(
                        array(
                            'id' => 'otw-shortcode-element-icon_sizes',
                            'label' => $this->get_label('Icon Size'),
                            'description' => $this->get_label('Choose icon size.'),
                            'parse' => $source, 'options' => $this->settings['icon_sizes'],
                            'value' => $this->settings['default_icon_sizes']
                        )
        );
//Choose the icon animation
        $html .= OTW_Form::select(
                        array(
                            'id' => 'otw-shortcode-element-icon_animations',
                            'label' => $this->get_label('Icon Animation'),
                            'description' => $this->get_label('Choose Icon Animation.'),
                            'parse' => $source, 'options' => $this->settings['icon_animations'],
                            'value' => $this->settings['default_icon_animations']
                        )
        );
        //Icon Box Background Color
        $html .= OTW_Form::select(
                        array(
                            'id' => 'otw-shortcode-element-icon_bgr_colors',
                            'label' => $this->get_label('Icon Box Background Color'),
                            'description' => $this->get_label('Choose Icon Box Background Color. '),
                            'parse' => $source, 'options' => $this->settings['icon_bgr_colors'],
                            'value' => $this->settings['default_icon_bgr_colors']
                        )
        );
        //Choose Icon Box Border Style.
        $html .= OTW_Form::select(
                        array(
                            'id' => 'otw-shortcode-element-icon_brd_style',
                            'label' => $this->get_label('Icon Box Border Style'),
                            'description' => $this->get_label('Choose Icon Box Border Style.'),
                            'parse' => $source, 'options' => $this->settings['icon_brd_style'],
                            'value' => $this->settings['default_icon_brd_style']
                        )
        );
//Choose Icon Box Border Width.
        $html .= OTW_Form::select(
                        array(
                            'id' => 'otw-shortcode-element-icon_brd_width',
                            'label' => $this->get_label('Icon Box Border Width'),
                            'description' => $this->get_label('Choose Icon Box Border Width.'),
                            'parse' => $source, 'options' => $this->settings['icon_brd_width'],
                            'value' => $this->settings['default_icon_brd_width']
                        )
        );


//Choose Icon Box Border Color.
        $html .= OTW_Form::select(
                        array(
                            'id' => 'otw-shortcode-element-icon_brd_color',
                            'label' => $this->get_label('Icon Box Border Color'),
                            'description' => $this->get_label('Choose Icon Box Border Color.'),
                            'parse' => $source, 'options' => $this->settings['icon_brd_color'],
                            'value' => $this->settings['default_icon_brd_color']
                        )
        );

//Choose Rounded Corners for icon
        $html .= OTW_Form::select(
                        array(
                            'id' => 'otw-shortcode-element-icon_brd_round',
                            'label' => $this->get_label('Icon Box Rounded Corners'),
                            'description' => $this->get_label('Choose Icon Box Rounded Corners.'),
                            'parse' => $source, 'options' => $this->settings['icon_brd_round'],
                            'value' => $this->settings['default_icon_brd_round']
                        )
        );
//Choose between Regular or Relative box type.
        $html .= OTW_Form::select(
                        array(
                            'id' => 'otw-shortcode-element-box_type',
                            'label' => $this->get_label('Box Type'),
                            'description' => $this->get_label('Choose between Regular or Relative box type.'),
                            'parse' => $source, 'options' => $this->settings['box_type'],
                            'value' => $this->settings['default_box_type']
                        )
        );

//Choose Box Border Width.
//        $html .= OTW_Form::select(
//                        array(
//                            'id' => 'otw-shortcode-element-box_brd_width',
//                            'label' => $this->get_label('Box Border Width'),
//                            'description' => $this->get_label('Choose Box Border Width.'),
//                            'parse' => $source, 'options' => $this->settings['box_brd_width'],
//                            'value' => $this->settings['default_box_brd_width']
//                        )
//        );
//Choose Box Border Style.
        $html .= OTW_Form::select(
                        array(
                            'id' => 'otw-shortcode-element-box_brd_style',
                            'label' => $this->get_label('Box Border Style'),
                            'description' => $this->get_label('Choose Box Border Style.'),
                            'parse' => $source, 'options' => $this->settings['box_brd_style'],
                            'value' => $this->settings['default_box_brd_style']
                        )
        );
//Choose Box Border Type.
        $html .= OTW_Form::select(
                        array(
                            'id' => 'otw-shortcode-element-box_brd_type',
                            'label' => $this->get_label('Box Border Type'),
                            'description' => $this->get_label('Choose Box Border Type.'),
                            'parse' => $source, 'options' => $this->settings['box_brd_type'],
                            'value' => $this->settings['default_box_brd_type']
                        )
        );


//Choose Box Border Color.
        $html .= OTW_Form::select(
                        array(
                            'id' => 'otw-shortcode-element-box_brd_color',
                            'label' => $this->get_label('Box Border Color'),
                            'description' => $this->get_label('Choose Box Border Color.'),
                            'parse' => $source, 'options' => $this->settings['box_brd_color'],
                            'value' => $this->settings['default_box_brd_color']
                        )
        );

//Choose Box Shadow.
        $html .= OTW_Form::select(
                        array(
                            'id' => 'otw-shortcode-element-box_shadow',
                            'label' => $this->get_label('Box Shadow'),
                            'description' => $this->get_label('Choose Box Shadow.'),
                            'parse' => $source, 'options' => $this->settings['box_shadow'],
                            'value' => $this->settings['default_box_shadow']
                        )
        );


//Choose Box Rounded Corners.
        $html .= OTW_Form::select(
                        array(
                            'id' => 'otw-shortcode-element-box_rounded_corners',
                            'label' => $this->get_label('Box Rounded Corners'),
                            'description' => $this->get_label('Choose Box Rounded Corners.'),
                            'parse' => $source, 'options' => $this->settings['box_rounded_corners'],
                            'value' => $this->settings['default_box_rounded_corners']
                        )
        );
//Choose Box Animation.
        $html .= OTW_Form::select(
                        array(
                            'id' => 'otw-shortcode-element-box_animations',
                            'label' => $this->get_label('Box Animation'),
                            'description' => $this->get_label('Choose Box Animation.'),
                            'parse' => $source, 'options' => $this->settings['box_animations'],
                            'value' => $this->settings['default_box_animations']
                        )
        );

//Choose Box Background Color.
        $html .= OTW_Form::select(
                        array(
                            'id' => 'otw-shortcode-element-box_bgr',
                            'label' => $this->get_label('Box Background Color'),
                            'description' => $this->get_label('Choose Box Background Color.'),
                            'parse' => $source, 'options' => $this->settings['box_bgr'],
                            'value' => $this->settings['default_box_bgr']
                        )
        );


//Choose Box Background Pattern. 
        $html .= OTW_Form::select(
                        array(
                            'id' => 'otw-shortcode-element-box_bgr_pattern',
                            'label' => $this->get_label('Box Background Pattern'),
                            'description' => $this->get_label('Choose Box Background Pattern.'),
                            'parse' => $source, 'options' => $this->settings['box_bgr_pattern'],
                            'value' => $this->settings['default_box_bgr_pattern']
                        )
        );

        return $html;
    }

    /**
     * Shortcode admin interface custom options
     */
    public function build_shortcode_editor_custom_options() {

        $html = '';
        $source = array();
        if (isset($_POST['shortcode_object'])) {
            $source = $_POST['shortcode_object'];
        }

        $html .= OTW_Form::uploader(
                        array('id' => 'otw-shortcode-element-icon_custom_url',
                            'label' => $this->get_label('Icon URL'),
                            'description' => $this->get_label('URL to a custom icon. (Recommended size: 128x128px)'),
                            'parse' => $source
                        )
        );
        $html .= OTW_Form::color_picker(
                        array('id' => 'otw-shortcode-element-icon_custom_color',
                            'label' => $this->get_label('Icon Color Custom '),
                            'description' => $this->get_label('Choose a custom Icon color.'),
                            'parse' => $source
                        )
        );
        $html .= OTW_Form::color_picker(
                        array('id' => 'otw-shortcode-element-icon_custom_box_bgr_color',
                            'label' => $this->get_label('Icon Box Background Color Custom'),
                            'description' => $this->get_label('Choose a custom box background color.'),
                            'parse' => $source
                        )
        );
        $html .= OTW_Form::color_picker(
                        array('id' => 'otw-shortcode-element-icon_custom_brd_color',
                            'label' => $this->get_label('Icon Box Border Color Custom'),
                            'description' => $this->get_label('Choose a custom icon box border color.'),
                            'parse' => $source
                        )
        );
        $html .= OTW_Form::color_picker(
                        array('id' => 'otw-shortcode-element-box_custom_border_color',
                            'label' => $this->get_label('Box Border Color Custom'),
                            'description' => $this->get_label('Choose a custom box border color.'),
                            'parse' => $source
                        )
        );
        $html .= OTW_Form::color_picker(
                        array('id' => 'otw-shortcode-element-box_custom_bgr_color',
                            'label' => $this->get_label('Box Background Color Custom'),
                            'description' => $this->get_label('Choose a custom box background color.'),
                            'parse' => $source
                        )
        );
        $html .= OTW_Form::uploader(
                        array('id' => 'otw-shortcode-element-box_custom_bgr_pattern',
                            'label' => $this->get_label('Box Background Pattern URL'),
                            'description' => $this->get_label('URL to a custom box background pattern. '),
                            'parse' => $source
                        )
        );
        $html .= OTW_Form::text_input(
                        array('id' => 'otw-shortcode-element-css_class',
                            'label' => $this->get_label('CSS Class'),
                            'description' => $this->get_label('If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..'),
                            'parse' => $source
                        )
        );
        return $html;
    }

    /**
     *
     *  @param array
     *  @return string
     */
    public function build_shortcode_code($attributes) {

        $code = '';
        if (!$this->has_error) {
            $code = '[otw_shortcode_icon_box';
            $code .= $this->format_attribute('title', 'title', $attributes, false, '', true);
            $code .= $this->format_attribute('call_to_action', 'call_to_action', $attributes);
            $code .= $this->format_attribute('href', 'href', $attributes);
            $code .= $this->format_attribute('action_text', 'action_text', $attributes);
            $code .= $this->format_attribute('icon_types', 'icon_types', $attributes);
            if ($type = $this->format_attribute('', 'icon_types', $attributes)) {
                if ($type == 'custom') {
                    $code .= $this->format_attribute('icon_custom_content', 'icon_custom_content', $attributes);
                }
            }
            $code .= $this->format_attribute('content_link_color', 'content_link_color', $attributes);
            $code .= $this->format_attribute('content_button_background', 'content_button_background', $attributes);
            $code .= $this->format_attribute('icon_animations', 'icon_animations', $attributes);
            $code .= $this->format_attribute('icon_sizes', 'icon_sizes', $attributes);
            $code .= $this->format_attribute('icon_colors', 'icon_colors', $attributes);
            $code .= $this->format_attribute('icon_bgr_colors', 'icon_bgr_colors', $attributes);
            $code .= $this->format_attribute('icon_brd_width', 'icon_brd_width', $attributes);
            $code .= $this->format_attribute('icon_brd_style', 'icon_brd_style', $attributes);
            $code .= $this->format_attribute('icon_brd_color', 'icon_brd_color', $attributes);
            $code .= $this->format_attribute('icon_brd_round', 'icon_brd_round', $attributes);
            $code .= $this->format_attribute('box_type', 'box_type', $attributes);
            $code .= $this->format_attribute('box_brd_type', 'box_brd_type', $attributes);
//            $code .= $this->format_attribute('box_brd_width', 'box_brd_width', $attributes);
            $code .= $this->format_attribute('box_brd_style', 'box_brd_style', $attributes);
            $code .= $this->format_attribute('box_brd_color', 'box_brd_color', $attributes);
            $code .= $this->format_attribute('box_shadow', 'box_shadow', $attributes);
            $code .= $this->format_attribute('box_rounded_corners', 'box_rounded_corners', $attributes);
            $code .= $this->format_attribute('box_animations', 'box_animations', $attributes);
            $code .= $this->format_attribute('box_bgr', 'box_bgr', $attributes);
            $code .= $this->format_attribute('box_bgr_pattern', 'box_bgr_pattern', $attributes);

            //add custom attributes to shortcode
            $code .= $this->format_attribute('icon_custom_url', 'icon_custom_url', $attributes);
            $code .= $this->format_attribute('icon_custom_color', 'icon_custom_color', $attributes);
            $code .= $this->format_attribute('icon_custom_box_bgr_color', 'icon_custom_box_bgr_color', $attributes);
            $code .= $this->format_attribute('icon_custom_brd_color', 'icon_custom_brd_color', $attributes);
            $code .= $this->format_attribute('box_custom_border_color', 'box_custom_border_color', $attributes);
            $code .= $this->format_attribute('box_custom_bgr_color', 'box_custom_bgr_color', $attributes);
            $code .= $this->format_attribute('box_custom_bgr_pattern', 'box_custom_bgr_pattern', $attributes);
            $code .= $this->format_attribute('css_class', 'css_class', $attributes);

            $code .= ']';
            $code .= ( $attributes['content'] );
            $code .= '[/otw_shortcode_icon_box]';
        }
        return $code;
    }

    private function _implementMasterDom($attributes) {
        $box_type = array();
        $box_type[] = $this->format_attribute('', 'box_type', $attributes);
        $box_type[] = 'otw-b-box';
        $box_type[] = 'otw-b-icon-box';
        $box_type[] = 'otw-b-clearfix';
        $box_type[] = $this->format_attribute('', 'css_class', $attributes);
        $box_type[] = 'otw-text-center';
        if (strlen($this->format_attribute('', 'box_brd_type', $attributes)) > 0 && strlen($this->format_attribute('', 'box_brd_style', $attributes)) > 0) {
            $box_type[] = $this->format_attribute('', 'box_brd_type', $attributes);
//        $box_type[] = $this->format_attribute('', 'box_brd_width', $attributes);
            $box_type[] = $this->format_attribute('', 'box_brd_style', $attributes);
        }
        $box_type[] = $this->format_attribute('', 'box_brd_color', $attributes);
        $box_type[] = $this->format_attribute('', 'box_shadow', $attributes);
        $box_type[] = $this->format_attribute('', 'box_rounded_corners', $attributes);
        $box_type[] = $this->format_attribute('', 'box_bgr', $attributes);
        $box_type[] = $this->format_attribute('', 'box_bgr_pattern', $attributes);

        //animations for box
        $box_animations = $this->format_attribute('', 'box_animations', $attributes);
        if (!empty($box_animations)) {
            $box_type[] = 'animated-b';
            $box_type[] = 'animated-b-' . $box_animations;
        }
        return implode(' ', $box_type);
    }

    /**
     * Export general classes for icon parent DOM
     * @param array $attributes
     * @return string
     */
    private function _implementParentIconClasses($attributes) {

        $parent_icon_dom_class = array();

        $icon_sizes = $this->format_attribute('', 'icon_sizes', $attributes);
        if (!empty($icon_sizes)) {
            $parent_icon_dom_class[] = $icon_sizes;
        }

        $icon_bgr_colors = $this->format_attribute('', 'icon_bgr_colors', $attributes);
        if (!empty($icon_bgr_colors)) {
            $parent_icon_dom_class[] = $icon_bgr_colors;
        }

        $icon_brd_style = $this->format_attribute('', 'icon_brd_style', $attributes);
        if (!empty($icon_brd_style)) {
            $parent_icon_dom_class[] = $icon_brd_style;
        }

        $icon_brd_width = $this->format_attribute('', 'icon_brd_width', $attributes);
        if (!empty($icon_brd_width)) {
            $parent_icon_dom_class[] = $icon_brd_width;
        }


        $icon_brd_color = $this->format_attribute('', 'icon_brd_color', $attributes);
        if (!empty($icon_brd_color)) {
            $parent_icon_dom_class[] = $icon_brd_color;
        }

        if ($this->hasRelative($attributes)) {
            switch ($icon_sizes) {
                case 'otw-b-icon-large':
                    $parent_icon_dom_class[] = 'otw-b-icon-absolute-large';
                    break;
                case 'otw-b-icon-small':
                    $parent_icon_dom_class[] = 'otw-b-icon-absolute-small';
                    break;
                case 'otw-b-icon-giant':
                    $parent_icon_dom_class[] = 'otw-b-icon-absolute-giant';
                    break;
                default:
                    $parent_icon_dom_class[] = 'otw-b-icon-absolute-large';
                    break;
            }


//          /  $parent_icon_dom_class[] = 'otw-b-icon-absolute-gaint';
        }

        $icon_brd_round = $this->format_attribute('', 'icon_brd_round', $attributes);
        if (!empty($icon_brd_round)) {
            $parent_icon_dom_class[] = $icon_brd_round;
        }
        //animations for icons
        $icon_animations = $this->format_attribute('', 'icon_animations', $attributes);
        if (!empty($icon_animations)) {
            $parent_icon_dom_class[] = 'animated-b';
            $parent_icon_dom_class[] = 'animated-b-' . $icon_animations;
        }
        return implode(' ', $parent_icon_dom_class);
    }

    /**
     * Export classes for Icon DOM element
     * @param array $attributes
     * @return string|boolean
     */
    private function _implementIconClasses($attributes) {
        $icon_class = array();
        $icon_types = $this->format_attribute('', 'icon_types', $attributes);
        $icon_class[] = $icon_types;

        $icon_colors = $this->format_attribute('', 'icon_colors', $attributes);
        if (!empty($icon_colors)) {
            $icon_class[] = $icon_colors;
        }
        return !empty($icon_class) ? implode(' ', $icon_class) : false;
    }

    /**
     * Export classes for Content DOM
     * @param type $attributes
     * @return boolean|string
     */
    private function _implementBoxContentClasses($attributes) {
        return false;
    }

    /**
     * Return the link/button
     * @param type $attributes
     * @return string
     */
    private function _implementBoxCallElemetn($attributes) {
        $html = '';
        $call_to_action = $this->format_attribute('', 'call_to_action', $attributes);
//link type 
        $class_call_to_action = array();
        $class_call_to_action[] = $call_to_action;
        $class_call_to_action[] = $this->format_attribute('', 'content_link_color', $attributes);
//if have button will set their background
        if (trim($call_to_action) == 'otw-button') {
            $class_call_to_action[] = $this->format_attribute('', 'content_button_background', $attributes);
        }
        if ($call_to_action == 'none') {
            return null;
        }
        $html .= '<a href="' . ($this->format_attribute('', 'href', $attributes)) . '" class="' . implode(' ', $class_call_to_action) . '">';
        //set the label of link
        $html .= $this->format_attribute('', 'action_text', $attributes, false, '');
        $html .= '</a>';
        return $html;
    }

    /**
     * If container box is relative
     * @param array $attributes
     * @return boolean
     */
    public function hasRelative($attributes) {
        $check = $this->format_attribute('', 'box_type', $attributes);
        if (empty($check)) {
            return false;
        } else {
            return true;
        }
    }

    /**
     * Check for existing custom icon image url
     * @param array $attributes
     * @return boolean
     */
    public function hasCustomIconImage($attributes) {
        $check = $this->format_attribute('', 'icon_custom_url', $attributes);
        if (empty($check)) {
            return false;
        } else {
            return true;
        }
    }

    /**
     * Check for existing custom icon color
     * @param array $attributes
     * @return boolean
     */
    public function hasCustomIconColor($attributes) {
        $check = $this->format_attribute('', 'icon_custom_color', $attributes);
        if (empty($check)) {
            return false;
        } else {
            return true;
        }
    }

    /**
     * Check for existing BGR icon color
     * @param array $attributes
     * @return boolean
     */
    public function hasCustomBackgroundIconColor($attributes) {
        $check = $this->format_attribute('', 'icon_custom_box_bgr_color', $attributes);
        if (empty($check)) {
            return false;
        } else {
            return true;
        }
    }

    /**
     * Check for existing Custom border icon colors
     * @param array $attributes
     * @return boolean
     */
    public function hasCustomBorderIconColor($attributes) {
        $check = $this->format_attribute('', 'icon_custom_brd_color', $attributes);
        if (empty($check)) {
            return false;
        } else {
            return true;
        }
    }

    /**
     * Check for existing custom border box color
     * @param array $attributes
     * @return boolean
     */
    public function hasCustomBorderBoxColor($attributes) {
        $check = $this->format_attribute('', 'box_custom_border_color', $attributes);
        if (empty($check)) {
            return false;
        } else {
            return true;
        }
    }

    /**
     * check has background color for general box color
     * @param array $attributes
     * @return boolean
     */
    public function hasCustomBackgroundBoxColor($attributes) {
        $check = $this->format_attribute('', 'box_custom_bgr_color', $attributes);
        if (empty($check)) {
            return false;
        } else {
            return true;
        }
    }

    /**
     * Check for custom bgr pattern image url
     * @param type $attributes
     * @return boolean
     */
    public function hasCustomBackgroundPattern($attributes) {
        $check = $this->format_attribute('', 'box_custom_bgr_pattern', $attributes);
        if (empty($check)) {
            return false;
        } else {
            return true;
        }
    }

    /**
     * Export custom styles for Icon Parent DOM
     * @param array $attributes
     * @return string
     */
    function setCustomIconBoxStyle($attributes) {
        $style = '';
        if ($this->hasCustomBackgroundIconColor($attributes)) {
            $style = $this->append_attribute($style, 'background-color: ' . $this->format_attribute('', 'icon_custom_box_bgr_color', $attributes) . '!important;');
        }

        if ($this->hasCustomBorderIconColor($attributes)) {
            $style = $this->append_attribute($style, 'border-color: ' . $this->format_attribute('', 'icon_custom_brd_color', $attributes) . '!important;');
        }
        return empty($style) ? null : $style;
    }

    /**
     * export style for general box
     * @param style $attributes
     * @return string
     */
    function setCustomBoxBoxStyle($attributes) {
        $style = '';
        if ($this->hasCustomBorderBoxColor($attributes)) {
            $style = $this->append_attribute($style, 'border-color: ' . $this->format_attribute('', 'box_custom_border_color', $attributes) . '!important;');
        }

        if ($this->hasCustomBackgroundBoxColor($attributes)) {
            $style = $this->append_attribute($style, 'background-color: ' . $this->format_attribute('', 'box_custom_bgr_color', $attributes) . '!important;');
        }

        if ($this->hasCustomBackgroundPattern($attributes)) {
            $style = $this->append_attribute($style, 'background-image: url(' . $this->format_attribute('', 'box_custom_bgr_pattern', $attributes) . ')!important;');
        }

        return empty($style) ? null : $style;
    }

    /**
     * Display shortcode
     */
    public function display_shortcode($attributes, $content) {

      $html = '';
        $style_box = $this->setCustomBoxBoxStyle($attributes);
        if (!empty($style_box)) {
            $html .= '<div style="' . $style_box . '" class="' . $this->_implementMasterDom($attributes) . '">';
        } else {
            $html .= '<div class="' . $this->_implementMasterDom($attributes) . '">';
        }
        $icon_classes = $this->_implementIconClasses($attributes);
        if ($icon_classes || $this->hasCustomIconImage($attributes)) {

            //set icon box styles
            $style_icon_box = $this->setCustomIconBoxStyle($attributes);
            if (!empty($style_icon_box)) {
                $html .= '<span style="' . $style_icon_box . '" class=" otw-b-icon ' . $this->_implementParentIconClasses($attributes) . '">';
            } else {
                $html .= '<span class=" otw-b-icon ' . $this->_implementParentIconClasses($attributes) . '">';
            }

            if ($this->hasCustomIconImage($attributes)) {
                $html .= '<img src="' . $this->format_attribute('', 'icon_custom_url', $attributes) . '" alt="" />';
            } else {
                $style = '';
                if ($this->hasCustomIconColor($attributes)) {
                    $style = $this->append_attribute($style, 'color: ' . $this->format_attribute('', 'icon_custom_color', $attributes) . '!important;');
                }
                if ($txt = $this->format_attribute('', 'icon_custom_content', $attributes)) {
                    $html .= '<span class="' . $icon_classes . '">' . $txt . '</span>';
                } else {
                    $html .= '<i style="' . $style . '" class="' . $icon_classes . '">';
                    $html .= '</i>';
                }
            }

            $html .= '</span>';
        }
        $html .= '<div class="' . $this->_implementBoxContentClasses($attributes) . '">';
        
        if( $title = $this->format_attribute('', 'title', $attributes, false, '') ){
	        $html .= '<h3>';
    			$html .= $title;
	        $html .= '</h3>';
        }
        if( strlen( trim( $content ) ) ){
    	    $html .= '<p>' . nl2br($content) . '</p>';
        }
        $html .= $this->_implementBoxCallElemetn($attributes);
        $html .= '</div>';
        $html .= '</div>';
        return $this->format_shortcode_output($html);
    }

}
