<?php
class OTW_Shortcode_Flickr extends OTW_Shortcodes{
	
	public function __construct(){
		
		$this->has_custom_options = true;
		
		$this->preview = 'div';
		
		parent::__construct();
	}
	/**
	 * register external libs
	 */
	public function register_external_libs(){
	
		$this->add_external_lib( 'css', 'otw-shortcode', $this->component_url.'css/otw_shortcode.css', 'all', 100 );
	}
	/**
	 * apply settings
	 */
	public function apply_settings(){
		
		$this->settings = array(
			
			'number' => array(
					'1'    => $this->get_label( '1' ),
					'2'    => $this->get_label( '2' ),
					'3'    => $this->get_label( '3' ),
					'4'    => $this->get_label( '4' ),
					'5'    => $this->get_label( '5' ),
					'6'    => $this->get_label( '6' ),
					'7'    => $this->get_label( '7' ),
					'8'    => $this->get_label( '8' ),
					'9'    => $this->get_label( '9' ),
					'10'   => $this->get_label( '10' )
				),
			'default_number' => '1',
			
			'type' => array(
					'user'    => $this->get_label( 'User' ),
					'group'    => $this->get_label( 'Group' )
				),
			'default_type' => '1',
			
			'sorting' => array(
					'latest'    => $this->get_label( 'Latest' ),
					'random'    => $this->get_label( 'Random' )
				),
			'default_sorting' => 'latest',
			
			'size' => array(
					's'    => $this->get_label( 'Square' ),
					'm'    => $this->get_label( 'Medium' ),
					't'    => $this->get_label( 'Thumbnail' )
				),
			'default_size' => 's'
			
		);
	}
	
	/**
	 * Shortcode admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-title', 'label' => $this->get_label( 'Title' ), 'description' => $this->get_label( '' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-id', 'label' => $this->get_label( 'Flickr ID' ), 'description' => $this->get_label( '<a href="http://www.idgettr.com">idGettr</a>' ), 'parse' => $source )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-number', 'label' => $this->get_label( 'Number' ), 'description' => $this->get_label( '' ), 'parse' => $source, 'options' => $this->settings['number'], 'value' => $this->settings['default_number'] )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-type', 'label' => $this->get_label( 'Type' ), 'description' => $this->get_label( '' ), 'parse' => $source, 'options' => $this->settings['type'], 'value' => $this->settings['default_type'] )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-sorting', 'label' => $this->get_label( 'Sorting' ), 'description' => $this->get_label( '' ), 'parse' => $source, 'options' => $this->settings['sorting'], 'value' => $this->settings['default_sorting'] )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-size', 'label' => $this->get_label( 'Size' ), 'description' => $this->get_label( '' ), 'parse' => $source, 'options' => $this->settings['size'], 'value' => $this->settings['default_size'] )  );
		
		return $html;
	}
	
	/**
	 * Shortcode admin interface custom options
	 */
	public function build_shortcode_editor_custom_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-css_class', 'label' => $this->get_label( 'CSS Class' ), 'description' => $this->get_label( 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/** build shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_flickr';
			
			$code .= $this->format_attribute( 'title', 'title', $attributes, false, '', true );
			$code .= $this->format_attribute( 'id', 'id', $attributes, false, '', true );
			$code .= $this->format_attribute( 'number', 'number', $attributes, false, '', true );
			$code .= $this->format_attribute( 'type', 'type', $attributes, false, '', true );
			$code .= $this->format_attribute( 'sorting', 'sorting', $attributes, false, '', true );
			$code .= $this->format_attribute( 'size', 'size', $attributes, false, '', true );
			$code .= $this->format_attribute( 'css_class', 'css_class', $attributes, false, '', true  );
			
			$code .= ']';
			
			$code .= '[/otw_shortcode_flickr]';
		}
		
		return $code;

	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode( $attributes, $content ){
		
		$html = '<div';
		
		/*class attributes*/
		$class = 'otw-widget-flickr';
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		if( strlen( $class ) ){
			$html .= ' class="'.$class.'"';
		}
		/*end class attributes*/
		
		/*style attribute*/
		$style = '';
		
		if( $float = $this->format_attribute( '', 'align', $attributes, false, '' ) ){
			$style = $this->append_attribute( $style, 'float: '.$float.';' );
		}
		
		if( strlen( $style ) ){
			$html .= ' style="'.$style.'"';
		}
		
		$html .= '>';
		
		$html .= '<h3 class="widget-title">'.$this->format_attribute( '', 'title', $attributes, false, '' ).'</h3>';
		
		$html .= '<div class="image-list animate-on-hover">';
		
		$query_string = '';
		
		if( $attr_value = $this->format_attribute( '', 'number', $attributes, false, '' ) ){
			$query_string .= '&amp;count='.$attr_value;
		}
		if( $attr_value = $this->format_attribute( '', 'sorting', $attributes, false, '' ) ){
			$query_string .= '&amp;display='.$attr_value;
		}
		if( $attr_value = $this->format_attribute( '', 'type', $attributes, false, '' ) ){
			$query_string .= '&amp;source='.$attr_value;
			
			$query_string .= '&amp;'.$attr_value.'='.$this->format_attribute( '', 'id', $attributes, false, '' );
		}
		if( $attr_value = $this->format_attribute( '', 'size', $attributes, false, '' ) ){
			$query_string .= '&amp;size='.$attr_value;
		}
		if( $this->is_live_preview ){
			
			$p = file_get_contents( "http://www.flickr.com/badge_code_v2.gne?layout=x" . str_replace( '&amp;', '&', $query_string ) );
			
			$html .= '<script type="text/javascript">';
			$html .= str_replace( 'document.write(b_txt);', '', $p );
			$html .= "jQuery('.image-list').html(b_txt);";
			$html .= '</script>';
			
		}else{
			$html .= '<script type="text/javascript" src="http://www.flickr.com/badge_code_v2.gne?layout=x' . $query_string . '"></script>' . "\n";
		}
		$html .= '</div>';
		
		$html .= '</div>';
		
		return $this->format_shortcode_output( $html );
	}
}
