<?php
class OTW_Shortcode_Editor_Content extends OTW_Shortcodes{
	
	public function __construct(){
		
		$this->has_custom_options = false;
		
		parent::__construct();
	}
	
	public function register_external_libs(){
	
		$this->add_external_lib( 'css', 'otw-shortcode-general_foundicons', $this->component_url.'css/general_foundicons.css', 'all', 10 );
		$this->add_external_lib( 'css', 'otw-shortcode-social_foundicons', $this->component_url.'css/social_foundicons.css', 'all', 20 );
		$this->add_external_lib( 'css', 'otw-shortcode', $this->component_url.'css/otw_shortcode.css', 'all', 100 );
	
	}
	
	/**
	 * Shortcode info box admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		if( isset( $_POST['otw_item_id'] ) ){
			$html .= '<input type="hidden" name="otw_item_id"  id="otw_item_id" value="'.$_POST['otw_item_id'].'"/>';
		}
		
		$html .= $this->get_label( 'This shortcode will place the content of your page/post editor in this column. Use this if you want to have the page content in your grid.' );
		
		return $html;
	}
	
	/**
	 * Shortcode info box admin interface custom options
	 */
	public function build_shortcode_editor_custom_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		return $html;
	}
	
	/** build info box shortcode
	 *
	 *  @param array
	 *  @retuyrn string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_editor_content';
			
			$code .= ']';
			
			$code .= '[/otw_shortcode_editor_content]';
		}
		
		return $code;

	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode( $attributes, $content ){
		
		global $post;
		
		$html = '<div';
		
		/*class attributes*/
		$class = 'otw-sc-editor-content';
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		if( strlen( $class ) ){
			$html .= ' class="'.$class.'"';
		}
		/*end class attributes*/
		
		$html .= '>';
		if( isset( $post->ID ) ){
			
			ob_start();
			$post_content = $post->post_content;
			//remove our shortcodes so it wont loop forever
			$post_content = str_replace( '[otw_shortcode_editor_content]', '', $post_content );
			$post_content = str_replace( '[/otw_shortcode_editor_content]', '', $post_content );
			
			$html .= nl2br( do_shortcode( $post_content ) );
			
			ob_end_clean();
		}else{
		
			//find if post id is in the post
			$otw_item_id = 0;
			if( isset( $_POST['otw_item_id'] ) && $_POST['otw_item_id'] ){
				$otw_item_id = $_POST['otw_item_id'];
			}elseif( isset( $_POST['shortcode'] ) && isset( $_POST['shortcode']['otw_item_id'] ) && $_POST['shortcode']['otw_item_id'] ){
				$otw_item_id = $_POST['shortcode']['otw_item_id'];
			}
			
			if( $otw_item_id ){
				$otw_post = get_post( $otw_item_id );
				
				if( isset( $otw_post->ID ) ){
				
					ob_start();
					$post_content = $otw_post->post_content;
					//remove our shortcodes so it wont loop forever
					$post_content = str_replace( '[otw_shortcode_editor_content]', '', $post_content );
					$post_content = str_replace( '[/otw_shortcode_editor_content]', '', $post_content );
					
					$html .= nl2br( do_shortcode( $post_content ) );
					
					ob_end_clean();
				}
			}
		}
		$html .= '</div>';
		
		return $this->format_shortcode_output( $html );
	}
}
