<?php
class OTW_Shortcode_Clients extends OTW_Shortcodes{
	
	public function __construct(){
		
		$this->has_custom_options = true;
		
		parent::__construct();
	}
	/**
	 * register external libs
	 */
	public function register_external_libs(){
	
		$this->add_external_lib( 'css', 'otw-shortcode', $this->component_url.'css/otw_shortcode.css', 'all', 100 );
	}
	/**
	 * apply settings
	 */
	public function apply_settings(){
		
		$this->settings = array(
		
			'number' => array(
				'1'           => $this->get_label( '1 Client' ),
				'2'           => $this->get_label( '2 Clients' ),
				'3'           => $this->get_label( '3 Clients' ),
				'4'           => $this->get_label( '4 Clients' ),
				'5'           => $this->get_label( '5 Clients' ),
				'6'           => $this->get_label( '6 Clients(default)' ),
				'7'           => $this->get_label( '7 Clients' ),
				'8'           => $this->get_label( '8 Clients' ),
				'9'           => $this->get_label( '9 Clients' ),
				'10'          => $this->get_label( '10 Clients' ),
				'11'          => $this->get_label( '11 Clients' ),
				'12'          => $this->get_label( '12 Clients' )
				
				
			),
			'default_number' => 6,
			
		);
		
	}
	
	/**
	 * Shortcode admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-number', 'label' => $this->get_label( 'Number' ), 'description' => $this->get_label( 'Number of clients. 6 or 12 are recommended.' ), 'parse' => $source, 'options' => $this->settings['number'], 'value' => $this->settings['default_number'], 'data-reload' => '1' ) );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-title', 'label' => $this->get_label( 'Title' ), 'description' => $this->get_label( 'The title.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-link_title', 'label' => $this->get_label( 'Link Title' ), 'description' => $this->get_label( 'The text for your more link. If empty no link text will be added.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-link_url', 'label' => $this->get_label( 'Link URL' ), 'description' => $this->get_label( 'Optional Link URL.' ), 'parse' => $source )  );
		
		$total_number = $this->settings['default_number'];
		
		if( isset( $source['otw-shortcode-element-number'] ) ){
			$total_number = $source['otw-shortcode-element-number'];
		}
		
		for( $cT = 1; $cT <= $total_number; $cT++ )
		{
			$html .= OTW_Form::uploader( array( 'id' => 'otw-shortcode-element-client_'.$cT.'_logo_url', 'label' => $this->get_label( 'Client '.$cT.' logo' ), 'description' => $this->get_label( 'Upload client logo. 120x80 px is recommended.' ), 'alternative_description' => $this->get_label( 'URL to client logo. 120x80 px is recommended.' ), 'parse' => $source )  );
			
			$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-client_'.$cT.'_url', 'label' => $this->get_label( 'Client '.$cT.' url' ), 'description' => $this->get_label( 'Optional client URL.' ), 'parse' => $source )  );
		}
		
		return $html;
	}
	
	/**
	 * Shortcode admin interface custom options
	 */
	public function build_shortcode_editor_custom_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-css_class', 'label' => $this->get_label( 'CSS Class' ), 'description' => $this->get_label( 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/** build shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_clients';
			
			$code .= $this->format_attribute( 'number', 'number', $attributes );
			
			$code .= $this->format_attribute( 'title', 'title', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'link_title', 'link_title', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'link_url', 'link_url', $attributes, false, '', true );
			
			if( $items = $this->format_attribute( '', 'number', $attributes ) ){
				
				for( $cT = 1; $cT <= $items; $cT++ ){
					
					$code .= $this->format_attribute( 'client_'.$cT.'_logo_url', 'client_'.$cT.'_logo_url', $attributes );
					
					$code .= $this->format_attribute( 'client_'.$cT.'_url', 'client_'.$cT.'_url', $attributes, false, '', true );
				}
			}
			
			$code .= $this->format_attribute( 'css_class', 'css_class', $attributes, false, '', true  );
			
			$code .= ']';
			
			$code .= '[/otw_shortcode_clients]';
		}
		
		return $code;

	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode( $attributes, $content ){
		
		$html = '<div';
		
		/*class attributes*/
		$class = 'otw-sc-clients';
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		if( strlen( $class ) ){
			$html .= ' class="'.$class.'"';
		}
		/*end class attributes*/
		
		/*style attribute*/
		$style = '';
		
		if( strlen( $style ) ){
			$html .= ' style="'.$style.'"';
		}
		
		$html .= '>';
		
		if( $title = $this->format_attribute( '', 'title', $attributes, false, '' ) ){
			$html .= '<div class="otw-sc-divider text-left">';
			$html .= '<span>'.$title.'</span>';
			
			if( $link_text = $this->format_attribute( '', 'link_title', $attributes, false, '' ) ){
			
				if( $link = $this->format_attribute( '', 'link_url', $attributes, false, '' ) ){
					$html .= '<a class="dot" href="'.$link.'">'.$link_text.'</a>';
				}else{
					$html .= '<div class="dot" href="'.$link.'">'.$link_text.'</div>';
				}
			}
			$html .= '</div>';
		}
		
		if( $items = $this->format_attribute( '', 'number', $attributes, false, '' ) ){
			
			$html .= '<ul class="block-grid mobile-three-up six-up">';
		
			for( $cT = 1; $cT <= $items; $cT++ ){
			
				$html .= '<li>';
				
				$client_url = $this->format_attribute( '', 'client_'.$cT.'_url', $attributes, false, '' );
				
				if( $client_url ){
					$html .= '<a href="'.$client_url.'">';
				}
				
				if( $client_logo_url = $this->format_attribute( '', 'client_'.$cT.'_logo_url', $attributes, false, '' ) ){
					$html .= '<img src="'.$client_logo_url.'" title="" alt="" />';
				}
				
				if( $client_url ){
					$html .= '</a>';
				}
				
				$html .= '</li>';
			}
			$html .= '</ul>';
		}
		
		$html .= '</div>';
		
		return $this->format_shortcode_output( $html );
	}
}
