<?php
class OTW_Shortcode_Blog_Lists extends OTW_Shortcodes{
	
	/**
	 *  Numbers
	 *
	 *  @var array
	 */
	public function __construct(){
		
		$this->has_custom_options = true;
		
		parent::__construct();
		
		
		add_action( 'wp_ajax_otw_item_options_otw_shortcode-element-categories', array( $this, '_get_category_options' ) );
		
		add_action( 'wp_ajax_otw_item_options_otw_shortcode-element-tags', array( $this, '_get_tag_options' ) );
		
		add_action( 'wp_ajax_otw_item_options_otw_shortcode-element-authors', array( $this, '_get_author_options' ) );
	}
	/**
	 * register external libs
	 */
	public function register_external_libs(){
	
		$this->add_external_lib( 'css', 'otw-shortcode', $this->component_url.'css/otw_shortcode.css', 'all', 100 );
	}
	
	/**
	 * apply settings
	 */
	public function apply_settings(){
		
		$this->settings = array(
			
			'templates' => array(
				'b1c'          => $this->get_label( 'Blog 1 Column' ),
				'b2c'          => $this->get_label( 'Blog 2 Column' ),
				'b3c'          => $this->get_label( 'Blog 3 Column' ),
				'b4c'          => $this->get_label( 'Blog 4 Column' ),
				'ba'           => $this->get_label( 'Blog Archive' ),
				'wc'           => $this->get_label( 'Widget Style' )
			),
			'default_template' => 1,
			'default_per_page' => 10,
			'pager' => array(
				'yes'          => $this->get_label( 'yes' ),
				'no'          => $this->get_label( 'no' )
			),
			'default_pager' => 'no',
			
			'yes_no' => array(
				'yes'          => $this->get_label( 'yes' ),
				'no'          => $this->get_label( 'no' )
			),
			'default_yes_no' => 'yes',
			
			'targets' => array( 
				'_self' => $this->get_label( 'Same Window / Tab (default)' ),
				'_blank' => $this->get_label( 'New Window / Tab' )
			),
			'default_target' => '_self',
			
			'default_excerpt_words' => 40
		);
		
	}
	
	/**
	 * Shortcode admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= '<div class="otw_updated">Want more blog post lists options? Check out the <a href="http://codecanyon.net/item/blog-manager-for-wordpress/9982292?ref=OTWthemes" target="_blank">Blog Manager for WordPress</a></div>';
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-template', 'label' => $this->get_label( 'Choose template' ), 'description' => $this->get_label( 'Choose the template.' ), 'parse' => $source, 'options' => $this->settings['templates'], 'value' => $this->settings['default_template'] ) );
		
		$html .= OTW_Form::dynamic_select( array( 'id' => 'otw-shortcode-element-categories', 'label' => $this->get_label( 'Choose Categories' ), 'description' => $this->get_label( 'Choose categories to include posts from those categories in your list or use the Select all checkbox to include posts from all categories.' ), 'parse' => $source ) );
		
		$html .= OTW_Form::dynamic_select( array( 'id' => 'otw-shortcode-element-tags', 'label' => $this->get_label( 'Choose Tags' ), 'description' => $this->get_label( 'Choose tags to include posts from those tags in your list or use the Select all checkbox to include posts from all tags.' ), 'parse' => $source ) );
		
		$html .= OTW_Form::dynamic_select( array( 'id' => 'otw-shortcode-element-authors', 'label' => $this->get_label( 'Post Author' ), 'description' => $this->get_label( 'Choose authors to include posts from those authors in your list or use the Select all checkbox to include posts from all authors.' ), 'parse' => $source ) );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-number', 'label' => $this->get_label( 'Number of Posts in the list' ), 'description' => $this->get_label( 'Please leave empty for all posts.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-per_page', 'label' => $this->get_label( 'Number of Posts per Page' ), 'description' => $this->get_label( 'Show pagination should be ebabled in the section above in order for this option to work.' ), 'parse' => $source, 'value' => $this->settings['default_per_page'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-pager', 'label' => $this->get_label( 'Show Pagination' ), 'description' => $this->get_label( 'Enable pager.' ), 'parse' => $source, 'options' => $this->settings['pager'], 'value' => $this->settings['default_pager'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-show_title', 'label' => $this->get_label( 'Show Title' ), 'description' => $this->get_label( '' ), 'parse' => $source, 'options' => $this->settings['yes_no'], 'value' => $this->settings['default_yes_no'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-show_meta', 'label' => $this->get_label( 'Show Meta' ), 'description' => $this->get_label( '' ), 'parse' => $source, 'options' => $this->settings['yes_no'], 'value' => $this->settings['default_yes_no'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-show_excerpt', 'label' => $this->get_label( 'Show Excerpt' ), 'description' => $this->get_label( '' ), 'parse' => $source, 'options' => $this->settings['yes_no'], 'value' => $this->settings['default_yes_no'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-show_read_more', 'label' => $this->get_label( 'Show Read More' ), 'description' => $this->get_label( '' ), 'parse' => $source, 'options' => $this->settings['yes_no'], 'value' => $this->settings['default_yes_no'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-show_image', 'label' => $this->get_label( 'Show Image' ), 'description' => $this->get_label( '' ), 'parse' => $source, 'options' => $this->settings['yes_no'], 'value' => $this->settings['default_yes_no'] ) );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-excerpt_words', 'label' => $this->get_label( 'Excerpt length in words' ), 'description' => $this->get_label( 'Excerpt is pulled from excerpt field for each post. If excerpt fields is empty excerpt is pulled from the text area (the post editor). If Excerpt length is empty or 0 this means pull the entire text.' ), 'parse' => $source, 'value' => $this->settings['default_excerpt_words'] )  );
		
		return $html;
	}
	
	/**
	 * Shortcode admin interface custom options
	 */
	public function build_shortcode_editor_custom_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-css_class', 'label' => $this->get_label( 'CSS Class' ), 'description' => $this->get_label( 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/** build shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_blog_lists';
			
			$code .= $this->format_attribute( 'template', 'template', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'categories', 'categories', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'categories_allitems', 'categories_allitems', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'tags', 'tags', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'tags_allitems', 'tags_allitems', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'authors', 'authors', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'authors_allitems', 'authors_allitems', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'number', 'number', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'per_page', 'per_page', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'pager', 'pager', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'show_title', 'show_title', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'show_meta', 'show_meta', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'show_excerpt', 'show_excerpt', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'show_read_more', 'show_read_more', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'show_image', 'show_image', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'excerpt_words', 'excerpt_words', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'css_class', 'css_class', $attributes, false, '', true  );
			
			$code .= ']';
			
			$code .= '[/otw_shortcode_blog_lists]';
		
		}
		
		return $code;

	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode( $attributes, $content ){
		
		$html = '';
		
		if( isset( $attributes['template'] ) ){
		
			$query = array();
			$query['post_status'] = 'publish';
			$query['post_type']   = 'post';
			
			if( ( $this->format_attribute( '', 'categories_allitems', $attributes, false, '' ) != 1 ) && ( $this->format_attribute( '', 'tags_allitems', $attributes, false, '' ) != 1 ) && $this->format_attribute( '', 'categories', $attributes, false, '' ) && $this->format_attribute( '', 'tags', $attributes, false, '' ) ){
				
				$query['tax_query'] = array(
					'relation' => 'OR',
					array(
						'taxonomy' => 'category',
						'field'    => 'id',
						'terms'    => explode( ',', $this->format_attribute( '', 'categories', $attributes, false, '' )  )
					),
					array(
						'taxonomy' => 'post_tag',
						'field'    => 'id',
						'terms'    => explode( ',', $this->format_attribute( '', 'tags', $attributes, false, '' )  )
					),
				);
			}else{
				//categories
				if( $this->format_attribute( '', 'categories_allitems', $attributes, false, '' ) != 1 ){
					
					if( $param_value = $this->format_attribute( '', 'categories', $attributes, false, '' ) ){
						$query['cat'] = $param_value;
					}
				}
				//tags
				if( $this->format_attribute( '', 'tags_allitems', $attributes, false, '' ) != 1 ){
					
					if( $param_value = $this->format_attribute( '', 'tags', $attributes, false, '' ) ){
						$query['tag__in'] = explode( ',', $param_value );
					}
				}
			}
			//authors
			if( $this->format_attribute( '', 'authors_allitems', $attributes, false, '' ) != 1 ){
				
				if( $param_value = $this->format_attribute( '', 'authors', $attributes, false, '' ) ){
					$query['author'] = $param_value;
				}
			}
			
			
			//this should be the last query params
			if( $this->format_attribute( '', 'pager', $attributes, false, '' ) == 'yes' ){
				
				if( $param_value = $this->format_attribute( '', 'per_page', $attributes, false, '' ) ){
					
					if( $number = $this->format_attribute( '', 'number', $attributes, false, '' ) ){
						//pull only limited number of posts
						$query['posts_per_page'] = $number;
						
						//limited posts
						wp_reset_query();
						$otw_limited_posts = new WP_Query( $query );
						
						if( isset( $otw_limited_posts->posts ) ){
							
							$post_ids = array();
							foreach( $otw_limited_posts->posts as $limited_post ){
								$post_ids[ $limited_post->ID ] = $limited_post->ID;
							}
							$query['post__in'] = $post_ids;
						}
						unset( $query['posts_per_page'] );
					}
					
					$query['posts_per_page'] = $param_value;
					$query['paged'] = 1;
					
					if( isset( $_GET['otwblpage'] ) && intval( $_GET['otwblpage'] ) ){
						$query['paged'] = max( 1, intval( $_GET['otwblpage'] ) );
					}else{
						$query['paged'] = 1;
					}
				}
				
				
			}elseif( $param_value = $this->format_attribute( '', 'number', $attributes, false, '' ) ){
				$query['posts_per_page'] = $param_value;
			}
			
			wp_reset_query();
			
			$otw_posts = new WP_Query( $query );
			switch( $attributes['template'] ){
				
				case 'b1c':
						$html .= $this->renderB1CTemplate( $attributes, $otw_posts );
					break;
				case 'b2c':
						$html .= $this->renderB2CTemplate( $attributes, $otw_posts );
					break;
				case 'b3c':
						$html .= $this->renderB3CTemplate( $attributes, $otw_posts );
					break;
				case 'b4c':
						$html .= $this->renderB4CTemplate( $attributes, $otw_posts );
					break;
				case 'ba':
						$html .= $this->renderBATemplate( $attributes, $otw_posts );
					break;
				case 'wc':
						$html .= $this->renderWCTemplate( $attributes, $otw_posts );
					break;
				default:
						echo $attributes['template'];
					break;
			}
		}
		
		return $this->format_shortcode_output( $html );
	}
	
	private function renderWCTemplate( $attributes, $items ){
		
		$html = '';
		
		$class = 'otw-twentyfour otw-columns';
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		$html = '';
		
		if( isset( $items->posts ) && is_array( $items->posts ) && count( $items->posts ) ){
			
			$html .= '<div class="otw-row">';
			$html .=	'<div class="'.$class.'">';
			$html .=		'<div class="otw-widget-blog-latest animate-on-hover">';
			foreach( $items->posts as $item ){
				
				$html .= '<div class="widget-row">';
				$html .=	$this->renderPost( $item, $attributes );
				$html .= '</div>';
			
			}
			$html .=		'</div>';
			$html .=	'</div>';
			$html .= '</div>';
			$html .= $this->renderPager( $items, $attributes );
		}
		
		return $html;
	}
	
	private function renderBATemplate( $attributes, $items ){
		
		$html = '';
		
		$class = 'otw-twentyfour otw-columns';
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		$html = '';
		
		if( isset( $items->posts ) && is_array( $items->posts ) && count( $items->posts ) ){
			
			foreach( $items->posts as $item ){
				
				$html .= '<div class="otw-row">';
				
				$html .= 	'<div class="'.$class.'">';
				$html .=		$this->renderPost( $item, $attributes );
				$html .= 	'</div>';
				
				$html .= '</div>';
			}
			$html .= $this->renderPager( $items, $attributes );
		}
		
		return $html;
	}
	private function renderB4CTemplate( $attributes, $items ){
		
		$class = 'otw-six otw-columns';
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		$html = '';
		
		if( isset( $items->posts ) && is_array( $items->posts ) && count( $items->posts ) ){
		
			$num = 0;
			
			$total_posts = count( $items->posts );
			$current_post = 0;
			foreach( $items->posts as $item ){
				
				$current_post++;
				
				if( $num == 0 ){
					$html .= '<div class="otw-row">';
				}
				
				$row_class = $class;
				
				if( ( $current_post == $total_posts ) || ( $num == 3 )  ){
					$row_class .= ' end';
				}
				
				$html .= 	'<div class="'.$row_class.'">';
				$html .= 		$this->renderPost( $item, $attributes );
				$html .= 	'</div>';
				
				$num++;
				
				if( $num == 4 ){
					$html .= '</div>';
					$num = 0;
				}
			}
			if( $num != 0 ){
				$html .= '</div>';
			}
			$html .= $this->renderPager( $items, $attributes );
		}
		
		return $html;
	}
	
	private function renderB3CTemplate( $attributes, $items ){
		
		$class = 'otw-eight otw-columns';
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		$html = '';
		
		if( isset( $items->posts ) && is_array( $items->posts ) && count( $items->posts ) ){
		
			$num = 0;
			$total_posts = count( $items->posts );
			$current_post = 0;
			foreach( $items->posts as $item ){
				
				$current_post++;
				
				if( $num == 0 ){
					$html .= '<div class="otw-row">';
				}
				
				$row_class = $class;
				
				if( ( $current_post == $total_posts ) || ( $num == 2 )  ){
					$row_class .= ' end';
				}
				
				$html .= 	'<div class="'.$row_class.'">';
				$html .=		$this->renderPost( $item, $attributes );
				$html .= 	'</div>';
				
				$num++;
				
				if( $num == 3 ){
					$html .= '</div>';
					$num = 0;
				}
			}
			if( $num != 0 ){
				$html .= '</div>';
			}
			$html .= $this->renderPager( $items, $attributes );
		}
		
		return $html;
	}
	
	private function renderB2CTemplate( $attributes, $items ){
		
		$class = 'otw-twelve otw-columns';
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		$html = '';
		
		if( isset( $items->posts ) && is_array( $items->posts ) && count( $items->posts ) ){
		
			$num = 0;
			
			$total_posts = count( $items->posts );
			$current_post = 0;
			foreach( $items->posts as $item ){
				
				$current_post++;
				
				if( $num == 0 ){
					$html .= '<div class="otw-row">';
				}
				
				$row_class = $class;
				
				if( ( $current_post == $total_posts ) || ( $num == 1 )  ){
					$row_class .= ' end';
				}
				
				$html .= 	'<div class="'.$row_class.'">';
				$html .=		$this->renderPost( $item, $attributes );
				$html .= 	'</div>';
				
				$num++;
				
				if( $num == 2 ){
					$html .= '</div>';
					$num = 0;
				}
			}
			if( $num != 0 ){
				$html .= '</div>';
			}
			$html .= $this->renderPager( $items, $attributes );
		}
		
		return $html;
	}
	
	private function renderB1CTemplate( $attributes, $items ){
		
		$class = 'otw-twentyfour otw-columns';
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		$html = '';
		
		$html .= '<div class="otw-row">';
		
		$html .= 	'<div class="'.$class.'">';
		
		if( isset( $items->posts ) && is_array( $items->posts ) && count( $items->posts ) ){
		
			foreach( $items->posts as $item ){
				
				$html .= $this->renderPost( $item, $attributes );
			}
		}
		
		$html .= $this->renderPager( $items, $attributes );
		
		$html .= 	'</div>';
		$html .= '</div>';
		
		return $html;
	}
	
	private function excerptLength($content, $count){
		$content = strip_tags($content);
		
		$content = str_replace('&nbsp;', ' ', $content);
		
		$content = explode(" ", $content);
		
		if( $count == 0 ){
			$count = 1;
		}
		
		if ($count < count($content) ){
			$content = array_slice($content, 0, $count);
		}
		$content = join(" ", $content);
		
		return $content;
	}
	
	private function resize_media( $type, $path, $width, $height, $crop ){
	
		$params = array();
		$params['type']   = $type;
		$params['path']   = $path;
		$params['width']  = $width;
		$params['height'] = $height;
		$params['crop']   = $crop;
		
		return otw_resize_media( $params );
	}
	
	private function renderPost( $item, $attributes ){
		
		$html = '';
		$postLink = get_permalink( $item->ID );
		
		
		switch( $attributes['template'] ){
		
			case 'wc':
					$html .= $this->renderPostImage( $item, $attributes, $postLink );
					
					//title
					$html .= $this->renderPostTitle( $item, $attributes, $postLink );
					
					//meta
					$html .= $this->renderPostMeta( $item, $attributes, $postLink );
					
					//content
					$html .= $this->renderPostContent( $item, $attributes, $postLink );
					
					//read more
					$html .= $this->renderPostReadMore( $item, $attributes, $postLink );
					
				break;
			case 'ba':
					$article_class = 'otw-post-archive';
					
					if( $this->format_attribute( '', 'show_image', $attributes ) != 'yes' ){
						$article_class .= ' otw-no-image';
					}
					$html .= '<article class="'.$article_class.'">';
					
					$html .= $this->renderPostImage( $item, $attributes, $postLink );
					
					$html .= '<div class="post-body">';
					
					//title
					$html .= $this->renderPostTitle( $item, $attributes, $postLink );
					
					//meta
					$html .= $this->renderPostMeta( $item, $attributes, $postLink );
					
					//content
					$html .= $this->renderPostContent( $item, $attributes, $postLink );
					
					//read more
					$html .= $this->renderPostReadMore( $item, $attributes, $postLink );
					
					$html .= '</div>';
					
					$html .= '</article>';
				break;
			default:
					$html .= '<article class="otw-sc-blog-post">';
					
					//title
					$html .= $this->renderPostTitle( $item, $attributes, $postLink );
					
					//meta
					$html .= $this->renderPostMeta( $item, $attributes, $postLink );
					
					//image
					$html .= $this->renderPostImage( $item, $attributes, $postLink );
					
					//content
					$html .= $this->renderPostContent( $item, $attributes, $postLink );
					
					//read more
					$html .= $this->renderPostReadMore( $item, $attributes, $postLink );
					
					$html .= '</article>';
			break;
		}
		
		return $html;
	}
	
	private function renderPager( $items, $attributes ){
		
		$html = '';
		
		if( $this->format_attribute( '', 'pager', $attributes, false, '' ) == 'yes' && isset( $items->query['paged'] ) && $items->query['paged'] ){
		
			$html .= '<div class="otw-row">';
			$html .= 	'<div class="otw-twentyfour otw-columns">';
			$html .= '<ul class="pagination">';
			
			if( $items->query['paged'] > 1 ){
				$html .= '<li class="prev">';
				$html .= 		'<a href="'.esc_url( add_query_arg( 'otwblpage', ( $items->query['paged'] - 1 ) ) ).'">&laquo '.$this->get_label('Previous').'</a>';
				$html .= '</li>';
			}
			if( isset( $items->max_num_pages ) && count( $items->max_num_pages ) ){
				for( $cP = 1; $cP <= $items->max_num_pages; $cP ++){
					
					$current_page = '';
					
					if( $cP == $items->query['paged'] ){
						$current_page = ' class="current"';
					}
					
					$html .= '<li'.$current_page.'>';
					$html .= 	'<a href="'.esc_url( add_query_arg( 'otwblpage', ( $cP ) ) ).'">'.$cP.'</a>';
					$html .= '</li>';
				}
				
				if( $items->query['paged'] < $items->max_num_pages ){
					$html .= '<li class="next">';
					$html .= 	'<a href="'.esc_url( add_query_arg( 'otwblpage', ( $items->query['paged'] + 1 ) ) ).'">'.$this->get_label('Next').' &raquo</a>';
					$html .= '</li>';
				}
			}
			$html .= '</ul>';
			
			$html .= 	'</div>';
			$html .= '</div>';
		}
		
		return $html;
	}
	
	public function renderPostTitle( $item, $attributes, $postLink ){
		$html = '';
		
		if( $this->format_attribute( '', 'show_title', $attributes ) == 'yes' ){
		
			switch( $attributes['template'] ){
				case 'wc':
						$html .= '<h4>';
								
								if( !empty($postLink) ){
									$html .= '<a href="'.$postLink.'" title="'.$item->post_title.'">'.$item->post_title.'</a>';
								}else{
									$html .= $item->post_title;
								}
						$html .= '</h4>';
					break;
				default:
						$html .= '<h3 class="post-title">';
								
								if( !empty($postLink) ){
									$html .= '<a href="'.$postLink.'" title="'.$item->post_title.'">'.$item->post_title.'</a>';
								}else{
									$html .= $item->post_title;
								}
						$html .= '</h3>';
					break;
			}
		}
		
		return $html;
	}
	
	public function renderPostMeta( $item, $attributes, $postLink ){
		
		$html = '';
		
		if( $this->format_attribute( '', 'show_meta', $attributes ) == 'yes' ){
			
			$html .= '<div class="post-meta">';
			
			$html .= '<span class="date">'.$this->get_label( 'Posted on' ).' <a href="'.get_day_link(get_the_time('Y', $item), get_the_time('m', $item), get_the_time('d', $item)).'" date-date="'.date('Y-m-d', strtotime($item->post_date)).'">'.date('d/m/Y', strtotime($item->post_date)).'</a></span>';
			if( isset( $item->post_author ) ){
				$html .= '&nbsp;<span class="author">'.$this->get_label( 'By' ).' <a href="'.get_author_posts_url( $item->post_author ).'" title="'.get_the_author_meta('display_name', $item->post_author).'">'.get_the_author_meta('display_name', $item->post_author).'</a></span>';
			}
			
			$catArray = wp_get_post_categories( $item->ID );
			
			if( is_array( $catArray ) ){
				
				$html .= '&nbsp;<span class="categories">'.$this->get_label( 'Categories' ).': ';
				
				foreach( $catArray as $index => $cat ){
					
					$category = get_category($cat);
					
					$catUrl = get_category_link( $category->term_id );
					
					$html .= '<a href="'.esc_url($catUrl).'" title="'.$this->get_label( 'View all posts in ' ).$category->name.'">'.$category->name.'</a>';
					
					if( $index < count( $catArray ) - 1 ){
						$html .= ', ';
					}
				}
				
				$html .= '</span>';
			}
			
			$tagsArray = wp_get_post_tags( $item->ID );
			
			if( is_array( $tagsArray ) && !empty($tagsArray[0]) ){
				
				$html .= '&nbsp;<span class="tags">'.$this->get_label( 'Tags' ).': ';
				
				foreach( $tagsArray as $index => $tag ){
					
					$tagUrl = get_tag_link( $tag->term_id );
					
					$html .= '<a href="'.$tagUrl.'">'.$tag->name.'</a>';
					
					if( $index < count( $tagsArray ) - 1 ){
						$html .= ', ';
					}
				}
				
				$html .= '</span>';
			}
			
			
			$html .= '&nbsp;<span class="bl_comments">'.$this->get_label( 'Comments' ).': <a href="'.get_comments_link($item->ID).'">'.$item->comment_count.'</a></span>';
			
			$html .= '</div>';
		}
		
		return $html;
	}
	
	public function renderPostContent( $item, $attributes, $postLink ){
		
		$html = '';
		
		if( $this->format_attribute( '', 'show_excerpt', $attributes ) == 'yes' ){
		
			switch( $attributes['template'] ){
				case 'wc':
						$html .= '<p>';
						
						if( !empty( $item->post_excerpt ) ){
							$postContent = $item->post_excerpt;
						}else{
							$postContent = $item->post_content;
						}
						
						if( $param_value =  $this->format_attribute( '', 'excerpt_words', $attributes ) ){
							if( intval( $param_value ) > 0 ){
								$postContent = $this->excerptLength( $postContent, $param_value );
							}
						}
						
						$html .= strip_tags($postContent);
						$html .= '</p>';
					break;
				default:
						$html .= '<div class="text">';
							$html .= '<p>';
							
							if( !empty( $item->post_excerpt ) ){
								$postContent = $item->post_excerpt;
							}else{
								$postContent = $item->post_content;
							}
							
							if( $param_value =  $this->format_attribute( '', 'excerpt_words', $attributes ) ){
								if( intval( $param_value ) > 0 ){
									$postContent = $this->excerptLength( $postContent, $param_value );
								}
							}
							
							$html .= strip_tags($postContent);
							$html .= '</p>';
						$html .= '</div>';
					break;
			}
		}
		
		return $html;
	}
	
	public function renderPostReadMore( $item, $attributes, $postLink ){
		
		$html = '';
		
		if( $this->format_attribute( '', 'show_read_more', $attributes ) == 'yes' ){
			$html .= '<div class="post-more">';
			
			if( !empty($postLink) ){
				$html .=	'<span class="read-more">';
				$html .=		'<a href="'.$postLink.'" title="'.$this->get_label( 'Read more' ).'">'.$this->get_label( 'Read more' ).'</a>';
				$html .=	'</span>';
			}
			
			$html .= '</div>';
		}
		
		return $html;
	}
	
	public function renderPostImage( $item, $attributes, $postLink ){
		
		$html = '';
		
		if( $this->format_attribute( '', 'show_image', $attributes ) == 'yes' ){
			if( $thumb = get_post_thumbnail_id( $item->ID ) ){
				
				$postAsset = parse_url( wp_get_attachment_url( get_post_thumbnail_id( $item->ID ) ) );
				
				if( is_array( $postAsset ) && isset( $postAsset['path'] ) && strlen( $postAsset['path'] ) ){
					
					$resized_image = '';
					
					switch( $attributes['template'] ){
						
						case 'b1c':
								$resized_image = $this->resize_media( 'img', $postAsset['path'], 700, 320, 'center_center' );
							break;
						case 'b2c':
								$resized_image = $this->resize_media( 'img', $postAsset['path'], 460, 220, 'center_center' );
							break;
						case 'b3c':
								$resized_image = $this->resize_media( 'img', $postAsset['path'], 300, 140, 'center_center' );
							break;
						case 'b4c':
								$resized_image = $this->resize_media( 'img', $postAsset['path'], 220, 152, 'center_center' );
							break;
						case 'ba':
								$resized_image = $this->resize_media( 'img', $postAsset['path'], 220, 170, 'center_center' );
							break;
						case 'wc':
								$resized_image = $this->resize_media( 'img', $postAsset['path'], 60, 60, 'center_center' );
							break;
					}
					
					if( $resized_image && strlen( $resized_image ) ){
						
						switch( $attributes['template'] ){
							case 'wc':
									$html .= '<a class="image" href="'.$postLink.'" title="">';
									$html .=	'<img src="'.$resized_image.'" alt="">';
									$html .=	'<span class="shadow-overlay hide-for-small"> </span>';
									$html .= '</a>';
								break;
							default:
									$html .= '<a class="animate-on-hover" href="'.$postLink.'" title="">';
									$html .=	'<div class="image-shadow-overlay">';
									$html .=		'<div class="image">';
									$html .=			'<img src="'.$resized_image.'" alt="">';
									$html .=			'<span class="shadow-overlay hide-for-small"> </span>';
									$html .=		'</div>';
									$html .=	'</div>';
									$html .= '</a>';
								break;
						}
					}
				}
			}
		}
		return $html;
	}
}
?>
