<?php
class OTW_Shortcode_About_Us extends OTW_Shortcodes{
	
	public function __construct(){
		
		$this->has_custom_options = true;
		
		parent::__construct();
	}
	
	
	/**
	 * register external libs
	 */
	public function register_external_libs(){
		
		$this->add_external_lib( 'css', 'otw-shortcode', $this->component_url.'css/otw_shortcode.css', 'all', 100 );
		
		$this->add_external_lib( 'js', 'otw-shortcode-core', $this->component_url.'js/otw_shortcode_core.js', 'all', 99, array( 'jquery' ) );
		$this->add_external_lib( 'js', 'otw-shortcode', $this->component_url.'js/otw_shortcode.js', 'front', 100 );
		$this->add_external_lib( 'js', 'otw-shortcode_live_preview', $this->component_url.'js/otw_shortcode_live_preview.js', 'live_preview', 200 );
	}
	
	/**
	 * apply settings
	 */
	public function apply_settings(){
		
		$this->settings = array(
			
		);
		
	}
	
	/**
	 * Shortcode admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		
		$html .= OTW_Form::uploader( array( 'id' => 'otw-shortcode-element-image_url', 'label' => $this->get_label( 'Image' ), 'description' => $this->get_label( 'Person image.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-link', 'label' => $this->get_label( 'Image URL' ), 'description' => $this->get_label( 'Person page.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-name', 'label' => $this->get_label( 'Name' ), 'description' => $this->get_label( 'Person name.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-position', 'label' => $this->get_label( 'Position' ), 'description' => $this->get_label( 'Person position – designer, developer, marketing, etc.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_area( array( 'id' => 'otw-shortcode-element-content', 'label' => $this->get_label( 'Text' ), 'description' => $this->get_label( 'Short description. HTML is allowed.' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/**
	 * Shortcode admin interface custom options
	 */
	public function build_shortcode_editor_custom_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-css_class', 'label' => $this->get_label( 'CSS Class' ), 'description' => $this->get_label( 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/** build shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_about_us';
			
			$code .= $this->format_attribute( 'image_url', 'image_url', $attributes );
			
			$code .= $this->format_attribute( 'link', 'link', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'name', 'name', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'position', 'position', $attributes );
			
			$code .= $this->format_attribute( 'css_class', 'css_class', $attributes, false, '', true  );
			
			$code .= ']';
			
			$code .= $attributes['content'];
			
			$code .= '[/otw_shortcode_about_us]';
		}
		
		return $code;

	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode( $attributes, $content ){
		
		$html = '<div';
		
		/*class attributes*/
		$class = 'otw-sc-about';
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		if( strlen( $class ) ){
			$html .= ' class="'.$class.'"';
		}
		/*end class attributes*/
		
		/*style attribute*/
		$style = '';
		
		if( strlen( $style ) ){
			$html .= ' style="'.$style.'"';
		}
		
		$html .= '>';
		
		$html .= '<a class="animate-on-hover" href="';
		
		if( $link = $this->format_attribute( '', 'link', $attributes, false, '' ) ){
			$html .= $link;
		}else{
			$html .= '#';
		}
		
		$html .= '">';
		
		
		$html .= '<div class="image">';
		
		if( $image_url = $this->format_attribute( '', 'image_url', $attributes, false, '' ) ){
			
			$html .= '<img src="'.$image_url.'" alt="'.$this->format_attribute( '', 'name', $attributes, false, '' ).'" title="'.$this->format_attribute( '', 'name', $attributes, false, '' ).'" />';
			$html .= '<span class="shadow-overlay hide-for-small"></span>';
		}
		
		$html .= '</div>';
		
		$html .= '</a>';
		
		$html .= '<div class="otw-sc-about-content">';
		
		
		$html .= '<h3 class="widget-title">'.$this->format_attribute( '', 'name', $attributes, false, '' ).'</h3>';
		
		if( $position = $this->format_attribute( '', 'position', $attributes, false, '' ) ){
			$html .= '<div class="work-position">'.$position.'</div>';
		}
		
		$html .= '<p>'.nl2br( $content ).'</p>';
		
		$html .= '</div>';
		
		$html .= '</div>';
		
		return $this->format_shortcode_output( $html );
	}
}