<?php
class OTW_Front_End_Grid_Manager extends OTW_Component{
	
	/**
	 * Name of the meta field
	 * 
	 * @var  string 
	 */
	public $meta_name = 'otw_grid_manager_content';
	
	
	/**
	 * Rreview shortcodes in the gird
	 */
	public $shortcode_preview_in_grid = false;
	
	/**
	 *  Activate in the front
	 */
	public $enabled = true;
	
	public function __construct(){
		
		if( !is_admin() && is_admin_bar_showing() ){
			add_action( 'admin_bar_menu', array( &$this, 'otw_admin_bar_menu' ), 1000 );
		}
	}
	
	private function process_requests(){
		
		if( isset( $_SERVER['HTTP_X_REQUESTED_WITH'] ) && isset( $_SERVER['HTTP_X_OTW_FEGR'] ) && $_SERVER['HTTP_X_OTW_FEGR'] == 1 && isset( $_POST['action'] ) ){
		
			switch( $_POST['action'] ){
			
				case 'replace_content':
						echo $this->replace_content();
						die;
					break;
				case 'publish_content':
						echo $this->publish_content();
						die;
					break;
			}
		}
	}
	
	public function publish_content(){
	
		$result = 'OK';
		
		if( isset( $_POST['post_id'] ) &&  $_POST['post_id'] && isset( $_POST['code'] ) ){
		
			update_post_meta( $_POST['post_id'], $this->meta_name, $_POST['code'] );
		}
		
		return $result;
	}
	public function replace_content(){
	
		$content = '';
		
		if( isset( $_POST['grid_id'] ) ){
			
			$post_id = 0;
			if( preg_match( "/^".$this->meta_name."_([0-9]+)$/", $_POST['grid_id'], $matches ) ){
				$post_id = $matches[1];
			}
			if( $post_id ){
			
				$current_code = get_post_meta( $post_id, $this->meta_name, TRUE );
				
				$templates = get_option( $this->meta_name.'_templates' );
				
				$js_templates = array();
				
				if( strlen( trim( $templates ) ) ){
					
					$templates_array = unserialize( $templates );
					
					if( is_array( $templates_array ) ){
					
						foreach( $templates_array as $template_key => $template ){
							$js_templates[] = array( $template_key, $template['name'] );
						}
					}
				}
				
				$content .= "<div id=\"otw_fge_".$this->meta_name."_container\" class=\"otw_fge_container\">";
				
				$content .= "\n<div id=\"otw_fge_".$this->meta_name."_preview\" class=\"otw_fge_content_preview\"></div>";
				$content .= "\n<input type=\"hidden\" id=\"otw_fge_".$this->meta_name."_code\" name=\"_otw_fge_".$this->meta_name."[code]\" value=\"".htmlentities( $current_code, ENT_QUOTES, "UTF-8")."\" />";
				$content .= "\n<input type=\"hidden\" id=\"otw_fge_".$this->meta_name."_item_id\" value=\"".$post_id."\" />";
				$content .= "\n<input type=\"hidden\" name=\"otw_fge_".$this->meta_name."_noncename\" value=\"" . wp_create_nonce(__FILE__) . "\" />";
				$content .= "\n<script type=\"text/javascript\">";
				$content .= "\njQuery(document).ready(function(){
					otw_grid_manager_".$this->meta_name." = new otw_front_grid_manager_object( '".$this->meta_name."', ".json_encode( $this->labels ).", ".json_encode( $js_templates ).", '".$this->shortcode_preview_in_grid ."', '".$this->component_url."', '".get_site_url()."/wp-admin/admin-ajax'  );";
				$content .= "\n});";
				$content .=  "\n</script>";
				
				$content .= "</div>";
				
				$content .= "</div>";
			}
		}
		
		return $content;
	}
	
	/**
	 *  Init 
	 */
	public function init(){
		
		
		if( !is_admin() ){
			
			wp_enqueue_script('otw_front_end_grid_manager', $this->component_url.'js/otw_front_end_grid_manager.js' , array( 'jquery', 'jquery-ui-sortable' ), $this->js_version );
			
			if(function_exists( 'wp_enqueue_media' )){
				wp_enqueue_media();
			}else{
				wp_enqueue_style('thickbox');
				wp_enqueue_script('media-upload');
				wp_enqueue_script('thickbox');
				wp_enqueue_script( 'tiny_mce' );
			}
			wp_enqueue_style( 'otw_front_end_grid_manager', $this->component_url.'css/otw_front_end_grid_manager.css', array( ), $this->css_version );
		}
		
		parent::init();
		
		$this->process_requests();
	}

	
	public function otw_admin_bar_menu(){
	
		if( !$this->enabled ){
			return;
		}
		
		if( !otw_is_grid_manager_content() ){
			return;
		}
		
		global $wp_admin_bar;
		
		$menu_class = '';
		
		if( otw_comprare_blog_version( '3.8.0' ) == -1 ){
			$menu_class = 'otw_with_icon';
		}
		
		$wp_admin_bar->add_menu( array(
			'id' => 'otw_front_end_grid_manager',
			'parent' => '',
			'title' => $this->get_label( 'Start OTW Front-end Grid Manager' ),
			'href' => 'javascript:;',
			// optional meta array
			'meta' => array(
				'onclick' => 'otw_load_front_end_grid_manager( this, "'.$this->get_label( 'Stop OTW Front-end Grid Manager' ).'" ); return false;',
				'html' => '',
				'class' => $menu_class,
				'target' => '',
				'title' => ''
			)
		) );
	}
}
