<?php
global $otw_cm_skins, $otw_cm_skins_path, $validate_messages;

$page_title = __( 'Create skin', 'otw_cm' );

$is_writable = otw_cm_skins_wirable( $otw_cm_skins_path );

$otw_skin_values = array();
$otw_skin_values['name'] = '';
$otw_skin_values['content'] = '';

$requested_skin = '';
if( isset( $_GET['skin'] ) && array_key_exists( $_GET['skin'], $otw_cm_skins ) && otw_cm_valid_skin_name( $_GET['skin'] ) ){
	$requested_skin = $_GET['skin'];
	$otw_skin_values['name'] = $_GET['skin'];
	$otw_skin_values['content'] = file_get_contents( $otw_cm_skins_path.$_GET['skin'].'.css' );
	$page_title = __( 'Edit skin', 'otw_cm' );
}

if( isset( $_POST['otw_skin_title'] ) ){
	$otw_skin_values['name'] = otw_stripslashes( $_POST['otw_skin_title'] );
}
if( isset( $_POST['otw_skin_content'] ) ){
	$otw_skin_values['content'] = otw_stripslashes( $_POST['otw_skin_content'] );
}
?>
<div class="wrap">
	<div id="icon-edit" class="icon32"><br/></div>
	<h2>
		<?php echo $page_title; ?>
		<a class="button add-new-h2" href="<?php echo admin_url( 'admin.php?page=otw-cm-skins' )?>" ><?php _e('Back To Available Skins', 'otw_cm')?></a>
	</h2>
	<?php if( isset( $validate_messages ) && count( $validate_messages ) ){?>
		<div id="message" class="error">
			<?php foreach( $validate_messages as $v_message ){
				echo '<p>'.$v_message.'</p>';
			}?>
		</div>
	<?php }?>
	<div class="form-wrap" id="poststuff">
		<?php include_once( 'otw_cm_help.php' );?>
		
		<?php if( !$is_writable ){ ?>
			<div id="message" class="error">
				<?php _e( 'The skin directory is not writable!!!<br />You will not be able to create/update/delete skins.', 'otw_cm')?>
			</div>
		<?php }else{?>
			<form method="post" action="" class="validate">
				<input type="hidden" name="otw_cm_action" value="manage_otw_cm_skin" />
				<input type="hidden" name="otw_skin_edit" value="<?php echo $requested_skin?>" />
				<?php wp_original_referer_field(true, 'previous'); wp_nonce_field('otw-cm-skin-manage'); ?>
				<div id="post-body">
					<div id="post-body-content">
						<div class="form-field form-required">
							<label for="otw_skin_title"><?php _e( 'Skin name', 'otw_cm' );?></label>
							<input type="text" id="otw_skin_title" value="<?php echo $otw_skin_values['name']?>" tabindex="1" style="width: 260px;" size="10" name="otw_skin_title"/>
							<p><?php _e( 'The name is your skin. Allowed chars are letters from a to z and \'_\' with length from 3 to 15 letters.', 'otw_cm' );?></p>
						</div>
						<div class="form-field">
							<label for="otw_skin_content"><?php _e( 'CSS content', 'otw_cm' )?></label>
							<textarea id="otw_skin_content" name="otw_skin_content" tabindex="4" rows="20" cols="10"><?php echo $otw_skin_values['content']?></textarea>
							<p><?php _e( 'CSS content of the skin.', 'otw_cm')?></p>
						</div>
						<p class="submit">
							<input type="submit" value="<?php _e( 'Save Skin', 'otw_cm') ?>" name="submit" class="button"/>
						</p>
					</div>
				</div>
			</form>
		<?php } ?>
	</div>
</div>
