<?php
global $otw_cm_skins, $otw_cm_skins_path, $validate_messages;

$page_title = __( 'Delete', 'otw_cm' );

$is_writable = otw_cm_skins_wirable( $otw_cm_skins_path );

$is_valid_skin = false;

$otw_skin_values = array();
$otw_skin_values['name'] = '';
$otw_skin_values['content'] = '';

if( isset( $_GET['skin'] ) && array_key_exists( $_GET['skin'], $otw_cm_skins ) && otw_cm_valid_skin_name( $_GET['skin'] ) ){
	$otw_skin_values['name'] = $_GET['skin'];
	$otw_skin_values['content'] = file_get_contents( $otw_cm_skins_path.$_GET['skin'].'.css' );
	$is_valid_skin = true;
}

?>
<div class="wrap">
	<div id="icon-edit" class="icon32"><br/></div>
	<h2>
		<?php echo $page_title; ?>
		<a class="button add-new-h2" href="<?php echo admin_url( 'admin.php?page=otw-cm-skins' )?>" ><?php _e('Back To Available Skins', 'otw_cm')?></a>
	</h2>
	<?php if( isset( $validate_messages ) && count( $validate_messages ) ){?>
		<div id="message" class="error">
			<?php foreach( $validate_messages as $v_message ){
				echo '<p>'.$v_message.'</p>';
			}?>
		</div>
	<?php }?>
	<div class="form-wrap" id="poststuff">
		<?php include_once( 'otw_cm_help.php' );?>
		
		<?php if( !$is_writable ){ ?>
			<div id="message" class="error">
				<?php _e( 'The skin directory is not writable!!!<br />You will not be able to create/update/delete skins.', 'otw_cm')?>
			</div>
		<?php }elseif( !$is_valid_skin ){ ?>
			<div id="message" class="error">
				<?php _e( 'Ivalid skin to delete.', 'otw_cm')?>
			</div>
		<?php }else{?>
			<form method="post" action="" class="validate">
				<input type="hidden" name="otw_cm_action" value="delete_otw_cm_skin" />
				<?php wp_original_referer_field(true, 'previous'); wp_nonce_field('otw-cm-skin-delete'); ?>
				<div id="post-body">
					<div id="post-body-content">
						<div class="form-field form-required">
							<input type="hidden" name="otw_skin_title" value="<?php echo $otw_skin_values['name']?>" />
							<p><?php _e( 'Please confirm to delete the skin \''.$otw_skin_values['name'].'\'.', 'otw_cm' );?></p>
						</div>
						<p class="submit">
							<input type="submit" value="<?php _e( 'Yes, delete it!', 'otw_cm') ?>" name="submit" class="button"/>
						</p>
					</div>
				</div>
			</form>
		<?php } ?>
	</div>
</div>
