<?php
global $validate_messages, $otw_import_shortcode_field_types, $_wp_column_headers;

$_wp_column_headers['toplevel_page_otw-cm-import-shortcodes'] = array(
	'name' => __( 'Option Name', 'otw_cm' ),
	'key' => __( 'Option Value', 'otw_cm' )
);

$page_title = __( 'Imported Shortcode Field Options', 'otw_cm' );

$otw_cm_import_shortcodes = get_option( 'otw_import_shortcodes' );

$otw_cm_import_shortcode_key = '';
$otw_cm_import_shortcode = false;

if( isset( $_GET['import_shortcode'] ) ){
	$otw_cm_import_shortcode_key = urldecode( $_GET['import_shortcode'] );
}

if( !is_array( $otw_cm_import_shortcodes ) ){
	$otw_cm_import_shortcodes = array();
}

if( isset( $otw_cm_import_shortcodes[ $otw_cm_import_shortcode_key ] ) ){
	$otw_cm_import_shortcode = $otw_cm_import_shortcodes[ $otw_cm_import_shortcode_key ];
}else{
	wp_die( __( 'Invalid imported shortcode', 'otw_cm' ) );
}

$requested_shortcode_field = '';
if( isset( $_GET['import_shortcode_field'] ) && array_key_exists( urldecode( $_GET['import_shortcode_field'] ), $otw_cm_import_shortcode['params'] ) ){
	$requested_shortcode_field = urldecode( $_GET['import_shortcode_field'] );
}

if( !$requested_shortcode_field ){
	wp_die( __( 'Invalid imported shortcode field', 'otw_cm' ) );
}

$otw_import_shortcode_field_option_values = array();
$otw_import_shortcode_field_option_values['key'] = '';
$otw_import_shortcode_field_option_values['name'] = '';

$requested_shortcode_field_option = '';
if( isset( $_GET['import_shortcode_field_option'] ) && array_key_exists( urldecode( $_GET['import_shortcode_field_option'] ), $otw_cm_import_shortcode['params'][ $requested_shortcode_field ]['options'] ) ){
	
	$requested_shortcode_field_option = urldecode( $_GET['import_shortcode_field_option'] );
	
	if( isset( $_GET['action'] ) && ( $_GET['action'] == 'delete' ) ){
		
		unset( $otw_cm_import_shortcode['params'][ $requested_shortcode_field ]['options'][ $requested_shortcode_field_option ] );
		unset( $otw_cm_import_shortcodes[ $otw_cm_import_shortcode_key ]['params'][ $requested_shortcode_field ]['options'][ $requested_shortcode_field_option ] );
		$requested_shortcode_field_option = '';
		update_option( 'otw_import_shortcodes', $otw_cm_import_shortcodes );
		$_GET['message'] = 2;
	}else{
		$otw_import_shortcode_field_option_values['key'] = $requested_shortcode_field_option;
		$otw_import_shortcode_field_option_values['name'] = $otw_cm_import_shortcode['params'][ $requested_shortcode_field ]['options'][ $requested_shortcode_field_option ];
		$page_title = __( 'Edit imported shortcode field option', 'otw_cm' );
	}
}

if( isset( $_POST['otw_import_shortcode_field_option_key'] ) ){
	$otw_import_shortcode_field_option_values['key'] = otw_stripslashes( $_POST['otw_import_shortcode_field_option_key'] );
}
if( isset( $_POST['otw_import_shortcode_field_option_name'] ) ){
	$otw_import_shortcode_field_option_values['name'] = otw_stripslashes( $_POST['otw_import_shortcode_field_option_name'] );
}
$message = '';
$massages = array();
$messages[1] = __( 'Option saved', 'otw_cm' );
$messages[2] = __( 'Option deleted', 'otw_cm' );

if( isset( $_GET['message'] ) && isset( $messages[ $_GET['message'] ] ) ){
	$message .= $messages[ $_GET['message'] ];
}
?>
<?php if ( $message ) : ?>
<div id="message" class="updated"><p><?php echo $message; ?></p></div>
<?php endif ?>
<div class="wrap">
	<div id="icon-edit" class="icon32"><br/></div>
	<h2>
		<?php echo $page_title; ?>
		<a class="button add-new-h2" href="<?php echo admin_url( 'admin.php?page=otw-cm-import-shortcodes-fields&import_shortcode='.$otw_cm_import_shortcode_key )?>" ><?php _e('Back To Available Imported Shortcodes Fields', 'otw_cm')?></a>
		<a class="button add-new-h2" href="admin.php?page=otw-cm-import-shortcodes"><?php _e('Back To Shortcodes', 'otw_cm') ?></a>
	</h2>
	<h3>
		<?php _e( 'Imported Shortcode:', 'otw_cm' )?> <?php echo $otw_cm_import_shortcode['title'];?>
	</h3>
	<?php if( isset( $validate_messages ) && count( $validate_messages ) ){?>
		<div id="message" class="error">
			<?php foreach( $validate_messages as $v_message ){
				echo '<p>'.$v_message.'</p>';
			}?>
		</div>
	<?php }?>
	<div id="poststuff">
		<?php include_once( 'otw_cm_help.php' );?>
		
		<form method="post" action="" class="validate">
			<input type="hidden" name="otw_cm_action" value="manage_otw_cm_import_shortcode_field_option" />
			<input type="hidden" name="otw_import_shortcode_field_option_edit" value="<?php echo $requested_shortcode_field_option?>" />
			<?php wp_original_referer_field(true, 'previous'); wp_nonce_field( 'otw_import_shortcode_field_option_edit' ); ?>
			<div id="post-body">
				<div id="post-body-content">
					<fieldset>
						<label for="otw_import_shortcode_field_option_key"><?php _e( 'Option value', 'otw_cm' );?></label>
						<input type="text" id="otw_import_shortcode_field_option_key" value="<?php echo $otw_import_shortcode_field_option_values['key']?>" tabindex="1" style="width: 140px;" size="100" name="otw_import_shortcode_field_option_key"/>
						<label for="otw_import_shortcode_field_option_name"><?php _e( 'Option name', 'otw_cm' );?></label>
						<input type="text" id="otw_import_shortcode_field_option_name" value="<?php echo $otw_import_shortcode_field_option_values['name']?>" tabindex="2" style="width: 140px;" size="100" name="otw_import_shortcode_field_option_name"/>
						
						<input type="submit" value="<?php ( $requested_shortcode_field_option )?_e( 'Update option', 'otw_cm'):_e( 'Add Option', 'otw_cm') ?>" name="submit" tabindex="3" class="button"/>
					</fieldset>
				</div>
			</div>
		</form>
		
		<br class="clear" />
		<br class="clear" />
		<?php if( isset( $otw_cm_import_shortcode['params'][ $requested_shortcode_field ]['options'] ) && is_array( $otw_cm_import_shortcode['params'][ $requested_shortcode_field ]['options'] ) && count( $otw_cm_import_shortcode['params'][ $requested_shortcode_field ]['options'] ) ){?>
			<table class="widefat fixed" cellspacing="0">
				<thead>
					<tr>
						<?php foreach( $_wp_column_headers['toplevel_page_otw-cm-import-shortcodes'] as $key => $name ){?>
							<th><?php echo $name?></th>
						<?php }?>
					</tr>
				</thead>
				<tfoot>
					<tr>
						<?php foreach( $_wp_column_headers['toplevel_page_otw-cm-import-shortcodes'] as $key => $name ){?>
							<th><?php echo $name?></th>
						<?php }?>
					</tr>
				</tfoot>
				<tbody>
				<?php foreach( $otw_cm_import_shortcode['params'][ $requested_shortcode_field ]['options'] as $option_key => $option_value ){?>
					<tr>
						<?php foreach( $_wp_column_headers['toplevel_page_otw-cm-import-shortcodes'] as $column_name => $column_title ){
							
							$edit_link = admin_url( 'admin.php?page=otw-cm-import-shortcodes-fields-options&amp;action=edit&amp;import_shortcode='.urlencode( $otw_cm_import_shortcode_key ).'&amp;import_shortcode_field='.urlencode( $requested_shortcode_field ).'&amp;import_shortcode_field_option='.urlencode( $option_key ) );
							$delete_link = admin_url( 'admin.php?page=otw-cm-import-shortcodes-fields-options&amp;action=delete&amp;import_shortcode='.urlencode( $otw_cm_import_shortcode_key ).'&amp;import_shortcode_field='.urlencode( $requested_shortcode_field ).'&amp;import_shortcode_field_option='.urlencode( $option_key ) );
							
							switch($column_name) {
							
								case 'name':
									
										echo '<td><strong><a href="'.$edit_link.'" title="'.esc_attr(sprintf(__('Edit &#8220;%s&#8221;', 'otw_cm'), $option_value)).'">'.$option_value.'</a></strong><br />';
										
										echo '<div class="row-actions">';
										echo '<a href="'.$edit_link.'">' . __('Edit', 'otw_cm') . '</a>';
										echo ' | <a href="'.$delete_link.'">' . __('Delete', 'otw_cm'). '</a>';
										
										echo '</div>';
										
										echo '</td>';
									break;
								case 'key':
										echo '<td>'.$option_key.'</td>';
									break;
							}
						?>
						
						<?php }?>
					</tr>
				<?php }?>
				</tbody>
			</table>
			
		<?php }else{ ?>
			<p><?php _e('No custom fields for this shortcode found.', 'otw_cm' )?></p>
		<?php } ?>

	</div>
	
</div>
