<?php
global $validate_messages, $otw_import_shortcode_field_types;

$page_title = __( 'Add Imported Shortcode Field', 'otw_cm' );

$otw_cm_import_shortcodes = get_option( 'otw_import_shortcodes' );

$otw_cm_import_shortcode_key = '';
$otw_cm_import_shortcode = false;

if( isset( $_GET['import_shortcode'] ) ){
	$otw_cm_import_shortcode_key = urldecode( $_GET['import_shortcode'] );
}


if( !is_array( $otw_cm_import_shortcodes ) ){
	$otw_cm_import_shortcodes = array();
}

if( isset( $otw_cm_import_shortcodes[ $otw_cm_import_shortcode_key ] ) ){
	$otw_cm_import_shortcode = $otw_cm_import_shortcodes[ $otw_cm_import_shortcode_key ];
}else{
	wp_die( __( 'Invalid imported shortcode', 'otw_cm' ) );
}


$otw_import_shortcode_field_values = array();
$otw_import_shortcode_field_values['key'] = '';
$otw_import_shortcode_field_values['name'] = '';
$otw_import_shortcode_field_values['description'] = '';
$otw_import_shortcode_field_values['type'] = '';
$otw_import_shortcode_field_values['default_value'] = '';
$otw_import_shortcode_field_values['options'] = '';

$requested_shortcode_field = '';
if( isset( $_GET['import_shortcode_field'] ) && array_key_exists( urldecode( $_GET['import_shortcode_field'] ), $otw_cm_import_shortcode['params'] ) ){
	$requested_shortcode_field = urldecode( $_GET['import_shortcode_field'] );
	
	$otw_import_shortcode_field_values['key'] = $requested_shortcode_field;
	$otw_import_shortcode_field_values['name'] = $otw_cm_import_shortcode['params'][ $requested_shortcode_field ]['name'];
	$otw_import_shortcode_field_values['description'] = $otw_cm_import_shortcode['params'][ $requested_shortcode_field ]['description'];
	$otw_import_shortcode_field_values['type'] = $otw_cm_import_shortcode['params'][ $requested_shortcode_field ]['type'];
	$otw_import_shortcode_field_values['default_value'] = $otw_cm_import_shortcode['params'][ $requested_shortcode_field ]['default_value'];
	$page_title = __( 'Edit imported shortcode field', 'otw_cm' );
}

if( isset( $_POST['otw_import_shortcode_field_key'] ) ){
	$otw_import_shortcode_field_values['key'] = otw_stripslashes( $_POST['otw_import_shortcode_field_key'] );
}
if( isset( $_POST['otw_import_shortcode_field_name'] ) ){
	$otw_import_shortcode_field_values['name'] = otw_stripslashes( $_POST['otw_import_shortcode_field_name'] );
}
if( isset( $_POST['otw_import_shortcode_field_description'] ) ){
	$otw_import_shortcode_field_values['description'] = otw_stripslashes( $_POST['otw_import_shortcode_field_description'] );
}
if( isset( $_POST['otw_import_shortcode_field_type'] ) ){
	$otw_import_shortcode_field_values['type'] = otw_stripslashes( $_POST['otw_import_shortcode_field_type'] );
}
if( isset( $_POST['otw_import_shortcode_field_default_value'] ) ){
	$otw_import_shortcode_field_values['default_value'] = otw_stripslashes( $_POST['otw_import_shortcode_field_default_value'] );
}
?>
<div class="wrap">
	<div id="icon-edit" class="icon32"><br/></div>
	<h2>
		<?php echo $page_title; ?>
		<a class="button add-new-h2" href="<?php echo admin_url( 'admin.php?page=otw-cm-import-shortcodes-fields&import_shortcode='.$otw_cm_import_shortcode_key )?>" ><?php _e('Back To Available Imported Shortcodes Fields', 'otw_cm')?></a>
		<a class="button add-new-h2" href="admin.php?page=otw-cm-import-shortcodes"><?php _e('Back To Shortcodes', 'otw_cm') ?></a>
	</h2>
	<h3>
		<?php _e( 'Imported Shortcode:', 'otw_cm' )?> <?php echo $otw_cm_import_shortcode['title'];?>
	</h3>
	<?php if( isset( $validate_messages ) && count( $validate_messages ) ){?>
		<div id="message" class="error">
			<?php foreach( $validate_messages as $v_message ){
				echo '<p>'.$v_message.'</p>';
			}?>
		</div>
	<?php }?>
	<div class="form-wrap" id="poststuff">
		<?php include_once( 'otw_cm_help.php' );?>
		
		<form method="post" action="" class="validate">
			<input type="hidden" name="otw_cm_action" value="manage_otw_cm_import_shortcode_field" />
			<input type="hidden" name="otw_import_shortcode_field_edit" value="<?php echo $requested_shortcode_field?>" />
			<?php wp_original_referer_field(true, 'previous'); wp_nonce_field('otw-cm-import-shortcodes-fields-manage'); ?>
			<div id="post-body">
				<div id="post-body-content">
					<div class="form-field form-required">
						<label for="otw_import_shortcode_field_key"><?php _e( 'Field key', 'otw_cm' );?></label>
						<input type="text" id="otw_import_shortcode_field_key" value="<?php echo $otw_import_shortcode_field_values['key']?>" tabindex="1" style="width: 460px;" size="100" name="otw_import_shortcode_field_key"/>
						<p><?php _e( 'Add the field key. This will be used for parameter of the shortcode', 'otw_cm' );?></p>
					</div>
					<div class="form-field form-required">
						<label for="otw_import_shortcode_field_name"><?php _e( 'Field name', 'otw_cm' );?></label>
						<input type="text" id="otw_import_shortcode_field_name" value="<?php echo $otw_import_shortcode_field_values['name']?>" tabindex="2" style="width: 460px;" size="100" name="otw_import_shortcode_field_name"/>
						<p><?php _e( 'Add the name of your field. This name displayed in the interface.', 'otw_cm' );?></p>
					</div>
					<div class="form-field form-required">
						<label for="otw_import_shortcode_field_description"><?php _e( 'Field description', 'otw_cm' );?></label>
						<input type="text" id="otw_import_shortcode_field_description" value="<?php echo $otw_import_shortcode_field_values['description']?>" tabindex="3" style="width: 560px;" size="100" name="otw_import_shortcode_field_description"/>
						<p><?php _e( 'Add the description of your field. This name displayed in the interface.', 'otw_cm' );?></p>
					</div>
					<div class="form-field form-required">
						<label for="otw_import_shortcode_field_type"><?php _e( 'Field type', 'otw_cm' );?></label>
						<select type="text" id="otw_import_shortcode_field_type" tabindex="4" name="otw_import_shortcode_field_type">
							<?php foreach( $otw_import_shortcode_field_types as $field_type => $field_name ){?>
								<option value="<?php echo $field_type?>"<?php echo ( $otw_import_shortcode_field_values['type'] == $field_type )?' selected="selected"':'' ?>><?php echo $field_name?></option>
							<?php }?>
						</select>
						<p><?php _e( 'Field type.', 'otw_cm' );?></p>
					</div>
					<div class="form-field form-required">
						<label for="otw_import_shortcode_field_default_value"><?php _e( 'Field default value', 'otw_cm' );?></label>
						<input type="text" id="otw_import_shortcode_field_default_value" value="<?php echo $otw_import_shortcode_field_values['default_value']?>" tabindex="5" style="width: 160px;" size="100" name="otw_import_shortcode_field_default_value"/>
						<p><?php _e( 'Add the description of your field. This name displayed in the interface.', 'otw_cm' );?></p>
					</div>
					<p class="submit">
						<input type="submit" value="<?php _e( 'Save', 'otw_cm') ?>" name="submit" tabindex="6" class="button"/>
					</p>
				</div>
			</div>
		</form>
	</div>
</div>
