<?php
global $validate_messages, $otw_import_shortcode_field_types;

$page_title = __( 'Delete Imported Shortcode Field', 'otw_cm' );

$otw_cm_import_shortcodes = get_option( 'otw_import_shortcodes' );

$otw_cm_import_shortcode_key = '';
$otw_cm_import_shortcode = false;

if( isset( $_GET['import_shortcode'] ) ){
	$otw_cm_import_shortcode_key = urldecode( $_GET['import_shortcode'] );
}


if( !is_array( $otw_cm_import_shortcodes ) ){
	$otw_cm_import_shortcodes = array();
}

if( isset( $otw_cm_import_shortcodes[ $otw_cm_import_shortcode_key ] ) ){
	$otw_cm_import_shortcode = $otw_cm_import_shortcodes[ $otw_cm_import_shortcode_key ];
}else{
	wp_die( __( 'Invalid imported shortcode', 'otw_cm' ) );
}

$otw_import_shortcode_field_values = array();
$otw_import_shortcode_field_values['key'] = '';
$otw_import_shortcode_field_values['name'] = '';
$otw_import_shortcode_field_values['description'] = '';
$otw_import_shortcode_field_values['type'] = '';
$otw_import_shortcode_field_values['default_value'] = '';
$otw_import_shortcode_field_values['options'] = '';

$requested_shortcode_field = '';
if( isset( $_GET['import_shortcode_field'] ) && array_key_exists( urldecode( $_GET['import_shortcode_field'] ), $otw_cm_import_shortcode['params'] ) ){
	$requested_shortcode_field = urldecode( $_GET['import_shortcode_field'] );
	
	$otw_import_shortcode_field_values['key'] = $requested_shortcode_field;
	$otw_import_shortcode_field_values['name'] = $otw_cm_import_shortcode['params'][ $requested_shortcode_field ]['name'];
	$otw_import_shortcode_field_values['description'] = $otw_cm_import_shortcode['params'][ $requested_shortcode_field ]['description'];
	$otw_import_shortcode_field_values['type'] = $otw_cm_import_shortcode['params'][ $requested_shortcode_field ]['type'];
	$otw_import_shortcode_field_values['default_value'] = $otw_cm_import_shortcode['params'][ $requested_shortcode_field ]['default_value'];
}else{
	wp_die( __( 'Invalid imported shortcode field', 'otw_cm' ) );
}

?>
<div class="wrap">
	<div id="icon-edit" class="icon32"><br/></div>
	<h2>
		<?php echo $page_title; ?>
		<a class="button add-new-h2" href="<?php echo admin_url( 'admin.php?page=otw-cm-import-shortcodes-fields&import_shortcode='.$otw_cm_import_shortcode_key )?>" ><?php _e('Back To Available Imported Shortcodes Fields', 'otw_cm')?></a>
		<a class="button add-new-h2" href="admin.php?page=otw-cm-import-shortcodes"><?php _e('Back To Shortcodes', 'otw_cm') ?></a>
	</h2>
	<h3>
		<?php _e( 'Imported Shortcode:', 'otw_cm' )?> <?php echo $otw_cm_import_shortcode['title'];?>
	</h3>
	<?php if( isset( $validate_messages ) && count( $validate_messages ) ){?>
		<div id="message" class="error">
			<?php foreach( $validate_messages as $v_message ){
				echo '<p>'.$v_message.'</p>';
			}?>
		</div>
	<?php }?>
	<div class="form-wrap" id="poststuff">
		<?php include_once( 'otw_cm_help.php' );?>
		
		<form method="post" action="" class="validate">
			<input type="hidden" name="otw_cm_action" value="delete_otw_cm_import_shortcode_field" />
			<?php wp_original_referer_field(true, 'previous'); wp_nonce_field('otw-cm-import-shortcode-field-delete'); ?>
			<div id="post-body">
				<div id="post-body-content">
					<div class="form-field form-required">
						<input type="hidden" name="otw_import_shortcode_field_key" value="<?php echo $otw_import_shortcode_field_values['key']?>" />
						<p><?php _e( 'Please confirm to delete the the imported shortcode field \''.$otw_import_shortcode_field_values['name'].'\'.', 'otw_cm' );?></p>
					</div>
					<p class="submit">
						<input type="submit" value="<?php _e( 'Yes, delete it!', 'otw_cm') ?>" name="submit" class="button"/>
					</p>
				</div>
			</div>
		</form>
	</div>
</div>
