<?php
global $validate_messages, $otw_custom_shortcode_field_types;

$page_title = __( 'Add Custom Shortcode', 'otw_cm' );

$otw_cm_custom_shortcodes = get_option( 'otw_custom_shortcodes' );


if( !is_array( $otw_cm_custom_shortcodes ) || !isset( $otw_cm_custom_shortcodes['index'] ) || !isset( $otw_cm_custom_shortcodes['shortcodes'] ) ){
	$otw_cm_custom_shortcodes = array();
	$otw_cm_custom_shortcodes['index'] = 0;
	$otw_cm_custom_shortcodes['shortcodes'] = array();
}

$otw_custom_shortcode_values = array();
$otw_custom_shortcode_values['name'] = '';
$otw_custom_shortcode_values['code'] = '';

$requested_shortcode = '';
if( isset( $_GET['custom_shortcode'] ) && array_key_exists( urldecode( $_GET['custom_shortcode'] ), $otw_cm_custom_shortcodes['shortcodes'] ) ){
	$requested_shortcode = urldecode( $_GET['custom_shortcode'] );
	$otw_custom_shortcode_values['key'] = urldecode( $_GET['custom_shortcode'] );
	$otw_custom_shortcode_values['name'] = $otw_cm_custom_shortcodes['shortcodes'][ urldecode( $_GET['custom_shortcode'] ) ]['title'];
	$otw_custom_shortcode_values['code'] = $otw_cm_custom_shortcodes['shortcodes'][ urldecode( $_GET['custom_shortcode'] ) ]['code'];
	$page_title = __( 'Edit custom shortcode', 'otw_cm' );
}
if( isset( $_POST['otw_custom_shortcode_title'] ) ){
	$otw_custom_shortcode_values['name'] = otw_stripslashes( $_POST['otw_custom_shortcode_title'] );
	$otw_custom_shortcode_values['code'] = otw_stripslashes( $_POST['otw_cm_custom_shortcode_code'] );
}
?>
<div class="wrap">
	<div id="icon-edit" class="icon32"><br/></div>
	<h2>
		<?php echo $page_title; ?>
		<a class="button add-new-h2" href="<?php echo admin_url( 'admin.php?page=otw-cm-custom-shortcodes' )?>" ><?php _e('Back to available custom shortcodes', 'otw_cm')?></a>
	</h2>
	<?php if( isset( $validate_messages ) && count( $validate_messages ) ){?>
		<div id="message" class="error">
			<?php foreach( $validate_messages as $v_message ){
				echo '<p>'.$v_message.'</p>';
			}?>
		</div>
	<?php }?>
	<div class="form-wrap" id="poststuff">
		<?php include_once( 'otw_cm_help.php' );?>
		<div class="updated">
			<p><?php _e( 'Choose the label and the controls for your custom shortcode. The controls can be rearranged easily - drag & drop interface.', 'otw_cm' );?></p>
		</div>
		<form method="post" action="" class="validate" id="otw_custom_shortcodes_form">
			<input type="hidden" name="otw_cm_action" value="manage_otw_cm_custom_shortcode" />
			<input type="hidden" name="otw_custom_shortcode_edit" value="<?php echo $requested_shortcode?>" />
			<input type="hidden" id="otw_cm_custom_shortcode_code" name="otw_cm_custom_shortcode_code" value="<?php echo htmlentities( $otw_custom_shortcode_values['code'], ENT_QUOTES, "UTF-8")?>" />
			<?php wp_original_referer_field(true, 'previous'); wp_nonce_field('otw-cm-custom-shortcodes-manage'); ?>
			<div id="post-body">
				<div id="post-body-content">
					<div id="col-right" style="width: 35%;">
						<div class="form-field form-required">
							<label for="otw_custom_shortcode_title"><?php _e( 'Control type', 'otw_cm' );?></label>
							<select id="custom_shortcode_field_type">
								<?php foreach( $otw_custom_shortcode_field_types as $field_type => $field_name ){?>
									<option value="<?php echo $field_type; ?>"><?php echo $field_name; ?></option>
								<?php }?>
							</select>
							<p class="submit">
								<a class="button" id="add_control" href="javascript:;"><?php _e( 'Add This Control', 'otw_cm') ?></a>
							</p>
						</div>
					</div>
					<div id="col-left" style="width: 65%;">
						<div class="form-field form-required">
							<label for="otw_custom_shortcode_title"><?php _e( 'Shortcode label', 'otw_cm' );?></label>
							<input type="text" id="otw_custom_shortcode_title" value="<?php echo $otw_custom_shortcode_values['name']?>" tabindex="1" style="width: 460px;" size="100" name="otw_custom_shortcode_title"/>
							<p><?php _e( 'The label is how you are going to see your shortcode in the OTW interface.', 'otw_cm' );?></p>
						</div>
						<div class="form-field form-required">
							<div id="otw_custom_shortcode_fields"></div>
						</div>
						<p class="submit">
							<input type="submit" value="<?php _e( 'Save', 'otw_cm') ?>" name="submit" class="button" id="otw_save_custom_shortcodes" tabindex="4"/>
						</p>
					</div>
				</div>
			</div>
		</form>
	</div>
</div>
