<?php
if( !function_exists( 'otw_cm_register_portfolio_custom_types' ) ){
	
	function otw_cm_register_portfolio_custom_types(){
		
		global $otw_cm_plugin_url;
		
		$portfolio_post_type = 'otw_cm_portfolio';
		$portfolio_taxonomy  = 'otw_cm_portfolio_category';
		
		if( !taxonomy_exists( $portfolio_taxonomy ) ){
			
			$labels = array(
				'name' => _x( 'CM Portfolio Categories', '','otw_cm' ),
				'singular_name' => _x( 'CM Portfolio Category', '', 'otw_cm' ),
				'search_items' =>  __( 'Search CM Portfolio Category', 'otw_cm' ),
				'all_items' => __( 'All CM Portfolio Category', 'otw_cm' ),
				'parent_item' => __( 'Parent CM Portfolio Category', 'otw_cm' ),
				'parent_item_colon' => __( 'Parent CM Portfolio Category:', 'otw_cm' ),
				'edit_item' => __( 'Edit CM Portfolio Category', 'otw_cm' ),
				'update_item' => __( 'Update CM Portfolio Category', 'otw_cm' ),
				'add_new_item' => __( 'Add New CM Portfolio Category', 'otw_cm' ),
				'new_item_name' => __( 'New CM Portfolio Category Name', 'otw_cm' ),
				'menu_name' => __( 'CM Portfolio Categories', 'otw_cm' )
			);
			
			$args = array(
				'hierarchical' => false,
				'labels' => $labels,
				'poblic' => true,
				'publicly_queryable' => true,
				'show_ui' => true,
				'exclude_from_search' => false,
				'query_var' => true,
				'has_archive'       =>  true,
				'rewrite' => 1
			);
			
			$otw_cm_plugin_options = get_option( 'otw_cm_plugin_options' );
			
			if( isset( $otw_cm_plugin_options['otw_cm_portfolio_tax_slug'] ) && strlen( trim( $otw_cm_plugin_options['otw_cm_portfolio_tax_slug'] ) ) ){
				$args['rewrite'] = array( 'slug' => $otw_cm_plugin_options['otw_cm_portfolio_tax_slug'] );
			}
			
			register_taxonomy( $portfolio_taxonomy , array( $portfolio_post_type ), $args );
		}
		
		
		if( !post_type_exists( $portfolio_post_type ) ){
			
			$labels = array(
				'name' => _x( 'CM Portfolio', 'post type general name', 'otw_cm' ),
				'singular_name' => _x( 'CM Portfolio Item', 'post type singular name', 'otw_cm' ),
				'add_new' => _x( 'Add New', 'slide', 'otw_cm' ),
				'add_new_item' => __( 'Add New CM Portfolio Item', 'otw_cm' ),
				'edit_item' => __( 'Edit CM Portfolio Item', 'otw_cm' ),
				'new_item' => __( 'New CM Portfolio Item', 'otw_cm' ),
				'view_item' => __( 'View CM Portfolio Item', 'otw_cm' ),
				'search_items' => __( 'Search CM Portfolio Items', 'otw_cm' ),
				'not_found' =>  __( 'No CM portfolio items found', 'otw_cm' ),
				'not_found_in_trash' => __( 'No CM portfolio items found in Trash', 'otw_cm' ), 
				'parent_item_colon' => ''
			);
			
			$args = array(
				'labels' => $labels,
				'public' => true,
				'publicly_queryable' => true,
				'show_ui' => true,
				'query_var' => true,
				'rewrite' => true,
				'capability_type' => 'post',
				'hierarchical' => false,
				'menu_icon' => $otw_cm_plugin_url . '/images/otw-sbm-icon.png',
				'menu_position' => null, 
				'has_archive' => true, 
				'taxonomies' => array( $portfolio_taxonomy ), 
				'supports' => array( 'title','editor','excerpt' )
			);
			
			$otw_cm_plugin_options = get_option( 'otw_cm_plugin_options' );
			
			if( isset( $otw_cm_plugin_options['otw_cm_portfolio_slug'] ) && strlen( trim( $otw_cm_plugin_options['otw_cm_portfolio_slug'] ) ) ){
				
				$args['rewrite'] = array( 'slug' => $otw_cm_plugin_options['otw_cm_portfolio_slug'] );
			}
			
			register_post_type( $portfolio_post_type, $args );
		}
	}
}

if( !function_exists( 'otw_cm_flush_rewrites' ) ){
	
	function otw_cm_flush_rewrites(){
		otw_cm_register_portfolio_custom_types();
		flush_rewrite_rules();
	}
}

function otw_cm_portfolio_template( $single ){
	global $post;
	
	if( isset( $post ) && isset( $post->post_type ) && ( $post->post_type == 'otw_cm_portfolio' ) ){
		return plugin_dir_path( __FILE__ ).'otw_cm_single_portfolio_template.php';
	}
	
	return $single;
}
?>