= v160709 =

- **Bug Fix** (Pro): Fixed a bug in the Auto-Cache Engine that was introduced by the previous release (v160706). The bug produced an error whenever the Auto-Cache Engine ran: "PHP Fatal error: Call to undefined method applyWpFilters()". This had no visible affect on the front-end of the site or in the WordPress Dashboard, but it prevented the Auto-Cache Engine from working behind the scenes. Props @Peter-FB for reporting. See [Issue #795](https://github.com/websharks/comet-cache/issues/795).

= v160706 =

- **New Feature! Apache Optimizations.** This release includes a completely new option panel for Apache Performance Tuning. Current options for Apache tuning include GZIP Compression, Leverage Browser Caching, Enforce Canonical URLs, and Send Access-Control-Allow-Origin Header (for Static CDN Filters). These options automatically add or remove from your `.htaccess` file the appropriate configuration based on the options you enable or disable (all options are disabled by default, so your `.htaccess` file is not modified unless you say so). If you prefer to update your `.htaccess` file manually, the necessary configuration can be viewed beneath each option. Props @jaswsinc, @renzms. See [Issue #789](https://github.com/websharks/comet-cache/issues/789).
- **New Feature!** A new "Enable GZIP Compression" option has been added to the new Apache Optimizations panel. This option will automatically add the appropriate configuration to your `.htaccess` file to enable GZIP compression. This option is disabled by default. The old "GZIP Compression" panel has been removed in favor of the new option inside Apache Optimizations. Props @renzms, @jaswsinc. See [Issue #764](https://github.com/websharks/comet-cache/issues/764).
- **New Feature!** Multisite Host Exclusion Patterns. It's now possible to exclude entire sites from the cache in a Multisite Network environment. Domain mapping is also supported! See _Comet Cache → Plugin Options → Host Exclusion Patterns_. If you're running a Multisite Network with Sub-Directories, you can exclude sites using the existing URI Exclusion Patterns feature. Props @kristineds. See [Issue #754](https://github.com/websharks/comet-cache/issues/754).
- **New Feature (Pro)!** A new "Leverage Browser Caching" option has been added to the new Apache Optimizations panel. This option will automatically add the appropriate configuration to your `.htaccess` file to enable Browser Caching. This option is disabled by default. Props @renzms, @jaswsinc. See [Issue #764](https://github.com/websharks/comet-cache/issues/764).
- **New Feature (Pro)!** A new "Enforce Canonical URLs" option has been added to the new Apache Optimizations panel. This options adds the appropriate `.htaccess` code to enforce the correct canonical URLs according to your WordPress Permalink settings (Comet Cache detects if the Permalink Structure ends with a trailing slash, or without a trailing slash). Props @renzms, @jaswsinc. See [Issue #554](https://github.com/websharks/comet-cache/issues/554).
- **Bug Fix**: In some scenarios the Cron Event that cleans up expired cache files (`_cron_comet_cache_cleanup`) would never run, or the Next Run time would constantly reset to 1 minute away from running every time a page was reloaded. We suspect this is a race condition and in attempt to work around this issue we now skip all of our Cron-related checks if Cron is currently in the middle of running a process. Props @xberg and @lkraav for help reporting. See [Issue #653](https://github.com/websharks/comet-cache/issues/653).
- **Bug Fix**: If your site uses aliased domains, Comet Cache now properly considers all possible domain variations when it clears the cache on WP Standard installations. Props @kristineds, @jaswsinc, @yoffe, and @VR51. See [Issue #608](https://github.com/websharks/comet-cache/issues/608).
- **Bug Fix** (Pro): Fixed a bug where Comet Cache would appear to prevent WordPress from redirecting Permalinks that don't include a trailing slash, to the URL that does include a trailing slash. This was due to the fact that Comet Cache loads very early on (for caching purposes) and as a result the WordPress `redirect_canonical()` function never gets run. This was fixed by adding an option to the new Apache Optimizations panel that allows you to Enforce Canonical URLs. Props @renzms, @jaswsinc. See [Issue #554](https://github.com/websharks/comet-cache/issues/554).
- **UX Bug Fix** (Pro): If you had your WordPress Dashboard login details saved by your browser, the browser autofill would automatically fill in the Pro Plugin Updater fields with those details, which then needed to be replaced with your actual Pro license details. The browser autofill has been disabled for those fields (tested in Chrome, Firefox, and Safari). Props @renzms. See [Issue #741](https://github.com/websharks/comet-cache/issues/741).
- **Enhancement**: Added links the Options Page for the Comet Cache [Twitter](http://twitter.com/cometcache) and [Facebook](http://facebook.com/cometcache) accounts. Props @renzms. [Issue #771](https://github.com/websharks/comet-cache/issues/771).
- **Enhancement:** Added full support for UTF-8 (multibyte strings). This release adds full support for UTF-8 throughout the Comet Cache codebase, greatly enhancing Comet Cache's ability to deal with file paths and URLs that may contain UTF-8 characters. Props @jaswsinc. [Issue #703](https://github.com/websharks/comet-cache/issues/703).
- **UI Enhancements**: Improved the Logged-In Users and the Client-Side Caching options panels to dim additional options when the feature is disabled. Additionally, the "Enable HTML Compression for Logged-In Users?" option has been relocated from the HTML Compressor option panel to the more appropriate Logged-In Users option panel. See [Issue #768](https://github.com/websharks/comet-cache/issues/768).
- **UX Enhancement**: Improved the inline docs for Auto-Clear List of Custom URLs to clarify that full URLs must be provided. Props @renzms. See [Issue #781](https://github.com/websharks/comet-cache/issues/781).
- **Enhancement** (Pro): The Pro Plugin Updater has been improved to allow for better compatibility with hosting platforms that use Apache's ModSecurity. In some cases, site owners were seeing a 404 error when attempting to update the Pro version using the Pro Plugin updater because certain ModSecurity rules were blocking the Pro Updater requests. The Pro Plugin Updater now uses WP Transients to store the necessary metadata, which works around the issue with ModSecurity. Props to @seozones for reporting and @jaswsinc for help fixing this. [Issue #416](https://github.com/websharks/comet-cache/issues/416).
- **Enhancement** (Pro): When Static CDN Filters are enabled, it's now possible to disable the automatic insertion of rules into your `.htaccess` file that are designed to prevent issues with [CORS](https://cometcache.com/kb-article/what-are-cross-origin-request-blocked-errors/). See _Apache Optimizations → Send Access-Control-Allow-Origin Header?_ See [Issue #787](https://github.com/websharks/comet-cache/issues/787).
- **Enhancement** (Pro): The HTML Notes added to the bottom of a cached page now specify if the page was cached as the result of an HTTP Request or if it was cached by the Auto-Cache Engine. Props @kristineds. See [Issue #292](https://github.com/websharks/comet-cache/issues/292).
- **Enhancement** (Pro): The Auto-Cache Engine now supports a fallback to cURL using the WP HTTP API. If your PHP configuration has `allow_fopen_url=0`, the Auto-Cache Engine will use the fallback to download the XML Sitemap and parse it from a temporary file. If you want to force the use of this fallback even when `allow_fopen_url=1`, you can use [a filter](https://github.com/websharks/comet-cache/issues/440#issuecomment-228338371). See [Issue #440](https://github.com/websharks/comet-cache/issues/440).
- **UI Enhancement** (Pro): A second button has been added to the bottom of the Pro Plugin Updater page that allows you to "Save and Update Comet Cache Pro" in one step. Props @renzms. See [Issue #741](https://github.com/websharks/comet-cache/issues/741).
- **UI Enhancement** (Pro): The "Cache Stats" button in Admin Bar is now linked to the Cache Stats page. Instead of hovering over the button and then clicking "More Info" inside the popup panel, you can now just click the "Cache Stats" button to go directly to the Cache Stats page. Props @Presskopp, @renzms. See [Issue #780](https://github.com/websharks/comet-cache/issues/780).
- **Comment Mail Compatibility:** Improved compatibility with the Comment Mail plugin by automatically clearing the cache whenever Comment Mail options are changed. Many of the Comment Mail options affect front-end portions of the site, so it's important that the cache is cleared whenever Comment Mail options change. See [Comment Mail Issue #278](https://github.com/websharks/comment-mail/issues/278#issuecomment-225994050).
- **PHP Compatibility:** Improved compatibility back to PHP 5.2 (the lowest version allowed by WordPress). Comet Cache still requires PHP 5.4+, but if you install Comet Cache on a site running PHP 5.2, it will now fail gracefully with a Dashboard notice indicating PHP 5.4+ is required, instead of producing a fatal error. See [Issue #784](https://github.com/websharks/comet-cache/issues/784).
- **WP-CLI Compatibility**: Fixed a bug with deactivating Comet Cache using WP-CLI. Doing so was producing a "Invalid argument; host token empty!" error message. This has been resolved. Props @MarioKnight @jaswsinc @renzms. See [Issue #728](https://github.com/websharks/comet-cache/issues/728).
- Renamed `COMET_CACHE_ALLOW_BROWSER_CACHE` constant to `COMET_CACHE_ALLOW_CLIENT_SIDE_CACHE`. Backwards compatibility has been maintained.
- Renamed `allow_browser_cache` plugin option to `allow_client_side_cache`.

= v160521 =

- **Bug Fix**: Fixed a bug that, in some scenarios, resulted in "PHP Fatal error: Undefined class constant 'CACHE_PATH_NO_PATH_INDEX'". This also affected the Cache Statistics feature (Comet Cache Pro), resulting in a blank panel when hovering over the Cache Stats button in the menu bar. See [Issue #752](https://github.com/websharks/comet-cache/issues/752).
- **Bug Fix**: When the PHP OPCache extension is active, the OPCache is now cleared when a WordPress plugin is upgraded, activated, or deactivated. This works around an issue that could produce a fatal error when the PHP OPCache contains cached PHP code that conflicts with new PHP code introduced by an update. See [Issue #740](https://github.com/websharks/comet-cache/issues/740).
- **Enhancement** (Pro): It's now possible to disable the WordPress Admin Toolbar when Logged-In User Caching is enabled with a new option in _Comet Cache → Plugin Options → Logged-In Users → Disable the Admin Toolbar for Logged-In Users & Comment Authors?_ Props @renzms and @KTS915. See [Issue #690](https://github.com/websharks/comet-cache/issues/690).
- **Enhancement**: The the option to automatically clear the cache for Custom Term Archive Views (see _Comet Cache → Plugin Options → Automatic Cache Clearing → Auto-Clear "Custom Term Archives" Too?_) is now enabled by default. This feature was previously disabled by default, which lead to confusion about why those cache files were not being cleared automatically when a Custom Post Type with a Custom Term Archive View was being used. Props @renzms. See [Issue #693](https://github.com/websharks/comet-cache/issues/693).
- **Enhancement** (Pro): A new filter allows overriding the default behavior to clear the user cache upon login and logout when caching for Logged-In Users is enabled. See [this article](https://cometcache.com/r/kb-article-how-can-i-prevent-the-user-cache-from-being-cleared-upon-login-or-logout/) for details. Props @KTS915. See [Issue #756](https://github.com/websharks/comet-cache/issues/756).

= v160417 =

- **Bug Fix**: Fixed a "PHP Fatal error: Undefined class constant 'CACHE_PATH_NO_SCHEME'" introduced by the previous release (v160416). This issue only affected sites where Feed Caching was enabled (_Comet Cache → Plugin Options → RSS, RDF, and Atom Feeds_). Props to MassimoD and @emanwebdev for reporting. See [Issue #739](https://github.com/websharks/comet-cache/issues/739).

= v160416 =

- **Enhancement**: Several PHP 5.4+ enhancements, most notably a conversion from PHP Closures to PHP Traits. See [Issue #635](https://github.com/websharks/comet-cache/issues/635).
- **Enhancement**: Dashboard notices generated by Comet Cache now use the WordPress-style dismiss button to keep things consistent. See [Issue #719](https://github.com/websharks/comet-cache/issues/719).
- **Enhancement**: Dashboard notices generated by Comet Cache are now compacted into a single notice that can be expanded to view details. This helps reduce the number of messages that appear when, for example, a Post is published or updated and several cache files are automatically cleared. Instead of showing a separate notice for each type of cache file that was cleared, a single notice is shown with a link to toggle the details. See [Issue #118](https://github.com/websharks/comet-cache/issues/118).
- **Enhancement** (Pro): Improved the way the Auto-Cache Engine figures out the URL scheme (`http` vs `https`) that should be used when fetching the XML Sitemap. Instead of forcing `http`, whatever scheme is configured with the Home URL is now used. See [Issue #715](https://github.com/websharks/comet-cache/issues/715).
- **Enhancement** (Pro): The Pro Plugin Updater page now includes a "Save All Changes" button at the bottom, allowing you to save changes to the updater configuration without actually running the plugin updater. Props @bridgeport @NoahjChampion @1wdtv. See [Issue #681](https://github.com/websharks/comet-cache/issues/681).
- **Bug Fix**: Fixed a duplicated row of links on the Pro Plugin Updater page. See [Issue #696](https://github.com/websharks/comet-cache/issues/696).
- **Bug Fix**: Fixed an issue where some browsers would report "Failed to parse SourceMap" errors in their console when browsing the Comet Cache Options page. This was related to `sourceMappingURL` comments in the minified JS/CSS files that were intended for development purposes. Props to @1wdtv for reporting. See [#732](https://github.com/websharks/comet-cache/issues/732).
- **Bug Fix**: Fixed a UI bug in the Pro Preview that was causing the Manual Cache Clearing panel to not appear as part of the Pro Preview. Props @renzms. See [Issue #711](https://github.com/websharks/comet-cache/issues/711).
- **Bug Fix** (Pro): Fixed a bug related to the Pro Updater where some users who had migrated from ZenCache Pro to Comet Cache Pro were seeing an invalid new version message. Props @renzms @jaswsinc. See [Issue #727](https://github.com/websharks/comet-cache/issues/727)
- **Bug Fix** (Pro): Fixed a bug with the Pro Plugin Updater that resulted in "Unknown error. Please wait 15 minutes and try again." when attempting to update Comet Cache Pro. The issue affected sites on servers running an old version of cURL (< v7.36) and/or an old version of OpenSSL, which made them unable to connect to the Comet Cache Pro update server. The Pro Plugin Updater now attempts to connect to a secondary update server that is more compatible with older versions of cURL and OpenSSL. See [Issue #678](https://github.com/websharks/comet-cache/issues/678).
- **Hooks/Filters**: Comet Cache now hooks into `plugins_loaded` instead of `after_setup_theme` when calling its own setup routine. This improves integration with other plugins that may be expecting the Comet Cache API functions to be available after `plugins_loaded`. Props to Frank Goossens (@futtta) from Autoptimize for helping with this. See [Issue #716](https://github.com/websharks/comet-cache/issues/716).
- **Compatibility**: Fixed a compatibility issue for some themes and plugins that were using old AC Plugin code designed to work with Quick Cache. This fix adds some backwards compatibility support for Quick Cache, but note that the first release of Comet Cache dropped support for Quick Cache backwards compatibility in favor of ZenCache backwards compatibility. See [Issue #710](https://github.com/websharks/comet-cache/issues/710).
- **Compatibility: Query Monitor.** The Query Monitor plugin was reporting false-positive errors indicating that many Comet Cache methods did not exist. This was due to how the Comet Cache codebase was utilizing PHP Closures, which Query Monitor had a hard time handling. The codebase has been refactored to use PHP Traits instead of Closures and now the Query Monitor plugin has no problem recognizing Comet Cache methods. Props to @NoahjChampion for reporting. See [Issue #686](https://github.com/websharks/comet-cache/issues/686).
- **Compatibility: WP-CLI.** When installing Comet Cache via WP-CLI, Comet Cache is now automatically enabled. There's no need to manually enable Comet Cache from within the plugin options after installing. Props @jaswsinc. See [Issue #464](https://github.com/websharks/comet-cache/issues/464).
- **Required WordPress Version is now v4.2.** The minimum required WordPress version has been bumped from v4.1 to v4.2. See [Issue #706](https://github.com/websharks/comet-cache/issues/706).

= v160227 =

- **Bug Fix**: Fixed a ZenCache Backwards Compatibility bug that was preventing calls to `$GLOBALS['zencache']` from working properly with Comet Cache. See [Issue #689](https://github.com/websharks/comet-cache/issues/689)
- **Bug Fix**: Fixed a ZenCache Backwards Compatibility bug that was preventing `ZENCACHE_ALLOWED` from working properly with Comet Cache. See [Issue #683](https://github.com/websharks/comet-cache/issues/683).
- **Bug Fix**: Fixed a Quick Cache Backwards Compatibility bug that was preventing calls to `$GLOBALS['quick_cache']` from working properly with Comet Cache. Props to @Kedakai for reporting. See [Issue #691](https://github.com/websharks/comet-cache/issues/691).
- **Bug Fix** (Pro): Fixed an Auto-Cache Engine bug that was preventing the Auto-Cache Engine from generating cached pages. Props @digitalhexcode for reporting. See [Issue #679](https://github.com/websharks/comet-cache/issues/679).
- **Enhancement**: Improved the way Comet Cache handles file locking in an effort to improve compatibility with various environments. There were reports of issues with PHP FPM/FastCGI and this release attempts to address those. See [Issue #671](https://github.com/websharks/comet-cache/issues/671)
- **Enhancement** (Pro): A new HTML Compression option allows you to define whether or not HTML Compression should be enabled for Logged-In users (when Logged-In User caching is enabled). See **Comet Cache → Plugin Options → HTML Compression → Enable HTML Compression for Logged-In Users?**. Props @renzms. See [Issue #650](https://github.com/websharks/comet-cache/issues/650).
- **Accelerated Mobile Pages (AMP) Compatibility**: Added full support for Accelerated Mobile Pages via the [AMP plugin](https://wordpress.org/plugins/amp/). Comet Cache now works great alongside the AMP plugin. AMP-generated pages will be cached and those cache files will be intelligently cleared when necessary to keep things up-to-date. See [Issue #688](https://github.com/websharks/comet-cache/issues/688).

= v160223.1 =

- **Bug Fix**: Fixes PHP Fatal Error when upgrading from Comet Cache v160211.

= v160223 =

- **Announcement: After March 1st, 2016 Comet Cache will require PHP Multibyte String support.** The `mbstring` extension provides Multibyte String support to PHP and is required to properly handle UTF-8 characters, which many sites now use. Without Multibyte String support, caching will be unstable. For that reason we are requiring the `mbstring` extension to improve reliability when caching and to prevent your site from experiencing unforeseen issues in the future..
- **Bug Fix (Multisite)**: Fixed a bug where when Comet Cache was Network Activated the plugin settings link would show up in the plugins list for the Main Site and would lead to a 404 error. The settings link is now only shown when viewing the plugins list from the Network Admin. Props @jaswsinc. See [Issue #675](https://github.com/websharks/zencache/issues/675).
- **Enhancement**: Added support-related links to the plugin options page. Props @renzms. See [Issue #612](https://github.com/websharks/zencache/issues/612#issuecomment-186827661).

= v160222 =

- **Announcement: ZenCache is changing its name to Comet Cache!** Learn more about this upcoming change [here](https://cometcache.com/r/announcing-comet-cache-formerly-zencache/).
- **Announcement: This version of ZenCache requires PHP 5.4+.** As announced in the previous release, the minimum PHP version required to run ZenCache / Comet Cache has changed to PHP 5.4+ as of December 1st, 2015. Please see announcement with further details: [New Minimum PHP Version: PHP 5.4](http://zencache.com/r/new-minimum-php-version-php-5-4/)
- **Announcement: This version of ZenCache does not support the PHP APC Extension**. As announced in the previous release, ZenCache / Comet Cache no longer runs with the PHP APC extension enabled as of December 1st, 2015. Please see announcement with further details: [PHP APC Extension No Longer Supported](http://zencache.com/r/php-apc-extension-no-longer-supported/)
- **Announcement: After March 1st, 2016 ZenCache / Comet Cache will require PHP Multibyte String support.** The `mbstring` extension provides Multibyte String support to PHP and is required to properly handle UTF-8 characters, which many sites now use. Without Multibyte String support, caching will be unstable. For that reason we are requiring the `mbstring` extension to improve reliability when caching and to prevent your site from experiencing unforeseen issues in the future.
- **Announcement: Restructured Codebase**. The entire ZenCache Lite codebase has been restructured to improve performance, enhance flexibility, and make it easier to build in new features! This release of ZenCache Lite has been built from the ZenCache Pro codebase, which is more polished and up-to-date. This release includes many changes and improvements that were released as part of ZenCache Pro releases over the past 6 months and are now being included in the Lite version. See the full changelog below for a complete list of changes.
- **New Feature!** A new watered-down Regular Expression syntax is now supported in several existing ZenCache features, including XML Sitemap Patterns, URI Exclusion Patterns, HTTP Referrer Exclusion Patterns, and User-Agent Exclusion Patterns. (It is also supported in the Pro-only Custom URLs to Auto-Clear, and the HTML Compressor CSS Exclusion Patterns and JavaScript Exclusion Patterns.) This new syntax greatly increases the power and flexibility of each of these features and makes things possible like the much-requested ability to Auto-Clear the Home Page or Posts Page of a site whenever a post cache is cleared. For more information on this new watered-down Regular Expression syntax, [this KB Article](http://zencache.com/r/watered-down-regex-syntax/). Props @kristineds @jaswsinc. See [Issue #191](https://github.com/websharks/zencache/issues/191).
- **Bug Fix**: Fixed a bug with clearing cache files for paginated pages where the `pagination_base` had been changed from the default `page` to something else (e.g., a translated string). The WP Rewrite API is now used to include `pagination_base` and `comments_pagination_base` when building paths to cache files to determine which cache files should be cleared. Props @renzms. See [Issue #607](https://github.com/websharks/zencache/issues/607).
- **Bug Fix**: This release attempts to resolve reports of Error 500 and Internal Server Error issues when running with PHP 5.6 + OPcache. Instead of clearing the entire Opcode cache whenever the plugin options are saved, we only invalidate the `advanced-cache.php` file, which is rebuilt each time you update your configuration options. Props @jaswsinc. Also props to @MarioKnight and @CotswoldPhoto for helping us narrow this down. See [Issue #624](https://github.com/websharks/zencache/issues/624).
- **Bug Fix**: Fixed an issue where a PHP Notice was generated when an inactive WordPress component was being upgraded. This issue did not have any adverse affect on the site, but this fix resolves the issue so that the notice won't appear in PHP logs. See [Issue #589](https://github.com/websharks/zencache/issues/589).
- **Bug Fix**: Fixed a bug where a commented-out `WP_CACHE` definition in `wp-config.php` (such as what WP Super Cache leaves behind) was being incorrectly ignored and resulted in caching being silently disabled. Props @davidfavor. See [Issue #591](https://github.com/websharks/zencache/issues/591).
- **Bug Fix**: Fixed a bug where in some scenarios a page might not be cached due to a stray `AUTH_COOKIE` or `SECURE_AUTH_COOKIE` cookie, even when the user is not logged in. Props @jaswsinc @renzms. See [Issue #592](https://github.com/websharks/zencache/issues/592).
- **Bug Fix**: Fixed an issue related to a popular NGINX server configuration (`try_files $uri $uri/ /index.php?q=$uri&$args;`) that was preventing the entire site from being cached. ZenCache disables caching by default for all requests that include a query string (see _Dashboard → ZenCache → Plugin Options → GET Requests_) and this particular NGINX configuration passes _all_ requests to WordPress with a `?q=` query variable, which was resulting in ZenCache disabling caching on all pages. This release implements better detection for NGINX and works around this scenario. Props @jaswsinc. See [Issue #561](https://github.com/websharks/zencache/issues/561).
- **Bug Fix**: Fixed a bug where, in some rare cases, `wp-config.php` would end up with two `WP_CACHE` definitions. Props @jaswsinc. See [Issue #509](https://github.com/websharks/zencache/issues/509).
- **Bug Fix**: Saving a Post as a Draft was incorrectly purging XML Sitemap cache files. Props @jaswsinc. See [Issue #368](https://github.com/websharks/zencache/issues/368).
- **Bug Fix**: Fixed a bug in the Dynamic Version Salt filter that was generating PHP notices and warnings. See [Issue #522](https://github.com/websharks/zencache/issues/522).
- **Bug Fix**: Fixed an issue with backwards compatibility that was preventing some AC Plugins from working properly. See [Issue #514](https://github.com/websharks/zencache/issues/514).
- **Bug Fix**: Fixed a bug where saving a Post/Page as a Draft as a user with an Editor role would unnecessarily clear the Home Page cache. See [Issue #625](https://github.com/websharks/zencache/issues/625).
- **Multisite Bug Fix**: Fixed a bug where the Clear Cache button wouldn't clear Child-Site Logged-In User Home Page cache files on WordPress Multisite Networks. Props @jaswsinc. See [Issue #409](https://github.com/websharks/zencache/issues/409)
- **Multisite Bug Fix**: Fixed a bug where the Home Page cache was not clearing on Child Sites in a Multisite Network. Props @jaswsinc. See [Issue #409](https://github.com/websharks/zencache/issues/409)
- **Multisite Bug Fix**: Fixed a bug with 404 Request caching on Multisite Networks where ZenCache Pro was not considering that each child blog in a multisite network will have its own 404 error page. Props @jaswsinc. See [Issue #539](https://github.com/websharks/zencache/issues/539).
- **Multisite Bug Fix**: Fixed a bug where clearing the cache from the main site of a multisite network, when there are child blogs in sub-directories, resulted in all child blogs being cleared from the cache, not just the main site as would be expected. This has been resolved and only the main site is cleared when clicking the Clear Cache button. Note that the Wipe Cache button can still be used to clear the cache for all sites in a Multisite Network. Props @jaswsinc. See [Issue #540](https://github.com/websharks/zencache/issues/540).
- **Multisite Bug Fix**: Fixed a bug where Wiping the cache on a multisite network resulted in the very next page view being cached incorrectly. Props @jaswsinc. See [Issue #541](https://github.com/websharks/zencache/issues/541).
- **Multisite Bug Fix**: Fixed a bug where when ZenCache was Network Activated the plugin settings link would show up in the plugins list for the Main Site and would lead to a 404 error. The settings link is now only shown when viewing the plugins list from the Network Admin. Props @jaswsinc. See [Issue #675](https://github.com/websharks/zencache/issues/675).
- **Enhancement**: Added support-related links to the plugin options page. Props @renzms. See [Issue #612](https://github.com/websharks/zencache/issues/612#issuecomment-186827661).
- **Enhancement**: It's now possible to override the ZenCache Nonce exclusion globally (dangerous) or only for Logged-In Users (safer). Please see [this article](http://zencache.com/r/kb-article-what-are-wordpress-nonces-and-why-are-they-not-cache-compatible/) for full details. [Issue #637](https://github.com/websharks/zencache/issues/637).
- **Enhancement**: Improved WP Cron-related configuration and validation of custom cron schedules. See [PR #197](https://github.com/websharks/zencache-pro/pull/197).
- **Enhancement**: ZenCache now clears the cache whenever a WordPress plugin is activated or deactivated. Many WordPress plugins change content on the front-end of the site, so this enhancement ensures that an old cache file is never served to visitors. If you want to disable this automatic behavior, see [this article](http://zencache.com/kb-article/how-do-i-prevent-zencache-from-clearing-the-cache-upon-plugin-activation-or-deactivation/). Props @renzms. See [Issue #424](https://github.com/websharks/zencache/issues/424).
- **Enhancement**: When activating ZenCache for the first time, a new Dashboard message now includes a helpful link to the options page to enable caching and review the options. Props @kristineds. See [Issue #112](https://github.com/websharks/zencache/issues/112).
- **Enhancement**: The automatic Cache Cleanup schedule that cleans up (deletes) expired/stale cache files has been changed from once every day to once every hour. Running the cleanup hourly makes ZenCache smarter when configured in certain ways and saves disk space. Props @kristineds. See [Issue #472](https://github.com/websharks/zencache/issues/472).
- **Enhancement**: When the Cache Directory location is changed, ZenCache now cleans up the old Cache Directory and any old cache files instead of leaving them behind. Props @clavaque @renzms. See [Issue #580](https://github.com/websharks/zencache/issues/580).
- **Enhancement**: Added a new API Function that allows a site owner to clear the cache for a specific URL via `zencache::clearUrl($url);`. See [this article](http://zencache.com/kb-article/clearing-the-cache-dynamically/#toc-988085ad) for further details. Props @kristineds. See [Issue #590](https://github.com/websharks/zencache/issues/590).
- **Enhancement**: Improved the HTML Notes generated by ZenCache when s2Member (a membership plugin for WordPress) is specifically disabling caching. s2Member automatically disables caching on certain pages that are required to remain dynamic. The HTML Notes generated by ZenCache now explain when this is happening. Props @renzms. See [Issue #504](https://github.com/websharks/zencache/issues/504).
- **Enhancement**: Manual Cache Clearing options have now been separated from Automatic Cache Clearing options inside the ZenCache Plugin Options to improve the differentiation between these.
- **Enhancement**: New icons in the ZenCache Plugin Options help improve the visual representation of each panel.
- **Enhancement**: The installed plugin version is now shown at the top of the ZenCache Options Page. Props @renzms. See [Issue #502](https://github.com/websharks/zencache/issues/502).
- **Enhancement**: New transition in/out effects on the Cache Cleared Dashboard notifications. Props @jaswsinc. See [Issue #538](https://github.com/websharks/zencache/issues/538).
- **Enhancement**: Improved compatibility with any Custom Post Type that uses hierarchies. Props @jaswsinc.
- **Akismet Compatibility:** ZenCache no longer caches pages that contain `akismet_comment_nonce` in the markup. This ensures that a page that contains a time-sensitive `nonce` value does not get cached. Props @kristineds and @jaswsinc. See [Issue #601](https://github.com/websharks/zencache/issues/601).
- **Akismet Compatibility:** ZenCache now automatically disables the Akismet Comment Nonce using [the `akismet_comment_nonce` filter](https://github.com/git-mirror/wordpress-akismet/blob/2.5.6/akismet.php#L333), which improves compatibility between Akismet and the page caching functionality provided by ZenCache. This ensures that pages do not contain time-sensitive `nonce` values that should not be cached. If you'd like to revert this behavior, please see [this article](http://zencache.com/kb-article/how-do-i-prevent-zencache-from-disabling-the-akismet-comment-nonce/). Props @kristineds and @jaswsinc. See [Issue #601](https://github.com/websharks/zencache/issues/601).
- **Akismet Compatibility**: Fixed a bug with Akismet compatibility where ZenCache was not properly disabling the Akismet Comment Nonce, which resulted in pages being unnecessarily excluded from the cache due to the presence of the `akismet_comment_nonce` in the markup. Props @Kalfer. See [Issue #642](https://github.com/websharks/zencache/issues/642).
- **WooCommerce Compatibility:** This release improves compatibility with the WooCommerce Product Stock feature. When the Product Stock changes, ZenCache will now clear the cache file for the associated Product to ensure that the stock quantity that appears on the site remains up-to-date. See [Issue #597](https://github.com/websharks/zencache/issues/597).
- **Multisite Domain Mapping Compatibility**: ZenCache is now fully compatible with the [WordPress MU Domain Mapping plugin](https://wordpress.org/plugins/wordpress-mu-domain-mapping/), including Multisite Networks using domain mapping on top-level domains, sub-domains, and sub-directories. Multiple variations of each site spread across an unlimited number of domain mappings and/or the original blog domain/path is also supported. All Pro-only features, including the Auto-Cache Engine, Static CDN Filters, and HTML Compression, are also now compatible with domain mapping. Props @jaswsinc. See [Issue #339](https://github.com/websharks/zencache/issues/339).
- **bbPress Compatibility**: This release greatly improves compatibility with bbPress. Events like creating a new Forum, creating a new Topic, and posting a reply to a Topic (including threaded replies), now properly clear the necessary cache files to ensure that cached bbPress pages remain up-to-date. Props @jaswsinc. See [Issue #168](https://github.com/websharks/zencache/issues/168).
- **bbPress Compatibility:** This release improves compatibility with bbPress when ZenCache Logged-In User caching is enabled. In this scenario, bbPress may generate links for Admins that contain time-sensitive `_wpnonce` values which could expire if cached and result in certain admin-related actions failing. ZenCache no longer caches pages that contain `_wpnonce` in the markup. This ensures that pages containing time-sensitive `nonce` values are not cached. Props @kristineds, @jaswsinc, and @clavaque. See [Issue #601](https://github.com/websharks/zencache/issues/601).
- **New Pro Features:** This release updates the Pro Preview to include several new Pro features that have been added over the past 6 months, including the ability to clear the PHP OPCache whenever manually clearing the cache (_ZenCache Options → Manual Cache Clearing → Clear the PHP OPCache Too?_), clear the CDN Cache whenever manually clearing the cache (_ZenCache Options → Manual Cache Clearing → CDN Cache Clear the CDN Cache Too?_), disable cache expiration if the server load average is high (_ZenCache Options → Cache Expiration Time → Disable Cache Expiration If Server Load Average is High_), the ability to specify which WordPress Roles/Capabilities are allowed to clear the cache from the WordPress Admin bar (_ZenCache Options → Manual Cache Clearing → Also allow others to clear the cache from their Admin Bar?_), a completely new Cache Statistics feature that allows you to monitor the health and status of your cache (_ZenCache → Stats / Charts_), the ability to specify a list of Custom URLs whose cache files should be cleared whenever ZenCache detects that a Post/Page cache should be cleared (_ZenCache Options → Automatic Cache Clearing → Misc. Auto-Clear Options → Auto-Clear a List of Custom URLs Too?_), a new menu of Clear Cache options in the Admin Bar that allows you to  clear the cache for just the Home Page, the Current URL, a Specific URL, PHP's OPCache, or the CDN Cache (_ZenCache Options → Plugin Options → Manual Cache Clearing_), the ability to customize the Cache Cleanup Schedule and set your own schedule (_ZenCache Options → Manual Cache Clearing → Cache Cleanup Schedule_), the ability to configure the Pro Plugin Updater to check for Beta versions, an option to clear Expired WordPress Transients, and URI Exclusion Patterns for Client-Side Caching.

= v160211 =

**Announcing Comet Cache, formerly ZenCache!**

We are very excited to announce the release of [Comet Cache](http://cometcache.com), an advanced WordPress caching plugin inspired by simplicity. Comet Cache is the successor to ZenCache (and Quick Cache before that), a very popular WordPress caching plugin that has been downloaded over 1 million times and has won acclaim for its speed, simplicity, and ease of configuration. [Read the full announcement here](https://cometcache.com/r/announcing-comet-cache-formerly-zencache/).

= v160103 =

- **Bug Fix**: Fixed an issue that was unexpectedly producing "Failed to update your /.htaccess file" error messages. The `.htaccess` routines are now more intelligent and take into consideration which plugin options are enabled and which options require updating the `.htaccess` file. This also improves performance by avoiding unnecessary read/writes to the `.htaccess` file. Props @patdumond. See [Issue #641](https://github.com/websharks/zencache/issues/641).
- **Bug Fix**: When `allow_url_fopen` is disabled via the PHP configuration, the Auto-Cache Engine is unable to read the XML Sitemap and was silently failing with only PHP Warning in the PHP error log. The Auto-Cache Engine currently requires [PHP URL-aware fopen wrappers](http://zencache.com/r/allow_url_fopen/). A new Dashboard notice displays an error message when `allow_url_fopen` is disabled and prevents the Auto-Cache Engine from attempting to run. See [Issue #644](https://github.com/websharks/zencache/issues/644).
- **Bug Fix**: Fixed an Auto-Cache Engine bug that was producing false-positive Dashboard errors related to timeouts: "Problematic XML Sitemap URL - WP_Http says: Operation timed out after 5001 milliseconds with 0 bytes received." Due to the way ZenCache was checking the XML Sitemap URL more than necessary, timeouts were more likely to occur. We now only check the URL repeatedly when a failure has been encountered. If the URL is confirmed as working, we don't check the URL again until the Auto-Cache Engine runs (every 15 minutes by default) or until the Plugin Options are saved. If you are still seeing timeout errors after this update, please see [this article](http://zencache.com/kb-article/why-am-i-seeing-auto-cache-engine-timeout-errors/). See [Issue #643](https://github.com/websharks/zencache/issues/643).
- **Bug Fix**: Fixed an Auto-Cache Engine bug where ZenCache would would check both the non-SSL (`http://`) and the SSL (`https://`) version of the XML Sitemap URL when the Site Address was configured to use SSL. See [Issue #643](https://github.com/websharks/zencache/issues/643).
- **Enhancement**: It's now possible to override the ZenCache Nonce exclusion globally (dangerous) or only for Logged-In Users (safer). Please see [this article](http://zencache.com/r/kb-article-what-are-wordpress-nonces-and-why-are-they-not-cache-compatible/) for full details. [Issue #637](https://github.com/websharks/zencache/issues/637).
- **Akismet Compatibility**: Fixed a bug with Akismet compatibility where ZenCache was not properly disabling the Akismet Comment Nonce, which resulted in pages being unnecessarily excluded from the cache due to the presence of the `akismet_comment_nonce` in the markup. Props @Kalfer. See [Issue #642](https://github.com/websharks/zencache/issues/642).

= v151220 =

- **New Feature!**: It's now possible to customize the Cache Cleanup Schedule and set your own schedule in _ZenCache → Plugin Options → Manual Cache Clearing → Cache Cleanup Schedule_. ZenCache uses [`wp_get_schedules()`](https://codex.wordpress.org/Function_Reference/wp_get_schedules) when generating the list of available schedules, which makes it possible to create your own custom cron schedule using a plugin like WP Crontrol and use that to define a custom Cache Cleanup Schedule. Props @kristineds. See [Issue #472](https://github.com/websharks/zencache/issues/472).
- **New Feature!** It's now possible to configure the Pro Plugin Updater to check for Beta versions (Release Candidates) of the plugin. See _ZenCache → Plugin Updater → Beta Testers_. We publish Release Candidates a week or so before official releases to allow for additional testing and early preview of upcoming features and bug fixes. If you're not already on our Beta Testers mailing list, you can signup [here](http://zencache.com/r/zencache-beta-testers-list/). Props @kristineds. See [Issue #352](https://github.com/websharks/zencache/issues/352).
- **New Feature!** It's now possible to clear [Expired WordPress Transients](https://codex.wordpress.org/Transients_API) from the Clear Cache Option Menu in the WordPress Admin Bar. The WordPress Transients API has no functionality to automatically clean up expired transients; doing so is left for plugin authors and we've found that very few plugins that use the Transient API actually clean up expired transients properly, which can lead to your database being full of expired transient data that is no longer used. Props @kristineds. See [Issue #459](https://github.com/websharks/zencache/issues/459).
- **New Feature!** Client-Side Caching now includes a new URI Exclusion Patterns for Client-Side Caching, allowing you to exclude specific URIs from being cached by a client-side browser when Client-Side Caching is enabled. Props @renzms. See [Issue #498](https://github.com/websharks/zencache/issues/498).
- **Bug Fix**: Fixed a bug that was generating a "Failed to update your `/.htaccess` file" error message. The routines that update your `.htaccess` file were failing if your `.htaccess` file already contained the word "ZenCache" (case-insensitive). See [Issue #617](https://github.com/websharks/zencache/issues/617) and [Issue #620](https://github.com/websharks/zencache/issues/620).
- **Bug Fix**: Fixed a bug that in some scenarios could cause custom `.htaccess` rules to be lost if your `.htaccess` file was using the exact same comment start and end markers as ZenCache (`# BEGIN ZenCache` and `# END ZenCache`). If you were using those exact same start and end markers, ZenCache was replacing whatever was between them with a copy of the ZenCache `.htaccess` rules. ZenCache now uses a unique marker (`WmVuQ2FjaGU`) to identify its own code blocks inside your `.htaccess` file. See [Issue #620](https://github.com/websharks/zencache/issues/620).
- **Bug Fix**: Fixed a bug with clearing cache files for paginated pages where the `pagination_base` had been changed from the default `page` to something else (e.g., a translated string). The WP Rewrite API is now used to include `pagination_base` and `comments_pagination_base` when building paths to cache files to determine which cache files should be cleared. Props @renzms. See [Issue #607](https://github.com/websharks/zencache/issues/607).
- **Bug Fix**: Fixed a bug with the Static CDN Filters that affected sites using a permalink structure that ended with `.htm` or `.html`. This bug was supposed to be fixed back in v151002 but another bug prevented the fix from working properly. This release fixes the issue once and for all. See [Issue #495](https://github.com/websharks/zencache/issues/495#issuecomment-160324313).
- **Bug Fix**: With Logged-In User caching enabled, there were some scenarios where the user cache was being cleared on every page load when a user was logged in. ZenCache now hooks into `updated_user_metadata` instead of `update_user_metadata` to clear a specific user cache. Props @kristineds. See [Issue #623](https://github.com/websharks/zencache/issues/623).
- **Bug Fix**: Fixed a bug where the Auto-Cache Engine cron event would disappear in some scenarios. Props @patdumond, @MarioKnight. See [Issue #613](https://github.com/websharks/zencache/issues/613).
- **Bug Fix**: ZenCache no longer caches any pages that contain `_wpnonce` in the markup. This ensures that pages containing time-sensitive `nonce` values are not cached. Props @kristineds and @jaswsinc. See [Issue #601](https://github.com/websharks/zencache/issues/601).
- **Bug Fix**: This release attempts to resolve reports of Error 500 and Internal Server Error issues when running with PHP 5.6 + OPcache. Instead of clearing the entire Opcode cache whenever the plugin options are saved, we only invalidate the `advanced-cache.php` file, which is rebuilt each time you update your configuration options. Props @jaswsinc. Also props to @MarioKnight and @CotswoldPhoto for helping us narrow this down. See [Issue #624](https://github.com/websharks/zencache/issues/624).
- **Bug Fix**: Fixed a bug where ZenCache could inadvertently corrupt the `.htaccess` file if it contained invalid UTF-8 characters. This has been fixed by first checking the `.htaccess` file for invalid UTF-8 characters via `wp_check_invalid_utf8()`. See [Issue #633](https://github.com/websharks/zencache/issues/633#issuecomment-165493039).
- **Enhancement**: Improved WP Cron-related configuration and validation of custom cron schedules. See [PR #197](https://github.com/websharks/zencache-pro/pull/197).
- **Enhancement**: ZenCache now clears the cache whenever a WordPress plugin is activated or deactivated. Many WordPress plugins change content on the front-end of the site, so this enhancement ensures that an old cache file is never served to visitors. If you want to disable this automatic behavior, see [this article](http://zencache.com/kb-article/how-do-i-prevent-zencache-from-clearing-the-cache-upon-plugin-activation-or-deactivation/). Props @renzms. See [Issue #424](https://github.com/websharks/zencache/issues/424).
- **Enhancement**: The Auto-Cache Engine diagnostic reporting for XML Sitemap-related errors has been greatly improved. The Dashboard notice now explains exactly what error is occurring when the Auto-Cache Engine attempts to verify that the XML Sitemap exists. Props @jaswsinc. See [Issue #615](https://github.com/websharks/zencache/issues/615) and [Issue #618](https://github.com/websharks/zencache/issues/618).
- **Enhancement**: Auto-Cache Engine XML Sitemap error checking is now more intelligent. When configured, the XML Sitemap URL is now checked upon every `admin_init` to verify that the XML Sitemap is accessible and valid. If a previous error has been fixed, the error message will disappear immediately instead of taking 15 minutes (the Auto-Cache Engine run cycle). See [Issue #616](https://github.com/websharks/zencache/issues/616).
- **Enhancement**: Static CDN Filters are no longer applied by default for Logged-In Users. This was causing some confusion because Logged-In User caching is disabled by default. There is no harm in applying Static CDN Filters to all users (logged-in or not logged-in), in fact we recommend it, however we now disable this functionality by default to avoid confusion. A new option allows you to control this behavior and enable Static CDN Filters for Logged-In users; see _ZenCache → Logged-In Users → Static CDN Filters Enabled for Logged-In Users & Comment Authors?_ Props @kristineds, @lkraav, and @isaumya. See [Issue #486](https://github.com/websharks/zencache/issues/486).
- **Enhancement**: The Static CDN Filters now attempt to obey the `ZENCACHE_ALLOWED` and `DONOTCACHEPAGE` constants so that Static CDN Filters are not applied when caching is disabled. However, due to the way Static CDN Filters are implemented this is not always reliable. If you need to programmatically disable Static CDN Filters, see [this article](http://zencache.com/kb-article/how-do-i-disable-static-cdn-filters-via-php/). See [Issue #628](https://github.com/websharks/zencache/issues/628).
- **Enhancement**: When activating ZenCache for the first time, a new Dashboard message now includes a helpful link to the options page to enable caching and review the options. Props @kristineds. See [Issue #112](https://github.com/websharks/zencache/issues/112).
- **Enhancement**: The automatic Cache Cleanup schedule that cleans up (deletes) expired/stale cache files has been changed from once every day to once every hour. Running the cleanup hourly makes ZenCache smarter when configured in certain ways and saves disk space. Props @kristineds. See [Issue #472](https://github.com/websharks/zencache/issues/472).
- **Enhancement:** The new default value for "Clear the PHP OPcache Too?" when clearing the cache manually is now disabled. Instead of having this option enabled by default, we automatically invalidate only the `advanced-cache.php` file in PHP's opcode cache whenever you update your configuration options, which allows ZenCache to function as expected. That was the most important reason for needing to clear the opcode cache in previous versions. Props @jaswsinc. Also props to @MarioKnight and @CotswoldPhoto for helping us narrow this down. See [Issue #624](https://github.com/websharks/zencache/issues/624).
- **Enhancement**: Improved `.htaccess` utilities so that an exclusive lock is acquired when reading+writing to the file. This helps avoid inadvertently corrupting the `.htaccess` file in scenarios where another process might be reading/writing to it at the same time. See [Issue #633](https://github.com/websharks/zencache/issues/633).
- **Multisite Enhancement**: The Auto-Cache Engine has a new configuration option when running on WP Multisite Networks that allows you to define whether or not the Auto-Cache Engine should look for XML Sitemaps on each of the child blogs. This now defaults to being off; i.e., by default, child blogs are no longer checked. Props @jaswsinc. See [Issue #618](https://github.com/websharks/zencache/issues/618#issuecomment-158695842).
- **Multisite Enhancement**: The Auto-Cache Engine XML Sitemap diagnostic reporting is now always disabled for child blogs and only errors related to a primary sitemap location are displayed on the Dashboard. Props @jaswsinc. See [Issue #618](https://github.com/websharks/zencache/issues/618#issuecomment-158695842).
- **bbPress Compatibility:** This release improves compatibility with bbPress when ZenCache Logged-In User caching is enabled. In this scenario, bbPress may generate links for Admins that contain time-sensitive `_wpnonce` values which could expire if cached and result in certain admin-related actions failing. ZenCache no longer caches pages that contain `_wpnonce` in the markup. This ensures that pages containing time-sensitive `nonce` values are not cached. Props @kristineds, @jaswsinc, and @clavaque. See [Issue #601](https://github.com/websharks/zencache/issues/601).
- **Akismet Compatibility:** ZenCache no longer caches pages that contain `akismet_comment_nonce` in the markup. This ensures that a page that contains a time-sensitive `nonce` value does not get cached. Props @kristineds and @jaswsinc. See [Issue #601](https://github.com/websharks/zencache/issues/601).
- **Akismet Compatibility:** ZenCache now automatically disables the Akismet Comment Nonce using [the `akismet_comment_nonce` filter](https://github.com/git-mirror/wordpress-akismet/blob/2.5.6/akismet.php#L333), which improves compatibility between Akismet and the page caching functionality provided by ZenCache. This ensures that pages do not contain time-sensitive `nonce` values that should not be cached. If you'd like to revert this behavior, please see [this article](http://zencache.com/kb-article/how-do-i-prevent-zencache-from-disabling-the-akismet-comment-nonce/). Props @kristineds and @jaswsinc. See [Issue #601](https://github.com/websharks/zencache/issues/601).
- **WooCommerce Compatibility:** This release improves compatibility with the WooCommerce Product Stock feature. When the Product Stock changes, ZenCache will now clear the cache file for the associated Product to ensure that the stock quantity that appears on the site remains up-to-date. See [Issue #597](https://github.com/websharks/zencache/issues/597).

= v151114 =

- **Announcement: The next version of ZenCache will require PHP 5.4+.** As of December 1st, 2015, the minimum PHP version required to run ZenCache will change to PHP 5.4+. This release of ZenCache will be the last version to support PHP 5.3. Please see announcement with further details: [New Minimum PHP Version: PHP 5.4](http://zencache.com/r/new-minimum-php-version-php-5-4/)
- **Announcement: The next version of ZenCache will not support the PHP APC Extension**. As of December 1st, 2015, ZenCache will no longer run with the PHP APC extension enabled. Please see announcement with further details: [PHP APC Extension No Longer Supported](http://zencache.com/r/php-apc-extension-no-longer-supported/)
- **New Feature!** The Clear Cache button in the Admin Bar now includes a sub-menu with several new options for clearing the cache from anywhere on your site. You can clear the cache for just the Home Page, the Current URL, a Specific URL, PHP's OPCache (if active), or the CDN Cache (when Static CDN Filters are configured). This menu comes in two flavors and can be customized (or disabled entirely) inside _ZenCache → Plugin Options → Manual Cache Clearing_. Props @jaswsinc. See [Issue #596](https://github.com/websharks/zencache/issues/596#issuecomment-152786080).
- **New Feature!** It's now possible to specify a list of Custom URLs whose cache files should be cleared whenever you update a Post/Page, approve a Comment, or make other changes where ZenCache detects that a Post/Page cache should be cleared to keep your site up-to-date. See _ZenCache → Plugin Options → Automatic Cache Clearing → Misc. Auto-Clear Options → Auto-Clear a List of Custom URLs Too?_ Props @kristineds. See [Issue #111](https://github.com/websharks/zencache/issues/111).
- **New Feature!** A new watered-down Regular Expression syntax is now supported in several existing ZenCache features, including the new list of Custom URLs to Auto-Clear, URI Exclusion Patterns, HTTP Referrer Exclusion Patterns, User-Agent Exclusion Patterns, and the HTML Compressor CSS Exclusion Patterns and JavaScript Exclusion Patterns. This new syntax greatly increases the power and flexibility of each of these features and makes things possible like the much-requested ability to Auto-Clear the Home Page or Posts Page of a site whenever a post cache is cleared. For more information on this new watered-down Regular Expression syntax, [this KB Article](http://zencache.com/r/watered-down-regex-syntax/). Props @kristineds @jaswsinc. See [Issue #191](https://github.com/websharks/zencache/issues/191).
- **Bug Fix**: Fixed a bug with Static CDN Filters and Cross-Origin Resource Sharing (CORS) that was generating a "Cross-Origin Request Blocked" error. ZenCache will now update the root `.htaccess` file to include a `Header set Access-Control-Allow-Origin "*"` rule for `ttf`, `ttc`, `otf`, `eot`, `woff`, `woff2`, `font.css`, `css`, and `js` files whenever the Static CDN Filters are enabled. This is necessary to avoid "Cross-Origin Request Blocked" errors. Note that if you are already experiencing this error, you should create and configure a new CDN hostname to resolve the issue. In our tests it appears that some CDNs are caching the initial header response received by the server, which means it's necessary to send the `Access-Control-Allow-Origin` header _before_ configuring the Static CDN Filters with a CDN hostname. See [Issue #427](https://github.com/websharks/zencache/issues/427#issuecomment-121774596).
- **Bug Fix**: Removed `eot,ttf,otf,woff` font extensions from the Static CDN Filter Blacklisted Extensions. These were added in a previous release in an attempt to resolve an issue with Cross-Origin Resource Sharing (CORS), however now that the HTML Compressor has been updated to work with Static CDN Filters, the CSS compressed by the HTML Compressor is now served from the CDN. Fonts are most likely to be referenced by CSS, which is static. So when Static CDN Filters are applied, the CSS is getting moved to the CDN and the fonts are then expected to live on the CDN too. By excluding them from the Static CDN Filter, we were creating a problem instead of solving one. This release removes the font extensions from the default Blacklisted Extensions so that fonts can be hosted on the CDN alongside the CSS that references them. See [Issue #427](https://github.com/websharks/zencache/issues/427#issuecomment-121777790).
- **Bug Fix**: Fixed a bug related to updating plugins with WP-CLI on a site that was running ZenCache Pro. While ZenCache Pro updates must still be done through the ZenCache Pro Updater inside the Dashboard, updating other plugins via WP-CLI was generating a harmless ZenCache exception: "Invalid argument; host token empty!". With this fix, ZenCache will properly detect when WP-CLI is running to avoid these errors. Props @MarioKnight @renzms. See [Issue #563](https://github.com/websharks/zencache/issues/563).
- **Bug Fix**: Fixed a bug where post previews were being cached when Logged-In User Caching and GET Request caching were both enabled (both are disabled by default). This release now detects previews in this scenario and excludes those requests from being cached. Props @clavaque @kristineds. See [Issue #583](https://github.com/websharks/zencache/issues/583).
- **Bug Fix**: Fixed an issue where a PHP Notice was generated when an inactive WordPress component was being upgraded. This issue did not have any adverse affect on the site, but this fix resolves the issue so that the notice won't appear in PHP logs. See [Issue #589](https://github.com/websharks/zencache/issues/589).
- **Bug Fix**: Fixed a bug where a commented-out `WP_CACHE` definition in `wp-config.php` (such as what WP Super Cache leaves behind) was being incorrectly ignored and resulted in caching being silently disabled. Props @davidfavor. See [Issue #591](https://github.com/websharks/zencache/issues/591).
- **Bug Fix**: Fixed a bug where in some scenarios a page might not be cached due to a stray `AUTH_COOKIE` or `SECURE_AUTH_COOKIE` cookie, even when the user is not logged in. Props @jaswsinc @renzms. See [Issue #592](https://github.com/websharks/zencache/issues/592).
- **Enhancement**: Excluded several unnecessary files from the plugin zip file that were being used during the build process but were not necessary to run the plugin. Props @bridgeport. See [Issue #579](https://github.com/websharks/zencache/issues/579).
- **Enhancement**: When the Cache Directory location is changed, ZenCache now cleans up the old Cache Directory and any old cache files instead of leaving them behind. Props @clavaque @renzms. See [Issue #580](https://github.com/websharks/zencache/issues/580).
- **Enhancement**: Added a new API Function that allows a site owner to clear the cache for a specific URL via `zencache::clearUrl($url);`. See [this article](http://zencache.com/kb-article/clearing-the-cache-dynamically/#toc-988085ad) for further details. Props @kristineds. See [Issue #590](https://github.com/websharks/zencache/issues/590).
- **Enhancement**: Improved the HTML Notes generated by ZenCache when s2Member (a membership plugin for WordPress) is specifically disabling caching. s2Member automatically disables caching on certain pages that are required to remain dynamic. The HTML Notes generated by ZenCache now explain when this is happening. Props @renzms. See [Issue #504](https://github.com/websharks/zencache/issues/504).
- **Enhancement**: In Logged-In User Caching, the "Yes, but DON'T maintain a separate cache for each user" option has been hidden because this particular option has the potential to create a security issue if not configured properly. If you were already using this option, it will not be hidden and it will continue to work. Otherwise, if you require this particular option you can now enable it using a filter (see [this comment](https://github.com/websharks/zencache/issues/497#issuecomment-146060440)). Props @renzms @jaswsinc. See [Issue #497](https://github.com/websharks/zencache/issues/497).
- **Enhancement**: The Auto-Cache Engine now detects when the configured XML Sitemap is not valid or is unreachable and displays an appropriate notice. Props @kristineds and @jaswsinc. See [Issue #555](https://github.com/websharks/zencache/issues/555).

= v151004 =

- **Bug Fix**: Fixed a bug introduced in the previous release that was resulting in a "Fatal error: Using $this when not in object context" for sites running PHP 5.3. (PHP 5.4+ sites were unaffected.) Props @jaswsinc. See [Issue #581](https://github.com/websharks/zencache/issues/581).

= v151002 =

- **New Feature!** Cache Statistics is a completely new ZenCache Pro feature that will help site owners better understand their WordPress site cache. An easy-to-access Cache Stats menu button in the Admin Bar is accompanied by a whole new page that shows Current Cache Totals (including total number of cache files and total size of cache on the disk), Current Disk Health (including total disk capacity and total available), Current System Health (including memory usage and load average), and two beautiful Polar Area pie charts that show you both current and historical data on Cache File Counts and Cache File Sizes with a 30-Day High, Current Total, Page Cache total, and HTML Compressor total for each chart. Props to @jaswsinc. See [Issue #83](https://github.com/websharks/zencache/issues/83).
- **New Feature!** It's now possible to specify which WordPress Roles/Capabilities are allowed to clear the cache from the WordPress Admin bar. A new option inside _Dashboard → ZenCache → Plugin Options → Manual Cache Clearing_ allows specifying a comma-delimited list of Roles and/or Capabilities under, "Also allow others to clear the cache from their Admin Bar?". If a user has an allowed Role/Capability, they will see the "Clear Cache" button in their Admin Bar. This feature is also compatible with WordPress Multisite Networks, allowing a Network Administrator to define which Child Site roles should allow a Child Site user to see the "Clear Cache" button for their Child Site. Props @danielmt2k @jaswsinc. See [Issue #68](https://github.com/websharks/zencache/issues/68).
- **New Feature!** It's now possible to "Disable Cache Expiration If Server Load Average is High" (see _Dashboard → ZenCache → Plugin Options → Cache Expiration Time_). This allows you to provide a specific load average that should cause ZenCache to disable cache expiration and help reduce stress on the server; i.e., to avoid generating a new version of the cache while the server is very busy. Props @jaswsinc. See [Issue #347](https://github.com/websharks/zencache/issues/347).
- **New Feature!** It's now possible to manually clear the CDN Cache when Static CDN Filters are enabled. Inside the Static CDN Filters options panel there's a new "Clear CDN Cache" button and there's also a new option ("Clear the CDN Cache Too?") inside _Dashboard → ZenCache → Plugin Options → Manual Cache Clearing_ that allows you to specify whether or not you'd like the CDN Cache to be cleared whenever the "Clear Cache" button is clicked (either from the Admin Bar or from inside the Plugin Options). Props @kristineds @jaswsinc. See [Issue #488](https://github.com/websharks/zencache/issues/488).
- **New Feature!** When your server has the [PHP OPCache Extension](http://zencache.com/r/php-opcache/) installed, ZenCache can now be configured to also clear the PHP opcode cache whenever you clear the cache manually using the ZenCache "Clear Cache" button. See _ZenCache Options → Manual Cache Clearing → Clear the PHP OPCache Too?_ (note that this option only appears if you have the OPCache Extension installed). Props @jaswsinc. See [Issue #489](https://github.com/websharks/zencache/issues/489).
- **Bug Fix**: Fixed an HTML Compressor bug related to CSS pseudo-classes where spaces between the class name and pseudo-class name were being removed when CSS was minified. Props @patdumond @jaswsinc. See [Issue #544](https://github.com/websharks/zencache/issues/544).
- **Bug Fix**: Fixed an HTML Compressor bug related to `<noscript>` tags. The HTML Compressor now makes no adjustments to anything inside `<noscript>` tags, and the same has always been true for IE conditional comments as well. Props @rtrevellyan @jaswsinc. See [Issue #65](https://github.com/websharks/html-compressor/issues/65).
- **Bug Fix**: Fixed an issue related to a popular NGINX server configuration (`try_files $uri $uri/ /index.php?q=$uri&$args;`) that was preventing the entire site from being cached. ZenCache disables caching by default for all requests that include a query string (see _Dashboard → ZenCache → Plugin Options → GET Requests_) and this particular NGINX configuration passes _all_ requests to WordPress with a `?q=` query variable, which was resulting in ZenCache disabling caching on all pages. This release implements better detection for NGINX and works around this scenario. Props @jaswsinc. See [Issue #561](https://github.com/websharks/zencache/issues/561).
- **Bug Fix**: Fixed a bug with the Static CDN Filters that affected sites using a permalink structure that ended with `.htm` or `.html`. Generally, files that end in `.htm` or `.html` are considered static files, hence the reason ZenCache was rewriting URLs with those extensions to point at the configured CDN. However, if a site uses `.htm` or `.html` in their permalink structure, all links to Posts/Pages within the site will appear to be static files when they are in fact dynamic and therefore should not be rewritten. ZenCache now checks the permalink structure and excludes `.htm` and `.html` from the allowed extensions when the permalink structure is using one of these. Props @jaswsinc. See [Issue #495](https://github.com/websharks/zencache/issues/495).
- **Bug Fix**: Fixed an SSL issue with the HTML Compressor that was causing problems in some hosting environments where the hosting server was incorrectly setting `$_SERVER['REQUEST_SCHEME']` to `http` even when the WordPress Site URL and Home URL were set to use `https://`. As a result of this improper server configuration, the combined CSS/JS files generated by the HTML Compressor were being served over HTTP even when a site was configured to use HTTPS. This release applies a workaround for this improper server configuration that no longer looks at `$_SERVER['REQUEST_SCHEME']`. See [Issue #413](https://github.com/websharks/zencache/issues/413) and [Issue #73](https://github.com/websharks/html-compressor/issues/73).
- **Multisite Bug Fix**: Fixed a bug in the Auto-Cache Engine that was resulting in duplicate Cron Jobs being created for each Child Site. The Auto-Cache Engine now only runs from the Main Site in a network, as it should. When the Auto-Cache Engine runs on the Main Site, it will also run for each of the Child Blogs (see [this article](http://zencache.com/r/kb-article-how-does-the-auto-cache-engine-cache-child-blogs-in-a-multisite-network/) for more information). Props @jaswsinc. See [Issue #543](https://github.com/websharks/zencache/issues/543).
- **Enhancement**: Improved HTML Compressor HTTP connection handling, timeouts, protocol, BOM markers, exceptions, `Referer:` and `User-Agent:` headers. Props @LittleBastard77 @jaswsinc. See [Issue #391](https://github.com/websharks/zencache/issues/391) and [Issue #69](https://github.com/websharks/html-compressor/issues/69).
- **Enhancement**: Manual Cache Clearing options have now been separated from Automatic Cache Clearing options inside the ZenCache Plugin Options to improve the differentiation between these.
- **Enhancement**: New icons in the ZenCache Plugin Options help improve the visual representation of each panel.
- **Enhancement**: The installed plugin version is now shown at the top of the ZenCache Options Page. When a newer version of the plugin is available, an "update available" link appears. Props @renzms. See [Issue #502](https://github.com/websharks/zencache/issues/502).
- **Enhancement**: New transition in/out effects on the Cache Cleared Dashboard notifications. Props @jaswsinc. See [Issue #538](https://github.com/websharks/zencache/issues/538).

= v150821 =

- **Multisite Domain Mapping Compatibility**: ZenCache Pro is now fully compatible with the [WordPress MU Domain Mapping plugin](https://wordpress.org/plugins/wordpress-mu-domain-mapping/), including Multisite Networks using domain mapping on top-level domains, sub-domains, and sub-directories. Multiple variations of each site spread across an unlimited number of domain mappings and/or the original blog domain/path is also supported. All other features of ZenCache Pro, including the Auto-Cache Engine, Static CDN Filters, and HTML Compression are also now compatible with domain mapping. Props @jaswsinc. See [Issue #339](https://github.com/websharks/zencache/issues/339).
- **bbPress Compatibility**: This release greatly improves compatibility with bbPress. Events like creating a new Forum, creating a new Topic, and posting a reply to a Topic (including threaded replies), now properly clear the necessary cache files to ensure that cached bbPress pages remain up-to-date. Props @jaswsinc. See [Issue #168](https://github.com/websharks/zencache/issues/168).
- **Bug Fix**: Fixed a bug where, in some rare cases, `wp-config.php` would end up with two `WP_CACHE` definitions. Props @jaswsinc. See [Issue #509](https://github.com/websharks/zencache/issues/509).
- **Bug Fix**: Saving a Post as a Draft was incorrectly purging XML Sitemap cache files. Props @jaswsinc. See [Issue #368](https://github.com/websharks/zencache/issues/368).
- **Bug Fix:** The HTML Compressor now strips UTF-8  Byte Order Markers (BOMs) from CSS files generated by preprocessors such as Sass. Files consolidated by the HTML Compressor include an `@charset` rule already, making a BOM unnecessary. In fact, if BOMs are not stripped, some browsers will choke on portions of a consolidated CSS file, because a BOM could potentially appear in the middle of the file; i.e., at the _wrong_ place. Symptoms included mysterious missing styles in portions of the site, fonts not loading at all times, or font-based icons (e.g., FontAwesome) to render mystery glyphs instead of the icons. Props @jaswsinc. See [Issue #52](https://github.com/websharks/html-compressor/issues/52).
- **Bug Fix:** Improved HTML Compressor strict data type comparison when analyzing `$_SERVER` environment variables to detect an `https://` connection URL. We now detect `(integer)443` and `(string)443`. In addition, we can now pick up `$_SERVER['HTTPS']` being any of `1|on|yes|true` (caSe insensitive). Props @jaswsinc. See [Issue #61](https://github.com/websharks/html-compressor/issues/61).
- **Multisite Bug Fix**: Fixed a bug where the Clear Cache button wouldn't clear Child-Site Logged-In User Home Page cache files on WordPress Multisite Networks. Props @jaswsinc. See [Issue #409](https://github.com/websharks/zencache/issues/409)
- **Multisite Bug Fix**: Fixed a bug where the Home Page cache was not clearing on Child Sites in a Multisite Network. Props @jaswsinc. See [Issue #409](https://github.com/websharks/zencache/issues/409)
- **Multisite Bug Fix**: Fixed an issue where the Auto-Cache Engine would fail to auto-cache child blogs in a multisite network whenever the network was being served from a sub-directory. Props @jaswsinc. See [Issue #537](https://github.com/websharks/zencache/issues/537).
- **Multisite Bug Fix**: Fixed a bug with 404 Request caching on Multisite Networks where ZenCache Pro was not considering that each child blog in a multisite network will have its own 404 error page. Props @jaswsinc. See [Issue #539](https://github.com/websharks/zencache/issues/539).
- **Multisite Bug Fix**: Fixed a bug where clearing the cache from the main site of a multisite network, when there are child blogs in sub-directories, resulted in all child blogs being cleared from the cache, not just the main site as would be expected. This has been resolved and only the main site is cleared when clicking the Clear Cache button. Note that the Wipe Cache button can still be used to clear the cache for all sites in a Multisite Network. Props @jaswsinc. See [Issue #540](https://github.com/websharks/zencache/issues/540).
- **Multisite Bug Fix**: Fixed a bug where Wiping the cache on a multisite network resulted in the very next page view being cached incorrectly. Props @jaswsinc. See [Issue #541](https://github.com/websharks/zencache/issues/541).
- **Enhancement**: Improved compatibility with any Custom Post Type that uses hierarchies. Props @jaswsinc.

= v150716 =

- **Bug Fix**: Fixed a fatal error that was occurring on some sites after upgrading to v150629. We discovered the fatal error was related to PHP's outdated and buggy APC extension, which is often active on sites running PHP 5.3 and PHP 5.4. We now prevent activation of ZenCache on systems with the APC extension enabled and show a warning message instead. We've written [a KB Article that further explains the APC Extension Warning](http://zencache.com/kb-article/why-does-zencache-show-an-apc-extension-warning/) and offers advice to site owners who are currently running APC. See also [Issue #511](https://github.com/websharks/zencache/issues/511).
- **Bug Fix**: Fixed a bug in the Dynamic Version Salt filter that was generating PHP notices and warnings. See [Issue #522](https://github.com/websharks/zencache/issues/522).
- **Bug Fix**: Fixed an issue with backwards compatibility that was preventing some AC Plugins from working properly. See [Issue #514](https://github.com/websharks/zencache/issues/514).
- **Enhancement**: Added a stats pinger, similar to the WordPress stats collector, that reports the server OS, PHP version, MySQL version, WordPress version, and the ZenCache version, securely and anonymously to WebSharks. See [this KB Article](http://zencache.com/kb-article/what-information-does-zencache-pro-report-to-websharks/) for more information.

= v150626 =

- **Restructured Codebase**: The entire ZenCache codebase has been restructured to improve performance, enhance flexibility, and make it easier to build in new features!
- **New Feature!** The free version of ZenCache now supports several new options that were previously only available in the Pro version. You can now toggle the Auto-Clear Cache routines for the Home Page, Posts Page, Author Page, Category Archives, Tag Archives, Custom Term Archives, RSS/RDF/Atom Feeds, and XML Sitemaps. This gives you more control over exactly when ZenCache purges the cache for these parts of your site. See _ZenCache → Plugin Options → Clearing the Cache_ for further details.
- **New Feature!** URI Exclusion Patterns are now available in ZenCache Lite! This previously Pro-only feature is now available in the free version of ZenCache and allows you to exclude a list of URIs from being cached by ZenCache. See _ZenCache → Plugin Options → URI Exclusion Patterns_ for further details.
- **New Feature!** HTTP Referrer Exclusion Patterns are now available in ZenCache Lite! This previously Pro-only feature is now available in the free version of ZenCache and allows you to define a list of referring URLs or domains that send you traffic. When ZenCache sees a request coming from one of those URLs or domains, it will not cache that particular request. See _ZenCache → Plugin Options → HTTP Referrer Exclusion Patterns_ for further details.
- **New Pro Feature!**: HTML Compression now supports compressing JSON (in addition to the already supported HTML, JavaScript, and CSS compression). Props @jaswsinc. See [Issue #469](https://github.com/websharks/zencache/issues/469).
- **New Pro Feature!**: Static CDN Filters now supports multiple CDN hostnames. This allows you to configure more than one CDN hostname, also referred to as Domain Sharding. This makes it possible for site owners to work around web browser concurrency limits, allowing the browser to download many resources simultaneously, which increases overall speed. Props to @isaumya and @jaswsinc. See [Issue #468](https://github.com/websharks/zencache/issues/468).
- **Enhancement** (Pro): Static CDN Filters now includes proper support for WordPress Multisite Networks, including support for subdomains (full support for Domain Mapping coming in the next release). If you're running a WordPress Multisite Network and want to configure a CDN, see [this KB Article](http://zencache.com/kb-article/static-cdn-filters-for-wordpress-multisite-networks/) for further details.
- **Enhancement** (Pro): Static CDN Filters now also apply to any static files that are referenced inside CSS files. Props @jaswsinc. See [Issue #461](https://github.com/websharks/zencache/issues/461).
- **Enhancement**: Completed a major restructure of the entire codebase to improve modularity and dependency management. Props @jaswsinc.
- **Enhancement** (Pro): Static CDN Filters now supports the ability to configure separate CDN hostname(s) for each domain (or subdomain) that you run in a WordPress Multisite Network. Props @jaswsinc. See [Issue #475](https://github.com/websharks/zencache/issues/475).
- **Enhancement** (Pro): Static CDN Filters now support subdomains when ZenCache is running inside a WordPress Multisite Network. Props @jaswsinc. See [Issue #439](https://github.com/websharks/zencache/issues/439).
- **Bug Fix** (Pro): Static CDN Filters were not being applied to the primary site on WP Multisite installations that used subdomains. Props to @isaumya for discovering this bug. See [Issue #470](https://github.com/websharks/zencache/issues/470).

= v150409 =

- **Enhancement (includes improved CloudFlare support)**: Improvements to IP address detection, including added support for CloudFlare IP forwarding, multiple IPs in a single header, and the ability to customize the lookup order and/or add/remove sources that are searched when looking for the current IP address. It's also possible to revert to the old IP address detection behavior (see [How do I customize remote IP detection?](http://zencache.com/kb-article/how-do-i-customize-ip-address-detection/)). Props @jaswsinc. [Issue #449](https://github.com/websharks/zencache/pull/449)
- **Enhancement** (Pro): Files being served by the HTML Compressor were being sent without a `Vary: Accept-Encoding` header, which caused some page speed testing services to give a lower rating to sites using ZenCache. ZenCache now ensures this header is sent via an `.htaccess` file inside the HTML Compressor cache directory (requires Apache 2.1+). Props @jaswsinc. [Issue #436](https://github.com/websharks/zencache/issues/436).
- **Enhancement** (Pro): Static CDN Filters now also filter any static resources inside Text Widgets, so that those resources can be cached by your CDN. Props @jaswsinc. [Issue #430](https://github.com/websharks/zencache/issues/430)
- **Enhancement** (Pro): Static CDN Filters now apply to minified and compressed CSS/JS files generated by the HTML Compressor; these files will now be cached by your CDN. Props @jaswsinc. [Issue #429](https://github.com/websharks/zencache/issues/429)
- **Bug Fix**: Fixed a bug related to the Quick Cache migration that resulted in caching being disabled despite ZenCache being enabled. Uninstalling Quick Cache was removing `define('WP_CACHE', TRUE);` from the `wp-config.php` file. ZenCache now makes sure that caching remains enabled after uninstalling Quick Cache during the ZenCache migration process. [Issue #450](https://github.com/websharks/zencache/issues/450).
- **Bug Fix**: Fixed a minor UI issue where the ZenCache Dashboard icon would occasionally flash to a black color when refreshing the Dashboard. Props @jaswsinc. [Issue #453](https://github.com/websharks/zencache/issues/453).
- **Bug Fix**: When ZenCache was running on an installation of PHP with `open_basedir` restrictions applied, calls to `is_dir()` were triggering a PHP Warning while looking for a writable temporary directory. This bug has been fixed. [Issue #456](https://github.com/websharks/zencache/issues/456).
- **Bug Fix**: Fixed a bug where changing the permalink for a published post would result in the cache file for the old permalink being left behind and as a result both the old and the new permalink would be accessible, instead of WordPress redirecting the old permalink to the new one. This has been fixed and ZenCache now properly clears the old cache file when changing the permalink on a published post. [Issue #359](https://github.com/websharks/zencache/issues/359).
- **Bug Fix**: Fixed a bug where transitioning a Published post back to Pending or Draft would not automatically clear the cache file. This resulted in the post remaining accessible on the frontend despite being set as Pending or Draft. ZenCache now properly clears the cache file automatically when transitioning from Published to Pending or Draft, which prevents access to the post as expected. [Issue #441](https://github.com/websharks/zencache/issues/441).
- **Bug Fix** (Pro): Some users reported seeing `Warning: trim() expects parameter 1 to be string`. This was produced by a low-impact bug that has been fixed in this release. [Issue #455](https://github.com/websharks/zencache/issues/455).
- **Bug Fix** (Pro): Some users running the HTML Compressor reported seeing 403 Forbidden errors related to loading the compressed/minified files. This was a permissions-related issue that has been resolved in this release. Props @superian and @jaswsinc. See [Issue #50](https://github.com/websharks/html-compressor/issues/50).
- **Bug Fix** (Pro): Some HTTP requests made by the HTML Compressor to servers configured to reject HTTP requests that don't include a User-Agent were failing. A User-Agent is now always used in all requests. Props @jaswsinc. See [Issue #49](https://github.com/websharks/html-compressor/issues/49).
- **Minimum Required PHP Version Bumped to PHP v5.3.2+:** The minimum PHP version required for ZenCache has been bumped up to PHP v5.3.2+ (from PHP v5.3+). The ZenCache cache locking mechanism, specifically the use of `flock()`, requires behavior introduced in PHP v5.3.2. [Issue #444](https://github.com/websharks/zencache/issues/444).

= v150314 =

- **Bug Fix**: Fixed a bug in the Quick Cache back compat. method `\zencache\share\apply_wp_filters()`. It was not passing the ZenCache-filtered value through the Quick Cache back compat. routine. This bug affected sites that had disabled automatic cache clearing routines via a filter.
- **Bug Fix** (Pro): Updated Static CDN Filters whitelist to include font file extensions `eot,ttf,otf,woff`, as site owners may wish to serve fonts with these extensions from the CDN (this would require a custom CORS configuration; see [this article](http://davidwalsh.name/cdn-fonts) for instructions). See [#427](https://github.com/websharks/zencache/issues/427).
- **Bug Fix** (Pro): Updated Static CDN Filters blacklist to exclude font file extensions `eot,ttf,otf,woff` by default, as they require custom CORS configuration to display properly. See [#427](https://github.com/websharks/zencache/issues/427).
- **Bug Fix** (Pro): The Static CDN Filters feature was calling a protected method that was requiring PHP v5.4+ but now the Static CDN Filters feature works with PHP v5.3+. See [#426](https://github.com/websharks/zencache/issues/426).
- **Bug Fix**: Fixed a zero-byte `advanced-cache.php` bug related to migrating from Quick Cache. When you deleted/uninstalled Quick Cache after upgrading to ZenCache, the Quick Cache uninstallation process would empty the `advanced-cache.php` file, resulting in the site no longer being cached, despite ZenCache being active. ZenCache now continuously checks to make sure that `advanced-cache.php` is installed properly. See [#432](https://github.com/websharks/zencache/issues/432).

= v150218 =

**Announcing ZenCache, formerly Quick Cache!**

We are very excited to announce the release of [ZenCache](http://zencache.com), an advanced WordPress caching plugin inspired by simplicity. ZenCache is the successor to Quick Cache, a very popular WordPress caching plugin that has been downloaded over 1 million times and won acclaim for its speed, simplicity, and ease of configuration. [Read the full announcement here](http://zencache.com/announcing-zencache-formerly-quick-cache/).

ZenCache is an evolution of Quick Cache. It comes with a completely refactored codebase, subtle UI enhancements, internal optimizations; along with full backward compatibility with all previous versions of Quick Cache Lite and Quick Cache Pro. In fact, installing ZenCache on a site that was previously running Quick Cache is a piece of cake! Watch [this video](http://zencache.com/kb-article/how-to-migrate-from-quick-cache-lite-to-zencache-lite/) to learn more. All configuration options are preserved.

- **New Pro Feature: CDN Integration:** With the announcement and release of ZenCache we are excited to also announce a new, highly-requested feature: Static CDN Filters. This feature allows you to serve some and/or ALL static files on your site from a CDN of your choosing. See also: [Introduction to Static CDN Filters](http://zencache.com/kb-article/introduction-to-static-cdn-filters/).
- **Full Backwards Compatibility with Quick Cache and Quick Cache Pro:** ZenCache is fully backwards compatible with all previous versions of Quick Cache Lite and Quick Cache Pro. Simply install ZenCache and your existing Quick Cache options will preserved by ZenCache.

= v150129 =

- **Bug Fix** (Pro): Fixed a bug where the Pro Updater would fail when FTP or SFTP details via the WordPress Dashboard are required to perform updates. Props @jaswsinc. See [#389](https://github.com/websharks/quick-cache/issues/389).
- **Bug Fix**: Several fixes for a stubborn bug related to "Fatal Error: 'Unable to clear dir'" error messages and errors referencing "SplFileInfo::getMTime(): stat failed". Props @jaswsinc. See [#397](https://github.com/websharks/quick-cache/issues/397).
- **Bug Fix** (Pro): Fixed a bug where the `qcAC` variable (used to force-enable/disable GET Request caching) was not respected properly whenever a URL contained a query string and a user was currently logged into the site. Props @jaswsinc. See [#401](https://github.com/websharks/quick-cache/issues/401).

= v141231 =

- **Bug Fix**: Addressed another issue related to "Fatal Error: 'Unable to clear dir'" and tmp directories that don't get cleared by Quick Cache. This fix discards iteration references before renaming the tmp directories. Props @jaswsinc. See [#288](https://github.com/websharks/quick-cache/issues/288).
- **Bug Fix**: We have had a few reports of getMTime Stat failing when clearing the cache. This fix clears the Stat Cache before iteration when deleting files from the cache directory. Props @jaswsinc. See [#385](https://github.com/websharks/quick-cache/issues/385).
- **Enhancement**: Added a new filter (`quick_cache\\share_disable_cache_locking`) to allow disabling cache locking. Simply return boolean `TRUE` to this filter to disable cache locking. This may be useful for site owners who are experiencing issues with cache locking on web hosting platforms with filesystems that don't properly support locking. Note that this filter must be applied using an Advanced Cache Plugin (see **Dashboard → Quick Cache → Plugin Options → Theme/Plugin Developers**). See also [#387](https://github.com/websharks/quick-cache/issues/387).
- **Enhancement**: Added a new filter that allows forcing Semaphore cache locking on hosting platforms where `sem_get()` is available and would result in improved performance. Return `sem` to the `quick_cache\\share::cache_lock_lock_type` filter to force Semaphore cache locking, or `flock` to use the default method that uses `flock()`. Note that this filter must be applied using an Advanced Cache Plugin (see **Dashboard → Quick Cache → Plugin Options → Theme/Plugin Developers**). See also [#387](https://github.com/websharks/quick-cache/issues/387).

= v141205 =

- **Bug Fix**: Addressed another issue with "Fatal Error: 'Unable to clear dir'" messages by adding new blocking methods for cache lock and unlock, making it so that cache writes (including clearing, purging, wiping) all gain an exclusive lock on the cache directory while work is underway. Props @jaswsinc. See [#288](https://github.com/websharks/quick-cache/issues/288).
- **Bug Fix**: Fixed a Home Page clearing bug that arose in the previous release as the result of an extra leading `\/` in one of our regex patterns. Props @jaswsinc. See [#365](https://github.com/websharks/quick-cache/issues/365).

= v141110 =

- **Quick Cache is changing its name to ZenCache!** See [the blog post](http://www.websharks-inc.com/post/quick-cache-is-changing-its-name/) for full details.
- **Enhancement**: All dashboard notices will now include the number of files cleared for each notice.  Props @jaswsinc. See [#351](https://github.com/websharks/quick-cache/pull/351).
- **Enhancement**:  Quick Cache is now capable of doing atomic clearing/purging/wiping. On a Multisite network, this is now accomplished on a blog-specific basis, without needing to scan the entire network-wide cache directory. This should improve performance considerably on large networks (i.e. those with VERY large cache directories). Props @jaswsinc. See [#288](https://github.com/websharks/quick-cache/issues/288) and [#351](https://github.com/websharks/quick-cache/pull/351).
- **Enhancement**: Added a new class file (`/includes/utils-feed.php`) and refactored the XML feed clearing routine. With these utilities in place, the `auto_clear_xml_feeds_cache()` method is now much easier to deal with and comprehend. Props @jaswsinc. See [#351](https://github.com/websharks/quick-cache/pull/351).
- **Enhancement**: Quick Cache now scans each scheme sub-directory, i.e. `/http/` and `/https/`, separately to help break apart what was previously a much larger directory scan for sites that serve pages over both schemes. This will improve performance on both standard and Multisite network installs. See [#351](https://github.com/websharks/quick-cache/pull/351).
- **Enhancement**: Refactored codebase to improve modularity by creating new methods in `includes/share.php` for network-wide clearing/purging/wiping, host/blog-specific clearing/purging/wiping, recursively deleting a directory, assisting in translations, and several new string utilities. Props @jaswsinc. See [#351](https://github.com/websharks/quick-cache/pull/351).
- **Enhancement**: Renamed all `\quick_cache\plugin::auto_purge_*` methods, giving them the proper prefix of `auto_clear_*` instead to reflect proper Wipe/Clear/Purge terminology. Along with this, all of the `auto_purge_` option keys have been renamed as well. See new [Wipe/Clear/Purge wiki article](http://www.websharks-inc.com/r/quick-cache-wipeclearpurge-terminology-wiki/) for a description of these terms. Props @jaswsinc. See [#351](https://github.com/websharks/quick-cache/pull/351).
- **Enhancement**: All URI and Referrer exclusion patterns are now caSe insensitive. WordPress v4.0 will serve URIs without cAse sensitivity. All of the Quick Cache codebase has been updated to support caSe insensitive clearing/purging/wiping; along with caSe insensitive pattern matching against URIs. Props @jaswsinc. See [#351](https://github.com/websharks/quick-cache/pull/351).
- **Bug Fix (Pro)**: Fixed a bug with the Auto-Clear Author Cache routine that was presenting dashboard notices even when `change_notifications_enable` was off. Props @jaswsinc. See [#351](https://github.com/websharks/quick-cache/pull/351).
- **Bug Fix (Pro)**: Fixed a bug with the HTML Compressor where `style`, `link` and/or `script` tags could become out of order in certain scenarios. See: [#45](https://github.com/websharks/html-compressor/issues/45)
- **Bug Fix (Pro)**: Several HTML Compressor bug fixes related to JavaScript compression routines. See [#38](https://github.com/websharks/html-compressor/issues/38)
- **Bug Fix**: Fixed a bug that was occasionally generating "Fatal Error: 'Unable to clear dir'" messages. The root cause of this is believed to be non-atomic purging of cache directories which, on a busy site, could result in new cache files being created before a purging routine was finished clearing the directory. Clearing/purging/wiping is now atomic in all scenarios. Props @jaswsinc. See [#288](https://github.com/websharks/quick-cache/issues/288) and [#351](https://github.com/websharks/quick-cache/pull/351).
- **Bug Fix**: Fixed a bug in the Auto-Clear Custom Post Type Archive Cache that was not checking for the `$post_id` in `$this->static[__FUNCTION__]`. Props @jaswsinc. See [#351](https://github.com/websharks/quick-cache/pull/351).
- **Bug Fix**: Fixed a bug with the uninstaller whereby attempting to uninstall after receiving a notice that PHP 5.3+ is required would result in a blank screen and require manual removal of the plugin. See [#334](https://github.com/websharks/quick-cache/issues/334).
- **Bug Fix**: Fixed an issue with detecting cacheable requests that was, in rare instances, resulting in blank white pages for some site owners. See [#279](https://github.com/websharks/quick-cache/issues/279).

= v141001 =

- **Enhancement**: Improved Dashboard messaging for the `auto_clear_cache()` routine. See [#328](https://github.com/websharks/quick-cache/issues/328).
- **Enhancement (Pro)**: Improved consistency of Auto-Cache Engine User-Agent string by removing WordPress-version-specific identifier. See [#315](https://github.com/websharks/quick-cache/issues/315).
- **Enhancement (Pro)**: It is now possible to disable the automatic clear and wipe cache routines. If you have a very large site with many cache files, this feature allows you manual control over when the cache gets cleared or wiped. For complete documentation on this feature, see [Quick Cache Wiki - Clear and Wipe Cache Routines](https://github.com/websharks/quick-cache/wiki/Clear-Cache-and-Wipe-Cache-Routines). See also [#23](https://github.com/websharks/quick-cache/issues/23).
- **Bug Fix**: Fixes an issue with the Pro Preview mode where saving the plugin options may inadvertently save Pro-only options that could later cause issues if the plugin is upgraded to the Pro version. See [#311](https://github.com/websharks/quick-cache/pull/311#issuecomment-54491922).
- **Bug Fix**: Fixes an edge-case where the proper cache files do not get purged when a user with the Editor role publishes a new post with both a category and a tag associated with the post. See [#313](https://github.com/websharks/quick-cache/issues/313).
- **Bug Fix**: When Quick Cache purges/resets the cache for a post with a Custom Post Type, any cache files for the associated Custom Post Type archive view are now auto-purged, along with any associated XML feed cache files. See [#280](https://github.com/websharks/quick-cache/issues/280).
- **Bug Fix**: Fixed missing trailing slash in Directory / Expiration Time configuration panel. This was purely a visual inconsistency and had no effect on Quick Cache's functionality. See [#267](https://github.com/websharks/quick-cache/issues/267).
- **Bug Fix**: When saving custom CSS using JetPack's Custom CSS module, Quick Cache now properly purges the site cache to ensure that outdated cache files are not served to visitors. See [#246](https://github.com/websharks/quick-cache/issues/246).
- **Bug Fix**: When changes are made to WordPress General, Reading, Discussion, or Permalink settings (Dashboard -> Settings), Quick Cache now clears the cache to prevent an outdated cache file from being served to visitors. See [#223](https://github.com/websharks/quick-cache/issues/223).
- **Bug Fix**: When an active plugin is updated, or when an active theme or the parent theme for an active child theme is updated, or when WordPress Core is updated, Quick Cache now properly clears the cache to ensure that an outdated cache file does not get served to a visitor. See [#145](https://github.com/websharks/quick-cache/issues/145) and [#327](https://github.com/websharks/quick-cache/issues/327).
- **Bug Fix**: When a new comment is posted, Quick Cache now properly purges the cache files for any paginated comment pages. See [#336](https://github.com/websharks/quick-cache/issues/336).
- **Bug Fix (Pro)**: Fixed a bug where the HTML Compressor, when enabled with the "remove extra whitespace in the final HTML" option, would incorrectly remove `<!DOCTYPE html>`. See [#299](https://github.com/websharks/quick-cache/issues/299).
- **Bug Fix (Pro)**: Fixed a bug in the HTML Compressor that would, in certain scenarios, leave behind fragments of HTML comments. See [#295](https://github.com/websharks/quick-cache/issues/295).
- **Bug Fix (Pro)**: The Auto-Cache Engine now has an option to configure a delay between each request when pre-caching the site. There were some reports of the Auto-Cache Engine causing load issues with large sites on servers that sometimes had trouble handling many requests. See [#294](https://github.com/websharks/quick-cache/issues/294).
- **Bug Fix (Pro)**: Fixes an Auto-Cache Engine scheduling issue that may, in some scenarios, prevent it from running as expected. See [#291](https://github.com/websharks/quick-cache/issues/291).
- **Bug Fix (Pro)**: Fixed a bug with the HTML Compressor where `style`, `link` and/or `script` tags could end up out of order in certain scenarios. See [#45](https://github.com/websharks/html-compressor/issues/45).
- **Bug Fix (Pro)**: Fixed a bug in the HTML Compressor related to JavaScript compression routines. See [#38](https://github.com/websharks/html-compressor/issues/38).

= v140829 =

- **SECURITY FIX - Please upgrade immediately**: Fixes a security related to cached cookies sent in the header of a request. This only affects sites running plugins that might send cookie data via the header. See [#253](https://github.com/websharks/Quick Cache/issues/253)
- **Enhancement**: Auto-Purge RSS Feeds. Quick Cache will now automatically purge the cache for RSS/RDF/Atom Feeds when Feed Caching is enabled. This new option will purge the cache for the master feed, the master comments feed, feeds associated with comments on a Post/Page, term-related feeds (including mixed term-related feeds), and author-related feeds when you update a Post/Page, approve a Comment, or make other changes where Quick Cache can detect that certain types of Feeds should be purged. See [#182](https://github.com/websharks/Quick Cache/issues/182)
- **Enhancement**: Improve handling of symlink creation for 404 cache files by using atomic symlink creation to decrease the possibility of encountering a race condition. See [#242](https://github.com/websharks/Quick Cache/issues/242).
- **Enhancement**: Improved portability of `advanced-cache.php`. This will help reduce configuration overhead for site owners when migrating a WordPress installation from one server to another. See [#258](https://github.com/websharks/Quick Cache/issues/258).
- **Enhancement**: Option Panels now have proper HTML anchor tags so that they work better with browser extensions that rely on anchor tags being available. See [#260.](https://github.com/websharks/Quick Cache/issues/260)
- **Enhancement**: The Plugin Deactivation Safeguards option has been renamed to Plugin Deletion Safeguards. When Plugin Deletion Safeguards are disabled, deactivating and deleting the plugin will now erase your options for the plugin, erase directories/files created by the plugin, remove the advanced-cache.php file, terminate CRON jobs, etc. It completely erases itself, but only when you disable Plugin Deletion Safeguards (enabled by default to prevent accidental loss of data). See [#261](https://github.com/websharks/Quick Cache/issues/261).
- **Enhancement (Pro)**: HTML Compressor now includes FOPEN as transport layer fallback in case cURL is not available. See [#15](https://github.com/websharks/html-compressor/issues/15)
- **Enhancement (Pro)**: HTML Compressor now writes files atomically; this will help avoid race conditions when writing cache files. See [#273](https://github.com/websharks/Quick Cache/issues/273)
- **Enhancement (Pro)**: Improved error handling for the Auto-Cache Engine. There were some scenarios where `XMLReader()` would fail with a PHP Warning notice when it was unable to properly parse the sitemap. See [#250](https://github.com/websharks/Quick Cache/issues/250).
- **Bug Fix**: The cache directory is now properly removed when deleting the plugin from the WordPress Dashboard plugins list. See [#261](https://github.com/websharks/Quick Cache/issues/261).
- **Bug Fix**: WooCommerce compatibility fix for a bug where cart session data appeared to get cached across sessions. See [#253](https://github.com/websharks/Quick Cache/issues/253)
- **Bug Fix (Pro)**: The plugin upgrade notice no longer appears on Child Blogs in a Multisite Network. There was no security risk here; while the upgrade notice was shown, Child Blog admins who did not have permission to upgrade Network-activated plugins were unable to do anything with the message. See [#259](https://github.com/websharks/Quick Cache/issues/259).
- **Bug Fix (Pro)**: Fixed a bug where, in certain scenarios, a WordPress Plugin may break the JavaScript that controls the Clear Cache button on the Dashboard. See [#272](https://github.com/websharks/Quick Cache/issues/259).
- **Bug Fix (Pro)**: CSS files are now excluded from compression by the HTML Compressor when included inside conditional comments. See [#35](https://github.com/websharks/html-compressor/issues/35)
- **Bug Fix (Pro)**: HTML Compressor now preserves whitespace inside CSS `calc()` statements. See [#286](https://github.com/websharks/Quick Cache/issues/286).

= v140725 =

- **Enhancement**: Improved overall performance by optimizing the auto-purge routines. See also: [#130](https://github.com/websharks/Quick Cache/issues/130)
- **Enhancement**: The "GET Requests" UI Panel now explains that you can use `?zcAC=0` to disable caching when you ARE caching GET Requests. See also: [#210](https://github.com/websharks/Quick Cache/issues/210).
- **New Pro Feature: Auto-Purge XML Sitemaps**. If you're generating XML Sitemaps with a plugin like Google XML Sitemaps, you can now tell Quick Cache to automatically purge any cached sitemap files whenever it purges a Post/Page cache. You may also specify a list of XML Sitemap patterns to clear, if you have multiple sitemap files. See also: [#169](https://github.com/websharks/Quick Cache/issues/169)
- **Enhancement (Pro)**: The Quick Cache Pro Updater now accepts a License Key in place of the WebSharks password.
- **Enhancement (Pro)**: In a Multisite Network, the Auto-Cache Engine will now also auto-cache each child blog. See also: [#169](https://github.com/websharks/Quick Cache/issues/169)
- **Bug Fix**: Fixed a bug that was causing unapproved, spam, and trash comments to unnecessarily purge the cache. See also: [#159](https://github.com/websharks/Quick Cache/issues/159)
- **Bug Fix**: A custom `WP_CONTENT_DIR` is now obeyed in the scenario where it's set to a path outside of `ABSPATH`. See also: [#95](https://github.com/websharks/Quick Cache/issues/95)
- **Bug Fix**: The UI now correctly displays custom `WP_CONTENT_DIR` in the "Directory/Expiration Time" options panel. See also: [#206](https://github.com/websharks/Quick Cache/issues/206)
- **Bug Fix**: Quick Cache LITE now correctly sets the `Quick Cache_PRO` constant to false. See also: [#229](https://github.com/websharks/Quick Cache/issues/229)
- **Bug Fix**: Workaround for broken page navigation on the front page of some sites. This is a WordPress `redirect_canonical()` bug workaround. See also: [#209](https://github.com/websharks/Quick Cache/issues/209)
- **Bug Fix (Pro)**: 404 Caching now properly returns a 404 HTTP Status code when serving a cached 404 page. See also: [#197](https://github.com/websharks/Quick Cache/issues/197)
- **Bug Fix (Pro)**: The HTML Compressor now properly preserves `[]` character whitespace during CSS compression. See also: [#25](https://github.com/websharks/html-compressor/issues/25)
- **Bug Fix (Pro)**: The Pro Updater upgrade link now points to the correction location when displayed from a Child Blog in a Multisite Network. See also: [#205](https://github.com/websharks/Quick Cache/issues/205)
- **Bug Fix (Pro)**: The Auto-Cache Engine now correctly handles the sitemap when `home_url()` differs from `site_url()`.
- **Bug Fix (Pro)**: The "Dynamic Version Salt" options panel now correctly displays the last saved value. See also: [#231](https://github.com/websharks/Quick Cache/issues/231)

= v140605 =

- **New Feature**: Branched Cache Structure. Cache files are now written to the cache directory using a more intuitive format of `PROTOCOL`/`HOSTNAME`/`PERMALINK` (e.g., `http/example-com/sample-page.html`). For more details, please see <http://www.websharks-inc.com/r/Quick Cache-branched-cache-structure-wiki/>
- **New Feature**: 404 Page caching. It's now possible to enable/disable the caching of 404 requests. Enabling this feature generates a single cache file for your 404 Page and then symlinks future 404 requests to that cache file. See *Dashboard -> Quick Cache -> Plugin Options -> 404 Requests*.
- **New Feature (Pro)**: HTML Compressor (experimental). This new experimental feature automatically combines and compresses CSS/JS/HTML code. See *Dashboard -> Quick Cache -> Plugin Options -> HTML Compressor*. For more details about how this feature works, please see <https://github.com/websharks/HTML-Compressor>
- **New Feature (Pro)**: Auto-Cache Engine. When enabled, the Auto-Cache Engine will pre-cache your site at 15-minute intervals, rebuilding cache files when necessary (it will not rebuild cache files until they have expired). This helps eliminate the slowness a user may experience when visiting a page on your site that has not yet been cached. See *Dashboard -> Quick Cache -> Plugin Options -> Auto-Cache Engine*.
- **New Feature**: Auto-Purge "Author Page". When a single Post/Page is changed in some way, Quick Cache can also purge any existing cache files for the associated Author Page. See *Dashboard -> Quick Cache -> Plugin Options -> Clearing the Cache*. (This option is enabled by default; disabling this requires Quick Cache Pro.)
- **New Feature**: Auto-Purge "Category Archives". When a single Post/Page is changed in some way, Quick Cache can also purge any existing cache files for the associated Category archive views. See *Dashboard -> Quick Cache -> Plugin Options -> Clearing the Cache*. (This option is enabled by default; disabling this requires Quick Cache Pro.)
- **New Feature**: Auto-Purge "Tag Archives". When a single Post/Page is changed in some way, Quick Cache can also purge any existing cache files for the associated Tag archive views. See *Dashboard -> Quick Cache -> Plugin Options -> Clearing the Cache*. (This option is enabled by default; disabling this requires Quick Cache Pro.)
- **New Feature**: Auto-Purge "Custom Term Archives". When a single Post/Page is changed in some way, Quick Cache can also purge any custom Terms that may have their own Term archive views. See *Dashboard -> Quick Cache -> Plugin Options -> Clearing the Cache*. (This option is enabled by default; disabling this requires Quick Cache Pro.)
- **Enhancement**: Improved conflict handling of other plugins using `ob_start()`. See <https://github.com/websharks/Quick Cache/issues/97>
- **Enhancement**: Added a postload filter for `status_header` so that Quick Cache can properly detect calls to the WP core function `status_header()`
- **Enhancement**: The Quick Cache cache directory has been changed to `wp-content/cache/Quick Cache/` to provide better organization of cache files and avoid interfering with another plugin that may also be writing to the `wp-content/cache/` directory. See <https://github.com/websharks/Quick Cache/issues/123>
- **Enhancement**: New detailed debugging notes (see *Dashboard -> Quick Cache -> Plugin Options -> Enable/Disable*). There is now an extra option to show detailed debugging information in addition to the Quick Cache notes in the HTML source. For now, this feature only applies when the HTML Compressor is enabled.
- **Enhancement**: Better Debugging Notices. If Quick Cache is not caching a particular page (such as when a logged-in user visits the site and logged-in user caching is not enabled), Quick Cache will now report why that page is not being cached in the HTML notes.
- **Enhancement**: Improved compatibility with the Nav Menu Roles plugin. See <https://github.com/websharks/Quick Cache/issues/164>
- **Bug Fix**: Obey custom content directories. If you have customized your `WP_CONTENT_DIR` and `WP_CONTENT_URL` constants to point somewhere other than the default, Quick Cache will now obey those and use your custom directory for storing cache files. See <https://github.com/websharks/Quick Cache/issues/95>
- **Bug Fix**: Scheduled posts now trigger the clearing of any associated archive views when those posts go live (assuming you have those archive views set to Auto-Purge in *Dashboard -> Quick Cache -> Plugin Options -> Clearing the Cache*). See <https://github.com/websharks/Quick Cache/issues/26>
- **Bug Fix**: Fixed a bug where saving a post as `draft` would trigger the Auto-Purge Post routine and clear the cache for that post. Now only purges post status `publish` and `private` and when transitioning from `publish` or `private` post status to `draft`, `future`, or `private`. See <https://github.com/websharks/Quick Cache/issues/43>
- **Bug Fix**: Split/paginated comments and multi-page Posts/Page cache files are now purged properly when the post cache is purged. See <https://github.com/websharks/Quick Cache/issues/75>

= v140104 =

* **New Options for Feed Caching**. It's now possible to control RSS, RDF, and Atom Feed caching. The new default is for feed caching to be disabled, which resolves an issue where new posts don't show up in the feed until the cache is cleared. This version of Quick Cache disables feed caching to prevent this from happening. If you wish to cache feeds, you can enable feed caching in the options. See: <https://github.com/websharks/Quick Cache/issues/44>
* **New Automatic Updater for Quick Cache Pro**. Quick Cache Pro now includes an automatic updater which lets you to keep Quick Cache Pro updated right from within your WordPress Dashboard. To upgrade to a new version of Quick Cache Pro using the Automatic Updater, simply fill in your WebSharks-Inc.com credentials in the new Plugin Updater sub-panel (**Quick Cache Pro -› Plugin Updater**). See: <https://github.com/websharks/Quick Cache/issues/21>

= v131224 =

* **New Lite Enhancement**. The Home Page cache and Posts Page cache are now automatically purged when necessary (such as when a new post is published). See: <https://github.com/websharks/Quick Cache/issues/40>
* Improved Quick Cache version check notice.
* Improved Quick Cache options validation.
* **Bug Fix**. Quick Cache was previously not properly excluding systematic WordPress areas reliably, e.g. any file that begins with `wp-` and/or the `xmlrpc` file. These are now properly auto-excluded. On Multisite installations, `/files/` is also auto-excluded from being cached. This bug required fixing incorrect instances of `[?$]` in regex patterns. See: <https://github.com/websharks/Quick Cache/issues/41>
* **Multisite Enhancement**. When running Quick Cache on Multisite Network installation, only allow the plugin to be "Network Activated" (becuase that is how Quick Cache is designed to work). See: <https://github.com/websharks/Quick Cache/issues/50>
* **Multisite Enhancement**. New 'Wipe' button allows a site owner to clear (wipe) the cache for all sites in a Multisite Network at once. See: <https://github.com/websharks/Quick Cache/issues/48>
* **Multisite Bug Fix**. Clearing the cache on a Multisite Network configured to use sub-directories now works properly. See: <https://github.com/websharks/Quick Cache/issues/39>
* **Multisite Bug Fix**. Fixed unmatched closing parenthesis in regex. See: <https://github.com/websharks/Quick Cache/issues/37>
* **Multisite Bug Fix**. Added support for `PATH_CURRENT_SITE` and `$GLOBALS['base']`.
* **Multisite Bug Fix**. Removed depreciated VHOST code that was causing issues with clearing the cache.

= v131206 =

* **New Pro Feature**. It's now possible for developers to add custom PHP code to the cache clearing routines (e.g. custom code which might consider things like APC or memcache also). This requires [Quick Cache Pro](http://www.websharks-inc.com/product/Quick Cache/). Please check your Dashboard under: **Quick Cache Pro -› Clearing the Cache**. See also: [this screenshot](https://f.cloud.github.com/assets/1563559/1692324/7ae902c4-5e78-11e3-98ba-acbb08b30585.png).
* **Multisite Bug Fix**. Unable to clear the cache when running sub-directories. See: <https://github.com/websharks/Quick Cache/issues/30>
* **Multisite Bug Fix**. The "Clear Cache" button was not displayed for child blogs in a network. Fixed in this release.

= v131205 =

* Added hook to `wp_set_comment_status` to purge the comment cache when a comment status changes.
* Ignore `set_time_limit()` errors in case function is disabled in PHP configuration. This is a temporary fix and will be handled more appropriately in a future maintenance release. See also: <https://github.com/websharks/Quick Cache/issues/20>
* Added Raam Dev to the contributors list. Raam will now be leading the development of Quick Cache and Quick Cache Pro.

= v131128 =

* **New Plugin Architecture for Quick Cache.** This release introduces a new way for theme/plugin developers to modify the way Quick Cache operates at the `advanced-cache.php` level (e.g. very early-on). For further details on this, please check your Dashboard under: `Quick Cache -› Theme/Plugin Developers`. See also: <https://github.com/websharks/Quick Cache/issues/17>
* **Compatibility.** This release further improves PHP v5.3 detection. Quick Cache will now generate an administrative notice instead of a PHP exception; allowing the plugin to be activated, but without actually loading the plugin under this scenario. A notice to the site owner is helpful in cases where the plugin is NOT being updated through the Dashboard. This will remove the risk of crashing a site that's attempting to run Quick Cache w/o PHP v5.3+ installed. See also: <https://github.com/websharks/Quick Cache/issues/13>

= v131127 =

* **Compatibility.** This release improves PHP v5.3 detection. Quick Cache will now generate an administrative notice instead of a PHP exception; allowing the plugin to be activated, but without actually loading the plugin under this scenario. A notice to the site owner is helpful in cases where the plugin is NOT being updated through the Dashboard. This will remove the risk of crashing a site that's attempting to run Quick Cache w/o PHP v5.3+ installed. See also: <https://github.com/websharks/Quick Cache/issues/13>
* **New Pro Feature.** Clear Home Page (and/or Posts Page) on auto-purge. See: <https://github.com/websharks/Quick Cache/issues/11>
* **Bug Fix (Options -Indexes).** Removing unnecessary `.htaccess` file from the `/wp-content/plugins/Quick Cache/` directory that prevented directory indexing, as this is not compatible in all hosting environents. See: <https://github.com/websharks/Quick Cache/issues/9>
* **Bug Fix (ABSPATH).** Incorrect detection of the `/wp-config.php` file on sites that move this file up one directory. Fixed in this release. See: <https://github.com/websharks/Quick Cache/issues/7>
* **Bug Fix (Parse Error).** Correcting code that deals with an edge case where the `/wp-config.php` file may become corrupted upon deactivation of the Quick Cache plugin through the WP Dashboard. Fixed in this release. See: <https://github.com/websharks/Quick Cache/issues/6>
* **Bug Fix (Error Reporting).** Improving error message via Dashboard whenever permissions are an issue in one specific scenario. See: <https://github.com/websharks/Quick Cache/issues/16>
* **Enhancement (Pro Preview).** Adding a more visible way to disable Pro Preview mode in the Lite version of Quick Cache. See: <https://github.com/websharks/Quick Cache/issues/2>
* **Emergency Scenario** Adding notes in several sections of the `reamde.txt` file regarding "what to do in an emergency scenario".
* **See Also** <https://github.com/websharks/Quick Cache/issues?page=1&state=closed>

= v131121 =

* Updated to support all features and functionality of WordPress v3.7+ (this new release of Quick Cache requires WordPress v3.7+). The Quick Cache plugin is now being actively maintained and future updates and improvements will be released periodically by lead developer Jason Caldwell. The popularity of this plugin and recent acknowldegments at WordCamp in Boston have inspired Jason to revamp Quick Cache!
* The latest version of Quick Cache is a complete rewrite (OOP design). Faster! and even more dependable. NOTE: the free version of Quick Cache (this new LITE version); while it remains fully functional and is more-than-adequate for most sites; is now limited in some ways. The following advanced features from the previous release are no longer available in the lite version: a custom MD5 Version Salt; custom Exclusion Patterns; the Clear Cache button in the admin bar. These, and MANY other brand new features are now available only in the pro version of the plugin. For further details, please see: <http://www.websharks-inc.com/product/Quick Cache/>.
* Bug fix. Quick Cache now considers the `HTTPS` evironment variable in order to prevent cache collisions on sites that serve pages over SSL. Nothing to configure, this is now built into the Quick Cache engine.
* UI updates. An improved user interface makes configuring this plugin a dream! Quick Cache got an awesome makeover in this release.
* Improved support for multisite networks. It's never been easier to run Quick Cache on a multisite network. For further details, please see: **Dashboard -› Network Admin -› Quick Cache** when/if you have Multisite Networking enabled in WordPress.
* Update; PUT and DELETE requests are now considered by Quick Cache. By default, Quick Cache does NOT serve cached pages to users who are logged in, or to users who have left comments recently. Quick Cache also excludes administrative pages, login pages, POST/PUT/DELETE/GET(w/ query string) requests and/or CLI processes.
* Dropping support for `ob_gzhandler()`; and the like. Quick Cache will now throw PHP exceptions to warn you about this should it be an issue in your hosting environment. If you want to enable GZIP, please follow the instructions provided by Quick Cache and avoid the use of `ob_gzhandler()` as this is not a recommended way to enable GZIP on any hosting platform.
* Truly atomic cache file write updates. Removing support for SEM vs. FLOCK for file locking. Quick Cache no longer needs a mutex file. Cache file updates are written to a temp file and renamed for the best reliability and improved speed too!
* Localization. Quick Cache is now translatable. This release adds support for gettext translations, a very popular method for translating WordPress plugins. All parts of the Quick Cache plugin can be localized now. The source code was updated with calls to the `__` function and a new text domain was added: `Quick Cache`. PO translation files should be placed in your plugins directory, example: `/wp-content/plugins/Quick Cache-en_US.mo`; or in `WP_LANG_DIR/plugins/Quick Cache-en_US.mo`.
* Capability requirement. This release of Quick Cache requires that an Administrator be logged-in with the Capability of `activate_plugins`. This is a default Capability that comes with the Administrator Role in WordPress. So, unless you've modified your WordPress Roles/Capabilities in some extremely creative way, this should not impact you; just something to be aware of.
* **(Pro Version)** There is now a pro version of this plugin available. Please see: <http://www.websharks-inc.com/product/Quick Cache/>. The initial set of pro features include: the ability to cache logged-in users too! (VERY powerful, particularly for membership sites); a new improved "Clear Cache" button in the admin bar (along with an option to enable/disable this feature); the ability to disable Dashboard notifications related to automatic clearing/purging on change detections; Import/Export functionality for Quick Cache configuration files; URI exclusion patterns (now supporting wildcards too); User-Agent exclusion patterns (now supporting wildcards too); HTTP referrer exclusion patterns (now supporting wildcards too); an MD5 Version Salt; and rockstar support for all Quick Cache features.
* **(Pro Version)** Regarding URI/User-Agent/HTTP Referrer exclusion patterns. If you configured any of these options in the previous release and would like to continue to use them in this release, please upgrade to the pro version or contact lead developer Jason Caldwell for assistance. Note: if you had these options configured in the previous release, once you upgrade to the pro version they will come back just like they were. Either that, or you may choose to continue using the previous version of Quick Cache where this functionality still exists.
* Lite version source code now available on GitHub also: <https://github.com/websharks/Quick Cache>.

= v111203 =

* Updated to support WordPress® v3.3. Backward compatibily remains for WordPress® v3.2.x.

= v110720 =

* Bug fix. Corrected XSS security issue associated with the handling of ``$_SERVER["REQUEST_URI"]`` inside the comment lines that Quick Cache introduces at the bottom of the source code.
* Bug fix. Corrected cosmetic issue in WordPress v3.2 related to the positioning of the Clear Cache button.

= v110709 =

* Routine maintenance. No signifigant changes.

= v110708 =

* Routine maintenance. No signifigant changes.
* Compatibility with WordPress v3.2.

= v110523 =

* **Versioning.** Starting with this release, versions will follow this format: `yymmdd`. The version for this release is: `110523`.
* Routine maintenance. No signifigant changes.

= v2.3.6 =

* Routine maintenance. No signifigant changes.

= v2.3.5 =

* Bug fix. Under the right scenario, errors regarding the function `is_user_logged_in()` in the second phase of `advanced-cache.php` have been resolved in this release of Quick Cache.
* Compatibility. Quick Cache is now capable of dealing with themes/plugins that attempt to use `ob_start("ob_gzhandler")` inside a `header.php` file, or in other places that may create a problem in the nesting order of output buffers. For instance, this release of Quick Cache resolves some incompatiblities with Headway themes for WordPress®. Please note that GZIP should be enabled at the Apache level ( i.e. with an .htaccess file ), or in PHP using `zlib.output_compression = on`. Both of these methods are preferred over `ob_start("ob_gzhandler")`. If you must use `ob_start("ob_gzhandler")`, please make this declaration inside your `/wp-config.php` file, and NOT inside `/header.php`, as this creates a problem that Quick Cache must work around, and could ultimately prevent GZIP from working at all if you do it this way. For further details on how to enable GZIP with Quick Cache, please see the included `/readme.txt` file.

= v2.3.2 =

* Compatiblity. References to `dirname()` that were processed by the Quick Cache `/advanced-cache.php` handler should have been using `WP_CONTENT_DIR` for improved compatibility with WordPress® installations that may use non-standardized installation directories and/or symlinks.
* New Filter available for developers. Multisite Super Admins can now give their Child Blog owners the ability to manually clear the cache for their own site in the Network. Quick Cache accomplishes this by making the "Clear Cache" button visible in the administrative header for Child Blog owners. If you wish to enable this, you can use this Filter: `add_filter("ws_plugin__qcache_ms_user_can_see_admin_header_controls", "__return_true");`. This button is always visible to Super Admins. Adding this Filter makes it visible to all child Blog Owners as well.

= v2.3.1 =

* Framework updated; general cleanup.
* Optimizations. Further internal optimizations applied through configuration checksums that allow Quick Cache to load with even less overhead now.
* Bug fix. Quick Cache was suffering from a bug regression related to stale Last-Modified headers being sent with cached copies. This has been resolved in Quick Cache v2.3.1+.

= v2.3 =

* Framework updated; general cleanup.
* Updated with static class methods. Quick Cache now uses PHP's SPL autoload functionality to further optimize all of its routines.

= v2.2.8 =

* Framework updated; general cleanup.
* Updated for compatibility with WordPress® 3.1.

= v2.2.7 =

* Framework updated. General cleanup.

= v2.2.6 =

* Updated to disable caching on database failures that do not trigger a `5xx` error code. Quick Cache is now capable of disabling the cache engine dynamically on all database connection failures within WordPress®.

= v2.2.5 =

* Updated to support all `5xx` error codes. Quick Cache now monitors the `status_header` function for `5xx` error codes. If a `5xx` status header is detected, caching is automatically disabled, as it should be.

= v2.2.3 =

* Framework updated. General cleanup.

= v2.2.2 =

* Minor updates to the Ajax clearing routines that were implemented in v2.2.1.
* This update also adds compatibility with (offline) localhost installations of WordPress® (WAMP/MAMP).

= v2.2.1 =

* Support for `glob()` has been added to Quick Cache. In previous versions, it was impossible to pinpoint a specific cache file through Dynamic Pruning routines ( at least, not with 100% accuracy ). This was because an MD5 Version Salt *could* have been generated; based on arbitrary conditionals, set by the site owner. Quick Cache now stores its cache files with three MD5 hash strings, producing longer file names; but with the added benefit of improved Multisite compatibility, and improvements in optimization overall. Quick Cache can now handle dynamic pruning with 100% accuracy. Even supporting complex Multisite installations, with or without `SUBDOMAIN_INSTALL`.
* New feature. Quick Cache now integrates a `Clear Quick Cache` button into the WordPress® Dashboard. This makes it easy to force a "cache reset, via <code>ajax</code>", without having to navigate through the Quick Cache menu for this simple task. Another great benefit to this new button, is that it works in all Dashboard views, even in a Multisite installation across different backends. If you're running a Multisite installation, you can use this new button to clear the cache for a particular site/blog in your network, without interrupting others.
* Bug fix. The Constant `Quick Cache_ALLOWED` was being defined too early in the buffering routine. This has been resolved in v2.2.1.
* Optimization of `advanced-cache.php`. A few things have been streamlined even further.
* Added compatibility for the [WP Maintenance Mode](http://wordpress.org/extend/plugins/wp-maintenance-mode/) plugin, and also the [Maintenance Mode](http://wordpress.org/extend/plugins/maintenance-mode/) plugin. Quick Cache will disable itself when these plugins are enabled for maintenance.
* Added compatibility for other Maintenance Mode plugins that are capable of sending a `Status: 503` header, or a `Retry-After:` header.
* Added compatibility for plugins that create PHP sessions. Quick Cache will automatically disable itself when a PHP session is active.
* Added compatiblity for web hosts that insert a port number into the `$_SERVER["HTTP_HOST"]` variable. Quick Cache is now capable of handling this gracefully.
* Improvement. Removed references to `$blog_id = 1` in favor of `is_main_site()`; providing support for Multisite Mode, where there are multiple sites, instead of just multiple blogs.
* Updated Dynamic Pruning Hooks for Custom Post Types, and Custom Taxonomies in WordPress® 3.0+.
* Extended compatiblity for Quick Cache on SSL enabled blogs.

= v2.1.9 =

* Framework updated; general cleanup.
* Updated minimum requirements to WordPress® 3.0.

= v2.1.8 =

* Framework updated to WS-P-3.0.

= v2.1.7 =

* Bug fix. A bug related to gzinflate variations handled by the WP_Http class has been resolved. This was preventing Quick Cache from validating a custom MD5 Version Salt on some servers.
* Framework updated to WS-P-2.3.

= v2.1.6 =

* Auto-Cache Engine. References to `ws_plugin__qcache_curl_get()`, have been replaced by `c_ws_plugin__qcache_utils_urls::remote()`, which makes use of `wp_remote_request()` through the WP_Http class. This removes an absolute dependency on the cURL extension for PHP. This also gives Quick Cache/WordPress® the ability to decide with method of communication to use for HTTP requests; based on what the installation server has available. Note: this only affects the Auto-Cache Engine for Quick Cache, which is completely optional.
* Compatibility. Quick Cache is now smarter about the way it reports errors. For example, when/if there are directory permission issues with your `wp-content` directory; Quick Cache can help with this, in a more intuitive fashion.
* Compatibility. Support has been added for WordPress® 3.0 with Multisite/Networking enabled.
* Updated minimum requirements to WordPress® 2.9.2.
* Framework updated to WS-P-2.2.

= v2.1.5 =

* A new option for Dynamic Cache Pruning was added. You can now choose `Single + Front Page`. This makes it possible to Create or Edit a Post/Page, and have the cache automatically updated for that specific Post/Page. And.. in addition, your Front Page ( aka: Home Page ) will also be refreshed at the same time.
* A minor bug was fixed in the Dynamic Cache Pruning routines. This bug was originally introduced in Quick Cache v2.1.1, and has now been corrected in v2.1.5. This bug, under certain circumstances, was preventing Quick Cache from locating an expired md5 cache file, for some Posts/Pages being updated.
* Advanced feature addition. Quick Cache now comes bundled with a robust Auto-Cache Engine. This is an optional feature, for VERY advanced users. You'll find the new Auto-Cache Engine listed right along with all of the other Quick Cache options. This works in conjunction with an XML Sitemap.

= v2.1.4 =

* Advanced feature addition. You can now prevent caching dynamically whenever pages on your site receive traffic from specific URLs, specific domains, or even specific word fragments found within the HTTP_REFERER. This feature is very advanced, and will NOT impact your site unless you decide to use it for one reason or another.

= v2.1.3 =

* Added `De-Activation Safeguards` to the Quick Cache options panel.
* Updated the Quick Cache options panel. It's been given a make-over.
* Stable tag updated in support of tagged releases within the repository at WordPress.org.

= v2.1.2 =

* WebSharks Framework for Plugins has been updated to P-2.1.
* Updated caching routines in support of hosting providers running with CGI/FastCGI. Quick Cache has been tested with VPS.net, HostGator, BlueHost, (mt) Media Temple (gs) and (dv), The Rackspace Cloud, and several dedicated servers ( including some Amazon EC2 instances ) running with Apache; including support for both `mod_php` and also `CGI/FastCGI` implementations. Quick Cache should work fine with any Apache/PHP combination. Please report all bugs through the [Support Forum](http://www.primothemes.com/forums/viewforum.php?f=5).
* An issue was discovered with WordPress® MU `/files/` being accessed through `htaccess/mod_rewrite`. Quick Cache has been updated to exclude all `/files/` served under WordPress® MU, which is the way it should be. Requests that contain `/files/` are a reference to WordPress® Media, and there is no reason, to cache, or send no-cache headers, for Media. Quick Cache now ignores all references to `/files/` under WordPress® MU. This problem was not affecting all installations of WPMU, because there already are/were scans in place for Content-Type headers. However, under some CGI/FastCGI implementations, this was not getting picked on WMPU with `mod_rewrite` rules. This has been resolved in v2.1.2.

= v2.1.1 =

* A WPMU bug was corrected in Quick Cache v2.1.1. This bug was related to `HTTP_HOST` detection under WordPress® MU installations that were using sub-domains. Please thank `QuickSander` for reporting this important issue.

= v2.1 =

* Quick Cache has added further support for themes and plugins that dynamically set `Content-Type` headers through PHP routines. Quick Cache is now smart enough to automatically disable itself whenever a theme or plugin sends a `Content-Type` header that would be incompatible with Quick Cache. In other words, any `Content-Type` header that is not a variation of `HTML, XHTML or XML`.
* Quick Cache has also been upgraded to support the preservation of scripted headers sent by PHP routines. If a plugin or theme sends scripted headers ( using the `header()` function in PHP ), those headers will be preserved. They'll be stored along with the cache. This allows them to be sent back to the browser whenever a cached version is served on subsequent visits to the original file.
* Compatability checked against WordPress.org 2.9.1, 2.9.2 &amp; WordPress MU 2.9.1, 2.9.2. Everything looks good. No changes required.

= v2.0 =

* A few tweaks to the options panel.
* Documentation updated, several small improvements in error reporting.
* Additional error checking to support an even wider range of hosting providers.
* Added automation routines for safe re-activation after an upgrade is performed.

= v1.9 =

* Additional support added for WordPress® MU 2.8.6+.
* Security file `Quick Cache-mu.php` added specifically for MU installations. WordPress® MU is a special ( multi-user ) version of WordPress®. If you're running WordPress® MU, check the [readme.txt] file for WordPress® MU notations.

= v1.8 =

* Re-organized core framework. Updated to: P-2.0.
* Updated to support WP 2.9+.

= v1.7 =

* Updated documentation. Added some additional code samples.
* Tested with WP 2.8.5. Everything ok.

= v1.6 =

* We've added the ability to enable Double-Caching ( client-side caching ). Full documentation is provided in the Quick Cache options panel. This feature is for those of you who just want blazing fast speed and are not concerned as much about reliability and control. We don't recommend turning this on unless you realize what you're doing.

= v1.5 =

* Support for Dynamic Cache Pruning has been improved. Full documentation is provided in the Quick Cache options panel.
* Additional feature-specific documentation has been added to assist novice webmasters during configuration.

= v1.4 =

* Garbage collection has been further optimized for speed and performance on extremely high traffic sites.
* PHP Ternary expressions are now supported in your Version Salt. This takes your Version Salt to a whole new level.
* Additional code samples have been provided for Version Salts; showing you how to deal with mobile devices and other tricky situations.

= v1.3 =

* We've implemented both Semaphore ( `sem_get` ) and `flock()` mutex. If you're on a Cloud Computing Model ( such as the Rackspace® Cloud ), then you'll want to go with flock() unless they tell you otherwise. In all other cases we recommend the use of Semaphores over Flock because it is generally more reliable. The folks over at Rackspace® have suggested the use of flock() because of the way their Cloud handles multi-threading. In either case, flock() will be fully functional in any hosting environment, so it makes a great fallback in case you experience any problems.

= v1.2 =

* We've implemented a way for plugin developers to disallow caching during certain routines or on specific pages. You can set the following PHP Constant at runtime to disable caching. `define("Quick Cache_ALLOWED", false)`. We have also added backward compatibility for WP Super Cache, so that `define("DONOTCACHEPAGE", true)` will also be supported by plugins that have previously been written for compatibility with Super Cache. In other words, Quick Cache looks for either of these two Constants.

= v1.1 =

* Added the ability to create a Version Salt. This is a feature offered ONLY by Quick Cache. Full documentation is provided in the Quick Cache options panel. This can become very useful for sites that provide membership services or have lots and lots of plugins installed that makes their site incompatible with WP Super Cache. With Quick Cache, you'll now have more control over the entire caching process using a custom Version Salt tailored to your specific needs.

= v1.0 =

* Initial release.
