<?php

/*======================================================================*\
|| #################################################################### ||
|| # Drag'nDrop Shop 1.8                                              # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2014 JAKWEB All Rights Reserved.                       # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| #   ----------- Drag'nDrop Shop IS NOT FREE SOFTWARE -----------   # ||
|| #                      http://www.jakweb.ch                        # ||
|| #################################################################### ||
\*======================================================================*/

// Check if the file is accessed only via index.php if not stop the script from running
if (!defined('JAK_PREVENT_ACCESS')) die('You cannot access this file directly.');

if (!JAK_SHOPSEARCH) jak_redirect(BASE_URL);

$errors = array();
$jaktable = DB_PREFIX.'shop';
$jaktable1 = DB_PREFIX.'shop_payment';
$jaktable2 = DB_PREFIX.'shop_order';
$jaktable3 = DB_PREFIX.'user';
$jaktable4 = DB_PREFIX.'shop_shipping';
$jaktable5 = DB_PREFIX.'shop_order_details';
$jaktable6 = DB_PREFIX.'shopping_cart';
$jaktable7 = DB_PREFIX.'categories';

// parse url
$backtoshop = JAK_rewrite::jakParseurl('', '', '', '', '');
$shopcheckout = JAK_rewrite::jakParseurl('checkout', '', '', '', '');
$shopsearch = JAK_rewrite::jakParseurl('search', '', '', '', '');


// Import all classes
include_once 'class/shopping_cart.php';
include_once 'class/currency_converter.php';

// Start the shopping cart
$shopping_cart = new Shopping_Cart();
$shopping_cart->startTheCart();

// Start the Currency Converter
$convert = new CurrencyConverter();

// The new Shop Currency exchange
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['currency'])) {
	
	if ($convert->CheckCurrency($_POST['currency'])) {
	
		$_SESSION['ECOMMERCE_CURRENCY'] = $_POST['currency'];
	
	} else {
	
		$_SESSION['ECOMMERCE_CURRENCY'] = JAK_CURRENCY;
	}	
}

if (!isset($_SESSION['ECOMMERCE_CURRENCY'])) {

	$_SESSION['ECOMMERCE_CURRENCY'] = JAK_CURRENCY;
}

$JAK_CURRENCY = $_SESSION['ECOMMERCE_CURRENCY'];
$E_CURRENCY_CHOOSE = $convert->CurrencyChoose();

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['search'])) {

    $defaults = $_POST;
	$errors = array();
	
    if ($defaults['search'] == '') {
        $errors['e1'] = $tl['search']['s1'];
    }

    if (strlen($defaults['search']) < '3') {
        $errors['e2'] = $tl['search']['s2'];
    }

    if (count($errors) > 0) {
        $errors['e'] = $tl['search']['s3'];
        $serrors = $errors;
    } else {
    
    	$filtered = filter_var($defaults['search'], FILTER_SANITIZE_STRING);
    	$searchf = strtolower($filtered);

		$result = $jakdb->query('SELECT t1.id, t1.catid, t1.title, t1.previmg, t1.img, t1.price, t1.sale, t1.product_options, t1.product_options1, t1.product_options2, t1.stock, t2.varname FROM '.$jaktable.' AS t1 LEFT JOIN '.$jaktable7.' AS t2 ON (t1.catid = t2.id) WHERE t1.active = 1 AND (LOWER(t1.title) LIKE "%'.smartsql($searchf).'%" OR LOWER(t1.content) LIKE "%'.smartsql($searchf).'%") ORDER BY t1.ecorder ASC');
		
		while ($row = $result->fetch_assoc()) {
		
			$seo = '';
			$onsale = 0;
			$instock = 1;
		
			if (JAK_SHOPURL) {
				$seo = JAK_base::jakCleanurl($row['title']);
			}
				
				if ($row['sale'] != "0.00") {
					$row['price'] = $row['sale'];
					$onsale = 1;
				}
				
				if ($_SESSION['ECOMMERCE_CURRENCY'] != JAK_CURRENCY) {
				
					$row['price'] = $convert->Convert($row['price'], $_SESSION['ECOMMERCE_CURRENCY']);
				}
				
				// image exist
				if ($row['previmg']) {
					$imge = $row['previmg'];
				} else {
					$imge = 'img/no_product_photo.png';
				}
				
				// big image exist
				if (!empty($row['img'])) $bigimg = $row['img'];
				
				if ($row['catid']) {
					$catname = $row['varname'];
				} else {
					$catname = 'all';
				}
				
				if (JAK_SHOPQUANTITY) {
				
					if ($row['stock'] <= 0) {
						$instock = $tl['shop']['m57'];
						$addtocart = false;
					} else {
						$instock = $row['stock'];
						$addtocart = true;
					}
				
				} else {
				
					if ($row['stock'] == 1) {
						$instock = $tl['shop']['m56'];
						$addtocart = true;
					} else {
						$instock = $tl['shop']['m57'];
						$addtocart = false;
					}
				
				}
				
				// There should be always a varname in categories and check if seo is valid
				$parseurl = JAK_rewrite::jakParseurl('i', $row['id'], $seo, '', '');
				
		        // collect each record into $jakdata
		        $jakdata[] = array('id' => $row['id'], 'title' => $row['title'], 'showtitle' => $row['showtitle'], 'previmg' => $imge, 'img' => $bigimg, 'parseurl' => $parseurl, 'price' => $row['price'], 'sale' => $row['sale'], 'product_options' => $row['product_options'], 'product_options1' => $row['product_options1'], 'product_options2' => $row['product_options2'], 'onsale' => $onsale, 'catname' => $row['varname'], 'parseurl' => $parseurl, 'instock' => $instock, 'addtocart' => $addtocart);
		    }
		    
		}
		
}
		
		
		$JAK_ECOMMERCE_ALL = $jakdata;
		
		$PAGE_TITLE = JAK_TITLE;
		$PAGE_CONTENT = JAK_WELCOME_MESSAGE;
		
		$PAGE_SHOWTITLE = 1;
		
		$JAK_SHOP_CAT = JAK_Base::jakGetcatmix($jaktable7, JAK_SHOPURL);
		
		// get the standard template
		$template = 'shop.php';
?>