<?php

/*======================================================================*\
|| #################################################################### ||
|| # Drag'nDrop Shop 1.8                                              # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2014 JAKWEB All Rights Reserved.                       # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| #   ----------- Drag'nDrop Shop IS NOT FREE SOFTWARE -----------   # ||
|| #                      http://www.jakweb.ch                        # ||
|| #################################################################### ||
\*======================================================================*/

// Check if the file is accessed only via index.php if not stop the script from running
if(!defined('JAK_PREVENT_ACCESS')){
die('You cannot access this file directly.');
}

$errors = array();
$jaktable = DB_PREFIX.'shop';
$jaktable1 = DB_PREFIX.'shop_payment';
$jaktable2 = DB_PREFIX.'shop_order';
$jaktable3 = DB_PREFIX.'user';
$jaktable4 = DB_PREFIX.'shop_shipping';
$jaktable5 = DB_PREFIX.'shop_order_details';
$jaktable6 = DB_PREFIX.'shopping_cart';
$jaktable7 = DB_PREFIX.'categories';

// parse url
$backtoshop = JAK_rewrite::jakParseurl('', '', '', '', '');
$shopcheckout = JAK_rewrite::jakParseurl('checkout', '', '', '', '');


// Import all classes
include_once 'class/shopping_cart.php';
include_once 'class/currency_converter.php';

// Start the shopping cart
$shopping_cart = new Shopping_Cart();
$shopping_cart->startTheCart();

// Start the Currency Converter
$convert = new CurrencyConverter();

// The new Shop Currency exchange
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['currency'])) {
	
	if ($convert->CheckCurrency($_POST['currency'])) {
	
		$_SESSION['ECOMMERCE_CURRENCY'] = $_POST['currency'];
	
	} else {
	
		$_SESSION['ECOMMERCE_CURRENCY'] = JAK_CURRENCY;
	}	
}

if (!isset($_SESSION['ECOMMERCE_CURRENCY'])) {

	$_SESSION['ECOMMERCE_CURRENCY'] = JAK_CURRENCY;
}

$JAK_CURRENCY = $_SESSION['ECOMMERCE_CURRENCY'];
$E_CURRENCY_CHOOSE = $convert->CurrencyChoose();

if (is_numeric($page1) && jak_row_exist($page1, $jaktable)) {

$result = $jakdb->query('SELECT * FROM '.$jaktable.' WHERE id = "'.smartsql($page1).'" LIMIT 1');
$row = $result->fetch_assoc();

if ($row['active'] != 1) {

	jak_redirect(JAK_rewrite::jakParseurl('404', '', '', '', ''));
	exit;
	
} else {

	// Now let's check the vote and hits cookie
	if (jak_cookie_voted_hits($jaktable, $row['id'], $_COOKIE['hits'])) {
	
		jak_write_vote_hits_cookie($jaktable, $row['id'], 'hits');
		
		// Update hits each time
		JAK_base::jakUpdatehits($row['id'],$jaktable);
	}
		
	// Now output the data
	$PAGE_ID = $row['id'];
	$PAGE_TITLE = $row['title'];
	$PAGE_CONTENT = $row['content'];
	$SHOWTITLE = $row['showtitle'];
	$SHOWDATE = $row['showdate'];
	$SHOWVOTE = $row['showvote'];
	$SHOWSOCIALBUTTON = $row['socialbutton'];
	$SHOP_HITS = $row['hits'];
	
	$PAGE_TIME = JAK_base::jakTimesince($row['time'], JAK_DATEFORMAT, JAK_TIMEFORMAT);
	$PAGE_TIME_HTML5 = date("Y-m-d", strtotime($row['time']));
	
	if ($row['sale'] != "0.00") {
		$row['price'] = $row['sale'];
		$onsale = 1;
	}
	
	if ($row['stock'] == 1) {
		$instock = $tl['shop']['m56'];
	} else {
		$instock = $tl['shop']['m57'];
	}
	
	if ($_SESSION['ECOMMERCE_CURRENCY'] != JAK_CURRENCY) {
	
		$row['price'] = $convert->Convert($row['price'], $_SESSION['ECOMMERCE_CURRENCY']);
	}
	
	if ($row['previmg']) {
		$row['previmg'] = $row['previmg'];
	} else {
		$row['previmg'] = 'img/no_product_photo.png';
	}
	
	// big image exist
	if (!empty($row['img'])) $row['img'] = $row['img'];

// Get the url session
$_SESSION['jak_lastURL'] = JAK_rewrite::jakParseurl($page1, $page2, $page3, '', '');

// Page Nav
$nextp = jak_next_page($page1, 'title', $jaktable, 'id', '', '', 'active');
if ($nextp) {
	
	if (JAK_SHOPURL) {
		$seo = JAK_base::jakCleanurl($nextp['title']);
	}
	
	$JAK_NAV_NEXT = JAK_rewrite::jakParseurl('i', $nextp['id'], $seo, '', '');
	$JAK_NAV_NEXT_TITLE = addslashes($nextp['title']);
}

$prevp = jak_previous_page($page1, 'title', $jaktable, 'id', '', '', 'active');
if ($prevp) {
	
	if (JAK_SHOPURL) {
		$seop = JAK_base::jakCleanurl($prevp['title']);
	}
	
	$JAK_NAV_PREV = JAK_rewrite::jakParseurl('i', $prevp['id'], $seop, '', '');
	$JAK_NAV_PREV_TITLE = addslashes($prevp['title']);
}

}
} else {
	jak_redirect($backtoshop);
	exit;
}

// get the standard template
$template = 'shopitem.php';
?>