<?php

/*======================================================================*\
|| #################################################################### ||
|| # Drag'nDrop Shop 1.8                                              # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2014 JAKWEB All Rights Reserved.                       # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| #   ----------- Drag'nDrop Shop IS NOT FREE SOFTWARE -----------   # ||
|| #                      http://www.jakweb.ch                        # ||
|| #################################################################### ||
\*======================================================================*/

if (!file_exists('../config.php')) {
    die('[install.php] config.php not found');
}
require_once '../config.php';

/* NO CHANGES FROM HERE */

// Set successfully to zero
$succesfully = 0;

?>

<!DOCTYPE html>
<html lang="en">

<head>
	<title>Update Drag'nDrop Shop to 1.8</title>
	<meta charset="utf-8">
	<meta name="author" content="JAKWEB (http://www.jakweb.ch)" />
	<link rel="shortcut icon" href="../favicon.ico" type="image/x-icon" />
	<link rel="stylesheet" href="../admin/css/screen.css" type="text/css" media="screen" />
</head>
<style type="text/css">
section {
	width:950px;margin:50px auto 0em;
}
header {
	background-color: #222;
	height: 60px;
}
header h1 {
	font-size: 28px;
	margin: 15px 20px;
	color: #fff;
	text-shadow: 0 1px 0 #000;
	font-weight: normal;
}
h2 {
	font-size: 14px;
	margin-bottom: 10px;
}
</style>
<body>

<div id="container">
<header><h1>Welcome to the update for Drag'nDrop Shop 1.8</h1></header><!-- #header -->

<div class="main">

<section>

<div id="installation">
<h2>Welcome to the update for Drag'nDrop Shop 1.8</h2>
<?php 

$result = $jakdb->query('SELECT value FROM '.DB_PREFIX.'setting WHERE varname = "version"');
$row = $result->fetch_assoc();
if ($row["value"] == "1.8") { $succesfully = 1; ?>

<div class="status-ok">Your Drag'nDrop Shop from JAKWEB is already up to date!</div>

<!-- Plugin is not installed let's display the installation script -->
<?php } else { if (isset($_POST['update']) && $_GET['step'] == 2) {

if ($row["value"] == "1.0") {

$jakdb->query("INSERT INTO ".DB_PREFIX."shop_payment (`id`, `title`, `field`, `field1`, `field2`, `field3`, `fees`, `status`, `msporder`) VALUES (NULL, 'AlertPay', 'AlertPay', NULL, NULL, NULL, '0', '0', '8')");

$jakdb->query("ALTER TABLE ".DB_PREFIX."shop_order ADD `downloadid` INT(10) UNSIGNED NOT NULL DEFAULT '0' AFTER `ordernumber`, ADD `downloadtime` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' AFTER `downloadid`");

}

if ($row["value"] == "1.0" || $row["value"] == "1.1") {

$jakdb->query('UPDATE '.DB_PREFIX.'shop_payment SET title = "Payza", field = "Payza" WHERE id = 8');

$jakdb->query("INSERT INTO ".DB_PREFIX."shop_payment (`id`, `title`, `field`, `field1`, `field2`, `field3`, `fees`, `status`, `msporder`) VALUES (NULL, 'Skrill (Moneybookers)', 'Skrill', NULL, NULL, NULL, '0', '0', '9')");

}

if ($row["value"] == "1.0" || $row["value"] == "1.1" || $row["value"] == "1.2") {

$jakdb->query('ALTER TABLE '.DB_PREFIX.'shop CHANGE `product_weight` `product_weight` FLOAT(10,3) NULL DEFAULT NULL');
$jakdb->query('ALTER TABLE '.DB_PREFIX.'shopping_cart CHANGE `weight` `weight` FLOAT(10,3) NULL DEFAULT NULL');
$jakdb->query('ALTER TABLE '.DB_PREFIX.'shop_order_details CHANGE `weight` `weight` FLOAT(10,3) NULL DEFAULT NULL');
$jakdb->query('ALTER TABLE '.DB_PREFIX.'shop_shipping CHANGE `weightfrom` `weightfrom` FLOAT(10,3) NULL DEFAULT NULL, CHANGE `weightto` `weightto` FLOAT(10,3) NULL DEFAULT NULL');
$jakdb->query('ALTER TABLE '.DB_PREFIX.'shop_order ADD `discount` FLOAT(10,2) NULL AFTER `total_price`, ADD `freeshipping` smallint(1) unsigned NOT NULL DEFAULT 0 AFTER `shipping`');
$jakdb->query('ALTER TABLE '.DB_PREFIX.'shop_order_details ADD `coupon_price` FLOAT(10,2) NULL AFTER `price`');

$jakdb->query("INSERT INTO ".DB_PREFIX."setting (`varname`, `groupname`, `value`, `defaultvalue`, `optioncode`, `datatype`, `product`) VALUES ('shopquantity', 'setting', '1', '0', 'yesno', 'boolean', 'shop')");

$jakdb->query("ALTER TABLE ".DB_PREFIX."shop CHANGE `stock` `stock` INT(11) NOT NULL DEFAULT 1");

$jakdb->query("CREATE TABLE IF NOT EXISTS ".DB_PREFIX."shop_coupon (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `code` varchar(255) DEFAULT NULL,
  `type` smallint(1) unsigned NOT NULL DEFAULT '0',
  `discount` float(10,2) DEFAULT NULL,
  `freeshipping` smallint(1) unsigned NOT NULL DEFAULT '0',
  `datestart` int(10) unsigned NOT NULL DEFAULT '0',
  `dateend` int(10) unsigned NOT NULL DEFAULT '0',
  `total` int(11) unsigned NOT NULL DEFAULT '0',
  `used` int(11) unsigned NOT NULL DEFAULT '0',
  `products` mediumtext,
  `status` smallint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1");

}

if ($row["value"] == "1.0" || $row["value"] == "1.1" || $row["value"] == "1.2" || $row["value"] == "1.3") {

$jakdb->query('CREATE TABLE '.DB_PREFIX.'shop_user (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(100) DEFAULT NULL,
  `password` char(64) NOT NULL,
  `idhash` varchar(32) DEFAULT NULL,
  `session` varchar(64) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `company` varchar(100) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `country` int(3) unsigned NOT NULL DEFAULT 0,
  `city` varchar(100) DEFAULT NULL,
  `zip_code` varchar(100) DEFAULT NULL,
  `time` datetime NOT NULL DEFAULT "0000-00-00 00:00:00",
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1');

$jakdb->query('ALTER TABLE '.DB_PREFIX.'shop ADD `product_home` SMALLINT(1) UNSIGNED NOT NULL DEFAULT 0 AFTER `catid`');

$jakdb->query('INSERT INTO '.DB_PREFIX.'setting (`varname`, `groupname`, `value`, `defaultvalue`, `optioncode`, `datatype`, `product`) VALUES ("shopsearch", "setting", 1, 1, "yesno", "boolean", "shop")');

}

$jakdb->query("INSERT INTO ".DB_PREFIX."shop_payment (`id`, `title`, `field`, `field1`, `field2`, `field3`, `fees`, `status`, `msporder`) VALUES (NULL, 'Stripe', 'Credit Card', NULL, NULL, NULL, '0', '0', '10')");

$jakdb->query('UPDATE '.DB_PREFIX.'setting SET value = "1.8" WHERE varname = "version"');

// Now let us delete the define cache file
$cachedeffile = '../'.JAK_CACHE_DIRECTORY.'/define.php';
if (file_exists($cachedeffile)) {
	unlink($cachedeffile);
}

$succesfully = 1;

?>
<div class="status-ok">Database update successfully, please delete or rename the <strong>install</strong> directory. You can now log in, in your <a href="../admin/">administration</a> panel.</div>
<?php } ?>

<?php if (!$succesfully) { ?>
<p><strong>Please follow this steps carefully before you update the database!</strong></p>
<p>
	<ul>
	<li>Backup all your files and your database.</li>
	<li>Upload all folders and files from the new version (except templates if modified).</li>
	<li>Be sure to have a backup from your database before you update!</li>
	<li>You have an up to date update from your database? OK, hit "Update Database".</li>
</ul>
<form name="company" method="post" action="update.php?step=2" enctype="multipart/form-data">
<input style="float:right;" type="submit" value="Update Database" name="update" />
</form>
<?php } } ?>
</p>

</div>

</section>

<footer>Copyright 2014 by <a href="http://www.jakweb.ch">JAKWEB</a></footer>

</div>

</div><!-- #container -->
</body>
</html>