<?php

/*======================================================================*\
|| #################################################################### ||
|| # Drag'nDrop Shop 1.8                                              # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2014 JAKWEB All Rights Reserved.                       # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| #   ----------- Drag'nDrop Shop IS NOT FREE SOFTWARE -----------   # ||
|| #                      http://www.jakweb.ch                        # ||
|| #################################################################### ||
\*======================================================================*/

if (!file_exists('../include/db.php')) {
    die('[install.php] include/db.php not exist');
}
require_once '../include/db.php';

/* NO CHANGES FROM HERE */

// Get the ls DB class
if (JAK_MYSQL_CONNECTION == 1) {
	require_once '../class/class.db.php';
} else {
	require_once '../class/class.dbn.php';
}

// Absolute Path
define('DIR_APPLICATION', str_replace('\'', '/', realpath(dirname(__FILE__))) . '/');
define('DIR_Shop', str_replace('\'', '/', realpath(DIR_APPLICATION . '../')) . '/');

function smartsql($value)
{
	global $jakdb;
    if (!is_int($value)) {
        $value = $jakdb->real_escape_string($value);
    }
    return $value;
}

// Now check if the database is empty
$check_db_content = false;
$show_form = true;

// MySQL/i connection
if (DB_USER && DB_PASS) {

	@$linkdb = mysql_connect(DB_HOST.':'.DB_PORT, DB_USER, DB_PASS, DB_NAME);
	@mysql_select_db(DB_NAME);

	@$result = mysql_query('SELECT name FROM '.DB_PREFIX.'shop_country WHERE id = 1 LIMIT 1');
	
	if ($result) {
	    $check_db_content = true;
	}
	
	// Finally close all db connections
	@mysql_close($linkdb);
}

?>

<!DOCTYPE html>
<html lang="en">

<head>
	<title>Installation Drag'nDrop Shop</title>
	<meta charset="utf-8">
	<meta name="author" content="JAKWEB (http://www.jakweb.ch)" />
	<link rel="shortcut icon" href="../favicon.ico" type="image/x-icon" />
	<link rel="stylesheet" href="../admin/css/screen.css" type="text/css" media="screen" />
</head>
<style type="text/css">
header {
	background-color: #222;
	height: 60px;
}
section {
	width:800px;margin:50px auto 0em;
}
header h1 {
	font-size: 28px;
	margin: 15px 20px;
	color: #fff;
	text-shadow: 0 1px 0 #000;
	font-weight: normal;
}
h2 {
	font-size: 14px;
}
</style>
<body>

<div id="container">
<header><h1>Welcome to the installation for Drag'nDrop Shop</h1></header><!-- #header -->

<section>

<div id="installation">
<p><h2>Welcome to the installation for Drag'nDrop Shop</h2>
<?php if (isset($_POST['install']) && $_GET['step'] == 2) {

// MySQL/i connection
if (DB_USER && DB_PASS) {
$jakdb = new jak_mysql(DB_HOST, DB_USER, DB_PASS, DB_NAME, DB_PORT);
$jakdb->set_charset("utf8");
}

$jakdb->query('CREATE TABLE '.DB_PREFIX.'categories (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `varname` varchar(100) DEFAULT NULL,
  `catimg` varchar(255) DEFAULT NULL,
  `catorder` int(11) unsigned NOT NULL DEFAULT 1,
  `catparent` int(11) unsigned NOT NULL DEFAULT 0,
  `subexist` smallint(1) unsigned NOT NULL DEFAULT 0,
  `count` int(10) unsigned NOT NULL DEFAULT 0,
  `active` smallint(1) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `catorder` (`catorder`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4');

$jakdb->query("INSERT INTO ".DB_PREFIX."categories VALUES (1, 'Pop', 'pop', 'files/catimg/stop_16.png', 1, 0, 0, 8, 1), (2, 'Rock', 'rock', 'files/catimg/bug_16.png', 2, 0, 0, 6, 1), (3, 'Rap', 'rap', 'files/catimg/bubble_16.png', 3, 0, 0, 1, 1)");

$jakdb->query('CREATE TABLE '.DB_PREFIX.'loginlog (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `fromwhere` varchar(255) DEFAULT NULL,
  `ip` char(15) NOT NULL,
  `usragent` varchar(255) DEFAULT NULL,
  `time` datetime NOT NULL DEFAULT "0000-00-00 00:00:00",
  `access` smallint(1) unsigned NOT NULL DEFAULT "0",
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1');

$jakdb->query('CREATE TABLE '.DB_PREFIX.'setting (
  `varname` varchar(100) NOT NULL DEFAULT "",
  `groupname` varchar(50) DEFAULT NULL,
  `value` mediumtext,
  `defaultvalue` mediumtext,
  `optioncode` mediumtext,
  `datatype` enum("free","number","boolean","bitfield","username","integer","posint") NOT NULL DEFAULT "free",
  `product` varchar(25) DEFAULT "",
  PRIMARY KEY (`varname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8');

$jakdb->query("INSERT INTO ".DB_PREFIX."setting VALUES ('version', 'version', '1.8', '1.8', NULL, 'free', 'shop'), ('thankyou_message', 'setting', '<p>Thank you for purchasing a Drag''nDrop Online Shop license!</p>\r\n<p>After we received the money you will get a confirmation email with further instructions.</p>\r\n<p>Thank you very much for your trust and hope you like Drag''nDrop as much as I do!</p>\r\n<p>Best regards<br /> Jérôme Kaegi - JAKWEB</p>', 'Thank you for your message.  We will be in touch as soon as possible!', 'textarea', 'free', 'shop'), ('title', 'setting', 'Drag''nDrop Shop', 'Drag''nDrop Shop', 'input', 'free', 'shop'), ('email', 'setting', '', 'jakweb', 'input', 'free', 'shop'), ('sitehttps', 'setting', '0', '0', 'yesno', 'boolean', 'shop'), ('dateformat', 'setting', 'd.m.Y', 'd.m.Y', 'input', 'free', 'shop'), ('timeformat', 'setting', ' - H:i', 'h:i A', 'input', 'free', 'shop'), ('welcome_message', 'setting', '<p>We are offering now a stand alone version, probably the most modernest online shop ever.</p>\r\n<p>If you are not sure how to install the software on your web server, you can buy a installation service for a very reasonable price.</p>', 'How do you feel about our website?', 'textarea', 'free', 'shop'), ('facebooklike', 'setting', '', NULL, 'input', 'free', 'shop'), ('timezoneserver', 'setting', 'Europe/Zurich', 'Europe/Zurich', 'select', 'free', 'shop'), ('lang', 'setting', 'en', 'en', 'input', 'free', 'shop'), ('copyright', 'setting', '', 'copyright 2013 - JAKWEB', 'input', 'free', 'shop'), ('ip_block', 'setting', '', NULL, 'textarea', 'free', 'shop'), ('email_block', 'setting', '', NULL, 'textarea', 'free', 'shop'), ('analyticsid', 'setting', '', NULL, 'input', 'free', 'shop'), ('sitestyle', 'setting', 'darkish', 'darkish', 'select', 'free', 'shop'), ('currency', 'setting', 'USD', 'USD', 'input', 'free', 'shop'), ('currency1', 'setting', '', '', 'input', 'free', 'shop'), ('currency2', 'setting', '', '', 'input', 'free', 'shop'), ('taxes', 'setting', '', '', 'input', 'free', 'shop'), ('shopurl', 'setting', '1', '0', 'yesno', 'boolean', 'shop'), ('shopsearch', 'setting', '1', '1', 'yesno', 'boolean', 'shop'), ('shopquantity', 'setting', '0', '0', 'yesno', 'boolean', 'shop'), ('shoprss', 'setting', '5', '5', 'number', 'free', 'shop'), ('agreement', 'setting', '', NULL, 'input', 'free', 'shop'), ('shoppagemid', 'setting', '3', '3', 'input', 'number', 'shop'), ('shoppageitem', 'setting', '8', '4', 'input', 'number', 'shop'), ('shop_address', 'setting', '', NULL, 'input', 'free', 'shop'), ('country', 'setting', '0', '0', 'number', 'free', 'shop'), ('productopen', 'setting', '0', '1', 'yesno', 'boolean', 'shop'), ('twittername', 'setting', '', 'jakweb', 'input', 'free', 'shop')");

$jakdb->query('CREATE TABLE '.DB_PREFIX.'shop (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `catid` int(11) unsigned NOT NULL DEFAULT 0,
  `title` varchar(255) DEFAULT NULL,
  `content` text,
  `price` float(10,2) DEFAULT NULL,
  `sale` float(10,2) DEFAULT NULL,
  `product_weight` float(10,3) DEFAULT NULL,
  `stock` int(11) NOT NULL DEFAULT 1,
  `product_options` varchar(255) DEFAULT NULL,
  `product_options1` varchar(255) DEFAULT NULL,
  `product_options2` varchar(255) DEFAULT NULL,
  `previmg` varchar(255) DEFAULT NULL,
  `img` varchar(255) DEFAULT NULL,
  `digital_file` varchar(255) DEFAULT NULL,
  `active` smallint(1) unsigned NOT NULL DEFAULT 1,
  `product_home` smallint(1) unsigned NOT NULL DEFAULT 0,
  `showdate` smallint(1) unsigned NOT NULL DEFAULT 0,
  `hits` int(10) unsigned NOT NULL DEFAULT 0,
  `time` datetime NOT NULL DEFAULT "0000-00-00 00:00:00",
  `ecorder` int(11) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `catid` (`catid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9');

$jakdb->query("INSERT INTO ".DB_PREFIX."shop VALUES (1, 1, 'Cat Stevens', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n<ul>\r\n<li>Track 1</li>\r\n<li>Track 2</li>\r\n<li>Track 3</li>\r\n<li>Track 4</li>\r\n<li>Track 5</li>\r\n<li>Track 6</li>\r\n<li>Track 7</li>\r\n<li>Track 8</li>\r\n<li>Track 9</li>\r\n<li>Bonus Track</li>\r\n</ul>\r\n<div class=\"clear\"> </div>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>', 19.00, 0.00, 0.200, 0, 'Bulk Order (2)::14.00::0.200,Bulk Order (3)::25.00::0.600,Bulk Order (4)::60.00::1.000,Bulk Order (5)::80.00::1.200', '', '', 'files/cover_small/catsteven.jpg', 'files/cover_big/catsteven.jpg', NULL, 1, 1, 0, 0, NOW(), 4), (2, 1, 'Coldplay XY', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n<ul>\r\n<li>Track 1</li>\r\n<li>Track 2</li>\r\n<li>Track 3</li>\r\n<li>Track 4</li>\r\n<li>Track 5</li>\r\n<li>Track 6</li>\r\n<li>Track 7</li>\r\n<li>Track 8</li>\r\n<li>Track 9</li>\r\n<li>Bonus Track</li>\r\n</ul>\r\n<div class=\"clear\">&nbsp;</div>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>', 22.00, 19.00, 0.200, 0, 'Bulk Order (2)::14.00::0.200,Bulk Order (3)::25.00::0.600,Bulk Order (4)::60.00::1.000,Bulk Order (5)::80.00::1.200', '', '', 'files/cover_small/coldplay.jpg', 'files/cover_big/coldplay.jpg', NULL, 1, 1, 0, 0, NOW(), 5), (3, 2, 'Foo Fighters', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n<ul>\r\n<li>Track 1</li>\r\n<li>Track 2</li>\r\n<li>Track 3</li>\r\n<li>Track 4</li>\r\n<li>Track 5</li>\r\n<li>Track 6</li>\r\n<li>Track 7</li>\r\n<li>Track 8</li>\r\n<li>Track 9</li>\r\n<li>Bonus Track</li>\r\n</ul>\r\n<div class=\"clear\"> </div>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>', 18.00, 0.00, 0.200, 0, '', '', '', 'files/cover_small/foofighters.jpg', 'files/cover_big/foofighters.jpg', NULL, 1, 1, 0, 0, NOW(), 6), (4, 3, 'Mia', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n<ul>\r\n<li>Track 1</li>\r\n<li>Track 2</li>\r\n<li>Track 3</li>\r\n<li>Track 4</li>\r\n<li>Track 5</li>\r\n<li>Track 6</li>\r\n<li>Track 7</li>\r\n<li>Track 8</li>\r\n<li>Track 9</li>\r\n<li>Bonus Track</li>\r\n</ul>\r\n<div class=\"clear\"> </div>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>', 24.00, 0.00, 0.200, 0, '', '', '', 'files/cover_small/mia.jpg', 'files/cover_big/mia.jpg', NULL, 1, 1, 0, 0, NOW(), 3), (5, 2, 'Supertramp', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n<ul>\r\n<li>Track 1</li>\r\n<li>Track 2</li>\r\n<li>Track 3</li>\r\n<li>Track 4</li>\r\n<li>Track 5</li>\r\n<li>Track 6</li>\r\n<li>Track 7</li>\r\n<li>Track 8</li>\r\n<li>Track 9</li>\r\n<li>Bonus Track</li>\r\n</ul>\r\n<div class=\"clear\"> </div>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>', 18.00, 16.00, 0.200, 0, 'Bulk Order (2)::14.00::0.200,Bulk Order (3)::25.00::0.600,Bulk Order (4)::60.00::1.000,Bulk Order (5)::80.00::1.200', '', '', 'files/cover_small/supertramp.jpg', 'files/cover_small/supertramp.jpg', NULL, 1, 1, 1, 0, NOW(), 7), (6, 2, 'Avalanche Westbound', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n<ul>\r\n<li>Track 1</li>\r\n<li>Track 2</li>\r\n<li>Track 3</li>\r\n<li>Track 4</li>\r\n<li>Track 5</li>\r\n<li>Track 6</li>\r\n<li>Track 7</li>\r\n<li>Track 8</li>\r\n<li>Track 9</li>\r\n<li>Bonus Track</li>\r\n</ul>\r\n<div class=\"clear\"> </div>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>', 21.00, 0.00, 0.200, 0, '', '', '', 'files/cover_small/avalanche.jpg', 'files/cover_big/avalanche.jpg', NULL, 1, 1, 0, 0, NOW(), 8), (7, 2, 'Aerosmith', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n<ul>\r\n<li>Track 1</li>\r\n<li>Track 2</li>\r\n<li>Track 3</li>\r\n<li>Track 4</li>\r\n<li>Track 5</li>\r\n<li>Track 6</li>\r\n<li>Track 7</li>\r\n<li>Track 8</li>\r\n<li>Track 9</li>\r\n<li>Bonus Track</li>\r\n</ul>\r\n<div class=\"clear\"> </div>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>', 23.00, 0.00, 0.200, 1, '', '', '', 'files/cover_small/aerosmith.jpg', 'files/cover_big/aerosmith.jpg', NULL, 1, 1, 0, 1, NOW(), 2), (8, 1, 'Shakira', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n<ul>\r\n<li>Track 1</li>\r\n<li>Track 2</li>\r\n<li>Track 3</li>\r\n<li>Track 4</li>\r\n<li>Track 5</li>\r\n<li>Track 6</li>\r\n<li>Track 7</li>\r\n<li>Track 8</li>\r\n<li>Track 9</li>\r\n<li>Bonus Track</li>\r\n</ul>\r\n<div class=\"clear\"> </div>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>', 17.00, 0.00, 0.200, 1, 'Bulk Order (2)::14.00::0.200,Bulk Order (3)::25.00::0.600,Bulk Order (4)::60.00::1.000,Bulk Order (5)::80.00::1.200', 'Bulk Order (2)::14.00::0.200,Bulk Order (3)::25.00::0.600,Bulk Order (4)::60.00::1.000,Bulk Order (5)::80.00::1.200', 'Bulk Order (2)::14.00::0.200,Bulk Order (3)::25.00::0.600,Bulk Order (4)::60.00::1.000,Bulk Order (5)::80.00::1.200', 'files/cover_small/shakira.jpg', 'files/cover_big/shakira.jpg', NULL, 1, 1, 1, 1, NOW(), 1)");

$jakdb->query('CREATE TABLE '.DB_PREFIX.'shopping_cart (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shopid` int(11) unsigned NOT NULL DEFAULT 0,
  `cartid` varchar(100) DEFAULT NULL,
  `product_option` varchar(255) DEFAULT NULL,
  `price` float(10,2) DEFAULT NULL,
  `weight` float(10,3) DEFAULT NULL,
  `session` varchar(32) DEFAULT NULL,
  `time` datetime NOT NULL DEFAULT "0000-00-00 00:00:00",
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1');

$jakdb->query('CREATE TABLE '.DB_PREFIX.'shop_country (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) DEFAULT NULL,
  `iso_code_2` varchar(2) DEFAULT NULL,
  `iso_code_3` varchar(3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1000');

$jakdb->query("INSERT INTO ".DB_PREFIX."shop_country VALUES (1, 'Afghanistan', 'AF', 'AFG'), (2, 'Albania', 'AL', 'ALB'), (3, 'Algeria', 'DZ', 'DZA'), (4, 'American Samoa', 'AS', 'ASM'), (5, 'Andorra', 'AD', 'AND'), (6, 'Angola', 'AO', 'AGO'), (7, 'Anguilla', 'AI', 'AIA'), (8, 'Antarctica', 'AQ', 'ATA'), (9, 'Antigua and Barbuda', 'AG', 'ATG'), (10, 'Argentina', 'AR', 'ARG'), (11, 'Armenia', 'AM', 'ARM'), (12, 'Aruba', 'AW', 'ABW'), (13, 'Australia', 'AU', 'AUS'), (14, 'Austria', 'AT', 'AUT'), (15, 'Azerbaijan', 'AZ', 'AZE'), (16, 'Bahamas', 'BS', 'BHS'), (17, 'Bahrain', 'BH', 'BHR'), (18, 'Bangladesh', 'BD', 'BGD'), (19, 'Barbados', 'BB', 'BRB'), (20, 'Belarus', 'BY', 'BLR'), (21, 'Belgium', 'BE', 'BEL'), (22, 'Belize', 'BZ', 'BLZ'), (23, 'Benin', 'BJ', 'BEN'), (24, 'Bermuda', 'BM', 'BMU'), (25, 'Bhutan', 'BT', 'BTN'), (26, 'Bolivia', 'BO', 'BOL'), (27, 'Bosnia and Herzegowina', 'BA', 'BIH'), (28, 'Botswana', 'BW', 'BWA'), (29, 'Bouvet Island', 'BV', 'BVT'), (30, 'Brazil', 'BR', 'BRA'), (31, 'British Indian Ocean Territory', 'IO', 'IOT'), (32, 'Brunei Darussalam', 'BN', 'BRN'), (33, 'Bulgaria', 'BG', 'BGR'), (34, 'Burkina Faso', 'BF', 'BFA'), (35, 'Burundi', 'BI', 'BDI'), (36, 'Cambodia', 'KH', 'KHM'), (37, 'Cameroon', 'CM', 'CMR'), (38, 'Canada', 'CA', 'CAN'), (39, 'Cape Verde', 'CV', 'CPV'), (40, 'Cayman Islands', 'KY', 'CYM'), (41, 'Central African Republic', 'CF', 'CAF'), (42, 'Chad', 'TD', 'TCD'), (43, 'Chile', 'CL', 'CHL'), (44, 'China', 'CN', 'CHN'), (45, 'Christmas Island', 'CX', 'CXR'), (46, 'Cocos (Keeling) Islands', 'CC', 'CCK'), (47, 'Colombia', 'CO', 'COL'), (48, 'Comoros', 'KM', 'COM'), (49, 'Congo', 'CG', 'COG'), (50, 'Cook Islands', 'CK', 'COK'), (51, 'Costa Rica', 'CR', 'CRI'), (52, 'Cote D''Ivoire', 'CI', 'CIV'), (53, 'Croatia', 'HR', 'HRV'), (54, 'Cuba', 'CU', 'CUB'), (55, 'Cyprus', 'CY', 'CYP'), (56, 'Czech Republic', 'CZ', 'CZE'), (57, 'Denmark', 'DK', 'DNK'), (58, 'Djibouti', 'DJ', 'DJI'), (59, 'Dominica', 'DM', 'DMA'), (60, 'Dominican Republic', 'DO', 'DOM'), (61, 'East Timor', 'TP', 'TMP'), (62, 'Ecuador', 'EC', 'ECU'), (63, 'Egypt', 'EG', 'EGY'), (64, 'El Salvador', 'SV', 'SLV'), (65, 'Equatorial Guinea', 'GQ', 'GNQ'), (66, 'Eritrea', 'ER', 'ERI'), (67, 'Estonia', 'EE', 'EST'), (68, 'Ethiopia', 'ET', 'ETH'), (69, 'Falkland Islands (Malvinas)', 'FK', 'FLK'), (70, 'Faroe Islands', 'FO', 'FRO'), (71, 'Fiji', 'FJ', 'FJI'), (72, 'Finland', 'FI', 'FIN'), (73, 'France', 'FR', 'FRA'), (74, 'France, Metropolitan', 'FX', 'FXX'), (75, 'French Guiana', 'GF', 'GUF'), (76, 'French Polynesia', 'PF', 'PYF'), (77, 'French Southern Territories', 'TF', 'ATF'), (78, 'Gabon', 'GA', 'GAB'), (79, 'Gambia', 'GM', 'GMB'), (80, 'Georgia', 'GE', 'GEO'), (81, 'Germany', 'DE', 'DEU'), (82, 'Ghana', 'GH', 'GHA'), (83, 'Gibraltar', 'GI', 'GIB'), (84, 'Greece', 'GR', 'GRC'), (85, 'Greenland', 'GL', 'GRL'), (86, 'Grenada', 'GD', 'GRD'), (87, 'Guadeloupe', 'GP', 'GLP'), (88, 'Guam', 'GU', 'GUM'), (89, 'Guatemala', 'GT', 'GTM'), (90, 'Guinea', 'GN', 'GIN'), (91, 'Guinea-bissau', 'GW', 'GNB'), (92, 'Guyana', 'GY', 'GUY'), (93, 'Haiti', 'HT', 'HTI'), (94, 'Heard and Mc Donald Islands', 'HM', 'HMD'), (95, 'Honduras', 'HN', 'HND'), (96, 'Hong Kong', 'HK', 'HKG'), (97, 'Hungary', 'HU', 'HUN'), (98, 'Iceland', 'IS', 'ISL'), (99, 'India', 'IN', 'IND'), (100, 'Indonesia', 'ID', 'IDN'), (101, 'Iran (Islamic Republic of)', 'IR', 'IRN'), (102, 'Iraq', 'IQ', 'IRQ'), (103, 'Ireland', 'IE', 'IRL'), (104, 'Israel', 'IL', 'ISR'), (105, 'Italy', 'IT', 'ITA'), (106, 'Jamaica', 'JM', 'JAM'), (107, 'Japan', 'JP', 'JPN'), (108, 'Jordan', 'JO', 'JOR'), (109, 'Kazakhstan', 'KZ', 'KAZ'), (110, 'Kenya', 'KE', 'KEN'), (111, 'Kiribati', 'KI', 'KIR'), (112, 'North Korea', 'KP', 'PRK'), (113, 'Korea, Republic of', 'KR', 'KOR'), (114, 'Kuwait', 'KW', 'KWT'), (115, 'Kyrgyzstan', 'KG', 'KGZ'), (116, 'Lao People''s Democratic Republic', 'LA', 'LAO'), (117, 'Latvia', 'LV', 'LVA'), (118, 'Lebanon', 'LB', 'LBN'), (119, 'Lesotho', 'LS', 'LSO'), (120, 'Liberia', 'LR', 'LBR'), (121, 'Libyan Arab Jamahiriya', 'LY', 'LBY'), (122, 'Liechtenstein', 'LI', 'LIE'), (123, 'Lithuania', 'LT', 'LTU'), (124, 'Luxembourg', 'LU', 'LUX'), (125, 'Macau', 'MO', 'MAC'), (126, 'Macedonia', 'MK', 'MKD'), (127, 'Madagascar', 'MG', 'MDG'), (128, 'Malawi', 'MW', 'MWI'), (129, 'Malaysia', 'MY', 'MYS'), (130, 'Maldives', 'MV', 'MDV'), (131, 'Mali', 'ML', 'MLI'), (132, 'Malta', 'MT', 'MLT'), (133, 'Marshall Islands', 'MH', 'MHL'), (134, 'Martinique', 'MQ', 'MTQ'), (135, 'Mauritania', 'MR', 'MRT'), (136, 'Mauritius', 'MU', 'MUS'), (137, 'Mayotte', 'YT', 'MYT'), (138, 'Mexico', 'MX', 'MEX'), (139, 'Micronesia, Federated States of', 'FM', 'FSM'), (140, 'Moldova, Republic of', 'MD', 'MDA'), (141, 'Monaco', 'MC', 'MCO'), (142, 'Mongolia', 'MN', 'MNG'), (143, 'Montserrat', 'MS', 'MSR'), (144, 'Morocco', 'MA', 'MAR'), (145, 'Mozambique', 'MZ', 'MOZ'), (146, 'Myanmar', 'MM', 'MMR'), (147, 'Namibia', 'NA', 'NAM'), (148, 'Nauru', 'NR', 'NRU'), (149, 'Nepal', 'NP', 'NPL'), (150, 'Netherlands', 'NL', 'NLD'), (151, 'Netherlands Antilles', 'AN', 'ANT'), (152, 'New Caledonia', 'NC', 'NCL'), (153, 'New Zealand', 'NZ', 'NZL'), (154, 'Nicaragua', 'NI', 'NIC'), (155, 'Niger', 'NE', 'NER'), (156, 'Nigeria', 'NG', 'NGA'), (157, 'Niue', 'NU', 'NIU'), (158, 'Norfolk Island', 'NF', 'NFK'), (159, 'Northern Mariana Islands', 'MP', 'MNP'), (160, 'Norway', 'NO', 'NOR'), (161, 'Oman', 'OM', 'OMN'), (162, 'Pakistan', 'PK', 'PAK'), (163, 'Palau', 'PW', 'PLW'), (164, 'Panama', 'PA', 'PAN'), (165, 'Papua New Guinea', 'PG', 'PNG'), (166, 'Paraguay', 'PY', 'PRY'), (167, 'Peru', 'PE', 'PER'), (168, 'Philippines', 'PH', 'PHL'), (169, 'Pitcairn', 'PN', 'PCN'), (170, 'Poland', 'PL', 'POL'), (171, 'Portugal', 'PT', 'PRT'), (172, 'Puerto Rico', 'PR', 'PRI'), (173, 'Qatar', 'QA', 'QAT'), (174, 'Reunion', 'RE', 'REU'), (175, 'Romania', 'RO', 'ROM'), (176, 'Russian Federation', 'RU', 'RUS'), (177, 'Rwanda', 'RW', 'RWA'), (178, 'Saint Kitts and Nevis', 'KN', 'KNA'), (179, 'Saint Lucia', 'LC', 'LCA'), (180, 'Saint Vincent and the Grenadines', 'VC', 'VCT'), (181, 'Samoa', 'WS', 'WSM'), (182, 'San Marino', 'SM', 'SMR'), (183, 'Sao Tome and Principe', 'ST', 'STP'), (184, 'Saudi Arabia', 'SA', 'SAU'), (185, 'Senegal', 'SN', 'SEN'), (186, 'Seychelles', 'SC', 'SYC'), (187, 'Sierra Leone', 'SL', 'SLE'), (188, 'Singapore', 'SG', 'SGP'), (189, 'Slovakia (Slovak Republic)', 'SK', 'SVK'), (190, 'Slovenia', 'SI', 'SVN'), (191, 'Solomon Islands', 'SB', 'SLB'), (192, 'Somalia', 'SO', 'SOM'), (193, 'South Africa', 'ZA', 'ZAF'), (194, 'South Georgia and South Sandwich Islands', 'GS', 'SGS'), (195, 'Spain', 'ES', 'ESP'), (196, 'Sri Lanka', 'LK', 'LKA'), (197, 'St. Helena', 'SH', 'SHN'), (198, 'St. Pierre and Miquelon', 'PM', 'SPM'), (199, 'Sudan', 'SD', 'SDN'), (200, 'Suriname', 'SR', 'SUR'), (201, 'Svalbard and Jan Mayen Islands', 'SJ', 'SJM'), (202, 'Swaziland', 'SZ', 'SWZ'), (203, 'Sweden', 'SE', 'SWE'), (204, 'Switzerland', 'CH', 'CHE'), (205, 'Syrian Arab Republic', 'SY', 'SYR'), (206, 'Taiwan', 'TW', 'TWN'), (207, 'Tajikistan', 'TJ', 'TJK'), (208, 'Tanzania, United Republic of', 'TZ', 'TZA'), (209, 'Thailand', 'TH', 'THA'), (210, 'Togo', 'TG', 'TGO'), (211, 'Tokelau', 'TK', 'TKL'), (212, 'Tonga', 'TO', 'TON'), (213, 'Trinidad and Tobago', 'TT', 'TTO'), (214, 'Tunisia', 'TN', 'TUN'), (215, 'Turkey', 'TR', 'TUR'), (216, 'Turkmenistan', 'TM', 'TKM'), (217, 'Turks and Caicos Islands', 'TC', 'TCA'), (218, 'Tuvalu', 'TV', 'TUV'), (219, 'Uganda', 'UG', 'UGA'), (220, 'Ukraine', 'UA', 'UKR'), (221, 'United Arab Emirates', 'AE', 'ARE'), (222, 'United Kingdom', 'GB', 'GBR'), (223, 'United States', 'US', 'USA'), (224, 'United States Minor Outlying Islands', 'UM', 'UMI'), (225, 'Uruguay', 'UY', 'URY'), (226, 'Uzbekistan', 'UZ', 'UZB'), (227, 'Vanuatu', 'VU', 'VUT'), (228, 'Vatican City State (Holy See)', 'VA', 'VAT'), (229, 'Venezuela', 'VE', 'VEN'), (230, 'Viet Nam', 'VN', 'VNM'), (231, 'Virgin Islands (British)', 'VG', 'VGB'), (232, 'Virgin Islands (U.S.)', 'VI', 'VIR'), (233, 'Wallis and Futuna Islands', 'WF', 'WLF'), (234, 'Western Sahara', 'EH', 'ESH'), (235, 'Yemen', 'YE', 'YEM'), (236, 'Yugoslavia', 'YU', 'YUG'), (237, 'Zaire', 'ZR', 'ZAR'), (238, 'Zambia', 'ZM', 'ZMB'), (239, 'Zimbabwe', 'ZW', 'ZWE'), (999, 'Worldwide', 'WW', 'WWE')");

$jakdb->query('CREATE TABLE '.DB_PREFIX.'shop_order (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `paid_method` smallint(2) unsigned NOT NULL DEFAULT 0,
  `total_price` float(10,2) DEFAULT NULL,
  `discount` float(10,2) DEFAULT NULL,
  `tax` float(10,2) DEFAULT NULL,
  `shipping` float(10,2) DEFAULT NULL,
  `freeshipping` smallint(1) unsigned NOT NULL DEFAULT 0,
  `currency` varchar(5) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `company` varchar(100) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `country` int(3) unsigned NOT NULL DEFAULT 0,
  `city` varchar(100) DEFAULT NULL,
  `zip_code` varchar(100) DEFAULT NULL,
  `sh_name` varchar(100) DEFAULT NULL,
  `sh_company` varchar(100) DEFAULT NULL,
  `sh_address` varchar(255) DEFAULT NULL,
  `sh_country` int(3) unsigned NOT NULL DEFAULT 0,
  `sh_city` varchar(100) DEFAULT NULL,
  `sh_zip_code` varchar(100) DEFAULT NULL,
  `sh_phone` varchar(100) DEFAULT NULL,
  `paidtime` datetime NOT NULL DEFAULT "0000-00-00 00:00:00",
  `paid` smallint(1) unsigned NOT NULL DEFAULT 0,
  `order_booked` smallint(1) unsigned NOT NULL DEFAULT 0,
  `time` datetime NOT NULL DEFAULT "0000-00-00 00:00:00",
  `ordernumber` varchar(20) DEFAULT NULL,
  `downloadid` INT(10) UNSIGNED NOT NULL DEFAULT 0,
  `downloadtime` DATETIME NOT NULL DEFAULT "0000-00-00 00:00:00",
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1');

$jakdb->query('CREATE TABLE '.DB_PREFIX.'shop_order_details (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderid` int(11) unsigned NOT NULL DEFAULT 0,
  `shopid` int(11) unsigned NOT NULL DEFAULT 0,
  `title` varchar(255) DEFAULT NULL,
  `product_option` varchar(100) DEFAULT NULL,
  `price` float(10,2) DEFAULT NULL,
  `coupon_price` float(10,2) DEFAULT NULL,
  `weight` float(10,3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `orderid` (`orderid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1');

$jakdb->query('CREATE TABLE IF NOT EXISTS '.DB_PREFIX.'shop_coupon (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `code` varchar(255) DEFAULT NULL,
  `type` smallint(1) unsigned NOT NULL DEFAULT 0,
  `discount` float(10,2) DEFAULT NULL,
  `freeshipping` smallint(1) unsigned NOT NULL DEFAULT 0,
  `datestart` int(10) unsigned NOT NULL DEFAULT 0,
  `dateend` int(10) unsigned NOT NULL DEFAULT 0,
  `total` int(11) unsigned NOT NULL DEFAULT 0,
  `used` int(11) unsigned NOT NULL DEFAULT 0,
  `products` mediumtext,
  `status` smallint(1) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1');

$jakdb->query('CREATE TABLE '.DB_PREFIX.'shop_payment (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `field` text,
  `field1` text,
  `field2` text,
  `field3` text,
  `fees` smallint(2) unsigned NOT NULL DEFAULT 0,
  `status` smallint(1) unsigned NOT NULL DEFAULT 0,
  `msporder` int(11) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9');

$jakdb->query("INSERT INTO ".DB_PREFIX."shop_payment VALUES (1, 'Bank Transfer', 'Bank Transfer Swiss', 'PHA+TXkgQmFuayBBY2NvdW50IEluZm9ybWF0aW9uLjwvcD4NCjxwPlBsZWFzZSB0cmFuc2ZlciB0aGUgbW9uZXkgdG8gZm9sbG93aW5nIGFjY291bnQ6PC9wPg0KPHA+VUJTIEFHIC8gWnVyaWNoPGJyIC8+QWNjb3VudDogNDMyLTQzMjQxLjM8YnIgLz44MDAwIFp1cmljaCZuYnNwOzwvcD4=', NULL, NULL, 0, 1, 1), (2, 'Cheque / Money Order', 'Cheque / Money Order', '', NULL, NULL, 0, 0, 2), (3, 'Paypal', 'Paypal', '', NULL, NULL, 0, 0, 3), (4, '2CheckOut', '2CheckOut', '', '', NULL, 0, 0, 4), (5, 'Authorize.net', 'Authorize.net', '', '', NULL, 0, 0, 5), (6, 'Cash on Delivery', 'Cash on Delivery', '', NULL, NULL, 0, 0, 6), (7, 'Pickup', 'Pickup', '', NULL, NULL, 0, 0, 7), (8, 'Payza', 'Payza', '', NULL, NULL, 0, 0, 8), (9, 'Skrill (Moneybookers)', 'Skrill', '', NULL, NULL, 0, 0, 9), (10, 'Stripe', 'Credit Card', '', NULL, NULL, 0, 0, 10)");

$jakdb->query('CREATE TABLE '.DB_PREFIX.'shop_payment_ipn (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ordernr` varchar(20) DEFAULT NULL,
  `status` varchar(250) DEFAULT NULL,
  `amount` varchar(250) DEFAULT NULL,
  `currency` varchar(250) DEFAULT NULL,
  `txn_id` varchar(250) DEFAULT NULL,
  `receiver_email` varchar(250) DEFAULT NULL,
  `payer_email` varchar(250) DEFAULT NULL,
  `paid_with` varchar(250) DEFAULT NULL,
  `time` datetime NOT NULL DEFAULT "0000-00-00 00:00:00",
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1');

$jakdb->query('CREATE TABLE '.DB_PREFIX.'shop_shipping (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `est_shipping` varchar(20) DEFAULT NULL,
  `price` float(10,2) DEFAULT NULL,
  `handling` float(10,2) DEFAULT NULL,
  `weightfrom` float(10,3) DEFAULT NULL,
  `weightto` float(10,3) DEFAULT NULL,
  `country` int(3) unsigned NOT NULL DEFAULT 0,
  `status` smallint(1) unsigned NOT NULL DEFAULT 1,
  `time` datetime NOT NULL DEFAULT "0000-00-00 00:00:00",
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3');

$jakdb->query("INSERT INTO ".DB_PREFIX."shop_shipping VALUES (1, 'Express Delivery', '2-5', 19.00, 3.00, 0.001, 10.000, 999, 1, NOW()), (2, 'Snail Mail', '8-12', 14.00, 4.00, 0.001, 10.000, 999, 1, NOW())");

$jakdb->query('CREATE TABLE '.DB_PREFIX.'user (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(100) DEFAULT NULL,
  `password` char(64) NOT NULL,
  `idhash` varchar(32) DEFAULT NULL,
  `session` varchar(64) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `time` datetime NOT NULL DEFAULT "0000-00-00 00:00:00",
  `lastactivity` int(10) unsigned NOT NULL DEFAULT 0,
  `hits` int(11) unsigned NOT NULL DEFAULT 0,
  `access` smallint(1) unsigned NOT NULL DEFAULT 0,
  `forgot` int(11) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1');

$jakdb->query('CREATE TABLE '.DB_PREFIX.'shop_user (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(100) DEFAULT NULL,
  `password` char(64) NOT NULL,
  `idhash` varchar(32) DEFAULT NULL,
  `session` varchar(64) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `company` varchar(100) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `country` int(3) unsigned NOT NULL DEFAULT 0,
  `city` varchar(100) DEFAULT NULL,
  `zip_code` varchar(100) DEFAULT NULL,
  `time` datetime NOT NULL DEFAULT "0000-00-00 00:00:00",
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1');

// Finally close all db connections
$jakdb->jak_close();

?>
<div class="status-ok">Database installed successfully.</div>
<form id="company" method="post" action="install.php?step=3" enctype="multipart/form-data">
<input style="float:right;" type="submit" value="Setup Administrator" name="userf" />
</form>
<?php } elseif (isset($_GET['step']) && $_GET['step'] == 3) { ?>
Last Step - Create Admin<br /><br />
<?php

if ($_SERVER['REQUEST_METHOD'] == 'POST' && !isset($_POST['userf'])) {

$errors = array();

if (!preg_match('/^([a-zA-Z0-9\-_])+$/', $_POST['username'])) {
    $errors['e1'] = 'Please enter a valid username (A-Z,a-z,0-9,-_)!<br />';
}

if ($_POST['email'] == '' || !filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)) {
    $errors['e2'] = 'Please enter a valid email address!<br />';
}

if (empty($_POST['pass'])) {
    $errors['e3'] = 'Please enter a valid password!';
}

if (count($errors) == 0) {

// MySQL/i connection
if (DB_USER && DB_PASS) {
$jakdb = new jak_mysql(DB_HOST, DB_USER, DB_PASS, DB_NAME, DB_PORT);
$jakdb->set_charset("utf8");
}

// The new password encrypt with hash_hmac
$passcrypt = hash_hmac('sha256', $_POST['pass'], DB_PASS_HASH);
 
$jakdb->query('INSERT INTO '.DB_PREFIX.'user SET
	username = "'.smartsql($_POST['username']).'",
	password = "'.$passcrypt.'",
	email = "'.smartsql($_POST['email']).'",
	name = "'.smartsql($_POST['name']).'",
	time = NOW(),
	access = 1');
	
$jakdb->query('UPDATE '.DB_PREFIX.'setting SET value = "'.smartsql($_POST['email']).'" WHERE varname = "email"');
    
@$jakdb->query('ALTER DATABASE '.DB_NAME.' DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci');
    
// Finally close all db connections
$jakdb->jak_close();

echo '<div class="status-ok">Installation successful, please delete or rename the <strong>install</strong> directory. You can now log in, in your <a href="../admin/">administration</a> panel.</div>';

$show_form = false;

} else {
   
  $errors = $errors;
}

if ($errors) {

	echo '<div class="status-failure">'.$errors["e1"].$errors["e2"].$errors["e3"].'</div>';

} } if ($show_form) { ?>

<div class="border">
<form name="user" method="post" action="install.php?step=3" enctype="multipart/form-data">
<table class="table">
<tr>
	<td>Name <span class="complete">*</span></td>
	<td><input type="text" value="" size="30" maxlength="30" name="name" title="Name" /></td>
</tr>
<tr>
	<td>Username <span class="complete">*</span></td>
	<td><input type="text" value="" size="30" maxlength="30" name="username" title="Username" /></td>
</tr>
<tr>
	<td>Password <span class="complete">*</span></td>
	<td><input type="text" value="" size="30" maxlength="30" name="pass" title="Password" /></td>
</tr>
<tr>
	<td>Email <span class="complete">*</span></td>
	<td><input type="text" value="" size="30" maxlength="30" name="email" title="Email" /></td>
</tr>
</table>
</div>
<input style="float:right;" type="submit" value="Finish" name="user" />
</form>
<?php } } if (!isset($_GET['step'])) { ?>
<br />
<p><strong>First the include/db.php.new file</strong></p>
<p>
	<ul>
	<li>Please rename this file to <strong>db.php</strong></li>
	<li>Open the file in a text editor.</li>
	<li>The db.php file is commented throughout, so you should be able to work out what values to enter for the variables yourself.</li>
	<li>When you have finished, save the file.</li>
</ul>
<br />
<strong>Upload</strong>
	<ul>
	<li>Upload all files and folders within the <strong>upload</strong> folder with your preferred FTP program.</li>
	<li>Folder permission (<strong>CHMOD 777</strong>): <strong>cache</strong>/, <strong>files</strong>/</li>
</ul>
<br />
<strong>Install the database.</strong>
	<ul>
	<li>Point your browser at <strong>http://www.yourdomain.com/install/install.php</strong> (where www.yourdomain.com is the URL of your Site).</li>
</ul>
<br />
<strong>Configuration and finishing</strong>
	<ul>
	<li>Please delete or rename the <strong>install</strong> folder!</li>
	<li>Point your browser at: <strong>http://www.yourdomain.com/admin/</strong></li>
	<li>Sign in with your login information.</li>
	<li>Configure your website.</li>
</ul>
<br />
<strong>Help for FTP, MySQL and PHP</strong>
	<ul>
	<li>Go to our <a href="http://www.jakweb.ch">support</a> website.</li>
	<li>Download From <a href="http://www.اسکریپت.com">اسکریپت.com</a></li>
</ul>

</p>
<br />
<?php

// Test for the config.php File

if (@file_exists('../config.php')) {
	
	$data_file = '<strong style="color:green">config.php available</strong>';
} else {
	
	$data_file = '<strong style="color:red">config.php not available!</strong>';
}

// Connect to the database

@$linkdb = mysql_connect(DB_HOST.':'.DB_PORT, DB_USER, DB_PASS, DB_NAME);

if ($linkdb && DB_USER && DB_PASS) {
 
    $conn_data = '<strong style="color:green">Database connection available</strong>';
} else {
 
	$conn_data = '<strong style="color:red">Could not connect to the database!</strong>';
@mysql_close($linkdb);
}

// Database exist

@$dlink = mysql_select_db(DB_NAME);

if ($dlink) {
 
    $data_exist = '<strong style="color:green">Database available</strong>';
} else {
 
	$data_exist = '<strong style="color:red">Could not find the database!</strong>';
@mysql_close($dlink);
}

// Test the minimum PHP version
$php_version = PHP_VERSION;
$php_big = '';
if (version_compare($php_version, '5.2.0') < 0) {
	$result_php = '<strong style="color:red">You need a higher version of PHP (min. PHP 5.2)!</strong>';
} else {
	
	if (version_compare($php_version, '5.5.3') > 0) $php_big = '<br /><strong style="color:red">The software has not been tested on your php version yet.</strong>';

	// We also give feedback on whether we're running in safe mode
	$result_safe = '<strong style="color:green">PHP Version: '.$php_version.'</strong>';
	if (@ini_get('safe_mode') || strtolower(@ini_get('safe_mode')) == 'on') {
		$result_safe .= ', <strong style="color:red">Safe Mode activated</strong>.';
	} else {
		$result_safe .= '<strong style="color:green">, Safe Mode deactivated.</strong>';
	}
	
	$result_safe .= $php_big;
}
			
// Check the Cache directory			
$dirc = DIR_Shop."/cache";
$writec = false;
// Now really check
			if (file_exists($dirc) && is_dir($dirc))
			{
				if (@is_writable($dirc))
				{
					$writec = true;
				}
				$existsc = true;
			}

			@$passedc['files'] = ($existsc && $passedc['files']) ? true : false;

			@$existsc = ($existsc) ? '<strong style="color:green">Found folder (files)</strong>' : '<strong style="color:red">Folder not found! (files)</strong>';
			@$writec = ($writec) ? '<strong style="color:green">permission set</strong>' : (($existsc) ? '<strong style="color:red">permission not set (check guide)!</strong>' : '');
			
// GD Graphics Support

if (!extension_loaded("gd")) {

	$gd_data = '<strong style="color:orange">GD-Libary not available</strong>';
} else {
	$gd_data = '<strong style="color:green">GD-Libary available</strong>';
}


?>
<br />

Before we start with the installation, the script will recheck the settings, everything green means ready to go!
<br /><br />
<table width="100%" class="table">
<tr>
	<td><strong>What we check</strong></td>
	<td><strong>Result</strong></td>
</tr>
<tr>
	<td>config.php</td>
	<td><?=$data_file?></td>
</tr>
<tr>
	<td>Database connection</td>
	<td><?=$conn_data?></td>
</tr>
<tr>
	<td>Database</td>
	<td><?=$data_exist?></td>
</tr>
<tr>
	<td>PHP Version and Safe Mode</td>
	<td><?=@$result_php?> <?=$result_safe?></td>
</tr>
<tr>
	<td valign="top">Folder</td>
	<td><?=$writec?></td>
</tr>
<tr>
	<td>GD Library Support</td>
	<td><?=$gd_data?></td>
</tr>
</table>

<?php if (file_exists('../config.php') AND ($linkdb) AND ($dlink) && !$check_db_content) { ?>
<form name="company" method="post" action="install.php?step=2" enctype="multipart/form-data">
<input style="float:right;" type="submit" value="Install Database" name="install" />
</form>
<?php } elseif ((file_exists('../config.php') AND ($linkdb) AND ($dlink) && $check_db_content)) { ?>
<form name="company" method="post" action="install.php?step=3" enctype="multipart/form-data">
<input style="float:right;" type="submit" value="(Database exist already) Create User" name="userf" />
</form>
<?php } else { ?>
<input type="button" value="Refresh page" onclick="history.go(0)" />
<?php } } ?>
</p>

</div>

</section>

<footer>Copyright 2014 by <a href="http://www.jakweb.ch">JAKWEB</a></footer>

</div><!-- #container -->
</body>
</html>