<?php

/*======================================================================*\
|| #################################################################### ||
|| # Drag'nDrop Shop 1.8                                              # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2014 JAKWEB All Rights Reserved.                       # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| #   ----------- Drag'nDrop Shop IS NOT FREE SOFTWARE -----------   # ||
|| #                      http://www.jakweb.ch                        # ||
|| #################################################################### ||
\*======================================================================*/

// prevent direct php access
define('JAK_PREVENT_ACCESS', 1);

if (!file_exists('config.php')) {
    die('[index.php] config.php not exist');
}
require_once 'config.php';

$page = ($tempp ? filter_var($tempp, FILTER_SANITIZE_STRING) : '');
$page1 = ($tempp1 ? filter_var($tempp1, FILTER_SANITIZE_STRING) : '');
$page2 = ($tempp2 ? filter_var($tempp2, FILTER_SANITIZE_STRING) : '');
$page3 = ($tempp3 ? filter_var($tempp3, FILTER_SANITIZE_STRING) : '');
$page4 = ($tempp4 ? filter_var($tempp4, FILTER_SANITIZE_STRING) : '');

// Import the language file
if (file_exists(APP_PATH.'lang/'.JAK_LANG.'.ini')) {
    $tl = parse_ini_file(APP_PATH.'lang/'.JAK_LANG.'.ini', true);
} else {
    $tl = parse_ini_file(APP_PATH.'lang/en.ini', true);
}

// If Referer Zero go to the session url
if (!isset($_SERVER['HTTP_REFERER'])) {
	if ($_SESSION['jak_lastURL']) {
    	$_SERVER['HTTP_REFERER'] = $_SESSION['jak_lastURL'];
    } else {
    	$_SERVER['HTTP_REFERER'] = BASE_URL;
    }
}

// Lang and pages file for template
define('JAK_SITELANG', JAK_LANG);

// Assign Pages to template
define('JAK_PAGINATE_ADMIN', 0);

// Define the avatarpath in the settings
define(JAK_FILEPATH_BASE, BASE_URL.basename(JAK_FILEPATH));

// Define the real request
$realrequest = 'index.php?p='.$page;
define('JAK_PARSE_REQUEST', $realrequest);

// Get the special lang var once for the time
define('JAK_DAY', $tl['general']['g17']);
define('JAK_HOUR', $tl['general']['g18']);
define('JAK_MINUTE', $tl['general']['g19']);
define('JAK_MULTITIME', $tl['general']['g20']);
define('JAK_AGO', $tl['general']['g16']);

// Get the users ip address
$ipa = get_ip_address();

// Check if the ip is blocked, if so redirect to contact page with a message
if (JAK_IP_BLOCK) {
	$blockedips = explode(',', JAK_IP_BLOCK);
	if (in_array($ipa, $blockedips)) {
		$USR_IP_BLOCKED = $tl['error']['e11'];
		$page == '404';
	}
}

// Set the check page to 0
$JAK_CHECK_PAGE = 0;
	
	// let's do the dirty work
	if ($page == '') {
		require_once 'shop.php';
		$JAK_CHECK_PAGE = 1;
		$PAGE_SHOWTITLE = 1;
	}
	if ($page == 'checkout') {
		require_once 'checkout.php';
		$JAK_CHECK_PAGE = 1;
		$PAGE_SHOWTITLE = 1;
	}
	if ($page == 'c') {
		require_once 'categories.php';
		$JAK_CHECK_PAGE = 1;
		$PAGE_SHOWTITLE = 1;
	}
	if ($page == 'i') {
		require_once 'product.php';
		$JAK_CHECK_PAGE = 1;
		$PAGE_SHOWTITLE = 1;
	}
	if ($page == 'dl') {
		require_once 'download.php';
		$JAK_CHECK_PAGE = 1;
		$PAGE_SHOWTITLE = 1;
	}
	if ($page == 'search') {
		require_once 'search.php';
		$JAK_CHECK_PAGE = 1;
		$PAGE_SHOWTITLE = 1;
	}
	if ($page == $tl['shop']['m6']) {
		require_once 'details.php';
		$JAK_CHECK_PAGE = 1;
		$PAGE_SHOWTITLE = 1;
	}
	if ($page == $tl['link']['l8']) {
		$PAGE_TITLE = $tl['shop']['m17'];
		$PAGE_CONTENT = $tl['shop']['m18'];
		$JAK_CHECK_PAGE = 1;
		$PAGE_SHOWTITLE = 1;
		$template = 'notify.php';
	}
	if ($page == $tl['link']['l9']) {
		$PAGE_TITLE = $tl['shop']['m15'];
		$PAGE_CONTENT = $tl['shop']['m16'];
		$JAK_CHECK_PAGE = 1;
		$PAGE_SHOWTITLE = 1;
		$template = 'notify.php';
	}
	// Get the rss feautures
	if ($page == 'rss.xml') {
		 require_once 'rss.php';
	    $JAK_CHECK_PAGE = 1;
	}
	if ($page == 'logout') {
	     $checkp = 1;
	     $shopcheckout = JAK_rewrite::jakParseurl('checkout', '', '', '', '');
	     if (JAK_CUSTOMER_USERID) {
	         $customerlogin->lsLogoutCustomer(JAK_CUSTOMER_USERID);
	         $JAK_CHECK_PAGE = 1;
	         unset($_SESSION['customer_selected']);
	         jak_redirect($shopcheckout);
	     } else {
	     	unset($_SESSION['customer_selected']);
	     	jak_redirect($shopcheckout);
	     }
	 }
    // Get the 404 page
   	if ($page == '404') {
   	    $PAGE_TITLE = '404 ';
   	    $template = '404.php';
   	    $JAK_CHECK_PAGE = 1;
   	    $PAGE_SHOWTITLE = 1;
   	}

// if page not found
if ($JAK_CHECK_PAGE == 0) {
    jak_redirect(JAK_rewrite::jakParseurl('404', '', '', '', ''));
}

// RSS
// Get the rss if active
if (JAK_SHOPRSS) {
	$JAK_RSS_DISPLAY = 1;
	$P_RSS_LINK = JAK_rewrite::jakParseurl('rss.xml', '', '', '', '');
}

// Get the template normal or mobile
if (isset($template) && $template != '') {

	include_once APP_PATH.'template/'.JAK_SITESTYLE.'/'.$template;
	
}

// Finally close all db connections
$jakdb->jak_close();
?>