<?php

/*======================================================================*\
|| #################################################################### ||
|| # Drag'nDrop Shop 1.8                                              # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2014 JAKWEB All Rights Reserved.                       # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| #   ----------- Drag'nDrop Shop IS NOT FREE SOFTWARE -----------   # ||
|| #                      http://www.jakweb.ch                        # ||
|| #################################################################### ||
\*======================================================================*/

// Check if the file is accessed only via index.php if not stop the script from running
if(!defined('JAK_PREVENT_ACCESS')){
die('You cannot access this file directly.');
}

$errors = array();
$jaktable = DB_PREFIX.'shop';
$jaktable1 = DB_PREFIX.'shop_payment';
$jaktable2 = DB_PREFIX.'shop_order';
$jaktable3 = DB_PREFIX.'user';
$jaktable4 = DB_PREFIX.'shop_shipping';
$jaktable5 = DB_PREFIX.'shop_order_details';
$jaktable6 = DB_PREFIX.'shopping_cart';
$jaktable7 = DB_PREFIX.'categories';

// parse url
$backtoshop = JAK_rewrite::jakParseurl('', '', '', '', '');
$shopcheckout = JAK_rewrite::jakParseurl('download', '', '', '', '');
$countdown = true;

if (!is_numeric($page2) && !is_numeric($page3)) jak_redirect(BASE_URL);

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

// stop the countdown
$countdown = false;

if (jak_row_exist($page2, DB_PREFIX.'shop')) {

$result = $jakdb->query('SELECT t3.title, t3.digital_file FROM '.$jaktable2.' AS t1 LEFT JOIN '.$jaktable5.' AS t2 ON (t1.id = t2.orderid) LEFT JOIN '.$jaktable.' AS t3 ON (t2.shopid = t3.id) WHERE t1.downloadid = "'.smartsql($page3).'" AND t1.downloadtime >= NOW() GROUP BY t2.shopid');

if ($jakdb->affected_rows > 0) {

	// We sabotage the cache directory for temporaring saving the file! :)
	$zipFile = APP_PATH.JAK_CACHE_DIRECTORY.'/digital_goods_'.time().'.zip';

	$zip = new ZipArchive;
	
	// This is a feature we do need!
	ini_set('zlib.output_compression', 'Off');
	
	if ($zip->open($zipFile, ZIPARCHIVE::CREATE) === TRUE) {
	
		$zip->addFromString('index.html', '');
		
		while ($row = $result->fetch_assoc()) {
		
			// get the directory, we use the name
			$dlfolder = JAK_base::jakCleanurl($row['title']);
			
				if($zip->addEmptyDir($dlfolder)) {
					if (file_exists($row['digital_file'])) {
						// Add files to the zip archive
						$zip->addFile($row['digital_file'], $dlfolder.'/'.basename($row['digital_file']));
				}
			}
		}
	
	}

	$zip->close();
	
	if (file_exists($zipFile)) {
		
		header('Content-Description: File Transfer');
		header('Content-Type: application/octet-stream');
		header('Content-Disposition: attachment; filename='.basename($zipFile));
		header('Content-Transfer-Encoding: binary');
		header('Expires: 0');
	    header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
		header('Pragma: public');
		header('Content-Length: ' . filesize($zipFile));
		readfile($zipFile);
		if (file_exists($zipFile)) unlink($zipFile);
		ob_clean();
		flush();
	}
		
} else {
	
	jak_redirect(BASE_URL);

}

} else {
	
	jak_redirect(BASE_URL);

}

}

// Get the url session
$_SESSION['jak_lastURL'] = JAK_rewrite::jakParseurl('download', '', '', '', '');

// Fire the template
$template = 'download.php';
?>