<?php

/*======================================================================*\
|| #################################################################### ||
|| # Drag'nDrop Shop 1.8                                              # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2014 JAKWEB All Rights Reserved.                       # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| #   ----------- Drag'nDrop Shop IS NOT FREE SOFTWARE -----------   # ||
|| #                      http://www.jakweb.ch                        # ||
|| #################################################################### ||
\*======================================================================*/

// Error reporting:
error_reporting(E_ALL^E_NOTICE);

// The DB connections data
require_once 'include/db.php';

// Do not go any further if install folder still exists
if (is_dir('install')) die('Please delete or rename install folder.');

if (!JAK_CACHE_DIRECTORY) die('Please define a cache directory in the db.php.');

// Absolute Path
define('APP_PATH', dirname(__file__) . DIRECTORY_SEPARATOR);

if (isset($_SERVER['SCRIPT_NAME'])) {

    # on Windows _APP_MAIN_DIR becomes \ and abs url would look something like HTTP_HOST\/restOfUrl, so \ should be trimed too
    # @modified Chis Florinel <chis.florinel@candoo.ro>
    $app_main_dir = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\');
    define('_APP_MAIN_DIR', $app_main_dir);
} else {
    die('[config.php] Cannot determine APP_MAIN_DIR, please set manual and comment this line');
}

// Start the session
session_start();

// Get the ls DB class
if (JAK_MYSQL_CONNECTION == 1) {
	require_once 'class/class.db.php';
} else {
	require_once 'class/class.dbn.php';
}

// MySQLi connection
$jakdb = new jak_mysql(DB_HOST, DB_USER, DB_PASS, DB_NAME, DB_PORT);
$jakdb->set_charset("utf8");

// All important files
include_once 'include/functions.php';
include_once 'class/class.jakbase.php';
include_once 'class/class.postmail.php';
include_once 'class/class.userlogin.php';
include_once 'class/class.user.php';
include_once 'class/class.paginator.php';

// Undo register_globals.
undoRegisterGlobals();

// If magic quotes is on, strip the slashes that it added.
if (get_magic_quotes_gpc()) {
	$_REQUEST = array_map("undoMagicQuotes", $_REQUEST);
	$_GET = array_map("undoMagicQuotes", $_GET);
	$_POST = array_map("undoMagicQuotes", $_POST);
	$_COOKIE = array_map("undoMagicQuotes", $_COOKIE);
}

// Now launch the rewrite class, depending on the settings in db.
$getURL = New JAK_rewrite($_SERVER['REQUEST_URI']);

// We are not using apache so take the ugly urls
$tempp = $getURL->jakGetseg(0);
$tempp1 = $getURL->jakGetseg(1);
$tempp2 = $getURL->jakGetseg(2);
$tempp3 = $getURL->jakGetseg(3);
$tempp4 = $getURL->jakGetseg(4);
$tempp5 = $getURL->jakGetseg(5);
$tempp6 = $getURL->jakGetseg(6);

// Check if we want caching
if (!is_dir(APP_PATH.JAK_CACHE_DIRECTORY)) mkdir(APP_PATH.JAK_CACHE_DIRECTORY, 0755);

// define file better for caching
$cachedefinefile = APP_PATH.JAK_CACHE_DIRECTORY.'/define.php';

if (!file_exists($cachedefinefile)) {

$allsettings = "<?php\n";

// Get the general settings out the database
$result = $jakdb->query('SELECT varname, value FROM '.DB_PREFIX.'setting');
    while ($row = $result->fetch_assoc()) {
    	// collect each record into a define
    	
    	// Now check if sting contains html and do something about it!
    	if (strlen($row['value']) != strlen(filter_var($row['value'], FILTER_SANITIZE_STRING))) {
    		$defvar  = 'htmlspecialchars_decode("'.htmlspecialchars($row['value']).'")';
    	} else {
    		$defvar = "'".$row["value"]."'";
    	}
    	
        $allsettings .= "define('JAK_".strtoupper($row['varname'])."', ".$defvar.");\n";
    }
    
$allsettings .= "?>";
        
JAK_base::lsWriteinCache($cachedefinefile, $allsettings, '');

}

// Now include the created definefile
include_once $cachedefinefile;

// timezone from server
date_default_timezone_set(JAK_TIMEZONESERVER);

// Check if https is activated
if (JAK_SITEHTTPS) {
	define('BASE_URL', 'https://' . FULL_SITE_DOMAIN . _APP_MAIN_DIR . '/');
} else {
	define('BASE_URL', 'http://' . FULL_SITE_DOMAIN . _APP_MAIN_DIR . '/');
}

// Check if customer is logged in
$customerlogin = new JAK_userlogin();
$customerc = $customerlogin->lsCheckLoggedCustomer();
$customerl = new JAK_user($customerc);
if ($customerl) {
	define(JAK_CUSTOMER_USERID, $customerl->getVar("id"));
	$shopClogout = JAK_rewrite::jakParseurl('logout', '', '', '', '');
} else {
	define(JAK_CUSTOMER_USERID, false);
}
?>