<?php

/*======================================================================*\
|| #################################################################### ||
|| # Drag'nDrop Shop 1.8                                              # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2014 JAKWEB All Rights Reserved.                       # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| #   ----------- Drag'nDrop Shop IS NOT FREE SOFTWARE -----------   # ||
|| #                      http://www.jakweb.ch                        # ||
|| #################################################################### ||
\*======================================================================*/

class Shopping_Cart {

	protected $value, $session, $option = '', $modal_option = '';

	public static function startTheCart()
	{
	
		/* Check if user has items in the shopping cart */
		if(isset($_COOKIE['shopping_cart']) && !isset($_SESSION['shopping_cart'])) {
		   $_SESSION['shopping_cart'] = $_COOKIE['shopping_cart'];
		}
	
		if (isset($_SESSION['shopping_cart'])) {
		
			return $_SESSION['shopping_cart'];
		
		} else {
		
			if (!isset($_COOKIE['shopping_cart'])) {
				setcookie("shopping_cart", session_id(), time() + 86400, JAK_COOKIE_PATH);
			}
		
			return $_SESSION['shopping_cart'] = session_id();
		
		}
	
	}
	
	public static function getCart($sessionid) {
		
		global $jakdb;
		
		$result = $jakdb->query('SELECT t1.id, t1.shopid, t1.cartid, t1.product_option, t1.price, t1.weight, t2.title, t2.previmg, t2.sale, t2.stock FROM '.DB_PREFIX.'shopping_cart AS t1 LEFT JOIN '.DB_PREFIX.'shop AS t2 ON(t1.shopid = t2.id) WHERE session = "'.smartsql($sessionid).'"');
		
		while ($row = $result->fetch_assoc()) {
		
			$woption = '';
			$cid = '';
			
			// Import the language file
			if (file_exists(APP_PATH.'lang/'.JAK_LANG.'.ini')) {
			    $tl = parse_ini_file(APP_PATH.'lang/'.JAK_LANG.'.ini', true);
			} else {
			    $tl = parse_ini_file(APP_PATH.'lang/en.ini', true);
			}
			
			$real_base = str_replace('ajax/', '', BASE_URL);
			
			// Image is available so display it or go standard
			if ($row['previmg']) {
				$imge = $real_base.$row['previmg'];
			} else {
				$imge = $real_base.'img/no_product_photo.png';
			}
			
			// Sale is active overwrite price to save some vars
			if ($row['sale'] != "0.00") {
				$tl["shop"]["m"] = $tl["shop"]["m31"];
			}
			
			// Uh, we got some different currency then standard, well we need to change
			if ($_SESSION['ECOMMERCE_CURRENCY'] != JAK_CURRENCY) {
			
				$convert = new CurrencyConverter();
					
				$row['price'] = $convert->Convert($row['price'], $_SESSION['ECOMMERCE_CURRENCY']);
			
			}
			
			// If optionlist do some cosmetic
			if ($row['product_option']) $brspace = '<br />';
			    
			$cart[] = array('status' => 1, 'id' => $row['cartid'], 'price' => $row['price'], 'txt' => '<figure class="product-inbasket" id="pib_'.$row['cartid'].'">
			  	<img src="'.$imge.'" alt="'.$row['title'].'" />
			    <h3><span id="'.$row['cartid'].'_count"></span> x '.$row["title"].'</h3>
			    <p>'.$row['product_option'].$brspace.$tl["shop"]["m"].$row['price'].'&nbsp;'.$_SESSION['ECOMMERCE_CURRENCY'].'<br /><a href="#" onclick="removeItem(\''.$row['cartid'].'\');return false;" class="remove">remove</a></p></figure>');
		
		}
		
		if (is_array($cart)) { 
		
			return $cart;
			
		} else { 
		
			return array('status' => 0);
		}
	}
	
	public static function writeInto($value, $option, $cartid, $price, $weight) {
	
		if (is_numeric($value) && jak_row_exist($value, DB_PREFIX.'shop')) {
			
			// Insert into to shop
			global $jakdb;
			$jakdb->query('INSERT INTO '.DB_PREFIX.'shopping_cart SET 
			shopid = "'.$value.'",
			cartid = "'.$cartid.'",
			product_option = "'.smartsql($option).'",
			price = "'.$price.'",
			weight = "'.$weight.'",
			session = "'.smartsql($_SESSION['shopping_cart']).'",
			time = NOW()');
			
			return true;
		}
	
	}
	
	public static function getCountry($limit, $select = 0) {
	
		global $jakdb;
		
		$result = $jakdb->query('SELECT id, name FROM '.DB_PREFIX.'shop_country LIMIT '.$limit.'');
		
		while ($row = $result->fetch_assoc()) {
		
			$countrys = '';
		
			if ($row['id'] == $select) $countrys = ' selected="selected"';
		
			$country_list .= '<option value="'.$row['id'].'"'.$countrys.'>'.$row['name'].'</option>';
		}
		
		return $country_list;
	
	}

}
?>