<?php

/*======================================================================*\
|| #################################################################### ||
|| # Drag'nDrop Shop 1.8                                              # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2014 JAKWEB All Rights Reserved.                       # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| #   ----------- Drag'nDrop Shop IS NOT FREE SOFTWARE -----------   # ||
|| #                      http://www.jakweb.ch                        # ||
|| #################################################################### ||
\*======================================================================*/

class CurrencyConverter {

	var $exchange_rates = array();
	
	function CurrencyConverter()
	{
	
		$currency_array = array('1' => JAK_CURRENCY);
		
		if (JAK_CURRENCY1) {
			
			// Currency Two
			$currency_two = explode('/', JAK_CURRENCY1);
			
			$currency_array1 = array($currency_two[1] => $currency_two[0]);
			
			$this->exchange_rates = @array_merge($currency_array, $currency_array1);
		}
		
		// Create a array with all three currency
		if (JAK_CURRENCY2) {	
				
			// Currency Three
			$currency_three = explode('/', JAK_CURRENCY2);
			
			$currency_array2 = array($currency_three[1] => $currency_three[0]);
			
			$this->exchange_rates = @array_merge($currency_array, $currency_array1, $currency_array2);
			
		}
	
	}


	function Convert($amount = 1, $to = JAK_CURRENCY1, $decimals = 2)
	{
		
		$keyto = array_search($to, $this->exchange_rates);
		
		if ($keyto) {
		
			$price = $amount*$keyto;
			
			return(number_format(round($price, 1), $decimals, '.', ''));
			
		} else {
			return false;
		}
	}
	
	function CheckCurrency($input)
	{
		
		if (in_array($input, $this->exchange_rates)) {
			
			return true;
		} else {
		
			return false;
		}
	
	}
	
	function CurrencyChoose()
	{
		
		$d = $this->exchange_rates;
		
		if (is_array($d) && count($d) > 1) {
			
			return array_values($d);
		} else {
		
			return false;
		}
	
	}

}
?>