<?php

/*======================================================================*\
|| #################################################################### ||
|| # Drag'nDrop Shop 1.8                                              # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2014 JAKWEB All Rights Reserved.                       # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| #   ----------- Drag'nDrop Shop IS NOT FREE SOFTWARE -----------   # ||
|| #                      http://www.jakweb.ch                        # ||
|| #################################################################### ||
\*======================================================================*/

include_once 'class.rewrite.php';

class JAK_base
{
	private $data = array();
	private $usraccesspl = array();
	private $case;
	private $lsvar;
	private $lsvar1;
	protected $table = '', $itemid = '', $select = '', $where = '', $dseo = '';
	
	// This constructor can be used for all classes:
	
	public function __construct(array $options){
			
			foreach($options as $k=>$v){
				if(isset($this->$k)){
					$this->$k = $v;
				}
			}
	}
	
	public static function jakCleanurl($lsvar)
	{
	
		$lsvar = strip_tags($lsvar);
		$lsvar = strtolower($lsvar);
		$crepl = array(' ','.','(',')',"'","?","!","/","*","+","&","%","=","$",":",",",";","<",">","ä","ö","ü","Ä","Ü","Ö","é","à","è","ô",'"','---','--','#');
		$cfin = array('-','','','','-','','','','','','','','','','','','','','','au','oe','ue','au','oe','ue','e','a','e','o','','-','-','');
		$lsvar = str_replace($crepl, $cfin, $lsvar);	
		return $lsvar;
	
	}
	
	public static function jakunCleanurl($lsvar)
	{
	
		$lsvar = strip_tags($lsvar);
		$lsvar = strtolower($lsvar);
		$crepl = array("ä","ö","ü","Ä","Ü","Ö","é","à","è","ô");
		$cfin = array('au','oe','ue','au','oe','ue','e','a','e','o');
		$lsvar = str_replace($cfin, $crepl, $lsvar);	
		return $lsvar;
	
	}
	
	public static function jakTimesince($mysqlstamp, $date, $time)
	{
	
		$today = time(); /* Current unix time  */
		$mysqlstamp = strtotime($mysqlstamp);
		$since = $today - $mysqlstamp;
		
		if ($since < 129600) {
		
		// array of time period chunks
		    $chunks = array(
		        array(60 * 60 * 24 , JAK_DAY),
		        array(60 * 60 , JAK_HOUR),
		        array(60 , JAK_MINUTE),
		    );
		
		    $today = time(); /* Current unix time  */
		    $since = $today - $mysqlstamp;
		
		// $j saves performing the count function each time around the loop
		for ($i = 0, $j = count($chunks); $i < $j; $i++) {
		
		    $seconds = $chunks[$i][0];
		    $name = $chunks[$i][1];
		
		    // finding the biggest chunk (if the chunk fits, break)
		    if (($count = floor($since / $seconds)) != 0) {
		        break;
		    }
		}
		
		$jakdata = ($count == 1) ? '1 '.$name : "$count {$name}".JAK_MULTITIME. ' '.JAK_AGO;
		
		} else {
		
			$jakdata = date($date.$time, $mysqlstamp);
		}
		
		return $jakdata;
	
	}
	
	public static function jakUpdatehits($lsvar,$lsvar1)
	{
		
		global $jakdb;
		
		$sql = 'UPDATE '.$lsvar1.' SET hits = hits + 1 WHERE id = "'.smartsql($lsvar).'"';
		$result = $jakdb->query($sql);
	
	}
	
	public static function jakGetcatmix($table, $dseo)
	{
			
		global $jakdb;
		$sql = 'SELECT * FROM '.$table.' WHERE active = 1 ORDER BY catorder ASC';
		$result = $jakdb->query($sql);
		while ($row = $result->fetch_assoc()) {
		
				$seo = '';
				
				// There should be always a varname in categories and check if seo is valid
				if ($dseo) {
					$seow = $row['varname'];
				}
				
				// parse the url
				$row['parseurl'] = JAK_rewrite::jakParseurl('c', $row['id'], $seow, '', '');
				
				// collect each record into $jakdata
				$jakdata[] = $row;
		}      
		      
		  return $jakdata;
	}
	
	public static function lsWriteinCache($file, $content, $extra)
	{
	
		if ($file && $content) {
		
			if (isset($extra)) {
				file_put_contents($file, $content, FILE_APPEND | LOCK_EX);
			} else {
				file_put_contents($file, $content, LOCK_EX);
			}
		}
	
	}

}
?>