<?php

/*======================================================================*\
|| #################################################################### ||
|| # Drag'nDrop Shop 1.8                                              # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2014 JAKWEB All Rights Reserved.                       # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| #   ----------- Drag'nDrop Shop IS NOT FREE SOFTWARE -----------   # ||
|| #                      http://www.jakweb.ch                        # ||
|| #################################################################### ||
\*======================================================================*/

if (!file_exists('../config.php')) {
    die('ajax/[qtips.php] config.php not exist');
}
require_once '../config.php';

if (!file_exists('../class/currency_converter.php')) {
    die('ajax/[addtocart.php] currency_converter.php not exist');
}
require_once '../class/currency_converter.php';

if(!$_SERVER['HTTP_X_REQUESTED_WITH']) {
	die("Nothing to see here");
}

if (!$_POST['id'] && is_numeric($_POST['id'])) die("There is no such product!");

$result = $jakdb->query('SELECT id, title, content, price, sale, stock, previmg, product_options, product_options1, product_options2, showdate, time FROM '.DB_PREFIX.'shop WHERE id = "'.smartsql($_POST['id']).'" AND active = 1');
$row = $result->fetch_assoc();

if(!$row) die("There is no such product!");

// Now let's check the vote and hits cookie
if (jak_cookie_voted_hits(DB_PREFIX.'shop', $row['id'], $_COOKIE['hits'])) {

	jak_write_vote_hits_cookie(DB_PREFIX.'shop', $row['id'], 'hits');
	
	// Update hits each time
	JAK_base::jakUpdatehits($row['id'], DB_PREFIX.'shop');
}

// Import the language file
if (file_exists(APP_PATH.'lang/'.JAK_LANG.'.ini')) {
    $tl = parse_ini_file(APP_PATH.'lang/'.JAK_LANG.'.ini', true);
} else {
    $tl = parse_ini_file(APP_PATH.'lang/en.ini', true);
}

// Get the special lang var once for the time
define('JAK_DAY', $tl['general']['g17']);
define('JAK_HOUR', $tl['general']['g18']);
define('JAK_MINUTE', $tl['general']['g19']);
define('JAK_MULTITIME', $tl['general']['g20']);
define('JAK_AGO', $tl['general']['g16']);

$real_base = str_replace('ajax/', '', BASE_URL);

// Image is available so display it or go standard
if ($row['previmg']) {
	$imge = $real_base.$row['previmg'];
} else {
	$imge = $real_base.'img/no_product_photo.png';
}

// Sale is active overwrite price to save some vars
if ($row['sale'] != "0.00") {
	$row['price'] = $row['sale'];
	$tl["shop"]["m"] = $tl["shop"]["m31"];
}

// Item is in stock
if ($row['stock'] == 1) {
	$instock = $tl['shop']['m56'];
} else {
	$instock = $tl['shop']['m57'];
}

// Uh, we got some different currency then standard, well we need to change
if ($_SESSION['ECOMMERCE_CURRENCY'] != JAK_CURRENCY) {

	$convert = new CurrencyConverter();
		
	$row['price'] = $convert->Convert($row['price'], $_SESSION['ECOMMERCE_CURRENCY']);

}

// Load time if wish so
if ($row['showdate']) {
$PAGE_TIME = JAK_base::jakTimesince($row['time'], JAK_DATEFORMAT, JAK_TIMEFORMAT);
$PAGE_TIME_HTML5 = date("Y-m-d", strtotime($row['time']));
$showdate = '<p>'.$tl["shop"]["m47"].'<time datetime="'.$PAGE_TIME_HTML5.'" pubdate>'.$PAGE_TIME.'</time></p>';
}

// Finally output the stuff
echo ' <div class="item-description"><figure><img src="'.$imge.'" alt="'.$title.'" /></figure><h1>'.$row['title'].'</h1>

'.$showdate.'

'.$row['content'].'

<p>'.$tl["shop"]["m46"].'<strong>'.$instock.'</strong></p>
<p><strong>'.$tl["shop"]["m"].'<span class="pprice_'.$row["id"].'">'.$row['price'].'</span>&nbsp;'.$_SESSION['ECOMMERCE_CURRENCY'].'</strong></p> 

</div>';
?>
