<?php

/*======================================================================*\
|| #################################################################### ||
|| # Drag'nDrop Shop 1.8                                              # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2014 JAKWEB All Rights Reserved.                       # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| #   ----------- Drag'nDrop Shop IS NOT FREE SOFTWARE -----------   # ||
|| #                      http://www.jakweb.ch                        # ||
|| #################################################################### ||
\*======================================================================*/

if (!file_exists('../config.php')) die('ajax/[addtocart.php] config.php not exist');
require_once '../config.php';

require_once '../class/shopping_cart.php';

if (!file_exists('../class/currency_converter.php')) {
    die('ajax/[addtocart.php] currency_converter.php not exist');
}
require_once '../class/currency_converter.php';


if (!$_SERVER['HTTP_X_REQUESTED_WITH']) die("Nothing to see here");

$csCode = strip_tags($_POST['coupon']);

if (!preg_match('/^([0-9]||[a-z]||[A-Z])+$/', $csCode)) die('<div class="status-failure">'.$_POST['shopmsg2'].'</div>');
	
if ($_POST['action'] == "checkC"){	
			
			// Get the coupons out the database
			$result = $jakdb->query('SELECT type, discount, freeshipping, products FROM '.DB_PREFIX.'shop_coupon WHERE code = "'.smartsql($csCode).'" AND status = 1 AND datestart < "'.time().'" AND dateend > "'.time().'" AND used < total LIMIT 1');
			
			if ($jakdb->affected_rows > 0) {
			
			$row = $result->fetch_assoc();
			
			if (!empty($row['discount']) || $row['freeshipping'] == 1) {
			
				// Let's check if there is any product in the discount
				if ($row['products'] == 0) {
					$sqlwhere = '';
				} elseif (is_numeric($row['products'])) {
					$sqlwhere = ' AND t1.shopid = '.$row['products'].'';
				} else {
					$sqlwhere = ' AND t1.shopid IN('.$row['products'].')';
				}
				
				$result1 = $jakdb->query('SELECT t1.shopid, t2.title, t1.price FROM '.DB_PREFIX.'shopping_cart AS t1 LEFT JOIN '.DB_PREFIX.'shop AS t2 ON(t1.shopid = t2.id) WHERE t1.session = "'.smartsql($_SESSION['shopping_cart']).'"'.$sqlwhere);
				
				if ($jakdb->affected_rows > 0) {
			
					if ($row['freeshipping'] == 1) {
						$fsT = $_POST['shopmsg1'];
					}
					// Check discount type (type1 = percentage)
					if ($row['type'] == 1) {
						$dtT = '&nbsp;%';
						
						while ($row1 = $result1->fetch_assoc()) {
						
								// Get the discount before taxes
								$totalD = $row1['price'] / 100 * $row['discount'];
								$totalB = $row1['price'] - round($totalD, 1);
								
								// Shop taxes, well start counting
								if (JAK_TAXES) {
									$taxTotal = $totalB / 100 * JAK_TAXES;
									$totalB = $totalB + round($taxTotal, 1);
								}
								
								// Uh, we got some different currency then standard, well we need to change
								if ($_SESSION['ECOMMERCE_CURRENCY'] != JAK_CURRENCY) {
								
									$convert = new CurrencyConverter();
										
									$totalB = $convert->Convert($totalB, $_SESSION['ECOMMERCE_CURRENCY']);
								
								}
								
								$totalS .= '<strong>'.$row1['title'].'</strong>&nbsp;-&nbsp;'.$_POST['shopmsg3'].number_format($totalB, 2, '.', '').'&nbsp;'.$_SESSION['ECOMMERCE_CURRENCY'].'<br />';
						    }
						    
					} else {
						$dtT = '&nbsp;'.$_SESSION['ECOMMERCE_CURRENCY'];
						
						while ($row1 = $result1->fetch_assoc()) {
						
								// Get the discount before taxes
								$totalB = $row1['price'] - $row['discount'];
								
								// Shop taxes, well start counting
								if (JAK_TAXES) {
									$taxTotal = $totalB / 100 * JAK_TAXES;
									$totalB = $totalB + round($taxTotal, 1);
								}
								
								// Uh, we got some different currency then standard, well we need to change
								if ($_SESSION['ECOMMERCE_CURRENCY'] != JAK_CURRENCY) {
								
									$convert = new CurrencyConverter();
										
									$totalB = $convert->Convert($totalB, $_SESSION['ECOMMERCE_CURRENCY']);
								
								}
								
								$totalS .= '<strong>'.$row1['title'].'</strong>&nbsp;-&nbsp;'.$_POST['shopmsg3'].number_format($totalB, 2, '.', '').'&nbsp;'.$_SESSION['ECOMMERCE_CURRENCY'].'<br />';
						    }
						    
					}
				echo '<div class="status-ok">'.$_POST['shopmsg'].$row['discount'].$dtT.'<br />'.$totalS.$fsT.'</div>';
			} else {
				echo '<div class="status-failure">'.$_POST['shopmsg2'].'</div>';
			}
			} else {
				echo '<div class="status-failure">'.$_POST['shopmsg2'].'</div>';
			}
			} else {
				echo '<div class="status-failure">'.$_POST['shopmsg2'].'</div>';
			}
	}
?>