<?php

/*======================================================================*\
|| #################################################################### ||
|| # Drag'nDrop Shop 1.8                                              # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2014 JAKWEB All Rights Reserved.                       # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| #   ----------- Drag'nDrop Shop IS NOT FREE SOFTWARE -----------   # ||
|| #                      http://www.jakweb.ch                        # ||
|| #################################################################### ||
\*======================================================================*/

// Check if the file is accessed only via index.php if not stop the script from running
if (!defined('JAK_ADMIN_PREVENT_ACCESS')) die('You cannot access this file directly.');

// Check if the user has access to this file
if (!JAK_USERID || !JAK_SUPERADMINACCESS) jak_redirect(BASE_URL);

// All the tables we need for this plugin
$errors = array();

// Important template Stuff
$JAK_SETTING = jak_get_setting('setting');

// Let's go on with the script
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $defaults = $_POST;
    
    if ($defaults['jak_email'] == '' || !filter_var($defaults['jak_email'], FILTER_VALIDATE_EMAIL)) { 
    	$errors['e1'] = $tl['error']['e3'];
    }
    
    if ($defaults['jak_lang'] == '') { $errors['e6'] = $tl['error']['e29']; }

    if (empty($defaults['jak_date'])) { $errors['e2'] = $tl['error']['e4']; }

    if (count($errors) == 0) {
    
    // Do the dirty work in mysql
    
    $sql = 'UPDATE '.DB_PREFIX.'setting SET value = CASE varname
    	WHEN "title" THEN "'.smartsql($defaults['jak_title']).'"
        WHEN "email" THEN "'.smartsql($defaults['jak_email']).'"
        WHEN "sitehttps" THEN '.$defaults['jak_shttp'].'
        WHEN "lang" THEN "'.smartsql($defaults['jak_lang']).'"
        WHEN "analyticsid" THEN "'.$defaults['jak_analytic'].'"
        WHEN "facebooklike" THEN "'.$defaults['jak_facebook'].'"
        WHEN "dateformat" THEN "'.smartsql($defaults['jak_date']).'"
        WHEN "timeformat" THEN "'.smartsql($defaults['jak_time']).'"
        WHEN "timezoneserver" THEN "'.$defaults['jak_timezone_server'].'"
        WHEN "welcome_message" THEN "'.smartsql($defaults['welcome_message']).'"
        WHEN "thankyou_message" THEN "'.smartsql($defaults['thankyou_message']).'"
        WHEN "ip_block" THEN "'.smartsql($defaults['ip_block']).'"
        WHEN "email_block" THEN "'.smartsql($defaults['email_block']).'"
        WHEN "shopsearch" THEN '.$defaults['jak_shopsearch'].'
        WHEN "shopurl" THEN '.$defaults['jak_shopurl'].'
        WHEN "productopen" THEN '.$defaults['jak_itemopen'].'
        WHEN "shopquantity" THEN '.$defaults['jak_quantity'].'
        WHEN "shoppagemid" THEN "'.smartsql($defaults['jak_mid']).'"
        WHEN "shoppageitem" THEN "'.smartsql($defaults['jak_item']).'"
        WHEN "agreement" THEN "'.smartsql($defaults['jak_license']).'"
        WHEN "copyright" THEN "'.smartsql($defaults['jak_copyright']).'"
        WHEN "shoprss" THEN "'.smartsql($defaults['jak_rssitem']).'"
        WHEN "currency" THEN "'.smartsql($defaults['jak_currency']).'"
        WHEN "currency1" THEN "'.smartsql($defaults['jak_currency1']).'"
        WHEN "currency2" THEN "'.smartsql($defaults['jak_currency2']).'"
        WHEN "taxes" THEN "'.smartsql($defaults['jak_taxes']).'"
        WHEN "shop_address" THEN "'.smartsql($defaults['jak_address']).'"
        WHEN "country" THEN "'.smartsql($defaults['jak_country']).'"
        WHEN "sitestyle" THEN "'.smartsql($defaults['jak_sitestyle']).'"
    END
		WHERE varname IN ("title","email","sitehttps","lang","ratingimg","analyticsid","facebooklike","dateformat","timeformat","timezoneserver","welcome_message","thankyou_message","ip_block","email_block","shopsearch","shopurl","productopen","shopquantity","shoppagemid","shoppageitem","agreement","copyright","shoprss","currency","currency1","currency2","taxes","shop_address","country","sitestyle")';
		$result = $jakdb->query($sql);
		
	// Now let us delete the define cache file
	$cachedefinefile = '../'.JAK_CACHE_DIRECTORY.'/define.php';
	if (file_exists($cachedefinefile)) {
		unlink($cachedefinefile);
	}
		
	if (!$result) {
		jak_redirect(BASE_URL.'index.php?p=error&sp=mysql');
	} else {		
        jak_redirect(BASE_URL.'index.php?p=success');
    }
    } else {
    
   	$errors['e'] = $tl['error']['e'];
    $errors = $errors;
    }
}

// Call the settings function
$lang_files = jak_get_lang_files(false);
$JAK_COUNTRY = getCountry(JAK_COUNTRY, '');
$site_style_files = jak_get_site_style('../template/');
// Call the template
$template = 'setting.php';

?>