<?php

/*======================================================================*\
|| #################################################################### ||
|| # Drag'nDrop Shop 1.8                                              # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2014 JAKWEB All Rights Reserved.                       # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| #   ----------- Drag'nDrop Shop IS NOT FREE SOFTWARE -----------   # ||
|| #                      http://www.jakweb.ch                        # ||
|| #################################################################### ||
\*======================================================================*/

// prevent direct php access
define('JAK_ADMIN_PREVENT_ACCESS', 1);

if (!file_exists('config.php')) die('[index.php] config.php not found');
require_once 'config.php';

$page = ($temppa ? filter_var($temppa, FILTER_SANITIZE_STRING) : '');
$page1 = ($temppa1 ? filter_var($temppa1, FILTER_SANITIZE_STRING) : '');
$page2 = ($temppa2 ? filter_var($temppa2, FILTER_SANITIZE_STRING) : '');
$page3 = ($temppa3 ? filter_var($temppa3, FILTER_SANITIZE_STRING) : '');
$page4 = ($temppa4 ? filter_var($temppa4, FILTER_SANITIZE_STRING) : '');
$page5 = ($temppa5 ? filter_var($temppa5, FILTER_SANITIZE_STRING) : '');
$page6 = ($temppa5 ? filter_var($temppa6, FILTER_SANITIZE_STRING) : '');

$JAK_SPECIALACCESS = false;
$JAK_UNDELETABLE = false;

$_SESSION['JAKLoggedInAdmin'] = false;

// Only the SuperAdmin in the config file see everything
if ($lsuser->lsSuperadminaccess(JAK_USERID)) {
	$JAK_SPECIALACCESS = true;
	$JAK_UNDELETABLE = true;
	define('JAK_SUPERADMINACCESS', true);
} else {
	define('JAK_SUPERADMINACCESS', false);
}

// Only the Admin's in the config can have access
if ($lsuser->lsAdminaccess(JAK_USERID)) {
	define('JAK_ADMINACCESS', true);
	$_SESSION['JAKLoggedInAdmin'] = true;
} else {
	define('JAK_ADMINACCESS', false);
}

// All other user will be redirect to the homepage, nothing else to do for this people
if (JAK_USERID && !JAK_ADMINACCESS) {
		jak_redirect(BASE_URL_ORIG);
}

if (file_exists(APP_PATH.'admin/lang/'.JAK_LANG.'.ini')) {
    $tl = parse_ini_file(APP_PATH.'admin/lang/'.JAK_LANG.'.ini', true);
} else {
    trigger_error('Translation file not found');
}

// Define for template the real request
$realrequest = substr($getURL->jakRealrequest(), 1);
define('JAK_PARSE_REQUEST', $realrequest);

// We need the template folder, title, author and lang as template variable
$JAK_CMSLANG = JAK_LANG;
$JAK_CONTACT_FORM = JAK_CONTACTFORM;
$JAK_REGISTER_FORM = JAK_REGISTER;
define('JAK_PAGINATE_ADMIN', 1);

// First check if the user is logged in
if (JAK_USERID) {

// Get the name from the user for the welcome message
$JAK_WELCOME_NAME = $lsuser->getVar("name");

// Now get the forgot password link into the right shape
$P_FORGOT_PASS_ADMIN = JAK_rewrite::jakParseurl($tl['login']['l12'], '', '', '', '');

}

$checkp = 0;

if (!isset($_SERVER['HTTP_REFERER'])) {
    $_SERVER['HTTP_REFERER'] = '';
}

// home
    if ($page == '') {
        #show login page only if the admin is not logged in
        #else show homepage
        if (!JAK_USERID) {
            require_once 'login.php';
        } else {
            require_once 'shop.php';
            $JAK_PROVED = 1;
            $JAK_PAGE_ACTIVE = 1;
            
            $cacheverfile=APP_PATH.JAK_CACHE_DIRECTORY.'/version.php';$admincacheexist=false;if(file_exists($cacheverfile)){include_once $cacheverfile;$admincacheexist=true;$admin_cache_expire=JAK_ADMIN_CACHE_CREATED+86400;if($admin_cache_expire<time()){if(file_exists($cacheverfile)){unlink($cacheverfile);$admincacheexist=false;}}}if(!$admincacheexist && function_exists('simplexml_load_file')){$versioncont="<?php\n";$versioncont.="define('JAK_ADMIN_CACHE_CREATED','".time()."');\n";$urlxml=parse_url(BASE_URL_ORIG);$jakXML=@simplexml_load_file('http://vc.jakweb.ch/dragdrop.xml?url='.$urlxml["host"]);if($jakXML){$versioncont.="define('JAK_VC_STATUS',1);\n";foreach($jakXML->children()as$child){$versioncont.="define('JAK_VC_".strtoupper($child->getName())."','".$child."');\n";}}else{$jakXML=jak_load_xml_from_url('http://vc.jakweb.ch/dragdrop.xml?url='.$urlxml["host"]);if($jakcurlxml){$versioncont.="define('JAK_VC_STATUS',1);\n";foreach($jakXML->children()as$child){$versioncont.="define('JAK_VC_".strtoupper($child->getName())."','".$child."');\n";}}else{$versioncont.="define('JAK_VC_STATUS',0);\n";}}$versioncont.="?>";JAK_base::lsWriteinCache($cacheverfile,$versioncont,'');if(file_exists($cacheverfile))include_once $cacheverfile;}
        }
        $checkp = 1;
   }
   if ($page == 'logout') {
        $checkp = 1;
        if (JAK_USERID) {
            $lsuserlogin->lsLogout(JAK_USERID);
            $JAK_PROVED = 1;
            $html_title = $tl['logout']['l'];
            $template = 'success.php';
        } else {
        	jak_redirect(BASE_URL);
        }
    }
    if ($page == 'forgot') {
    	if (JAK_USERID) {
    	    jak_redirect(BASE_URL);
    	}
        require_once 'forgot.php';
        $html_title = $tl['general']['g94'];
        $JAK_PROVED = 0;
        $JAK_PAGE_ACTIVE = 1;
        $checkp = 1;
    }
    if ($page == 'success') {
        if (!JAK_USERID) {
            jak_redirect(BASE_URL);
            exit;
        }
        $template = 'success.php';
        $JAK_PROVED = 1;
        $checkp = 1;
    }
    if ($page == 'error') {
        if (!JAK_USERID) {
            jak_redirect(BASE_URL);
        }
        $template = 'error.php';
        $JAK_PROVED = 1;
        $checkp = 1;
    }
    if ($page == '404') {
        if (!JAK_USERID) {
            jak_redirect(BASE_URL);
        }
        // Go to the 404 Page
        $JAK_PROVED = 1;
        $html_title = '404 / ' . JAK_TITLE;
        $template = '404.php';
        $checkp = 1;
    }
    if ($page == 'shop') {
        require_once 'shop.php';
        $JAK_PROVED = 1;
        $JAK_PAGE_ACTIVE = 1;
        $checkp = 1;
    }
    if ($page == 'categories') {
        require_once 'categories.php';
        $JAK_PROVED = 1;
        $JAK_PAGE_ACTIVE = 1;
        $checkp = 1;
    }
    if ($page == 'coupons') {
        require_once 'coupons.php';
        $JAK_PROVED = 1;
        $JAK_PAGE_ACTIVE = 1;
        $checkp = 1;
    }
    if ($page == 'emails') {
        require_once 'emails.php';
        $JAK_PROVED = 1;
        $JAK_PAGE_ACTIVE = 1;
        $checkp = 1;
    }
    if ($page == 'settings') {
        require_once 'setting.php';
        $JAK_PROVED = 1;
        $JAK_PAGE_ACTIVE = 1;
        $checkp = 1;
    }
    if ($page == 'users') {
        require_once 'user.php';
        $JAK_PROVED = 1;
        $JAK_PAGE_ACTIVE = 1;
        $checkp = 1;
    }
    if ($page == 'backupdb') {
        require_once 'backupdb.php';
        $JAK_PROVED = 1;
        $JAK_PAGE_ACTIVE = 1;
        $checkp = 1;
    }
    if ($page == 'logs') {
        require_once 'logs.php';
        $JAK_PROVED = 1;
        $JAK_PAGE_ACTIVE = 1;
        $checkp = 1;
    }
     
// if page not found

if ($checkp == 0) {
    jak_redirect(BASE_URL.'index.php?p=404');
}

if (isset($template) && $template != '') {
	include_once APP_PATH.'admin/template/'.$template;
}

// Get the plugin template
if (isset($plugin_template) && $plugin_template != '') {
	
	include_once APP_PATH.$plugin_template;
}
    
// Finally close all db connections
$jakdb->jak_close();
?>