<?php

/*======================================================================*\
|| #################################################################### ||
|| # Drag'nDrop Shop 1.8                                              # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2014 JAKWEB All Rights Reserved.                       # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| #   ----------- Drag'nDrop Shop IS NOT FREE SOFTWARE -----------   # ||
|| #                      http://www.jakweb.ch                        # ||
|| #################################################################### ||
\*======================================================================*/

// Check if the file is accessed only via index.php if not stop the script from running
if (!defined('JAK_ADMIN_PREVENT_ACCESS')) die('You cannot access this file directly.');

// Check if the user has access to this file
if (!JAK_USERID || !JAK_SUPERADMINACCESS) jak_redirect(BASE_URL);

// All the tables we need for this plugin
$errors = array();
$jaktable = DB_PREFIX.'shop';
$jaktable10 = DB_PREFIX.'shop_coupon';

// Now start with the plugin use a switch to access all pages
switch ($page1) {

		case 'new':
				
			if ($_SERVER['REQUEST_METHOD'] == 'POST') {
				$defaults = $_POST;
				
				if (empty($defaults['jak_title'])) {
					$errors['e1'] = $tl['error']['e2'];
				}
				        
				if (empty($defaults['jak_code']) || !preg_match('/^([0-9]||[a-z]||[A-Z])+$/', $defaults['jak_code'])) {
				    $errors['e2'] = $tl['error']['e36'];
				}
				
				if (empty($defaults['jak_discount']) || !preg_match('/^([0-9]||[.])+$/', $defaults['jak_discount'])) {
				    $errors['e3'] = $tl['error']['e15'];
				}
				
				if (!isset($defaults['jak_products'])) {
					$products = 0;
					} elseif (in_array(0, $defaults['jak_products'])) {
						$products = 0;
				} else {
					$products = join(',', $defaults['jak_products']);
				}
				
				if (!empty($defaults['jak_datefrom'])) {
				
					list($yearf, $monthf, $dayf) = explode('-', $defaults['jak_datefrom']);
					$finalfrom = mktime($defaults['jak_timefrom'], $defaults['jak_timefromm'], 0, $monthf, $dayf, $yearf);
					
				}
				
				if (!empty($defaults['jak_dateto'])) {
						
					list($yeart, $montht, $dayt) = explode('-', $defaults['jak_dateto']);
					$finalto = mktime($defaults['jak_timeto'], $defaults['jak_timetom'], 0, $montht, $dayt, $yeart);
					
				}
				
				if ($finalto < $finalfrom) {
					$errors['e4'] = $tl['error']['e28'];
				}
					
				if (!is_numeric($defaults['jak_total'])) {
				    $errors['e5'] = $tl['error']['e15'];
				}
				
				if (!is_numeric($defaults['jak_used'])) {
				    $errors['e6'] = $tl['error']['e15'];
				}
				
				if (count($errors) == 0) {
				
					$result = $jakdb->query('INSERT INTO '.$jaktable10.' SET 
					    title = "'.$defaults['jak_title'].'",
					    description = "'.smartsql($defaults['jak_description']).'",
					    code = "'.smartsql($defaults['jak_code']).'",
					    type = "'.smartsql($defaults['jak_type']).'",
					    discount = "'.smartsql($defaults['jak_discount']).'",
					    freeshipping = '.$defaults['jak_freeshipping'].',
					    datestart = "'.smartsql($finalfrom).'",
					    dateend = "'.smartsql($finalto).'",
					    total = "'.smartsql($defaults['jak_total']).'",
					    used = "'.smartsql($defaults['jak_used']).'",
					    products = "'.smartsql($products).'"');
					
						if (!$result) {
					    	jak_redirect(BASE_URL.'index.php?p=error&sp=mysql');
						} else {
					        jak_redirect(BASE_URL.'index.php?p=success');
					    }
					    
						} else {
					   	$errors['e'] = $tl['error']['e'];
					    $errors = $errors;
					}
					
				}
				
			$JAK_PRODUCTS_CHOOSE = jak_get_shop($jaktable, '');
				
			// Call the template
			$template = 'newcoupon.php';
				
		break;
		case 'lock':
		 		
		 		$sql = 'UPDATE '.$jaktable10.' SET status = IF (status = 1, 0, 1) WHERE id = "'.smartsql($page2).'"';
		 	    	$result = $jakdb->query($sql);
		 	    	
			 	if (!$result) {
			 		jak_redirect(BASE_URL.'index.php?p=error&sp=mysql');
			 	} else {
			 	    jak_redirect(BASE_URL.'index.php?p=success');
			 	}
		 		
		break;
		case 'delete':
				if (is_numeric($page2) && jak_row_exist($page2, $jaktable10)) {
					$result = $jakdb->query('DELETE FROM '.$jaktable10.' WHERE id = "'.smartsql($page2).'"');
			
				if (!$result) {
			    	jak_redirect(BASE_URL.'index.php?p=error&sp=mysql');
				} else {
			        jak_redirect(BASE_URL.'index.php?p=success');
			    }
			    
			} else {
			   	jak_redirect(BASE_URL.'index.php?p=error&sp=not-exist');
			}
		break;
		case 'edit':
			if (is_numeric($page2) && jak_row_exist($page2,$jaktable10)) {
		
			if ($_SERVER['REQUEST_METHOD'] == 'POST') {
		    $defaults = $_POST;
		
		    if (empty($defaults['jak_title'])) {
		        $errors['e1'] = $tl['error']['e2'];
		    }
		    
		    if (empty($defaults['jak_code']) || !preg_match('/^([0-9]||[a-z]||[A-Z])+$/', $defaults['jak_code'])) {
		        $errors['e2'] = $tl['error']['e36'];
		    }
		    
		    if (empty($defaults['jak_discount']) || !preg_match('/^([0-9]||[.])+$/', $defaults['jak_discount'])) {
		        $errors['e3'] = $tl['error']['e15'];
		    }
		    
		    if (!isset($defaults['jak_products'])) {
		    	$products = 0;
		    	} elseif (in_array(0, $defaults['jak_products'])) {
		    		$products = 0;
		    } else {
		    	$products = join(',', $defaults['jak_products']);
		    }
		    
		    if (!empty($defaults['jak_datefrom'])) {
		    
		    	list($yearf, $monthf, $dayf) = explode('-', $defaults['jak_datefrom']);
		    	$finalfrom = mktime($defaults['jak_timefrom'], $defaults['jak_timefromm'], 0, $monthf, $dayf, $yearf);
		    	
		    }
		    
		    if (!empty($defaults['jak_dateto'])) {
		    		
		    	list($yeart, $montht, $dayt) = explode('-', $defaults['jak_dateto']);
		    	$finalto = mktime($defaults['jak_timeto'], $defaults['jak_timetom'], 0, $montht, $dayt, $yeart);
		    	
		    }
		    
		    if ($finalto < $finalfrom) {
		    	$errors['e4'] = $tl['error']['e28'];
		    }
		    	
		    if (!is_numeric($defaults['jak_total'])) {
		        $errors['e5'] = $tl['error']['e15'];
		    }
		    
		    if (!is_numeric($defaults['jak_used'])) {
		        $errors['e6'] = $tl['error']['e15'];
		    }
		    
		    if (count($errors) == 0) {
		
				$result = $jakdb->query('UPDATE '.$jaktable10.' SET 
				title = "'.$defaults['jak_title'].'",
				description = "'.smartsql($defaults['jak_description']).'",
				code = "'.smartsql($defaults['jak_code']).'",
				type = "'.smartsql($defaults['jak_type']).'",
				discount = "'.smartsql($defaults['jak_discount']).'",
				freeshipping = '.$defaults['jak_freeshipping'].',
				datestart = "'.smartsql($finalfrom).'",
				dateend = "'.smartsql($finalto).'",
				total = "'.smartsql($defaults['jak_total']).'",
				used = "'.smartsql($defaults['jak_used']).'",
				products = "'.smartsql($products).'"
				WHERE id = "'.smartsql($page2).'"');
			
				if (!$result) {
			    	jak_redirect(BASE_URL.'index.php?p=error&sp=mysql');
				} else {
			        jak_redirect(BASE_URL.'index.php?p=success');
			    }
			    
		 	} else {
			   	$errors['e'] = $tl['error']['e'];
			    $errors = $errors;
		    }
		}
		
		$JAK_FORM_DATA = jak_get_data($page2, $jaktable10);
		$JAK_PRODUCTS_CHOOSE = jak_get_shop($jaktable, '');
		
		// Call the template
		$template = 'editcoupon.php';
		
		} else {
		   	jak_redirect(BASE_URL.'index.php?p=error&sp=not-exist');
		}
		break;
		default:
	
		$getTotal = jak_get_total($jaktable10, '', '', '');
		if ($getTotal != 0) {
		// Paginator
			$pages = new Paginator;
			$pages->items_total = $getTotal;
			$pages->mid_range = 5;
			$pages->items_per_page = 20;
			$pages->jak_get_page = $page1;
			$pages->jak_where = 'index.php?p=coupons';
			$pages->paginate();
			$JAK_PAGINATE = $pages->display_pages();
		}
		$JAK_SHOPCOUPON_ALL = jak_get_page_info($jaktable10, $pages->limit);
		
		// Call the template
		$template = 'coupons.php';
		
}
?>