<?php

/*======================================================================*\
|| #################################################################### ||
|| # Drag'nDrop Shop 1.8                                              # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2014 JAKWEB All Rights Reserved.                       # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| #   ----------- Drag'nDrop Shop IS NOT FREE SOFTWARE -----------   # ||
|| #                      http://www.jakweb.ch                        # ||
|| #################################################################### ||
\*======================================================================*/

// Do not go any further if install folder still exists
if (is_dir('../install')) die('Please delete or rename install folder.');

// The DB connections data
require_once '../include/db.php';

// Get the real stuff
require_once '../config.php';

define('BASE_URL_ADMIN', BASE_URL);
define('BASE_URL_ORIG', str_replace('/admin/', '/', BASE_URL));
define('BASE_PATH_ORIG', str_replace('/admin', '/', _APP_MAIN_DIR));

// Include some functions for the ADMIN Area
include_once 'include/admin.function.php';
include_once '../class/class.paginator.php';

// Overwrite url for admin
// We are not using apache so take the ugly urls
$temppa = $getURL->jakGetsegAdmin(0);
$temppa1 = $getURL->jakGetsegAdmin(1);
$temppa2 = $getURL->jakGetsegAdmin(2);
$temppa3 = $getURL->jakGetsegAdmin(3);
$temppa4 = $getURL->jakGetsegAdmin(4);
$temppa5 = $getURL->jakGetsegAdmin(5);
$temppa6 = $getURL->jakGetsegAdmin(6);

// Set the last activity and session into cookies
setcookie('lastactivity', time(), time() + 60 * 60 * 24 * 10, JAK_COOKIE_PATH);
setcookie('usrsession', session_id(), time() + 60 * 60 * 24 * 10, JAK_COOKIE_PATH);

// Check if user is logged in
$lsuserlogin = new JAK_userlogin();
$lsuserrow = $lsuserlogin->lsCheckLogged();
$lsuser = new JAK_user($lsuserrow);
if ($lsuser) {
	define(JAK_USERID, $lsuser->getVar("id"));
} else {
	define(JAK_USERID, false);
}

if (JAK_USERID) {
	// Update last activity from this user
	$lsuserlogin->lsUpdatelastactivity(JAK_USERID);
}
?>