<?php
/**
 * Template name: Login Page
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage classiera
 * @since classiera
 */

if ( is_user_logged_in() ) { 

	global $redux_demo; 
	$profile = $redux_demo['profile'];
	wp_redirect( $profile ); exit;

}

global $user_ID, $username, $password, $remember;

//We shall SQL escape all inputs
$username = esc_sql(isset($_REQUEST['username']) ? $_REQUEST['username'] : '');
$password = esc_sql(isset($_REQUEST['password']) ? $_REQUEST['password'] : '');
$remember = esc_sql(isset($_REQUEST['rememberme']) ? $_REQUEST['rememberme'] : '');
	
if($remember) $remember = "true";
else $remember = "false";
$login_data = array();
$login_data['user_login'] = $username;
$login_data['user_password'] = $password;
$login_data['remember'] = $remember;
$user_verify = wp_signon( $login_data, false ); 
//wp_signon is a wordpress function which authenticates a user. It accepts user info parameters as an array.
if(isset($_POST['submit'])){
if($_POST['submit'] == 'Login'){
	if ( is_wp_error($user_verify) ) {		
		$UserError =  esc_html__( 'Invalid username or password. Please try again!', 'classiera' );
	} else {

		global $redux_demo; 
		$profile = $redux_demo['profile'];
		wp_redirect( $profile ); exit;

	}
}
}
global $redux_demo; 
$login = $redux_demo['login'];
$classieraSocialLogin = $redux_demo['classiera_social_login'];
$rand1 = rand(0,9);
$rand2 = rand(0,9);
$rand_answer = $rand1 + $rand2;


global $resetSuccess;

if (!$user_ID) {
	if(isset($_POST['submit'])){
	if($_POST['submit'] == 'Reset') 

	{

		// First, make sure the email address is set
		if ( isset( $_POST['email'] ) && ! empty( $_POST['email'] ) ) {

		  	// Next, sanitize the data
		  	$email_addr = trim( strip_tags( stripslashes( $_POST['email'] ) ) );

		  	$user = get_user_by( 'email', $email_addr );
		  	$user_ID = $user->ID;

		  	if( !empty($user_ID)) {

				$new_password = wp_generate_password( 12, false ); 

				if ( isset($new_password) ) {

					wp_set_password( $new_password, $user_ID );
					
					$message =  esc_html__( 'Check your email for new password.', 'classiera' );

			      	$from = get_option('admin_email');
					$headers = 'From: '.$from . "\r\n";
					$subject = "Password reset!";
					$msg = "Reset password.\nYour login details\nNew Password: $new_password";
					wp_mail( $email_addr, $subject, $msg, $headers );

					$resetSuccess = 1;

				}

		    } else {

				$message =  esc_html__( 'There is no user available for this email.', 'classiera' );

		    } // end if/else

		} else {			
			$message =  esc_html__( 'Email should not be empty.', 'classiera' );
		}

	}
}

}

get_header(); ?>
<?php 
	$page = get_page($post->ID);
	$current_page_id = $page->ID;
?>
<?php $page_custom_title = get_post_meta($current_page_id, 'page_custom_title', true); ?>
<!-- page Heading -->
<?php $titleBg = $redux_demo['title-bg']['url']; ?>	
<section class="pageHeading" style="background:url(<?php echo $titleBg; ?>);">
    <div class="row">
    <h3><?php the_title(); ?></h3>
	<p><?php echo $page_custom_title; ?></p>
    </div>
</section><!-- End page Heading -->
<!-- advertisement -->
<?php global $redux_demo;
?>
<section id="advertisement" class="noBorder removePad">
	<div class="row">
		<div class="large-6 columns <?php if(is_rtl()){ echo "loginborder-left"; }else{ echo "loginborder-right";} ?>"><!--Social Login -->
			<div class="row">
				<div class="large-8 large-centered columns">
					<div class="loginContent">
						<div class="loginLogo">
							<?php
							global $redux_demo;
							$logo = $redux_demo['logo']['url'];
							$register = $redux_demo['register'];
							if (!empty($logo)) { ?>
							<img src="<?php echo $logo; ?>" alt="Logo" />
							<?php } else { ?>
							<img src="<?php echo get_template_directory_uri(); ?>/images/logo.png" alt="Logo" />
							<?php } ?>
							<p><?php esc_html_e('Dont have an account?', 'classiera') ?> <a href="<?php echo $register; ?>"><?php esc_html_e('Create your account.', 'classiera') ?></a> <?php esc_html_e('It takes less than a minute', 'classiera') ?></p>
							<?php if($classieraSocialLogin == 1){?>
							<span class="loginSep"><?php esc_html_e('OR', 'classiera') ?></span>
							<?php } ?>
						</div>
						<div class="loginSocial">
						<?php if($classieraSocialLogin == 1){?>
							<h4><?php esc_html_e('LOGIN VIA SOCIAL ACCOUNT', 'classiera') ?></h4>
							<?php
							/* Detect plugin. For use on Front End only.*/
							include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
							// check for plugin using plugin name
							if ( is_plugin_active( "nextend-facebook-connect/nextend-facebook-connect.php" ) ) {
								//plugin is activated
								?>
								<a class="loginSocialbtn fb" href="<?php echo get_site_url(); ?>/wp-login.php?loginFacebook=1" onclick="window.location = '<?php echo get_site_url(); ?>/wp-login.php?loginFacebook=1&redirect='+window.location.href; return false;"><i class="fa fa-facebook"></i><?php esc_html_e('Login via Facebook', 'classiera') ?></a>
							<?php } ?>
							<?php
							/* Detect plugin. For use on Front End only.*/
							include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
							// check for plugin using plugin name
							if ( is_plugin_active( "nextend-twitter-connect/nextend-twitter-connect.php" ) ) {
								//plugin is activated
								?>
								<a class="loginSocialbtn twitter" href="<?php echo get_site_url(); ?>/wp-login.php?loginTwitter=1" onclick="window.location = '<?php echo get_site_url(); ?>/wp-login.php?loginTwitter=1&redirect='+window.location.href; return false;"><i class="fa fa-twitter"></i><?php esc_html_e('Login via Twitter', 'classiera') ?></a>
							<?php }	?>
							<?php
							/* Detect plugin. For use on Front End only.*/
							include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
							// check for plugin using plugin name
							if ( is_plugin_active( "nextend-google-connect/nextend-google-connect.php" ) ) {
								//plugin is activated
								?>
								<a class="loginSocialbtn google" href="<?php echo get_site_url(); ?>/wp-login.php?loginGoogle=1" onclick="window.location = '<?php echo get_site_url(); ?>/wp-login.php?loginGoogle=1&redirect='+window.location.href; return false;"><i class="fa fa-google-plus"></i><?php esc_html_e('Login via Google', 'classiera') ?></a>
								<?php
							}
							?>
							<!--AccessPress Socil Login-->
							<?php
							include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
							if ( is_plugin_active( "accesspress-social-login-lite/accesspress-social-login-lite.php" )){
								echo do_shortcode('[apsl-login-lite]');
							}								
							?>
							<!--AccessPress Socil Login-->
						<?php } ?>	
						</div>
					</div>
				</div>
			</div>
		</div><!-- End Social Login -->	
		<div class="large-6 columns">
			<div class="row">
				<div class="large-8 large-centered columns">
					<div class="loginContent">
						<div class="loginHead">
							<h4><?php esc_html_e('Login', 'classiera') ?></h4>
						</div>
						<div class="loginSocial">
							<form class="form-item login-form" action="" id="myform" method="POST" enctype="multipart/form-data" data-abide>
								<?php if(isset($_GET['action'])){ if($_GET['action'] == 'resetpass'){ ?>
								<span><?php esc_html_e( 'Go to your inbox or spam/junk and get your password', 'classiera' ); ?></span>
								<?php  }} ?>
								<?php if(isset($_GET['action'])){ if($_GET['action'] == 'register' && $_GET['success'] == '1'){ ?>
								<span><?php esc_html_e( 'Go to your inbox or spam/junk and get your password', 'classiera' ); ?></span>
								<?php  }} ?>	
								<?php global $user_ID, $user_identity; wp_get_current_user(); ?>
								<?php if(!empty($UserError)) { ?>
								<div class='error'><?php echo $UserError; ?></div>
								<div class="clearfix"></div>
								<?php } ?>
								<div class="inner-addon left-addon name-field">
									<i class="icon fa fa-user"></i>
									<input type="text" id="contactName" Placeholder="<?php esc_html_e( 'UserName', 'classiera' ); ?>" name="username" class="text input-textarea half" value="" />
									<small class="error"><?php esc_html_e( 'Name is required and must be a string.', 'classiera' ); ?></small>
								</div><!-- End UserName Div -->
								<div class="inner-addon left-addon password-field">
									<i class="icon fa fa-unlock-alt"></i>
									<input type="password" id="password" Placeholder="<?php esc_html_e( 'Password', 'classiera' ); ?>" name="password" class="text input-textarea half" value="" />
									<small class="error"><?php esc_html_e( 'An password is required.', 'classiera' ); ?></small>
								</div><!-- End Password Div -->
								<div class="checkbox">
									<input id="remember" name="rememberme" type="checkbox" value="forever" style="float: left;"/>
									<label for="remember"><?php esc_html_e( 'Remember me', 'classiera' ); ?></label>
								</div><!-- End checkbox Div -->
								<?php 
								global $redux_demo;
								$reset = $redux_demo['reset'];
								?>
								<div class="row">
									<div class="large-12 columns">
										<div class="inner-addon left-addon">
											<input type="hidden" id="submitbtn" name="submit" value="Login" />				
											<button class="button round btnfull form-submit" id="edit-submit" name="op" value="Login" type="submit"><?php esc_html_e('LOGIN NOW', 'classiera') ?></button>											
										</div>
										<p class="reset">
											<a class="resetPass" href="<?php echo $reset; ?>"><?php esc_html_e('Forget Password?', 'classiera') ?></a>
										</p>
									</div>
								</div><!-- End LoginButton Div -->
							</form>
						</div>
					</div>
				</div>
			</div>
		</div><!-- End Custom Login Form -->	
	</div><!-- End Main Row -->
</section>
<!-- End advertisement -->
<?php get_footer(); ?>