<?php
/**
 * Template Name: Blog Main Page
 *
 * The template for displaying the Main Blog Page.
 *
 * it will loop and display the blog posts
 *
 * @package WordPress
 * @subpackage classiera
 * @since classiera 1.0
 */

get_header();

 ?>
<?php 
	$page = get_page($post->ID);
	$current_page_id = $page->ID;
	$caticoncolor="";
	$category_icon_code ="";
	$category_icon="";
	$category_icon_color="";
?>
<?php $page_custom_title = get_post_meta($current_page_id, 'page_custom_title', true); ?>
<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
<?php $titleBg = $redux_demo['title-bg']['url']; ?>	
<section class="pageHeading" style="background:url(<?php echo $titleBg; ?>);">
	<div class="row">
		<h3><?php the_title(); ?> </h3>
		<p><?php echo $page_custom_title; ?></p>
	</div>
</section><!-- End page Heading -->
<!-- advertisement -->
<section id="advertisement noBorder">
	<div class="row">
		<div class="large-8 medium-12 columns">
			<?php // query the blog posts and loop them
				$paged = ( get_query_var( 'paged' ) ) ? absint( get_query_var( 'paged' ) ) : 1;
				$blog_args = array (
					'post_type' => 'blog_posts',
					'paged' => $paged,
					);
				$blog_query = new WP_Query( $blog_args );					
			?>
			<?php if ( $blog_query->have_posts() ): ?>
			<?php while ( $blog_query->have_posts() ) : $blog_query->the_post(); ?>
			<?php get_template_part( 'content', 'blog-loop' ); ?>
			<?php endwhile; ?>
			<!--Paginatation-->
			<div class="row">
				<div class="large-12 columns">
					<?php 
					//pagination
					$big = 999999999; // need an unlikely integer		
					echo paginate_links( array(
							'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
							'format' => '?paged=%#%',
							'current' => max( 1, get_query_var('paged') ),
							'total' => $blog_query->max_num_pages
						) );                        
					?>
				</div>
			</div><!--Paginatation Row -->
			<?php else :
					echo "Sorry, Nothing found";
				endif; ?>
				<?php // reset to main query
				wp_reset_postdata(); ?>
			<!--Ads area -->
			<div class="blog-ads">
				<?php 
				$homeAd2 = '';
				$homeAdImg2 = $redux_demo['post_ad']['url']; 
				$homeAdImglink2 = $redux_demo['post_ad_url']; 
				$homeAdCode2 = $redux_demo['post_ad_code_client']; 
				$homeAdCodeslot2 = $redux_demo['post_ad_code_slot']; 
				$homeAdCodewidth2 = $redux_demo['post_ad_code_width']; 
				$homeAdCodeheight2 = $redux_demo['post_ad_code_height']; 
				if(!empty($homeAdCode2) || !empty($homeAdImg2)){
					if(!empty($homeAdCode2)){
							$homeAd2 = '<ins class="adsbygoogle"
									 style="display:inline-block;width:'.$homeAdCodewidth2.'px;height:'.$homeAdCodeheight2.'px"
									 data-ad-client="'.$homeAdCode2.'"
									 data-ad-slot="'.$homeAdCodeslot2.'"></ins>';
					}else{
							$homeAd2 = '<a href="'.$homeAdImglink2.'" target="_blank"><img alt="image" src="'.$homeAdImg2.'" /></a>';
					}
				}
				?>	
				<?php echo $homeAd2; ?>
			</div>
			<!--Ads area -->
		</div><!-- End large-8 medium-12 columns -->
		<div class="large-4 medium-12 columns">
			<aside class="sidebar blog-sidebar">
				<div class="row">
					<?php get_sidebar('blog'); ?>					
				</div>
			</aside>
		</div><!-- large-4 medium-12 columns -->
	</div><!-- End Row -->
</section>
<!-- End advertisement Section -->
<?php endwhile; endif; ?>
<?php get_footer(); ?>