<?php
/**
 * Template name: All posts
 *
 * This is the most generic template file in a WordPress theme and one of the
 * two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * For example, it puts together the home page when no home.php file exists.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage classiera
 * @since classiera 1.0
 */
 get_header(); ?>
 <?php 
	global $redux_demo;
	$view = $redux_demo['home-ads-view'];	
	$ad_desc = $redux_demo['ad-desc'];
	$category_icon_code = "";
	$category_icon_color = "";
	$your_image_url = "";
	$category_icon ="";
	$caticoncolor="";
	
	$page = get_page($post->ID);
	$current_page_id = $page->ID;

	$page_slider = get_post_meta($current_page_id, 'page_slider', true);
	$page_custom_title = get_post_meta($current_page_id, 'page_custom_title', true);	


	global $redux_demo, $maximRange; 
	$max_range = $redux_demo['max_range'];
	if(!empty($max_range)) {
		$maximRange = $max_range;
	} else {
		$maximRange = 1000;
	}

?>
<?php 
	$titleBg = $redux_demo['title-bg']['url'];
?>
<section class="pageHeading" style="background:url(<?php echo $titleBg; ?>);">
	<div class="row">
		<h3><?php the_title(); ?></h3>
		<p><?php echo $page_custom_title; ?></p>
	</div>
</section><!-- End page Heading -->
<section id="advertisement" class="noBorder removePad">
	<div class="row">
		<div class="mainHeading">
			<div class="large-7 medium-8 large-centered medium-centered columns">
				<h2><?php esc_html_e( 'ADVERTISEMENTS', 'classiera' ); ?></h2>
				<p><span class="line"><i class="fa fa-circle"></i></span></p>
				<?php if(!empty($ad_desc)){ ?>
				<p><?php echo $ad_desc; ?></p>
				<?php } ?>
			</div>
		</div>
	</div><!-- END Heading Row-->	
	<div class="row">
		<div class="advContent"> 
		<?php if($view=='grid'){?>
			<div class="tabs-content">
				<div class="content active" id="panel1">
				<div class="loop-content">
					<?php

					global $paged, $wp_query, $wp;

					$args = wp_parse_args($wp->matched_query);

					if ( !empty ( $args['paged'] ) && 0 == $paged ) {

						$wp_query->set('paged', $args['paged']);

						$paged = $args['paged'];

					}

					$cat_id = get_cat_ID(single_cat_title('', false));

					$temp = $wp_query;

					$wp_query= null;

					$wp_query = new WP_Query();

					$wp_query->query('post_type=post&posts_per_page=12&paged='.$paged.'&cat='.$cat_id);

					$current = -1;
					$current2 = 0;

					?>
					<?php while ($wp_query->have_posts()) : $wp_query->the_post(); $current++; $current2++; ?>
					<div class="large-4 medium-6 columns advItems matchHeight end">
						<div class="advItem"> 
							<?php 
							if ( has_post_thumbnail()) {
							$imageurl = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'classiera-grid');
							$thumb_id = get_post_thumbnail_id($post->id);
							$alt = get_post_meta($thumb_id, '_wp_attachment_image_alt', true);
							?>
							<div class="advItem-img">
								<img src="<?php echo $imageurl[0]; ?>" alt="<?php if(empty($alt)){echo "Image";}else{ echo $alt; } ; ?>"/>
							</div>
							<?php										
							}else{
							?>
							<div class="advItem-img">
								<img src="<?php echo get_template_directory_uri() . '/images/nothumb/nothumb370x300.png' ?>" alt="No Thumb"/>
							</div>
							<?php
							}
								/*Get Category Extra Fields For Price Icon Background */
								$category = get_the_category();
									if ($category[0]->category_parent == 0) {
										$tag = $category[0]->cat_ID;
										$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
										if (isset($tag_extra_fields[$tag])) {
											$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
											$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
										}
									}else{
										$tag = $category[0]->category_parent;
										$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
										if (isset($tag_extra_fields[$tag])) {
											$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
											$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
										}
									}
									if(!empty($category_icon_code)) {
										$category_icon = stripslashes($category_icon_code);
									}
									$category_icon_code = "";
								/*Get Category Extra Fields For Price Icon Background */
							$post_price = get_post_meta($post->ID, 'post_price', true);
							if(!empty($post_price)){
							?>
							<span class="price" style="background-color:<?php echo $category_icon_color; ?>"><?php echo $post_price; ?></span>
							<?php }?>
							<a class="hover" href="<?php the_permalink(); ?>"></a>
							<div class="info">
								<a href="<?php the_permalink(); ?>">
								<?php 
									$postCatgory = get_the_category( $post->ID );
									//echo $postCatgory['name'];
								?>
									<i class="<?php echo $category_icon; ?>" style="background-color:<?php echo $category_icon_color; ?>"></i>
									<span class="title"><?php $theTitle = get_the_title(); $theTitle = (strlen($theTitle) > 25) ? substr($theTitle,0,25).'...' : $theTitle; echo $theTitle; ?></span>
									<span class="cat"><?php esc_html_e( 'Category', 'classiera' ); ?> &nbsp;:&nbsp;<?php echo $postCatgory[0]->name; ?></span>
								</a>
							</div>
						</div>
					</div>
					<?php endwhile; ?>
				</div><!--loop-content-->
				<?php 
				global $redux_demo;
				$scroll = $redux_demo['infinite-scroll'];
				?>
				<?php if($scroll == 1){ ?>
					<?php echo infinite($wp_query); ?>
				<?php } ?>
				</div><!-- End Panel 1-->
				<?php $scroll = $redux_demo['infinite-scroll'];?>
				<?php if($scroll != 1){	?>
				<!-- Begin classiera_pagination-->
				<?php get_template_part('pagination'); ?>
				<?php }?>
				<?php wp_reset_query(); ?>
				<!-- End classiera_pagination-->
			</div>
		<?php }else{
			?>
			<div class="tabs-content listView">
				<div class="content active clearfix" id="panel1">
				<div class="loop-content">
					<?php

					global $paged, $wp_query, $wp;

					$args = wp_parse_args($wp->matched_query);

					if ( !empty ( $args['paged'] ) && 0 == $paged ) {

						$wp_query->set('paged', $args['paged']);

						$paged = $args['paged'];

					}

					$cat_id = get_cat_ID(single_cat_title('', false));

					$temp = $wp_query;

					$wp_query= null;

					$wp_query = new WP_Query();

					$wp_query->query('post_type=post&posts_per_page=12&paged='.$paged.'&cat='.$cat_id);

					$current = -1;
					$current2 = 0;

					?>
					<?php while ($wp_query->have_posts()) : $wp_query->the_post(); $current++; $current2++; ?>
					<div class="large-12 medium-12 columns advItems end">
						<?php 
						/*Get Category Extra Fields For Price Icon Background */
							$category = get_the_category();
								if ($category[0]->category_parent == 0) {
									$tag = $category[0]->cat_ID;
									$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
									if (isset($tag_extra_fields[$tag])) {
										$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
										$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
									}
								}else{
									$tag = $category[0]->category_parent;
									$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
									if (isset($tag_extra_fields[$tag])) {
										$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
										$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
									}
								}
								if(!empty($category_icon_code)) {
									$category_icon = stripslashes($category_icon_code);
								}
								$category_icon_code = "";
								$postCatgory = get_the_category( $post->ID );
								$post_price = get_post_meta($post->ID, 'post_price', true);
								$comments_count = wp_count_comments( $post->ID  );
								$approvedComment = $comments_count->approved;
						/*Get Category Extra Fields For Price Icon Background */
						?>
						<article class="listAdv">
							<div class="row">
								<div class="large-3 medium-4 small-5 column">
									<div class="list-img">
										<?php if(!empty($post_price)){ ?>
										<span class="listPrice" style="background-color:<?php echo $category_icon_color; ?>"><?php echo $post_price; ?></span>
										<?php }?>
										<?php /*Start Image */
										if ( has_post_thumbnail()) {
											$imageurl = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'classiera-list');
											$thumb_id = get_post_thumbnail_id($post->id);
											$alt = get_post_meta($thumb_id, '_wp_attachment_image_alt', true);
											?>
											<div class="advList-img">
												<img src="<?php echo $imageurl[0]; ?>" alt="<?php if(empty($alt)){echo "Image";}else{ echo $alt; } ; ?>"/>
											</div>
											<?php										
										}else{
											?>
											<div class="advItem-img">
												<img src="<?php echo get_template_directory_uri() . '/images/nothumb/nothumb370x300.png' ?>" alt="No Thumb"/>
											</div>
											<?php
										}
									/*End Image */?>
										<div class="listcomment">
											<span><?php echo $approvedComment; ?></span>
											<i class="fa fa-comments"></i>
											<span><?php echo classiera_get_post_views($post->ID); ?></span>
											<i class="fa fa-eye"></i>
										</div>	<!-- End listcomment-->
									</div>
								</div><!-- End large-3 medium-4 column-->
								<div class="large-9 medium-8 small-7 column">
									<div class="listAdv-desc">
										<div class="row">
											<div class="large-6 medium-7 columns">
												<div class="listAdv-desc-header">
													<div class="icon">
														<i class="<?php echo $category_icon; ?>" style="background-color:<?php echo $category_icon_color; ?>"></i>
														<h4><a href="<?php the_permalink(); ?>"><?php $theTitle = get_the_title(); $theTitle = (strlen($theTitle) > 25) ? substr($theTitle,0,25).'...' : $theTitle; echo $theTitle; ?></a></h4>
														<span><?php esc_html_e( 'Category', 'classiera' ); ?> &nbsp;:&nbsp;<?php echo $postCatgory[0]->name; ?></span>
													</div>
												</div>
											</div><!-- large-9-->
											<div class="large-6 medium-5 column">
											<?php if(function_exists('the_ratings')) { ?>
												<div class="rating">
													<?php the_ratings(); ?>
												</div>
											<?php } ?>	
											</div><!-- large-3-->
										</div><!-- listAdv First Row-->
										<div class="row">
											<div class="large-12 columns">
												<div class="listAdv-desc-detail">
													<?php echo substr(get_the_excerpt(), 0,260); ?>
												</div>
											</div>
										</div><!-- listAdv second Row-->
										<div class="row">
											<div class="listAdv-tags">
												<div class="large-6 medium-7 columns">
													<div class="listTags">
														<i class="fa fa-tags"></i>
														<span><?php esc_html_e('Tags', 'classiera'); ?>:</span>
														<?php the_tags('','',''); ?>
													</div><!-- listTags-->
												</div><!-- large-6-->
												<div class="large-6 medium-5 columns">
													<div class="listReadMore">
														<a href="<?php the_permalink(); ?>">
														<?php esc_html_e( 'Read More', 'classiera' ); ?>
														</a>
													</div>
												</div><!-- large-6 medium-5-->
											</div><!-- listAdv-tags-->
										</div><!-- listAdv third Row-->
									</div><!-- listAdv-desc-->
								</div><!-- large-9 medium-8 column-->
							</div><!-- End Article Main Row-->
						</article>
					</div><!-- END large-12-->
					<?php endwhile; ?>
				</div><!--loop-content-->
				<?php 
				global $redux_demo;
				$scroll = $redux_demo['infinite-scroll'];
				?>
				<?php if($scroll == 1){ ?>
					<?php echo infinite($wp_query); ?>
				<?php } ?>
				</div><!--EndPenal-->
				<?php $scroll = $redux_demo['infinite-scroll'];?>
				<?php if($scroll != 1){	?>
				<!-- Begin classiera_pagination-->
				<?php get_template_part('pagination'); ?>
				<?php } ?>
				<?php wp_reset_query(); ?>
				<!-- End classiera_pagination-->
			</div>
			<?php
		}?>
		</div>
	</div>
</section>
	<!-- End All Ads Section -->
<?php get_footer(); ?>