<?php
/**
 * Template name: All Categories
 *
 * This is the most generic template file in a WordPress theme and one of the
 * two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * For example, it puts together the home page when no home.php file exists.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage classiera
 * @since classiera
 */


get_header(); ?>

<?php 

	$page = get_page($post->ID);
	$current_page_id = $page->ID;

	$page_slider = get_post_meta($current_page_id, 'page_slider', true); 
	$page_custom_title = get_post_meta($current_page_id, 'page_custom_title', true);


	global $redux_demo, $maximRange; 
	$home_cat_desc = $redux_demo['cat-sec-desc'];
	$catSecTitle = $redux_demo['cat-sec-title'];
	$max_range = $redux_demo['max_range'];
	if(!empty($max_range)) {
		$maximRange = $max_range;
	} else {
		$maximRange = 1000;
	}
	$category_icon_code = "";
	$category_icon_color = "";
	$your_image_url = "";
	$caticoncolor="";
	$category_icon="";
	$allCatStyle = $redux_demo['all-cat-style'];	

?>
<!-- page Heading -->
<?php $titleBg = $redux_demo['title-bg']['url']; ?>	
<section class="pageHeading removeMargin" style="background:url(<?php echo $titleBg; ?>);">
	<div class="row">
		<h3><?php the_title(); ?></h3>	
		<p><?php echo $page_custom_title; ?></p>
	</div>
</section>
<!-- End page Heading -->
<!-- Ads Categories -->
<section id="adsCategory"> 
	<div class="row"><!-- Categories Heading Row -->
		<div class="mainHeading">
			<div class="large-7 medium-8 large-centered medium-centered columns">
				<h2><?php echo $catSecTitle; ?></h2>
				<p><span class="line"><i class="fa fa-circle"></i></span></p>
				<p><?php echo $home_cat_desc; ?></p>
			</div>
		</div>
	</div><!-- Categories Heading Row -->       
    <div class="row cat"><!-- Categories Box Row -->
		<?php			$argsmaino = array(	
			'order' => 'DESC',
			'hide_empty'               => 0,			
			'taxonomy'                 => 'category',
			'pad_counts'               => false
			); 							
			$categories = get_categories($argsmaino);
		    	$currentCat = 0;							      
				foreach ($categories as $category) { 
					if ($category->category_parent == 0) {
						$currentCat++;
					}
				}			
			?>
			<?php 
			$argsmain = array(
								'order'                    => 'DESC',
								'hide_empty'               => 0,
								'taxonomy'                 => 'category',
								'pad_counts'               => false 

							); 
			
			$cat_counter = $redux_demo['home-cat-counter'];
			$primaryColor = $redux_demo['color-primary'];
			$categories = get_terms(
				'category', 
				array('hide_empty' => 0,'parent' => 0,'order'=> 'ASC')	
					);
				$current = -1;				
			foreach ($categories as $category) { 
				$tag = $category->term_id;
				$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
				if (isset($tag_extra_fields[$tag])) {
					$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
					$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
					$caticoncolor = $tag_extra_fields[$tag]['category_icon_color'];
					$categoryIMG = $tag_extra_fields[$tag]['category_image'];
				}
				if(empty($category_icon_color)){
					$iconColor = $primaryColor;
				}else{
					$iconColor = $category_icon_color;
				}
				if(empty($categoryIMG)){
				$catIMG = get_template_directory_uri().'/images/category.png';
				}else{
					$catIMG = $categoryIMG;
				}
				$cat = $category->count;
				$catName = $category->term_id;
				$mainID = $catName;
				$current++;
				$allPosts = 0;
				$categories = get_categories('child_of='.$catName);
				foreach ($categories as $category) {
					$allPosts += $category->category_count;
				}
				?>
				<?php if($allCatStyle == 1){?>
				<div class="large-3 medium-6 columns category end">
					<div class="categoryBox">
						<div style="border-top:2px solid <?php echo $iconColor; ?>;" class="category-icon">
							<i class="<?php $category_icon = stripslashes($category_icon_code); echo $category_icon; ?>" style="background-color:<?php echo $iconColor; ?>"></i>
						</div>
					
						<div class="category-heading">
							<a href="<?php echo get_category_link( $catName ) ?>">
								<h4><?php echo get_cat_name( $catName ); ?></h4>
							</a>
						</div><!--categoryheading-->
						<div class="categories" style="border-bottom:1px solid <?php echo $iconColor; ?>;">
							<ul>
								<?php
								$currentCat = 0;
								$args2 = array(
										'type' => 'post',
										'child_of' => $catName,
										'parent' => get_query_var(''),
										'orderby' => 'name',
										'order' => 'ASC',
										'hide_empty' => 0,
										'hierarchical' => 1,
										'exclude' => '',
										'include' => '',
										'number' => '',
										'taxonomy' => 'category',
										'pad_counts' => true );
								$categories2 = get_categories($args2);
								foreach($categories2 as $category2) { 
									$currentCat++;
								}
								$args = array(
										'type' => 'post',
										'child_of' => $catName,
										'parent' => get_query_var(''),
										'orderby' => 'name',
										'order' => 'ASC',
										'hide_empty' => 0,
										'hierarchical' => 1,
										'exclude' => '',
										'include' => '',
										'number' => '5',
										'taxonomy' => 'category',
										'pad_counts' => true );
								$categories = get_categories($args);
								foreach($categories as $category) {
									?>
								<li>
									<a href="<?php echo get_category_link( $category->term_id )?>" title="View posts in <?php echo $category->name?>"><?php $categoryTitle = $category->name; $categoryTitle = (strlen($categoryTitle) > 30) ? substr($categoryTitle,0,27).'...' : $categoryTitle; echo $categoryTitle; ?>
									</a>
									<span class="category-counter"><?php echo $category->count ?></span>
								</li>	
								<?php }	?>
								<?php if($currentCat > 5) { ?>
								<li>
									<a href="<?php echo get_category_link( $catName ) ?>"><?php esc_html_e( 'Others', 'classiera' ); ?> </a>
									<span class="category-counter"><?php echo $allPosts; ?></span>
								</li>	
								<?php } ?>
							</ul>
						</div><!--categories-->
						<div class="category-button">
							 <a class="mas" href="<?php echo get_category_link( $mainID ) ?>" onMouseOver="this.style.backgroundColor='<?php echo $category_icon_color; ?>'" onMouseOut="this.style.backgroundColor='inherit'"><?php esc_html_e( 'VIEW ALL', 'classiera' ); ?></a>
						</div>
					</div><!--categoryBox-->
				</div><!--large3-->
				<?php }elseif($allCatStyle == 2){ ?>
				<div class="large-3 medium-4 columns category end">
					<div class="categoryBox categoryBoxV2">
					   <div class="category-img">
						   <img src="<?php echo $catIMG; ?>" alt="category image">
						   <div class="cat-head">
								<h4>
									<a href="<?php echo get_category_link( $mainID ) ?>">
										<i style="background-color:<?php echo $iconColor; ?>;" class="<?php $category_icon = stripslashes($category_icon_code); echo $category_icon; ?>"></i>
										<?php echo get_cat_name( $catName ); ?>
									</a>
								</h4>
						   </div>
					   </div><!--category-img-->
						<div class="categories">
							<ul>
							<?php 
							$currentCat = 0;
							$args2 = array(
							'type' => 'post',
							'child_of' => $catName,
							'parent' => get_query_var(''),
							'orderby' => 'name',
							'order' => 'ASC',
							'hide_empty' => 0,
							'hierarchical' => 1,
							'exclude' => '',
							'include' => '',
							'number' => '',
							'taxonomy' => 'category',
							'pad_counts' => true );
							$categories2 = get_categories($args2);
							foreach($categories2 as $category2) { 
								$currentCat++;
							}
							$args = array(
							'type' => 'post',
							'child_of' => $catName,
							'parent' => get_query_var(''),
							'orderby' => 'name',
							'order' => 'ASC',
							'hide_empty' => 0,
							'hierarchical' => 1,
							'exclude' => '',
							'include' => '',
							'number' => '5',
							'taxonomy' => 'category',
							'pad_counts' => true );
							$categories = get_categories($args);
							foreach($categories as $category) {
								?>
								<li>
									<a href="<?php echo get_category_link( $category->term_id )?>" title="View posts in <?php echo $category->name?>"><?php $categoryTitle = $category->name; $categoryTitle = (strlen($categoryTitle) > 30) ? substr($categoryTitle,0,27).'...' : $categoryTitle; echo $categoryTitle; ?></a><span>(<?php echo $category->count ?>)</span>
								</li>
							<?php }/*End For Each for sub Category*/?>
							<?php if($currentCat > 5) { ?>
								<li>
									<a href="<?php echo get_category_link( $catName ) ?>"><?php esc_html_e( 'Others', 'classiera' ); ?> </a>
									<span class="category-counter"><?php echo $allPosts; ?></span>
								</li>
							<?php } ?>	
							</ul>
						</div><!--sub categories-->
						<div class="category-button-v2 text-center">                   
							<a class="button round" href="<?php echo get_category_link( $mainID ) ?>" onMouseOver="this.style.backgroundColor='<?php echo $caticoncolor; ?>'" onMouseOut="this.style.backgroundColor='inherit'"><?php esc_html_e( 'VIEW ALL', 'classiera' ); ?></a>
						</div><!--view button-->
					</div><!--categoryBox categoryBoxV2-->
				</div><!--category box main--> 
				<?php } ?>
				<?php
			
			}/* End Will be here*/	
			?>

	</div><!-- Categories Box ROW-->
</section>
<!-- Company Section Start-->
<?php 
global $redux_demo; 
$classieraCompany = $redux_demo['partners-on'];
if($classieraCompany == 1){
	get_template_part('templates/company');
} ?>
<!-- Company Section End-->	
<?php get_footer(); ?>